/*
 * Decompiled with CFR 0.152.
 */
package org.babyfish.jimmer.sql.runtime;

import java.sql.PreparedStatement;
import java.sql.SQLException;
import java.util.Objects;

public interface DbLiteral {
    public Class<?> getType();

    default public void render(StringBuilder builder) {
        builder.append('?');
    }

    public void renderValue(StringBuilder var1);

    public void renderToComment(StringBuilder var1);

    public void setParameter(PreparedStatement var1, int var2, int var3) throws SQLException;

    public static class JsonWithSuffix
    implements DbLiteral {
        private final Object value;
        private final String suffix;

        public JsonWithSuffix(Object value, String suffix) {
            this.value = value;
            this.suffix = suffix;
        }

        @Override
        public Class<?> getType() {
            return this.value.getClass();
        }

        @Override
        public void render(StringBuilder builder) {
            builder.append("? ").append(this.suffix);
        }

        @Override
        public void renderValue(StringBuilder builder) {
            builder.append('\"').append(this.value.toString().replace("'", "''")).append(' ').append(this.suffix);
        }

        @Override
        public void renderToComment(StringBuilder builder) {
            builder.append(this.value).append(' ').append(this.suffix);
        }

        @Override
        public void setParameter(PreparedStatement stmt, int index, int jdbcType) throws SQLException {
            stmt.setString(index, this.value.toString());
        }

        public int hashCode() {
            int result = this.value.hashCode();
            result = 31 * result + this.suffix.hashCode();
            return result;
        }

        public boolean equals(Object o) {
            if (this == o) {
                return true;
            }
            if (o == null || this.getClass() != o.getClass()) {
                return false;
            }
            JsonWithSuffix that = (JsonWithSuffix)o;
            if (!this.value.equals(that.value)) {
                return false;
            }
            return this.suffix.equals(that.suffix);
        }

        public String toString() {
            return "JsonWithSuffix{value=" + this.value + ", suffix='" + this.suffix + '\'' + '}';
        }
    }

    public static class DbNull
    implements DbLiteral {
        private final Class<?> type;

        public DbNull(Class<?> type) {
            this.type = type;
        }

        @Override
        public Class<?> getType() {
            return this.type;
        }

        @Override
        public void renderValue(StringBuilder builder) {
            builder.append("null");
        }

        @Override
        public void renderToComment(StringBuilder builder) {
            builder.append("<null: ").append(this.type.getSimpleName()).append('>');
        }

        @Override
        public void setParameter(PreparedStatement stmt, int index, int jdbcType) throws SQLException {
            stmt.setNull(index, jdbcType);
        }

        public int hashCode() {
            return Objects.hash(this.type);
        }

        public boolean equals(Object o) {
            if (this == o) {
                return true;
            }
            if (o == null || this.getClass() != o.getClass()) {
                return false;
            }
            DbNull dbNull = (DbNull)o;
            return this.type.equals(dbNull.type);
        }

        public String toString() {
            return "DbNull{type=" + this.type + '}';
        }
    }
}

