/*
 * Decompiled with CFR 0.152.
 */
package org.babyfish.jimmer.sql.fetcher.impl;

import java.sql.Connection;
import java.util.ArrayList;
import java.util.Collection;
import java.util.HashMap;
import java.util.LinkedHashMap;
import java.util.List;
import java.util.ListIterator;
import java.util.Map;
import java.util.function.Function;
import org.babyfish.jimmer.meta.ImmutableProp;
import org.babyfish.jimmer.meta.ImmutableType;
import org.babyfish.jimmer.runtime.DraftSpi;
import org.babyfish.jimmer.runtime.Internal;
import org.babyfish.jimmer.sql.ast.Selection;
import org.babyfish.jimmer.sql.fetcher.Fetcher;
import org.babyfish.jimmer.sql.fetcher.impl.ColumnAccessors;
import org.babyfish.jimmer.sql.fetcher.impl.FetcherContext;
import org.babyfish.jimmer.sql.fetcher.impl.FetcherImplementor;
import org.babyfish.jimmer.sql.fetcher.impl.FetcherSelection;
import org.babyfish.jimmer.sql.runtime.JSqlClientImplementor;
import org.jetbrains.annotations.Nullable;

public class Fetchers {
    private Fetchers() {
    }

    /*
     * WARNING - void declaration
     */
    public static void fetch(JSqlClientImplementor sqlClient, Connection con, List<Selection<?>> selections, List<?> rows) {
        if (rows.isEmpty()) {
            return;
        }
        LinkedHashMap columnMap = new LinkedHashMap();
        for (int i = 0; i < selections.size(); ++i) {
            Object fetcherSelection;
            Fetcher<?> fetcher;
            Selection<?> selection = selections.get(i);
            if (!(selection instanceof FetcherSelection) || ((FetcherImplementor)(fetcher = (fetcherSelection = (FetcherSelection)selection).getFetcher())).__isSimpleFetcher() && !Fetchers.hasReferenceFilter(fetcher.getImmutableType(), sqlClient) && fetcherSelection.getConverter() == null) continue;
            columnMap.put(i, new ArrayList());
        }
        if (columnMap.isEmpty()) {
            return;
        }
        for (Object obj : rows) {
            for (Map.Entry entry : columnMap.entrySet()) {
                int columnIndex = (Integer)entry.getKey();
                List columnValues = (List)entry.getValue();
                columnValues.add(ColumnAccessors.get(obj, columnIndex));
            }
        }
        for (Map.Entry entry : columnMap.entrySet()) {
            void var8_24;
            Function converter;
            int columnIndex = (Integer)entry.getKey();
            List list = (List)entry.getValue();
            FetcherSelection selection = (FetcherSelection)selections.get(columnIndex);
            Fetcher<?> fetcher = selection.getFetcher();
            if (!((FetcherImplementor)fetcher).__isSimpleFetcher() || Fetchers.hasReferenceFilter(fetcher.getImmutableType(), sqlClient)) {
                List list2 = Internal.produceList((ImmutableType)selection.getFetcher().getImmutableType(), (Collection)list, values -> Fetchers.fetch(sqlClient, con, selection.getFetcher(), values));
            }
            if ((converter = selection.getConverter()) != null) {
                void var8_22;
                ArrayList list3 = new ArrayList(var8_22.size());
                for (Object fetched : var8_22) {
                    list3.add(converter.apply(fetched));
                }
                ArrayList arrayList = list3;
            }
            entry.setValue(var8_24);
        }
        HashMap<Integer, Object> indexValueMap = new HashMap<Integer, Object>();
        ListIterator<?> listIterator = rows.listIterator();
        int rowIndex = 0;
        while (listIterator.hasNext()) {
            for (Map.Entry e : columnMap.entrySet()) {
                int colIndex = (Integer)e.getKey();
                Object value = ((List)e.getValue()).get(rowIndex);
                indexValueMap.put(colIndex, value);
            }
            listIterator.set(ColumnAccessors.set(listIterator.next(), indexValueMap));
            ++rowIndex;
        }
    }

    private static void fetch(JSqlClientImplementor sqlClient, Connection con, Fetcher<?> fetcher, List<@Nullable DraftSpi> drafts) {
        FetcherContext.using(sqlClient, con, (ctx, isRoot) -> {
            ctx.addAll(fetcher, drafts);
            if (isRoot.booleanValue()) {
                ctx.execute();
            }
        });
    }

    private static boolean hasReferenceFilter(ImmutableType type, JSqlClientImplementor sqlClient) {
        for (ImmutableProp prop : type.getSelectableReferenceProps().values()) {
            if (sqlClient.getFilters().getTargetFilter(prop) == null) continue;
            return true;
        }
        return false;
    }
}

