/*
 * Decompiled with CFR 0.152.
 */
package org.babyfish.jimmer.sql.ast.query;

import java.sql.Connection;
import java.util.Collections;
import java.util.List;
import org.babyfish.jimmer.sql.ast.impl.query.ConfigurableRootQueryImplementor;
import org.babyfish.jimmer.sql.ast.query.ConfigurableRootQuery;

public class PagingQueries {
    private PagingQueries() {
    }

    public static <E, P> P execute(ConfigurableRootQuery<?, E> query, int pageIndex, int pageSize, PageFactory<E, P> pageFactory) {
        return PagingQueries.execute(query, pageIndex, pageSize, null, pageFactory);
    }

    public static <E, P> P execute(ConfigurableRootQuery<?, E> query, int pageIndex, int pageSize, Connection con, PageFactory<E, P> pageFactory) {
        List entities;
        ConfigurableRootQueryImplementor queryImplementor = (ConfigurableRootQueryImplementor)query;
        if (pageSize == 0 || pageSize == -1 || pageSize == Integer.MAX_VALUE) {
            List entities2 = (List)query.execute(con);
            return pageFactory.create(entities2, entities2.size(), queryImplementor);
        }
        if (pageIndex < 0) {
            return pageFactory.create(Collections.emptyList(), 0L, queryImplementor);
        }
        long offset = (long)pageIndex * (long)pageSize;
        if (offset > Long.MAX_VALUE - (long)pageSize) {
            throw new IllegalArgumentException("offset is too big");
        }
        long total = query.count(con);
        if (offset >= total) {
            return pageFactory.create(Collections.emptyList(), 0L, queryImplementor);
        }
        ConfigurableRootQuery<?, E> reversedQuery = null;
        if (offset + (long)(pageSize / 2) > total / 2L) {
            reversedQuery = query.reverseSorting();
        }
        if (reversedQuery != null) {
            int limit;
            long reversedOffset = (int)(total - offset - (long)pageSize);
            if (reversedOffset < 0L) {
                limit = pageSize + (int)reversedOffset;
                reversedOffset = 0L;
            } else {
                limit = pageSize;
            }
            entities = (List)reversedQuery.limit(limit, reversedOffset).execute(con);
            Collections.reverse(entities);
        } else {
            entities = (List)query.limit(pageSize, offset).execute(con);
        }
        return pageFactory.create(entities, total, queryImplementor);
    }

    @FunctionalInterface
    public static interface PageFactory<E, P> {
        public P create(List<E> var1, long var2, ConfigurableRootQueryImplementor<?, E> var4);
    }
}

