/*
 * Decompiled with CFR 0.152.
 */
package org.babyfish.jimmer.sql.ast.impl;

import java.util.List;
import java.util.Objects;
import org.babyfish.jimmer.sql.ast.Expression;
import org.babyfish.jimmer.sql.ast.impl.AbstractExpression;
import org.babyfish.jimmer.sql.ast.impl.Ast;
import org.babyfish.jimmer.sql.ast.impl.AstVisitor;
import org.babyfish.jimmer.sql.ast.impl.StringExpressionImplementor;
import org.babyfish.jimmer.sql.runtime.SqlBuilder;
import org.jetbrains.annotations.NotNull;

class ConcatExpression
extends AbstractExpression<String>
implements StringExpressionImplementor {
    private final Expression<String> first;
    private final List<Expression<String>> others;

    ConcatExpression(Expression<String> first, List<Expression<String>> others) {
        this.first = first;
        this.others = others;
    }

    @Override
    public void accept(@NotNull AstVisitor visitor) {
        ((Ast)((Object)this.first)).accept(visitor);
        for (Expression<String> other : this.others) {
            ((Ast)((Object)other)).accept(visitor);
        }
    }

    @Override
    public void renderTo(@NotNull SqlBuilder builder) {
        builder.sql("concat(");
        this.renderChild((Ast)((Object)this.first), builder);
        for (Expression<String> other : this.others) {
            builder.sql(", ");
            this.renderChild((Ast)((Object)other), builder);
        }
        builder.sql(")");
    }

    @Override
    public int precedence() {
        return 0;
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (o == null || this.getClass() != o.getClass()) {
            return false;
        }
        ConcatExpression that = (ConcatExpression)o;
        return this.first.equals(that.first) && this.others.equals(that.others);
    }

    public int hashCode() {
        return Objects.hash(this.first, this.others);
    }
}

