/*
 * Decompiled with CFR 0.152.
 */
package org.babyfish.jimmer.sql.runtime;

import java.util.Objects;

public final class SqlFormatter {
    public static final SqlFormatter SIMPLE = new SqlFormatter(false, "", Integer.MAX_VALUE, 100);
    public static final SqlFormatter PRETTY = new SqlFormatter(true, "    ", 10, 100);
    private final boolean isPretty;
    private final String indent;
    private final int listParamCountInLine;
    private final int maxVariableContentLength;

    public SqlFormatter(boolean isPretty, String indent, int listParamCountInLine, int maxVariableContentLength) {
        this.isPretty = isPretty;
        this.indent = indent != null ? indent : "";
        this.listParamCountInLine = Math.max(listParamCountInLine, 1);
        this.maxVariableContentLength = Math.max(maxVariableContentLength, 10);
    }

    public boolean isPretty() {
        return this.isPretty;
    }

    public String getIndent() {
        return this.indent;
    }

    public int getListParamCountInLine() {
        return this.listParamCountInLine;
    }

    public int getMaxVariableContentLength() {
        return this.maxVariableContentLength;
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (!(o instanceof SqlFormatter)) {
            return false;
        }
        SqlFormatter formatter = (SqlFormatter)o;
        return this.isPretty == formatter.isPretty && this.listParamCountInLine == formatter.listParamCountInLine && this.maxVariableContentLength == formatter.maxVariableContentLength && this.indent.equals(formatter.indent);
    }

    public int hashCode() {
        return Objects.hash(this.isPretty, this.indent, this.listParamCountInLine, this.maxVariableContentLength);
    }

    public String toString() {
        return "SqlFormatter{isPretty=" + this.isPretty + ", indent='" + this.indent + '\'' + ", listParamCountInLine=" + this.listParamCountInLine + ", maxVariableContentLength=" + this.maxVariableContentLength + '}';
    }
}

