/*
 * Decompiled with CFR 0.152.
 */
package org.babyfish.jimmer.sql.event.binlog;

import com.fasterxml.jackson.core.JsonProcessingException;
import com.fasterxml.jackson.databind.JsonNode;
import com.fasterxml.jackson.databind.Module;
import com.fasterxml.jackson.databind.ObjectMapper;
import com.fasterxml.jackson.datatype.jsr310.JavaTimeModule;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import org.babyfish.jimmer.meta.EmbeddedLevel;
import org.babyfish.jimmer.meta.ImmutableProp;
import org.babyfish.jimmer.meta.ImmutableType;
import org.babyfish.jimmer.meta.TypedProp;
import org.babyfish.jimmer.runtime.DraftSpi;
import org.babyfish.jimmer.runtime.Internal;
import org.babyfish.jimmer.sql.association.meta.AssociationProp;
import org.babyfish.jimmer.sql.association.meta.AssociationType;
import org.babyfish.jimmer.sql.ast.impl.util.EmbeddableObjects;
import org.babyfish.jimmer.sql.ast.tuple.Tuple2;
import org.babyfish.jimmer.sql.event.binlog.BinLogModule;
import org.babyfish.jimmer.sql.event.binlog.ValueParser;
import org.babyfish.jimmer.sql.meta.MetadataStrategy;
import org.babyfish.jimmer.sql.runtime.JSqlClientImplementor;
import org.jetbrains.annotations.NotNull;

public class BinLogParser {
    private ObjectMapper mapper;
    private JSqlClientImplementor sqlClient;

    public BinLogParser initialize(JSqlClientImplementor sqlClient) {
        return this.initialize(sqlClient, null);
    }

    public BinLogParser initialize(JSqlClientImplementor sqlClient, ObjectMapper mapper) {
        if (sqlClient == null) {
            throw new IllegalArgumentException("`sqlClient` cannot be null");
        }
        ObjectMapper clonedMapper = mapper != null ? new ObjectMapper(mapper){} : new ObjectMapper();
        clonedMapper.registerModule((Module)new BinLogModule(sqlClient)).registerModule((Module)new JavaTimeModule());
        this.mapper = clonedMapper;
        this.sqlClient = sqlClient;
        return this;
    }

    public <T> T parseEntity(@NotNull Class<T> type, String json) {
        if (json == null || json.isEmpty()) {
            return null;
        }
        try {
            return (T)this.mapper.readValue(json, type);
        }
        catch (JsonProcessingException ex) {
            throw new IllegalArgumentException("Illegal json: " + json, ex);
        }
    }

    public <T> T parseEntity(@NotNull Class<T> type, JsonNode data) {
        if (data == null || data.isNull()) {
            return null;
        }
        return this.parseEntity(type, data.toString());
    }

    public <T> T parseEntity(@NotNull ImmutableType type, String json) {
        if (type instanceof AssociationType) {
            throw new IllegalArgumentException("type cannot be AssociationType");
        }
        return this.parseEntity(type.getJavaClass(), json);
    }

    public <T> T parseEntity(@NotNull ImmutableType type, JsonNode data) {
        if (data == null || data.isNull()) {
            return null;
        }
        return this.parseEntity(type, data.toString());
    }

    public <S, T> Tuple2<S, T> parseIdPair(@NotNull AssociationType associationType, JsonNode data) {
        AssociationProp sourceProp = associationType.getSourceProp();
        AssociationProp targetProp = associationType.getTargetProp();
        ImmutableProp sourceIdProp = sourceProp.getTargetType().getIdProp();
        ImmutableProp targetIdProp = targetProp.getTargetType().getIdProp();
        Object sourceId = null;
        Object targetId = null;
        MetadataStrategy strategy = this.sqlClient.getMetadataStrategy();
        if (sourceIdProp.isEmbedded(EmbeddedLevel.SCALAR) && ((sourceId = Internal.produce((ImmutableType)sourceIdProp.getTargetType(), null, draft -> {
            Iterator itr = data.fields();
            while (itr.hasNext()) {
                Map.Entry e = (Map.Entry)itr.next();
                List chain = associationType.getPropChain((String)e.getKey(), strategy);
                if (chain.get(0) != sourceProp) continue;
                ValueParser.addEntityProp((DraftSpi)draft, chain.subList(2, chain.size()), (JsonNode)e.getValue(), this.sqlClient);
            }
        })) == null || !EmbeddableObjects.isCompleted(sourceId))) {
            throw new IllegalArgumentException("source id fields of \"" + (Object)((Object)associationType) + "\" cannot be null");
        }
        if (targetIdProp.isEmbedded(EmbeddedLevel.SCALAR) && ((targetId = Internal.produce((ImmutableType)targetIdProp.getTargetType(), null, draft -> {
            Iterator itr = data.fields();
            while (itr.hasNext()) {
                Map.Entry e = (Map.Entry)itr.next();
                List chain = associationType.getPropChain((String)e.getKey(), strategy);
                if (chain.get(0) != targetProp) continue;
                ValueParser.addEntityProp((DraftSpi)draft, chain.subList(2, chain.size()), (JsonNode)e.getValue(), this.sqlClient);
            }
        })) == null || !EmbeddableObjects.isCompleted(targetId))) {
            throw new IllegalArgumentException("target id fields of \"" + (Object)((Object)associationType) + "\" cannot be null");
        }
        if (sourceId == null || targetId == null) {
            Iterator itr = data.fields();
            while (itr.hasNext()) {
                Map.Entry e = (Map.Entry)itr.next();
                List chain = associationType.getPropChain((String)e.getKey(), strategy);
                ImmutableProp prop = (ImmutableProp)chain.get(0);
                if (prop == sourceProp) {
                    sourceId = ValueParser.parseSingleValue(this.sqlClient, (JsonNode)e.getValue(), sourceIdProp.getElementClass(), false);
                    if (sourceId != null) continue;
                    throw new IllegalArgumentException("source id fields of \"" + (Object)((Object)associationType) + "\" cannot be null");
                }
                if (prop != targetProp || (targetId = ValueParser.parseSingleValue(this.sqlClient, (JsonNode)e.getValue(), targetIdProp.getElementClass(), false)) != null) continue;
                throw new IllegalArgumentException("target id fields of \"" + (Object)((Object)associationType) + "\" cannot be null");
            }
        }
        return new Tuple2<Object, Object>(sourceId, targetId);
    }

    public <S, T> Tuple2<S, T> parseIdPair(@NotNull AssociationType associationType, String json) {
        JsonNode data;
        if (json == null || json.isEmpty()) {
            return null;
        }
        try {
            data = this.mapper.readTree(json);
        }
        catch (JsonProcessingException ex) {
            throw new IllegalArgumentException("Illegal json: " + json, ex);
        }
        return this.parseIdPair(associationType, data);
    }

    public <S, T> Tuple2<S, T> parseIdPair(@NotNull TypedProp<?, ?> prop, JsonNode data) {
        return this.parseIdPair(AssociationType.of(prop.unwrap()), data);
    }

    public <S, T> Tuple2<S, T> parseIdPair(@NotNull ImmutableProp prop, JsonNode data) {
        return this.parseIdPair(AssociationType.of(prop), data);
    }

    public <S, T> Tuple2<S, T> parseIdPair(@NotNull TypedProp<?, ?> prop, String json) {
        return this.parseIdPair(AssociationType.of(prop.unwrap()), json);
    }

    public <S, T> Tuple2<S, T> parseIdPair(@NotNull ImmutableProp prop, String json) {
        return this.parseIdPair(AssociationType.of(prop), json);
    }
}

