/*
 * Decompiled with CFR 0.152.
 */
package org.babyfish.jimmer.sql.ast.impl.query;

import java.util.ArrayList;
import java.util.List;
import org.babyfish.jimmer.sql.ast.tuple.Tuple3;
import org.babyfish.jimmer.sql.dialect.PaginationContext;
import org.babyfish.jimmer.sql.runtime.SqlFormatter;

public class PaginationContextImpl
implements PaginationContext {
    private final SqlFormatter sqlFormatter;
    private final int limit;
    private final int offset;
    private final String originSql;
    private final List<Object> originVariables;
    private final List<Integer> originVariablePositions;
    private final boolean idOnly;
    private final StringBuilder builder = new StringBuilder();
    private final List<Object> variables = new ArrayList<Object>();
    private final List<Integer> variablePositions;
    private boolean originApplied = false;

    public PaginationContextImpl(SqlFormatter formatter, int limit, int offset, String originSql, List<Object> originVariables, List<Integer> originVariablePositions, boolean idOnly) {
        this.sqlFormatter = formatter;
        this.limit = limit;
        this.offset = offset;
        this.originSql = originSql;
        this.originVariables = originVariables;
        this.originVariablePositions = originVariablePositions;
        this.idOnly = idOnly;
        this.variablePositions = originVariablePositions != null ? new ArrayList<Integer>() : null;
    }

    @Override
    public int getLimit() {
        return this.limit;
    }

    @Override
    public int getOffset() {
        return this.offset;
    }

    @Override
    public boolean isIdOnly() {
        return this.idOnly;
    }

    @Override
    public PaginationContext origin() {
        if (this.originApplied) {
            throw new IllegalStateException("origin() can only be called once");
        }
        this.builder.append(this.originSql);
        this.variables.addAll(this.originVariables);
        if (this.variablePositions != null) {
            this.variablePositions.addAll(this.originVariablePositions);
        }
        this.originApplied = true;
        return this;
    }

    @Override
    public PaginationContext space() {
        if (this.sqlFormatter.isPretty()) {
            this.builder.append('\n');
        } else {
            this.builder.append(' ');
        }
        return this;
    }

    @Override
    public PaginationContext newLine() {
        if (this.sqlFormatter.isPretty()) {
            this.builder.append('\n');
        }
        return this;
    }

    @Override
    public PaginationContext sql(String sql) {
        this.builder.append(sql);
        return this;
    }

    @Override
    public PaginationContext variable(Object value) {
        if (!this.originApplied) {
            throw new IllegalStateException("Cannot add variables before the origin() is called");
        }
        this.builder.append("?");
        this.variables.add(value);
        if (this.variablePositions != null) {
            this.variablePositions.add(this.builder.length());
        }
        return this;
    }

    public Tuple3<String, List<Object>, List<Integer>> build() {
        if (!this.originApplied) {
            throw new IllegalStateException("origin() has not been called");
        }
        return new Tuple3<String, List<Object>, List<Integer>>(this.builder.toString(), this.variables, this.variablePositions);
    }
}

