/*
 * Decompiled with CFR 0.152.
 */
package org.babyfish.jimmer.sql.runtime;

import java.math.BigDecimal;
import java.math.BigInteger;
import java.nio.ByteBuffer;
import java.sql.Blob;
import java.sql.Date;
import java.sql.ResultSet;
import java.sql.SQLException;
import java.sql.Time;
import java.sql.Timestamp;
import java.time.LocalDate;
import java.time.LocalDateTime;
import java.time.LocalTime;
import java.time.OffsetDateTime;
import java.time.ZonedDateTime;
import java.util.HashMap;
import java.util.LinkedHashMap;
import java.util.Map;
import java.util.UUID;
import org.babyfish.jimmer.impl.util.StaticCache;
import org.babyfish.jimmer.meta.EmbeddedLevel;
import org.babyfish.jimmer.meta.ImmutableProp;
import org.babyfish.jimmer.meta.ImmutableType;
import org.babyfish.jimmer.meta.TargetLevel;
import org.babyfish.jimmer.runtime.DraftSpi;
import org.babyfish.jimmer.runtime.Internal;
import org.babyfish.jimmer.sql.association.Association;
import org.babyfish.jimmer.sql.association.meta.AssociationType;
import org.babyfish.jimmer.sql.ast.impl.util.EmbeddableObjects;
import org.babyfish.jimmer.sql.dialect.Dialect;
import org.babyfish.jimmer.sql.meta.ColumnDefinition;
import org.babyfish.jimmer.sql.meta.FormulaTemplate;
import org.babyfish.jimmer.sql.meta.SqlTemplate;
import org.babyfish.jimmer.sql.meta.Storage;
import org.babyfish.jimmer.sql.runtime.ExecutionException;
import org.babyfish.jimmer.sql.runtime.JSqlClientImplementor;
import org.babyfish.jimmer.sql.runtime.ObjectReader;
import org.babyfish.jimmer.sql.runtime.Reader;
import org.babyfish.jimmer.sql.runtime.ScalarProvider;

public class ReaderManager {
    private static final Map<Class<?>, Reader<?>> BASE_READER_MAP;
    private final JSqlClientImplementor sqlClient;
    private StaticCache<ImmutableType, Reader<?>> typeReaderCache = new StaticCache(this::createTypeReader, true);
    private StaticCache<ImmutableProp, Reader<?>> propReaderCache = new StaticCache(this::createPropReader, true);

    public ReaderManager(JSqlClientImplementor sqlClient) {
        this.sqlClient = sqlClient;
    }

    public Reader<?> reader(Class<?> type) {
        ImmutableType immutableType = ImmutableType.tryGet(type);
        return immutableType != null ? this.reader(immutableType) : this.scalarReader(type);
    }

    public Reader<?> reader(ImmutableType type) {
        return (Reader)this.typeReaderCache.get((Object)type);
    }

    public Reader<?> reader(ImmutableProp prop) {
        return (Reader)this.propReaderCache.get((Object)prop);
    }

    private Reader<?> createPropReader(ImmutableProp prop) {
        Storage storage = prop.getStorage(this.sqlClient.getMetadataStrategy());
        if (storage instanceof ColumnDefinition) {
            if (prop.isEmbedded(EmbeddedLevel.SCALAR)) {
                return new EmbeddedReader(prop.getTargetType(), this);
            }
            if (prop.isReference(TargetLevel.ENTITY)) {
                return new ReferenceReader(prop, this);
            }
            return this.scalarReader(prop);
        }
        SqlTemplate template = prop.getSqlTemplate();
        if (template instanceof FormulaTemplate) {
            return this.scalarReader(prop);
        }
        return null;
    }

    private Reader<?> createTypeReader(ImmutableType immutableType) {
        if (immutableType.isEmbeddable()) {
            return new EmbeddedReader(immutableType, this);
        }
        if (immutableType instanceof AssociationType) {
            return new AssociationReader((AssociationType)immutableType, this);
        }
        if (!immutableType.isEntity()) {
            return null;
        }
        LinkedHashMap nonIdReaderMap = new LinkedHashMap();
        Reader<?> idReader = null;
        for (ImmutableProp prop : immutableType.getSelectableProps().values()) {
            if (prop.isId()) {
                idReader = this.reader(prop);
                continue;
            }
            nonIdReaderMap.put(prop, this.reader(prop));
        }
        return new ObjectReader(immutableType, idReader, nonIdReaderMap);
    }

    private Reader<?> scalarReader(ImmutableProp prop) {
        Reader<?> reader;
        ImmutableType immutableType = prop.getTargetType();
        if (immutableType != null && immutableType.isEmbeddable()) {
            return new EmbeddedReader(immutableType, this);
        }
        Reader<?> reader2 = reader = prop.isScalarList() ? null : BASE_READER_MAP.get(prop.getElementClass());
        if (reader == null) {
            ScalarProvider scalarProvider = this.sqlClient.getScalarProvider(prop);
            if (scalarProvider == null) {
                throw new IllegalArgumentException("No scalar provider for property \"" + prop + "\"");
            }
            Class sqlType = scalarProvider.getSqlType();
            reader = BASE_READER_MAP.get(sqlType);
            if (reader == null) {
                reader = ReaderManager.unknownSqlTypeReader(sqlType, scalarProvider, this.sqlClient.getDialect());
            }
            reader = new CustomizedScalarReader(scalarProvider, reader);
        }
        return reader;
    }

    private Reader<?> scalarReader(Class<?> type) {
        ImmutableType immutableType = ImmutableType.tryGet(type);
        if (immutableType != null && immutableType.isEmbeddable()) {
            return new EmbeddedReader(immutableType, this);
        }
        Reader<?> reader = BASE_READER_MAP.get(type);
        if (reader == null) {
            ScalarProvider scalarProvider = this.sqlClient.getScalarProvider(type);
            if (scalarProvider == null) {
                throw new IllegalArgumentException("No scalar provider for customized scalar type \"" + type.getName() + "\"");
            }
            Class sqlType = scalarProvider.getSqlType();
            reader = BASE_READER_MAP.get(sqlType);
            if (reader == null) {
                reader = ReaderManager.unknownSqlTypeReader(sqlType, scalarProvider, this.sqlClient.getDialect());
            }
            reader = new CustomizedScalarReader(scalarProvider, reader);
        }
        return reader;
    }

    private static Reader<?> unknownSqlTypeReader(Class<?> sqlType, ScalarProvider<?, ?> provider, Dialect dialect) {
        Reader<?> reader = provider.reader();
        if (reader == null && (reader = dialect.unknownReader(sqlType)) == null) {
            throw new IllegalStateException("There is no reader for unknown type \"" + sqlType.getName() + "\" in both \"" + ScalarProvider.class.getName() + "\" and \"" + dialect.getClass().getName() + "\"");
        }
        return reader;
    }

    public static boolean isStandardScalarType(Class<?> type) {
        return BASE_READER_MAP.containsKey(type);
    }

    static {
        HashMap map = new HashMap();
        map.put(Boolean.TYPE, new BooleanReader());
        map.put(Boolean.class, new BooleanReader());
        map.put(Character.TYPE, new CharReader());
        map.put(Character.class, new CharReader());
        map.put(Byte.TYPE, new ByteReader());
        map.put(Byte.class, new ByteReader());
        map.put(byte[].class, new ByteArrayReader());
        map.put(Byte[].class, new BoxedByteArrayReader());
        map.put(Short.TYPE, new ShortReader());
        map.put(Short.class, new ShortReader());
        map.put(Integer.TYPE, new IntReader());
        map.put(Integer.class, new IntReader());
        map.put(Long.TYPE, new LongReader());
        map.put(Long.class, new LongReader());
        map.put(Float.TYPE, new FloatReader());
        map.put(Float.class, new FloatReader());
        map.put(Double.TYPE, new DoubleReader());
        map.put(Double.class, new DoubleReader());
        map.put(BigInteger.class, new BigIntegerReader());
        map.put(BigDecimal.class, new BigDecimalReader());
        map.put(String.class, new StringReader());
        map.put(UUID.class, new UUIDReader());
        map.put(Blob.class, new BlobReader());
        map.put(Date.class, new SqlDateReader());
        map.put(Time.class, new SqlTimeReader());
        map.put(Timestamp.class, new SqlTimestampReader());
        map.put(java.util.Date.class, new DateReader());
        map.put(LocalDate.class, new LocalDateReader());
        map.put(LocalTime.class, new LocalTimeReader());
        map.put(LocalDateTime.class, new LocalDateTimeReader());
        map.put(OffsetDateTime.class, new OffsetDateTimeReader());
        map.put(ZonedDateTime.class, new ZonedDateTimeReader());
        BASE_READER_MAP = map;
    }

    private static class EmbeddedReader
    implements Reader<Object> {
        private final ImmutableType targetType;
        private Map<ImmutableProp, Reader<?>> readerMap;

        EmbeddedReader(ImmutableType targetType, ReaderManager readerManager) {
            this.targetType = targetType;
            LinkedHashMap map = new LinkedHashMap();
            for (ImmutableProp childProp : targetType.getProps().values()) {
                if (childProp.isEmbedded(EmbeddedLevel.SCALAR)) {
                    map.put(childProp, new EmbeddedReader(childProp.getTargetType(), readerManager));
                    continue;
                }
                map.put(childProp, readerManager.scalarReader(childProp));
            }
            this.readerMap = map;
        }

        @Override
        public Object read(ResultSet rs, Reader.Col col) throws SQLException {
            Object embeddable = Internal.produce((ImmutableType)this.targetType, null, draft -> {
                DraftSpi spi = (DraftSpi)draft;
                for (Map.Entry<ImmutableProp, Reader<?>> e : this.readerMap.entrySet()) {
                    ImmutableProp prop = e.getKey();
                    Object value = e.getValue().read(rs, col);
                    if (value == null && !prop.isNullable()) continue;
                    spi.__set(prop.getId(), value);
                }
            });
            return EmbeddableObjects.isCompleted(embeddable) ? embeddable : null;
        }
    }

    private static class ReferenceReader
    implements Reader<Object> {
        private final ImmutableType targetType;
        private final Reader<?> foreignKeyReader;

        private ReferenceReader(ImmutableProp prop, ReaderManager readerManager) {
            this.targetType = prop.getTargetType();
            this.foreignKeyReader = readerManager.scalarReader(this.targetType.getIdProp());
        }

        @Override
        public Object read(ResultSet rs, Reader.Col col) throws SQLException {
            Object fk = this.foreignKeyReader.read(rs, col);
            if (fk == null) {
                return null;
            }
            return Internal.produce((ImmutableType)this.targetType, null, draft -> ((DraftSpi)draft).__set(this.targetType.getIdProp().getId(), fk));
        }
    }

    private static class AssociationReader
    implements Reader<Association<?, ?>> {
        private final ImmutableType sourceType;
        private final ImmutableType targetType;
        private final ImmutableProp sourceIdProp;
        private final ImmutableProp targetIdProp;
        private final Reader<?> sourceReader;
        private final Reader<?> targetReader;

        AssociationReader(AssociationType associationType, ReaderManager readerManager) {
            this.sourceType = associationType.getSourceType();
            this.targetType = associationType.getTargetType();
            this.sourceIdProp = this.sourceType.getIdProp();
            this.targetIdProp = this.targetType.getIdProp();
            this.sourceReader = new ReferenceReader(associationType.getSourceProp(), readerManager);
            this.targetReader = new ReferenceReader(associationType.getTargetProp(), readerManager);
        }

        @Override
        public Association<?, ?> read(ResultSet rs, Reader.Col col) throws SQLException {
            Object source = this.sourceReader.read(rs, col);
            Object target = this.targetReader.read(rs, col);
            return new Association(source, target);
        }
    }

    private static class CustomizedScalarReader<T, S>
    implements Reader<T> {
        private final ScalarProvider<T, S> scalarProvider;
        private final Reader<S> sqlReader;

        CustomizedScalarReader(ScalarProvider<T, S> scalarProvider, Reader<S> sqlReader) {
            this.scalarProvider = scalarProvider;
            this.sqlReader = sqlReader;
        }

        @Override
        public T read(ResultSet rs, Reader.Col col) throws SQLException {
            S sqlValue = this.sqlReader.read(rs, col);
            try {
                return sqlValue != null ? (T)this.scalarProvider.toScalar(sqlValue) : null;
            }
            catch (Exception ex) {
                throw new ExecutionException("Cannot convert \"" + sqlValue + "\" to the jvm type \"" + this.scalarProvider.getScalarType() + "\"", ex);
            }
        }
    }

    private static class BooleanReader
    implements Reader<Boolean> {
        private BooleanReader() {
        }

        @Override
        public Boolean read(ResultSet rs, Reader.Col col) throws SQLException {
            return rs.getObject(col.get(), Boolean.class);
        }
    }

    private static class CharReader
    implements Reader<Character> {
        private CharReader() {
        }

        @Override
        public Character read(ResultSet rs, Reader.Col col) throws SQLException {
            String str = rs.getString(col.get());
            return str != null ? Character.valueOf(str.charAt(0)) : null;
        }
    }

    private static class ByteReader
    implements Reader<Byte> {
        private ByteReader() {
        }

        @Override
        public Byte read(ResultSet rs, Reader.Col col) throws SQLException {
            return rs.getObject(col.get(), Byte.class);
        }
    }

    private static class ByteArrayReader
    implements Reader<byte[]> {
        private ByteArrayReader() {
        }

        @Override
        public byte[] read(ResultSet rs, Reader.Col col) throws SQLException {
            return rs.getBytes(col.get());
        }
    }

    private static class BoxedByteArrayReader
    implements Reader<Byte[]> {
        private BoxedByteArrayReader() {
        }

        @Override
        public Byte[] read(ResultSet rs, Reader.Col col) throws SQLException {
            return rs.getObject(col.get(), Byte[].class);
        }
    }

    private static class ShortReader
    implements Reader<Short> {
        private ShortReader() {
        }

        @Override
        public Short read(ResultSet rs, Reader.Col col) throws SQLException {
            return rs.getObject(col.get(), Short.class);
        }
    }

    private static class IntReader
    implements Reader<Integer> {
        private IntReader() {
        }

        @Override
        public Integer read(ResultSet rs, Reader.Col col) throws SQLException {
            return rs.getObject(col.get(), Integer.class);
        }
    }

    private static class LongReader
    implements Reader<Long> {
        private LongReader() {
        }

        @Override
        public Long read(ResultSet rs, Reader.Col col) throws SQLException {
            return rs.getObject(col.get(), Long.class);
        }
    }

    private static class FloatReader
    implements Reader<Float> {
        private FloatReader() {
        }

        @Override
        public Float read(ResultSet rs, Reader.Col col) throws SQLException {
            return rs.getObject(col.get(), Float.class);
        }
    }

    private static class DoubleReader
    implements Reader<Double> {
        private DoubleReader() {
        }

        @Override
        public Double read(ResultSet rs, Reader.Col col) throws SQLException {
            return rs.getObject(col.get(), Double.class);
        }
    }

    private static class BigIntegerReader
    implements Reader<BigInteger> {
        private BigIntegerReader() {
        }

        @Override
        public BigInteger read(ResultSet rs, Reader.Col col) throws SQLException {
            BigDecimal decimal = rs.getBigDecimal(col.get());
            return decimal.toBigInteger();
        }
    }

    private static class BigDecimalReader
    implements Reader<BigDecimal> {
        private BigDecimalReader() {
        }

        @Override
        public BigDecimal read(ResultSet rs, Reader.Col col) throws SQLException {
            return rs.getBigDecimal(col.get());
        }
    }

    private static class StringReader
    implements Reader<String> {
        private StringReader() {
        }

        @Override
        public String read(ResultSet rs, Reader.Col col) throws SQLException {
            return rs.getString(col.get());
        }
    }

    private static class UUIDReader
    implements Reader<UUID> {
        private UUIDReader() {
        }

        @Override
        public UUID read(ResultSet rs, Reader.Col col) throws SQLException {
            Object obj = rs.getObject(col.get());
            if (obj == null) {
                return null;
            }
            if (obj instanceof byte[]) {
                ByteBuffer byteBuffer = ByteBuffer.wrap((byte[])obj);
                long high = byteBuffer.getLong();
                long low = byteBuffer.getLong();
                return new UUID(high, low);
            }
            return UUID.fromString(obj.toString());
        }
    }

    private static class BlobReader
    implements Reader<Blob> {
        private BlobReader() {
        }

        @Override
        public Blob read(ResultSet rs, Reader.Col col) throws SQLException {
            return rs.getBlob(col.get());
        }
    }

    private static class SqlDateReader
    implements Reader<Date> {
        private SqlDateReader() {
        }

        @Override
        public Date read(ResultSet rs, Reader.Col col) throws SQLException {
            return rs.getDate(col.get());
        }
    }

    private static class SqlTimeReader
    implements Reader<Time> {
        private SqlTimeReader() {
        }

        @Override
        public Time read(ResultSet rs, Reader.Col col) throws SQLException {
            return rs.getTime(col.get());
        }
    }

    private static class SqlTimestampReader
    implements Reader<Timestamp> {
        private SqlTimestampReader() {
        }

        @Override
        public Timestamp read(ResultSet rs, Reader.Col col) throws SQLException {
            return rs.getTimestamp(col.get());
        }
    }

    private static class DateReader
    implements Reader<java.util.Date> {
        private DateReader() {
        }

        @Override
        public java.util.Date read(ResultSet rs, Reader.Col col) throws SQLException {
            Timestamp timestamp = rs.getTimestamp(col.get());
            return timestamp != null ? new java.util.Date(timestamp.getTime()) : null;
        }
    }

    private static class LocalDateReader
    implements Reader<LocalDate> {
        private LocalDateReader() {
        }

        @Override
        public LocalDate read(ResultSet rs, Reader.Col col) throws SQLException {
            Timestamp timestamp = rs.getTimestamp(col.get());
            return timestamp != null ? timestamp.toLocalDateTime().toLocalDate() : null;
        }
    }

    private static class LocalTimeReader
    implements Reader<LocalTime> {
        private LocalTimeReader() {
        }

        @Override
        public LocalTime read(ResultSet rs, Reader.Col col) throws SQLException {
            Timestamp timestamp = rs.getTimestamp(col.get());
            return timestamp != null ? timestamp.toLocalDateTime().toLocalTime() : null;
        }
    }

    private static class LocalDateTimeReader
    implements Reader<LocalDateTime> {
        private LocalDateTimeReader() {
        }

        @Override
        public LocalDateTime read(ResultSet rs, Reader.Col col) throws SQLException {
            Timestamp timestamp = rs.getTimestamp(col.get());
            return timestamp != null ? timestamp.toLocalDateTime() : null;
        }
    }

    private static class OffsetDateTimeReader
    implements Reader<OffsetDateTime> {
        private OffsetDateTimeReader() {
        }

        @Override
        public OffsetDateTime read(ResultSet rs, Reader.Col col) throws SQLException {
            return rs.getObject(col.get(), OffsetDateTime.class);
        }
    }

    private static class ZonedDateTimeReader
    implements Reader<ZonedDateTime> {
        private ZonedDateTimeReader() {
        }

        @Override
        public ZonedDateTime read(ResultSet rs, Reader.Col col) throws SQLException {
            return rs.getObject(col.get(), ZonedDateTime.class);
        }
    }
}

