/*
 * Decompiled with CFR 0.152.
 */
package org.babyfish.jimmer.sql.cache.spi;

import com.fasterxml.jackson.core.JsonProcessingException;
import com.fasterxml.jackson.databind.Module;
import com.fasterxml.jackson.databind.ObjectMapper;
import com.fasterxml.jackson.datatype.jsr310.JavaTimeModule;
import java.sql.Connection;
import java.sql.PreparedStatement;
import java.sql.ResultSet;
import java.sql.SQLException;
import java.util.ArrayList;
import java.util.Collection;
import java.util.LinkedHashMap;
import java.util.LinkedHashSet;
import java.util.Map;
import java.util.Objects;
import java.util.Set;
import java.util.function.Consumer;
import org.babyfish.jimmer.jackson.ImmutableModule;
import org.babyfish.jimmer.meta.ImmutableProp;
import org.babyfish.jimmer.meta.ImmutableType;
import org.babyfish.jimmer.sql.cache.CacheOperator;
import org.babyfish.jimmer.sql.cache.LocatedCache;
import org.babyfish.jimmer.sql.runtime.ExecutionException;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public abstract class AbstractTransactionCacheOperator
implements CacheOperator {
    private static final Logger LOGGER = LoggerFactory.getLogger(AbstractTransactionCacheOperator.class);
    private static final String TABLE_NAME = "JIMMER_TRANS_CACHE_OPERATOR";
    private static final String ID = "ID";
    private static final String TYPE = "TYPE";
    private static final String PROP = "PROP";
    private static final String REASON = "REASON";
    private static final String KEYS = "KEYS";
    private static final String INSERT = "insert into JIMMER_TRANS_CACHE_OPERATOR(TYPE, PROP, REASON, KEYS)";
    private static final String SELECT_ID_PREFIX = "select ID from JIMMER_TRANS_CACHE_OPERATOR order by ID limit ";
    private static final String SELECT_PREFIX = "select ID, TYPE, PROP, REASON, KEYS from JIMMER_TRANS_CACHE_OPERATOR where ID in";
    private final ThreadLocal<Map<MergedKey, Set<Object>>> mergedMapLocal = new ThreadLocal();
    private final ObjectMapper mapper;
    private final int batchSize;

    protected AbstractTransactionCacheOperator(ObjectMapper mapper, int batchSize) {
        if (batchSize < 1) {
            throw new IllegalArgumentException("`batchSize` cannot be less than 1");
        }
        this.mapper = mapper != null ? mapper : new ObjectMapper().registerModule((Module)new JavaTimeModule()).registerModule((Module)new ImmutableModule());
        this.batchSize = batchSize;
    }

    public void begin() {
        this.mergedMapLocal.set(new LinkedHashMap());
    }

    @Override
    public void delete(LocatedCache<Object, ?> cache, Object key, Object reason) {
        this.keys(cache, reason).add(key);
    }

    @Override
    public void deleteAll(LocatedCache<Object, ?> cache, Collection<Object> keys, Object reason) {
        if (!keys.isEmpty()) {
            this.keys(cache, reason).addAll(keys);
        }
    }

    private Set<Object> keys(LocatedCache<?, ?> cache, Object reason) {
        if (reason != null && !(reason instanceof String)) {
            throw new IllegalArgumentException("The cache deletion reason can only be null or string when trigger type is `TRANSACTION_ONLY`");
        }
        return this.mergedMapLocal.get().computeIfAbsent(new MergedKey(cache.getType(), cache.getProp(), (String)reason), it -> new LinkedHashSet());
    }

    public void beforeCommit() {
        Map<MergedKey, Set<Object>> map = this.mergedMapLocal.get();
        this.jdbc(con -> {
            try {
                try (PreparedStatement stmt = con.prepareStatement(INSERT);){
                    for (Map.Entry e : map.entrySet()) {
                        int keyCountInCount;
                        ImmutableType type = ((MergedKey)e.getKey()).type;
                        ImmutableProp prop = ((MergedKey)e.getKey()).prop;
                        String reason = ((MergedKey)e.getKey()).reason;
                        Set keys = (Set)e.getValue();
                        int n = keyCountInCount = type != null ? this.keyCountInRow(type) : this.keyCountInRow(prop);
                        if (keys.size() <= keyCountInCount) {
                            this.save(stmt, type, prop, reason, keys);
                            continue;
                        }
                        ArrayList<Object> list = new ArrayList<Object>(keyCountInCount);
                        for (Object key : keys) {
                            list.add(key);
                            if (list.size() != keyCountInCount) continue;
                            this.save(stmt, type, prop, reason, list);
                            list.clear();
                        }
                        if (list.isEmpty()) continue;
                        this.save(stmt, type, prop, reason, list);
                    }
                    stmt.executeBatch();
                }
                this.mergedMapLocal.remove();
            }
            catch (JsonProcessingException | SQLException ex) {
                this.mergedMapLocal.remove();
                throw new ExecutionException("Failed to save delayed cache deletion", ex);
            }
        });
    }

    private void save(PreparedStatement stmt, ImmutableType type, ImmutableProp prop, String reason, Collection<Object> keys) throws SQLException, JsonProcessingException {
        stmt.setString(1, type != null ? type.toString() : null);
        stmt.setString(2, prop != null ? prop.toString() : null);
        stmt.setString(3, REASON);
        stmt.setString(4, this.mapper.writeValueAsString(keys));
        stmt.addBatch();
    }

    public void rollback() {
        this.mergedMapLocal.remove();
    }

    public void flush() {
        String sql = SELECT_ID_PREFIX + this.batchSize;
        ArrayList ids = new ArrayList();
        this.jdbc(con -> {
            try (PreparedStatement stmt = con.prepareStatement(sql);
                 ResultSet rs = stmt.executeQuery();){
                while (rs.next()) {
                    ids.add(rs.getLong(1));
                }
            }
            catch (SQLException ex) {
                LOGGER.warn("Failed to flush transaction cache operator", (Throwable)ex);
                return;
            }
        });
        if (ids.isEmpty()) {
            return;
        }
        StringBuilder builder = new StringBuilder();
        builder.append(SELECT_PREFIX).append('(');
        for (int i = ids.size(); i > 0; --i) {
            if (i > 1) {
                builder.append(", ");
            }
            builder.append('?');
        }
        builder.append(") for update");
        this.jdbc(con -> {
            try (PreparedStatement stmt = con.prepareStatement(builder.toString());
                 ResultSet rs = stmt.executeQuery();){
                while (rs.next()) {
                }
            }
            catch (SQLException ex) {
                LOGGER.warn("Failed to flush transaction cache operator", (Throwable)ex);
            }
        });
    }

    protected int keyCountInRow(ImmutableType type) {
        Class idClass = type.getIdProp().getElementClass();
        if (idClass.isPrimitive()) {
            return 8;
        }
        return 4;
    }

    protected int keyCountInRow(ImmutableProp prop) {
        Class idClass = prop.getDeclaringType().getIdProp().getElementClass();
        if (idClass.isPrimitive()) {
            return 8;
        }
        return 4;
    }

    protected abstract void jdbc(Consumer<Connection> var1);

    private static class MergedKey {
        final ImmutableType type;
        final ImmutableProp prop;
        final String reason;

        private MergedKey(ImmutableType type, ImmutableProp prop, String reason) {
            this.type = type;
            this.prop = prop;
            this.reason = reason;
        }

        public boolean equals(Object o) {
            if (this == o) {
                return true;
            }
            if (o == null || this.getClass() != o.getClass()) {
                return false;
            }
            MergedKey mergedKey = (MergedKey)o;
            return Objects.equals(this.type, mergedKey.type) && Objects.equals(this.prop, mergedKey.prop) && Objects.equals(this.reason, mergedKey.reason);
        }

        public int hashCode() {
            return Objects.hash(this.type, this.prop, this.reason);
        }

        public String toString() {
            return "MergedKey{type=" + this.type + ", prop=" + this.prop + ", reason=" + this.reason + '}';
        }
    }
}

