/*
 * Decompiled with CFR 0.152.
 */
package org.babyfish.jimmer.sql.runtime;

import org.babyfish.jimmer.meta.ImmutableProp;
import org.babyfish.jimmer.meta.ImmutableType;
import org.babyfish.jimmer.sql.meta.DatabaseNamingStrategy;

public class DefaultDatabaseNamingStrategy
implements DatabaseNamingStrategy {
    public static final DefaultDatabaseNamingStrategy UPPER_CASE = new DefaultDatabaseNamingStrategy(false);
    public static final DefaultDatabaseNamingStrategy LOWER_CASE = new DefaultDatabaseNamingStrategy(true);
    private final boolean lowercase;

    protected DefaultDatabaseNamingStrategy(boolean lowercase) {
        this.lowercase = lowercase;
    }

    public String tableName(ImmutableType type) {
        return this.snake(type.getJavaClass().getSimpleName());
    }

    public String sequenceName(ImmutableType type) {
        return this.snake(type.getJavaClass().getSimpleName()) + (this.lowercase ? "_seq_id" : "_SEQ_ID");
    }

    public String columnName(ImmutableProp prop) {
        return this.snake(prop.getName());
    }

    public String foreignKeyColumnName(ImmutableProp prop) {
        return this.snake(prop.getName()) + (this.lowercase ? "_id" : "_ID");
    }

    public String middleTableName(ImmutableProp prop) {
        return this.snake(prop.getDeclaringType().getJavaClass().getSimpleName()) + '_' + this.snake(prop.getTargetType().getJavaClass().getSimpleName()) + (this.lowercase ? "_mapping" : "_MAPPING");
    }

    public String middleTableBackRefColumnName(ImmutableProp prop) {
        return this.snake(prop.getDeclaringType().getJavaClass().getSimpleName()) + (this.lowercase ? "_id" : "_ID");
    }

    public String middleTableTargetRefColumnName(ImmutableProp prop) {
        return this.snake(prop.getTargetType().getJavaClass().getSimpleName()) + (this.lowercase ? "_id" : "_ID");
    }

    protected String snake(String text) {
        StringBuilder builder = new StringBuilder();
        int size = text.length();
        boolean isPrevLowerCase = false;
        for (int i = 0; i < size; ++i) {
            char c = text.charAt(i);
            boolean isLowerCase = Character.isLowerCase(c);
            if (isPrevLowerCase && !isLowerCase) {
                builder.append('_');
            }
            isPrevLowerCase = isLowerCase;
            if (isLowerCase == this.lowercase) {
                builder.append(c);
                continue;
            }
            if (this.lowercase) {
                builder.append(Character.toLowerCase(c));
                continue;
            }
            builder.append(Character.toUpperCase(c));
        }
        return builder.toString();
    }
}

