/*
 * Decompiled with CFR 0.152.
 */
package org.babyfish.jimmer.sql.ast.query;

import java.util.ArrayList;
import java.util.List;
import java.util.Objects;
import java.util.regex.Pattern;
import org.babyfish.jimmer.meta.EmbeddedLevel;
import org.babyfish.jimmer.meta.ImmutableProp;
import org.babyfish.jimmer.meta.ImmutableType;
import org.babyfish.jimmer.meta.TargetLevel;
import org.babyfish.jimmer.sql.JoinType;
import org.babyfish.jimmer.sql.ast.Expression;
import org.babyfish.jimmer.sql.ast.PropExpression;
import org.babyfish.jimmer.sql.ast.query.NullOrderMode;
import org.babyfish.jimmer.sql.ast.query.OrderMode;
import org.babyfish.jimmer.sql.ast.table.Props;

public class Order {
    private static final Pattern SEPARATOR_PATTERN = Pattern.compile("[,;]");
    private static final Pattern WHITESPACE_PATTERN = Pattern.compile("\\s+");
    private final Expression<?> expression;
    private final OrderMode orderMode;
    private final NullOrderMode nullOrderMode;

    public Order(Expression<?> expression, OrderMode orderMode, NullOrderMode nullOrderMode) {
        this.expression = Objects.requireNonNull(expression);
        this.orderMode = Objects.requireNonNull(orderMode);
        this.nullOrderMode = Objects.requireNonNull(nullOrderMode);
    }

    public Expression<?> getExpression() {
        return this.expression;
    }

    public OrderMode getOrderMode() {
        return this.orderMode;
    }

    public NullOrderMode getNullOrderMode() {
        return this.nullOrderMode;
    }

    public Order nullsFirst() {
        return new Order(this.expression, this.orderMode, NullOrderMode.NULLS_FIRST);
    }

    public Order nullsLast() {
        return new Order(this.expression, this.orderMode, NullOrderMode.NULLS_LAST);
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (o == null || this.getClass() != o.getClass()) {
            return false;
        }
        Order order = (Order)o;
        return this.expression.equals(order.expression) && this.orderMode == order.orderMode && this.nullOrderMode == order.nullOrderMode;
    }

    public int hashCode() {
        return Objects.hash(new Object[]{this.expression, this.orderMode, this.nullOrderMode});
    }

    public String toString() {
        return "Order{expression=" + this.expression + ", orderMode=" + (Object)((Object)this.orderMode) + ", nullOrderMode=" + (Object)((Object)this.nullOrderMode) + '}';
    }

    public static List<Order> makeOrders(Props table, String ... codes) {
        CustomOrderCreator<Order> creator = (path, orderMode, nullOrderMode) -> new Order(Order.orderedExpression(table, path), orderMode, nullOrderMode);
        return Order.makeCustomOrders(creator, codes);
    }

    public static <O> List<O> makeCustomOrders(CustomOrderCreator<O> creator, String ... codes) {
        ArrayList<O> orders = new ArrayList<O>();
        for (String code : codes) {
            for (String part : SEPARATOR_PATTERN.split(code)) {
                if ((part = part.trim()).isEmpty()) continue;
                orders.add(Order.makeCustomOrder(part, creator));
            }
        }
        return orders;
    }

    private static <O> O makeCustomOrder(String code, CustomOrderCreator<O> creator) {
        String[] parts = WHITESPACE_PATTERN.split(code);
        OrderMode orderMode = OrderMode.ASC;
        NullOrderMode nullOrderMode = NullOrderMode.UNSPECIFIED;
        int channel = 0;
        block24: for (int i = 1; i < parts.length; ++i) {
            String rest = parts[i].toLowerCase();
            switch (channel) {
                case 0: {
                    switch (rest) {
                        case "asc": {
                            channel = 1;
                            continue block24;
                        }
                        case "desc": {
                            channel = 1;
                            orderMode = OrderMode.DESC;
                            continue block24;
                        }
                        case "nulls": {
                            channel = 2;
                            continue block24;
                        }
                    }
                    throw new IllegalArgumentException("Illegal order code \"" + code + "\",\"asc\", \"desc\" or \"nulls\" is expected after property path");
                }
                case 1: {
                    if ("nulls".equals(rest)) {
                        channel = 2;
                        continue block24;
                    }
                    throw new IllegalArgumentException("Illegal order code \"" + code + "\"\"nulls\" is expected but \"" + rest + "\" is found");
                }
                case 2: {
                    switch (rest) {
                        case "first": {
                            channel = 3;
                            nullOrderMode = NullOrderMode.NULLS_FIRST;
                            continue block24;
                        }
                        case "last": {
                            channel = 3;
                            nullOrderMode = NullOrderMode.NULLS_LAST;
                            continue block24;
                        }
                    }
                    throw new IllegalArgumentException("Illegal order code \"" + code + "\",\"asc\", \"desc\" or \"nulls\" is expected after property path");
                }
                case 3: {
                    throw new IllegalArgumentException("Illegal order code \"" + code + "\",unexpected token \"" + rest + "\"");
                }
            }
        }
        if (channel == 2) {
            throw new IllegalArgumentException("Illegal order code \"" + code + "\", \"first\" or \"last\" is expected after \"nulls\"");
        }
        return creator.create(parts[0], orderMode, nullOrderMode);
    }

    public static Expression<?> orderedExpression(Props table, String path) {
        List<ImmutableProp> props = Order.orderedPropChain(table.getImmutableType(), path);
        boolean allNullable = props.stream().filter(it -> it.isReference(TargetLevel.PERSISTENT)).allMatch(ImmutableProp::isNullable);
        Props source = table;
        Expression<?> expr = null;
        for (ImmutableProp prop : props) {
            if (prop.isReference(TargetLevel.PERSISTENT)) {
                source = source.join(prop.getName(), allNullable ? JoinType.LEFT : JoinType.INNER);
                continue;
            }
            if (expr != null) {
                expr = (Expression<?>)((PropExpression.Embedded)expr).get(prop.getName());
                continue;
            }
            expr = (Expression<?>)source.get(prop.getName());
        }
        if (expr == null) {
            throw new AssertionError((Object)("Internal bug, illegal path \"" + path + "\""));
        }
        return expr;
    }

    public static List<ImmutableProp> orderedPropChain(ImmutableType type, String path) {
        ArrayList<ImmutableProp> props = new ArrayList<ImmutableProp>();
        while (!path.isEmpty()) {
            int dotIndex = path.indexOf(46);
            String propName = dotIndex == -1 ? path : path.substring(0, dotIndex);
            String restPath = dotIndex == -1 ? "" : path.substring(dotIndex + 1);
            ImmutableProp prop = (ImmutableProp)type.getProps().get(propName);
            if (prop == null) {
                throw new IllegalArgumentException("Cannot resolve ordered property path \"" + path + "\" from \"" + type + "\", there is no property \"" + propName + "\" in \"" + type + "\"");
            }
            if (prop.isReferenceList(TargetLevel.OBJECT) || prop.isScalarList()) {
                throw new IllegalArgumentException("Cannot resolve ordered property path \"" + path + "\" from \"" + type + "\", the property \"" + prop + "\" cannot be list");
            }
            if (restPath.isEmpty() && !prop.isScalar(TargetLevel.OBJECT)) {
                throw new IllegalArgumentException("Cannot resolve ordered property path \"" + path + "\" from \"" + type + "\", \"" + prop + "\" is the last property of the path but it is not scalar");
            }
            if (!(restPath.isEmpty() || prop.isReference(TargetLevel.PERSISTENT) || prop.isEmbedded(EmbeddedLevel.BOTH))) {
                throw new IllegalArgumentException("Cannot resolve ordered property path \"" + path + "\" from \"" + type + "\", \"" + prop + "\" is not the last property of path but it is neither reference nor embedded");
            }
            props.add(prop);
            path = restPath;
            if (prop.getTargetType() == null) continue;
            type = prop.getTargetType();
        }
        return props;
    }

    public static interface CustomOrderCreator<O> {
        public O create(String var1, OrderMode var2, NullOrderMode var3);
    }
}

