/*
 * Decompiled with CFR 0.152.
 */
package org.babyfish.jimmer.sql.fetcher.impl;

import java.util.stream.IntStream;
import org.babyfish.jimmer.sql.fetcher.RecursionStrategy;

class DefaultRecursionStrategy<E>
implements RecursionStrategy<E> {
    private int depth;
    private static final DefaultRecursionStrategy<?>[] DEFAULTS = (DefaultRecursionStrategy[])IntStream.range(0, 10).mapToObj(DefaultRecursionStrategy::new).toArray(DefaultRecursionStrategy[]::new);
    private static final DefaultRecursionStrategy<?> UNLIMITED = new DefaultRecursionStrategy(Integer.MAX_VALUE);

    public static <E> DefaultRecursionStrategy<E> of(int depth) {
        if (depth == Integer.MAX_VALUE) {
            return UNLIMITED;
        }
        if (depth < DEFAULTS.length) {
            return DEFAULTS[Math.max(depth, 0)];
        }
        return new DefaultRecursionStrategy<E>(depth);
    }

    private DefaultRecursionStrategy(int depth) {
        this.depth = depth;
    }

    public int getDepth() {
        return this.depth;
    }

    @Override
    public boolean isRecursive(RecursionStrategy.Args<E> args) {
        return args.getDepth() < this.depth;
    }
}

