/*
 * Decompiled with CFR 0.152.
 */
package org.babyfish.jimmer.sql.ast.impl.query;

import java.util.ArrayList;
import java.util.List;
import org.babyfish.jimmer.sql.ast.tuple.Tuple2;
import org.babyfish.jimmer.sql.dialect.PaginationContext;

public class PaginationContextImpl
implements PaginationContext {
    private int limit;
    private int offset;
    private String originSql;
    private List<Object> originVariables;
    private StringBuilder builder = new StringBuilder();
    private List<Object> variables = new ArrayList<Object>();
    private boolean originApplied = false;

    public PaginationContextImpl(int limit, int offset, String originSql, List<Object> originVariables) {
        this.limit = limit;
        this.offset = offset;
        this.originSql = originSql;
        this.originVariables = originVariables;
    }

    @Override
    public int getLimit() {
        return this.limit;
    }

    @Override
    public int getOffset() {
        return this.offset;
    }

    @Override
    public PaginationContext origin() {
        if (this.originApplied) {
            throw new IllegalStateException("origin() can only be called once");
        }
        this.builder.append(this.originSql);
        this.variables.addAll(this.originVariables);
        this.originApplied = true;
        return this;
    }

    @Override
    public PaginationContext sql(String sql) {
        this.builder.append(sql);
        return this;
    }

    @Override
    public PaginationContext variable(Object value) {
        if (!this.originApplied) {
            throw new IllegalStateException("Cannot add variables before the origin() is called");
        }
        this.variables.add(value);
        this.builder.append("?");
        return this;
    }

    public Tuple2<String, List<Object>> build() {
        if (!this.originApplied) {
            throw new IllegalStateException("origin() has not been called");
        }
        return new Tuple2<String, List<Object>>(this.builder.toString(), this.variables);
    }
}

