/*
 * Decompiled with CFR 0.152.
 */
package org.babyfish.jimmer.sql.ast.impl;

import java.util.Arrays;
import java.util.List;
import java.util.Objects;
import java.util.stream.Collectors;
import org.babyfish.jimmer.sql.ast.Expression;
import org.babyfish.jimmer.sql.ast.LikeMode;
import org.babyfish.jimmer.sql.ast.Predicate;
import org.babyfish.jimmer.sql.ast.StringExpression;
import org.babyfish.jimmer.sql.ast.impl.CoalesceBuilder;
import org.babyfish.jimmer.sql.ast.impl.ComparableExpressionImplementor;
import org.babyfish.jimmer.sql.ast.impl.ConcatExpression;
import org.babyfish.jimmer.sql.ast.impl.LikePredicate;
import org.babyfish.jimmer.sql.ast.impl.Literals;
import org.babyfish.jimmer.sql.ast.impl.LowerExpression;
import org.babyfish.jimmer.sql.ast.impl.UpperExpression;
import org.jetbrains.annotations.Nullable;

interface StringExpressionImplementor
extends StringExpression,
ComparableExpressionImplementor<String> {
    @Override
    default public Class<String> getType() {
        return String.class;
    }

    @Override
    @Nullable
    default public Predicate like(String pattern, LikeMode likeMode) {
        return LikePredicate.of(this, pattern, false, likeMode);
    }

    @Override
    @Nullable
    default public Predicate ilike(String pattern, LikeMode likeMode) {
        return LikePredicate.of(this, pattern, true, likeMode);
    }

    @Override
    default public StringExpression upper() {
        return new UpperExpression(this);
    }

    @Override
    default public StringExpression lower() {
        return new LowerExpression(this);
    }

    @Override
    default public StringExpression concat(String ... others) {
        return this.concat((Expression[])Arrays.stream(others).filter(it -> it != null && !it.isEmpty()).map(Literals::string).toArray(Expression[]::new));
    }

    @Override
    default public StringExpression concat(Expression<String> ... others) {
        List<Expression<String>> exprs = Arrays.stream(others).filter(Objects::nonNull).collect(Collectors.toList());
        if (exprs.isEmpty()) {
            return this;
        }
        return new ConcatExpression(this, exprs);
    }

    @Override
    default public StringExpression coalesce(String defaultValue) {
        return this.coalesceBuilder().or(defaultValue).build();
    }

    @Override
    default public StringExpression coalesce(Expression<String> defaultExpr) {
        return ((CoalesceBuilder.Str)this.coalesceBuilder().or((Expression)defaultExpr)).build();
    }

    @Override
    default public CoalesceBuilder.Str coalesceBuilder() {
        return new CoalesceBuilder.Str(this);
    }
}

