/*
 * Decompiled with CFR 0.152.
 */
package org.babyfish.jimmer.sql.ast.impl;

import java.sql.Connection;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.LinkedHashMap;
import java.util.LinkedHashSet;
import java.util.List;
import java.util.ListIterator;
import java.util.Map;
import java.util.Set;
import java.util.function.Function;
import java.util.stream.Collectors;
import org.babyfish.jimmer.Input;
import org.babyfish.jimmer.meta.ImmutableProp;
import org.babyfish.jimmer.meta.ImmutableType;
import org.babyfish.jimmer.meta.TypedProp;
import org.babyfish.jimmer.runtime.DraftSpi;
import org.babyfish.jimmer.runtime.ImmutableSpi;
import org.babyfish.jimmer.runtime.Internal;
import org.babyfish.jimmer.sql.Entities;
import org.babyfish.jimmer.sql.ast.Predicate;
import org.babyfish.jimmer.sql.ast.impl.ExampleImpl;
import org.babyfish.jimmer.sql.ast.impl.mutation.BatchEntitySaveCommandImpl;
import org.babyfish.jimmer.sql.ast.impl.mutation.DeleteCommandImpl;
import org.babyfish.jimmer.sql.ast.impl.mutation.SimpleEntitySaveCommandImpl;
import org.babyfish.jimmer.sql.ast.impl.query.MutableRootQueryImpl;
import org.babyfish.jimmer.sql.ast.impl.query.Queries;
import org.babyfish.jimmer.sql.ast.mutation.BatchEntitySaveCommand;
import org.babyfish.jimmer.sql.ast.mutation.DeleteCommand;
import org.babyfish.jimmer.sql.ast.mutation.SimpleEntitySaveCommand;
import org.babyfish.jimmer.sql.ast.query.ConfigurableRootQuery;
import org.babyfish.jimmer.sql.ast.query.Example;
import org.babyfish.jimmer.sql.ast.query.Order;
import org.babyfish.jimmer.sql.cache.Cache;
import org.babyfish.jimmer.sql.cache.CacheEnvironment;
import org.babyfish.jimmer.sql.cache.CacheLoader;
import org.babyfish.jimmer.sql.fetcher.Fetcher;
import org.babyfish.jimmer.sql.fetcher.impl.FetcherSelection;
import org.babyfish.jimmer.sql.fetcher.impl.Fetchers;
import org.babyfish.jimmer.sql.runtime.Converters;
import org.babyfish.jimmer.sql.runtime.ExecutionPurpose;
import org.babyfish.jimmer.sql.runtime.JSqlClientImplementor;

public class EntitiesImpl
implements Entities {
    private final JSqlClientImplementor sqlClient;
    private final boolean forUpdate;
    private final Connection con;
    private final ExecutionPurpose purpose;

    public EntitiesImpl(JSqlClientImplementor sqlClient) {
        this(sqlClient, false, null, ExecutionPurpose.QUERY);
    }

    public EntitiesImpl(JSqlClientImplementor sqlClient, boolean forUpdate, Connection con, ExecutionPurpose purpose) {
        this.sqlClient = sqlClient;
        this.forUpdate = forUpdate;
        this.con = con;
        this.purpose = purpose;
    }

    public JSqlClientImplementor getSqlClient() {
        return this.sqlClient;
    }

    public Connection getCon() {
        return this.con;
    }

    public EntitiesImpl forSqlClient(JSqlClientImplementor sqlClient) {
        if (this.sqlClient == sqlClient) {
            return this;
        }
        return new EntitiesImpl(sqlClient, this.forUpdate, this.con, this.purpose);
    }

    @Override
    public Entities forUpdate() {
        if (this.forUpdate) {
            return this;
        }
        return new EntitiesImpl(this.sqlClient, true, this.con, this.purpose);
    }

    @Override
    public Entities forConnection(Connection con) {
        if (this.con == con) {
            return this;
        }
        return new EntitiesImpl(this.sqlClient, this.forUpdate, con, this.purpose);
    }

    public Entities forLoader() {
        if (this.purpose == ExecutionPurpose.LOAD) {
            return this;
        }
        return new EntitiesImpl(this.sqlClient, this.forUpdate, this.con, ExecutionPurpose.LOAD);
    }

    public Entities forExporter() {
        if (this.purpose == ExecutionPurpose.EXPORT) {
            return this;
        }
        return new EntitiesImpl(this.sqlClient, this.forUpdate, this.con, ExecutionPurpose.EXPORT);
    }

    @Override
    public <E> E findById(Class<E> entityType, Object id) {
        if (this.con != null) {
            return this.findById(entityType, id, this.con);
        }
        return (E)this.sqlClient.getConnectionManager().execute(con -> this.findById(entityType, id, (Connection)con));
    }

    @Override
    public <E> List<E> findByIds(Class<E> entityType, Collection<?> ids) {
        if (this.con != null) {
            return this.findByIds(entityType, ids, this.con);
        }
        return this.sqlClient.getConnectionManager().execute(con -> this.findByIds(entityType, ids, (Connection)con));
    }

    @Override
    public <ID, E> Map<ID, E> findMapByIds(Class<E> entityType, Collection<ID> ids) {
        if (this.con != null) {
            return this.findMapByIds(entityType, ids, this.con);
        }
        return this.sqlClient.getConnectionManager().execute(con -> this.findMapByIds(entityType, ids, (Connection)con));
    }

    @Override
    public <E> E findById(Fetcher<E> fetcher, Object id) {
        if (this.con != null) {
            return this.findById(fetcher, id, this.con);
        }
        return (E)this.sqlClient.getConnectionManager().execute(con -> this.findById(fetcher, id, (Connection)con));
    }

    @Override
    public <E> List<E> findByIds(Fetcher<E> fetcher, Collection<?> ids) {
        if (this.con != null) {
            return this.findByIds(fetcher, ids, this.con);
        }
        return this.sqlClient.getConnectionManager().execute(con -> this.findByIds(fetcher, ids, (Connection)con));
    }

    @Override
    public <ID, E> Map<ID, E> findMapByIds(Fetcher<E> fetcher, Collection<ID> ids) {
        if (this.con != null) {
            return this.findMapByIds(fetcher, ids, this.con);
        }
        return this.sqlClient.getConnectionManager().execute(con -> this.findMapByIds(fetcher, ids, (Connection)con));
    }

    private <E> E findById(Class<E> entityType, Object id, Connection con) {
        if (id instanceof Collection) {
            throw new IllegalArgumentException("id cannot be collection, do you want to call 'findByIds'?");
        }
        List<E> rows = this.findByIds(entityType, null, Collections.singleton(id), con);
        return rows.isEmpty() ? null : (E)rows.get(0);
    }

    private <E> List<E> findByIds(Class<E> entityType, Collection<?> ids, Connection con) {
        return this.findByIds(entityType, null, ids, con);
    }

    private <ID, E> Map<ID, E> findMapByIds(Class<E> entityType, Collection<ID> ids, Connection con) {
        ImmutableProp idProp = ImmutableType.get(entityType).getIdProp();
        return this.findByIds(entityType, null, ids, con).stream().collect(Collectors.toMap(it -> ((ImmutableSpi)it).__get(idProp.getId()), Function.identity(), (a, b) -> {
            throw new IllegalStateException("Objects with same id");
        }, LinkedHashMap::new));
    }

    private <E> E findById(Fetcher<E> fetcher, Object id, Connection con) {
        if (id instanceof Collection) {
            throw new IllegalArgumentException("id cannot be collection, do you want to call 'findByIds'?");
        }
        List<E> rows = this.findByIds(fetcher.getJavaClass(), fetcher, Collections.singleton(id), con);
        return rows.isEmpty() ? null : (E)rows.get(0);
    }

    private <E> List<E> findByIds(Fetcher<E> fetcher, Collection<?> ids, Connection con) {
        return this.findByIds(fetcher.getJavaClass(), fetcher, ids, con);
    }

    private <ID, E> Map<ID, E> findMapByIds(Fetcher<E> fetcher, Collection<ID> ids, Connection con) {
        ImmutableProp idProp = ImmutableType.get(fetcher.getJavaClass()).getIdProp();
        return this.findByIds(fetcher.getJavaClass(), fetcher, ids, con).stream().collect(Collectors.toMap(it -> ((ImmutableSpi)it).__get(idProp.getId()), Function.identity(), (a, b) -> {
            throw new IllegalStateException("Objects with same id");
        }, LinkedHashMap::new));
    }

    private <E> List<E> findByIds(Class<E> entityType, final Fetcher<E> fetcher, Collection<?> ids, Connection con) {
        if (ids == null || ids.isEmpty()) {
            return Collections.emptyList();
        }
        LinkedHashSet distinctIds = ids instanceof Set ? (LinkedHashSet)ids : new LinkedHashSet(ids);
        ImmutableType immutableType = ImmutableType.get(entityType);
        Class idClass = immutableType.getIdProp().getElementClass();
        for (Object id : distinctIds) {
            if (Converters.tryConvert(id, idClass) != null) continue;
            throw new IllegalArgumentException("The type of \"" + immutableType.getIdProp() + "\" must be \"" + idClass.getName() + "\"");
        }
        Cache cache = this.sqlClient.getCaches().getObjectCache(immutableType);
        if (cache != null) {
            ArrayList entities = new ArrayList(cache.getAll(distinctIds, new CacheEnvironment(this.sqlClient, con, CacheLoader.objectLoader(this.sqlClient, con, immutableType.getJavaClass()), true)).values());
            if (fetcher != null && !entities.isEmpty()) {
                boolean needUnload = false;
                block1: for (ImmutableSpi spi : entities) {
                    for (ImmutableProp prop : immutableType.getProps().values()) {
                        if (!spi.__isLoaded(prop.getId()) || fetcher.getFieldMap().containsKey(prop.getName())) continue;
                        needUnload = true;
                        continue block1;
                    }
                }
                if (needUnload) {
                    ListIterator<ImmutableSpi> itr = entities.listIterator();
                    while (itr.hasNext()) {
                        ImmutableSpi spi;
                        spi = (ImmutableSpi)itr.next();
                        itr.set((ImmutableSpi)Internal.produce((ImmutableType)immutableType, (Object)spi, draft -> {
                            for (ImmutableProp prop : immutableType.getProps().values()) {
                                if (prop.isView() || !spi.__isLoaded(prop.getId()) || fetcher.getFieldMap().containsKey(prop.getName())) continue;
                                ((DraftSpi)draft).__unload(prop.getId());
                            }
                        }));
                    }
                }
                Fetchers.fetch(this.sqlClient, con, Collections.singletonList(new FetcherSelection<E>(){

                    @Override
                    public Fetcher<?> getFetcher() {
                        return fetcher;
                    }
                }), entities);
            }
            return entities;
        }
        ConfigurableRootQuery query = Queries.createQuery(this.sqlClient, immutableType, this.purpose, true, (q, table) -> {
            Object idProp = table.get(immutableType.getIdProp().getName());
            if (distinctIds.size() == 1) {
                q.where(new Predicate[]{idProp.eq(distinctIds.iterator().next())});
            } else {
                q.where(new Predicate[]{idProp.in(distinctIds)});
            }
            return q.select(table.fetch(fetcher));
        });
        if (this.forUpdate) {
            query = query.forUpdate(true);
        }
        return (List)query.execute(con);
    }

    @Override
    public <E> List<E> findAll(Class<E> type, TypedProp.Scalar<?, ?> ... sortedProps) {
        return this.find(ImmutableType.get(type), null, null, sortedProps);
    }

    @Override
    public <E> List<E> findAll(Fetcher<E> fetcher, TypedProp.Scalar<?, ?> ... sortedProps) {
        return this.find(fetcher.getImmutableType(), fetcher, null, sortedProps);
    }

    @Override
    public <E> List<E> findByExample(Example<E> example, TypedProp.Scalar<?, ?> ... sortedProps) {
        ExampleImpl exampleImpl = (ExampleImpl)example;
        return this.find(exampleImpl.type(), null, exampleImpl, sortedProps);
    }

    @Override
    public <E> List<E> findByExample(Example<E> example, Fetcher<E> fetcher, TypedProp.Scalar<?, ?> ... sortedProps) {
        ExampleImpl exampleImpl = (ExampleImpl)example;
        return this.find(exampleImpl.type(), fetcher, exampleImpl, sortedProps);
    }

    private <E> List<E> find(ImmutableType type, Fetcher<E> fetcher, ExampleImpl<E> example, TypedProp.Scalar<?, ?> ... sortedProps) {
        if (fetcher != null && fetcher.getImmutableType() != type) {
            throw new IllegalArgumentException("The type of fetcher is \"" + fetcher.getImmutableType() + "\", it does not match the query root type \"" + type + "\"");
        }
        if (example != null && example.type() != type) {
            throw new IllegalArgumentException("The type of example is \"" + example.type() + "\", it does not match the query root type \"" + type + "\"");
        }
        MutableRootQueryImpl query = new MutableRootQueryImpl(this.sqlClient, type, ExecutionPurpose.QUERY, false);
        Object table = query.getTable();
        if (example != null) {
            example.applyTo(query);
        }
        for (TypedProp.Scalar<?, ?> sortedProp : sortedProps) {
            if (!sortedProp.unwrap().getDeclaringType().isAssignableFrom(type)) {
                throw new IllegalArgumentException("The sorted field \"" + sortedProp + "\" does not belong to the type \"" + type + "\" or its super types");
            }
            Object expr = table.get(sortedProp.unwrap().getName());
            Order astOrder = sortedProp.isDesc() ? expr.desc() : expr.asc();
            if (sortedProp.isNullsFirst()) {
                astOrder = astOrder.nullsFirst();
            }
            if (sortedProp.isNullsLast()) {
                astOrder = astOrder.nullsLast();
            }
            query.orderBy(new Order[]{astOrder});
        }
        query.freeze();
        return (List)query.select(fetcher != null ? table.fetch(fetcher) : table).execute(this.con);
    }

    @Override
    public <E> SimpleEntitySaveCommand<E> saveCommand(E entity) {
        if (entity instanceof Collection) {
            throw new IllegalArgumentException("entity cannot be collection, do you want to call 'batchSaveCommand'?");
        }
        if (entity instanceof Input) {
            throw new IllegalArgumentException("entity cannot be input, please call another overloaded function whose parameter is input");
        }
        return new SimpleEntitySaveCommandImpl<E>(this.sqlClient, this.con, entity);
    }

    @Override
    public <E> BatchEntitySaveCommand<E> batchSaveCommand(Collection<E> entities) {
        for (E e : entities) {
            if (!(e instanceof Input)) continue;
            throw new IllegalArgumentException("the collection cannot contains input, please call another overloaded function whose parameter is input collection");
        }
        return new BatchEntitySaveCommandImpl<E>(this.sqlClient, this.con, entities);
    }

    @Override
    public DeleteCommand deleteCommand(Class<?> entityType, Object id) {
        if (id instanceof Collection) {
            throw new IllegalArgumentException("`id` cannot be collection, do you want to call 'batchDeleteCommand'?");
        }
        if (id instanceof ImmutableSpi && ((ImmutableSpi)id).__type().isEntity() || id instanceof Input) {
            throw new IllegalArgumentException("`id` must be simple type");
        }
        return this.batchDeleteCommand(entityType, Collections.singleton(id));
    }

    @Override
    public DeleteCommand batchDeleteCommand(Class<?> entityType, Collection<?> ids) {
        for (Object id : ids) {
            if ((!(id instanceof ImmutableSpi) || !((ImmutableSpi)id).__type().isEntity()) && !(id instanceof Input)) continue;
            throw new IllegalArgumentException("All the elements of `ids` must be simple type");
        }
        ImmutableType immutableType = ImmutableType.get(entityType);
        return new DeleteCommandImpl(this.sqlClient, this.con, immutableType, ids);
    }
}

