/*
 * Decompiled with CFR 0.152.
 */
package org.babyfish.jimmer.sql.fetcher.impl;

import java.util.HashMap;
import java.util.Map;
import java.util.Objects;
import org.babyfish.jimmer.meta.ImmutableProp;
import org.babyfish.jimmer.runtime.DraftContext;
import org.babyfish.jimmer.runtime.DraftSpi;
import org.babyfish.jimmer.runtime.ImmutableSpi;
import org.babyfish.jimmer.sql.fetcher.Field;
import org.babyfish.jimmer.sql.fetcher.FieldFilter;
import org.babyfish.jimmer.sql.fetcher.impl.Ids;

public class FetchingCache {
    private static final Object NULL = new Object();
    private Map<FieldKey, Map<Object, Object>> map = new HashMap<FieldKey, Map<Object, Object>>();

    public Object createKey(Field field, ImmutableSpi owner) {
        ImmutableProp prop = field.getProp();
        if (prop.isColumnDefinition()) {
            Object fk = Ids.idOf((ImmutableSpi)owner.__get(prop.getId()));
            DraftContext ctx = owner instanceof DraftSpi ? ((DraftSpi)owner).__draftContext() : null;
            return new ForeignKey(fk, ctx);
        }
        return Ids.idOf(owner);
    }

    public Object get(Field field, Object key) {
        Map<Object, Object> subMap = this.map.get(new FieldKey(field));
        if (subMap == null) {
            return null;
        }
        return subMap.get(key);
    }

    public void put(Field field, Object key, Object value) {
        Map subMap = this.map.computeIfAbsent(new FieldKey(field), it -> new HashMap());
        subMap.put(key, value != null ? value : NULL);
    }

    public static Object unwrap(Object value) {
        return value == NULL ? null : value;
    }

    private static class ForeignKey {
        private final Object raw;
        private final DraftContext ctx;

        private ForeignKey(Object raw, DraftContext ctx) {
            this.raw = raw;
            this.ctx = ctx;
        }

        public int hashCode() {
            return Objects.hash(this.raw, this.ctx);
        }

        public boolean equals(Object o) {
            if (this == o) {
                return true;
            }
            if (o == null || this.getClass() != o.getClass()) {
                return false;
            }
            ForeignKey that = (ForeignKey)o;
            return Objects.equals(this.raw, that.raw) && this.ctx == that.ctx;
        }

        public String toString() {
            return "ForeignKey{raw=" + this.raw + "ctx=" + this.ctx + '}';
        }
    }

    private static class FieldKey {
        private final ImmutableProp prop;
        private final FieldFilter<?> filter;
        private final int limit;
        private final int offset;

        FieldKey(Field field) {
            this(field.getProp(), field.getFilter(), field.getLimit(), field.getOffset());
        }

        FieldKey(ImmutableProp prop, FieldFilter<?> filter, int limit, int offset) {
            this.prop = prop;
            this.filter = filter;
            this.limit = limit;
            this.offset = offset;
        }

        public int hashCode() {
            return Objects.hash(this.prop, this.filter, this.limit, this.offset);
        }

        public boolean equals(Object o) {
            if (this == o) {
                return true;
            }
            if (o == null || this.getClass() != o.getClass()) {
                return false;
            }
            FieldKey fieldKey = (FieldKey)o;
            return this.limit == fieldKey.limit && this.offset == fieldKey.offset && this.prop.equals((Object)fieldKey.prop) && Objects.equals(this.filter, fieldKey.filter);
        }

        public String toString() {
            return "FieldKey{prop=" + this.prop + ", filter=" + this.filter + ", limit=" + this.limit + ", offset=" + this.offset + '}';
        }
    }
}

