/*
 * Decompiled with CFR 0.152.
 */
package org.babyfish.jimmer.sql.ast.impl.mutation;

import java.sql.Connection;
import java.sql.PreparedStatement;
import java.util.Arrays;
import java.util.Collection;
import java.util.Collections;
import java.util.Iterator;
import java.util.LinkedHashSet;
import java.util.List;
import java.util.Set;
import org.babyfish.jimmer.meta.ImmutableProp;
import org.babyfish.jimmer.sql.ast.Expression;
import org.babyfish.jimmer.sql.ast.impl.AstContext;
import org.babyfish.jimmer.sql.ast.impl.mutation.MutationTrigger;
import org.babyfish.jimmer.sql.ast.tuple.Tuple2;
import org.babyfish.jimmer.sql.ast.tuple.Tuple3;
import org.babyfish.jimmer.sql.meta.MetadataStrategy;
import org.babyfish.jimmer.sql.meta.MiddleTable;
import org.babyfish.jimmer.sql.meta.Storage;
import org.babyfish.jimmer.sql.runtime.ExecutionPurpose;
import org.babyfish.jimmer.sql.runtime.Executor;
import org.babyfish.jimmer.sql.runtime.JSqlClientImplementor;
import org.babyfish.jimmer.sql.runtime.Selectors;
import org.babyfish.jimmer.sql.runtime.SqlBuilder;

class MiddleTableOperator {
    private final JSqlClientImplementor sqlClient;
    private final Connection con;
    private final ImmutableProp prop;
    private final boolean isBackProp;
    private final MiddleTable middleTable;
    private final Expression<?> sourceIdExpression;
    private final Expression<?> targetIdExpression;
    private final MutationTrigger trigger;

    private MiddleTableOperator(JSqlClientImplementor sqlClient, Connection con, ImmutableProp prop, boolean isBackProp, MiddleTable middleTable, MutationTrigger trigger) {
        this.sqlClient = sqlClient;
        this.con = con;
        this.prop = prop;
        this.isBackProp = isBackProp;
        this.middleTable = middleTable;
        if (isBackProp) {
            this.sourceIdExpression = Expression.any().nullValue(prop.getTargetType().getIdProp().getElementClass());
            this.targetIdExpression = Expression.any().nullValue(prop.getDeclaringType().getIdProp().getElementClass());
        } else {
            this.sourceIdExpression = Expression.any().nullValue(prop.getDeclaringType().getIdProp().getElementClass());
            this.targetIdExpression = Expression.any().nullValue(prop.getTargetType().getIdProp().getElementClass());
        }
        this.trigger = trigger;
    }

    public static MiddleTableOperator tryGet(JSqlClientImplementor sqlClient, Connection con, ImmutableProp prop, MutationTrigger trigger) {
        return MiddleTableOperator.tryGetImpl(sqlClient, con, prop, false, trigger);
    }

    public static MiddleTableOperator tryGetByBackProp(JSqlClientImplementor sqlClient, Connection con, ImmutableProp backProp, MutationTrigger trigger) {
        return MiddleTableOperator.tryGetImpl(sqlClient, con, backProp, true, trigger);
    }

    private static MiddleTableOperator tryGetImpl(JSqlClientImplementor sqlClient, Connection con, ImmutableProp prop, boolean isPropBack, MutationTrigger trigger) {
        ImmutableProp mappedBy = prop.getMappedBy();
        if (mappedBy != null && prop.isRemote()) {
            return null;
        }
        MetadataStrategy strategy = sqlClient.getMetadataStrategy();
        if (mappedBy != null) {
            Storage storage = mappedBy.getStorage(strategy);
            if (storage instanceof MiddleTable) {
                MiddleTable middleTable = isPropBack ? (MiddleTable)storage : ((MiddleTable)storage).getInverse();
                return new MiddleTableOperator(sqlClient, con, prop, isPropBack, middleTable, trigger);
            }
        } else {
            Storage storage = prop.getStorage(strategy);
            if (storage instanceof MiddleTable) {
                MiddleTable middleTable = isPropBack ? ((MiddleTable)storage).getInverse() : (MiddleTable)storage;
                return new MiddleTableOperator(sqlClient, con, prop, isPropBack, middleTable, trigger);
            }
        }
        return null;
    }

    List<Object> getTargetIds(Object id) {
        SqlBuilder builder = new SqlBuilder(new AstContext(this.sqlClient));
        builder.enter(SqlBuilder.ScopeType.SELECT).definition(this.middleTable.getTargetColumnDefinition()).leave().from().sql(this.middleTable.getTableName()).enter(SqlBuilder.ScopeType.WHERE).definition(null, this.middleTable.getColumnDefinition(), true).sql(" = ").variable(id).leave();
        Tuple3<String, List<Object>, List<Integer>> sqlResult = builder.build();
        return Selectors.select(this.sqlClient, this.con, sqlResult.get_1(), sqlResult.get_2(), sqlResult.get_3(), Collections.singletonList(this.targetIdExpression), ExecutionPurpose.MUTATE);
    }

    private IdPairReader filterReader(IdPairReader reader) {
        if (!reader.isReadable()) {
            return new TupleReader(Collections.emptyList());
        }
        SqlBuilder builder = new SqlBuilder(new AstContext(this.sqlClient));
        builder.enter(SqlBuilder.ScopeType.SELECT).definition(this.middleTable.getColumnDefinition()).separator().definition(this.middleTable.getTargetColumnDefinition()).leave().from().sql(this.middleTable.getTableName()).enter(SqlBuilder.ScopeType.WHERE).enter(SqlBuilder.ScopeType.TUPLE).definition(this.middleTable.getColumnDefinition()).separator().definition(this.middleTable.getTargetColumnDefinition()).leave().sql(" in ").enter(SqlBuilder.ScopeType.LIST);
        while (reader.read()) {
            builder.separator();
            builder.enter(SqlBuilder.ScopeType.TUPLE).variable(reader.sourceId()).separator().variable(reader.targetId()).leave();
        }
        builder.leave().leave();
        reader.reset();
        Tuple3<String, List<Object>, List<Integer>> sqlResult = builder.build();
        List<Tuple2<Object, Object>> tuples = Selectors.select(this.sqlClient, this.con, sqlResult.get_1(), sqlResult.get_2(), sqlResult.get_3(), Arrays.asList(this.sourceIdExpression, this.targetIdExpression), ExecutionPurpose.MUTATE);
        return new TupleReader(tuples);
    }

    IdPairReader getIdPairReader(Collection<Object> sourceIds) {
        SqlBuilder builder = new SqlBuilder(new AstContext(this.sqlClient));
        builder.enter(SqlBuilder.ScopeType.SELECT).definition(this.middleTable.getColumnDefinition()).separator().definition(this.middleTable.getTargetColumnDefinition()).leave().from().sql(this.middleTable.getTableName()).enter(SqlBuilder.ScopeType.WHERE).definition(null, this.middleTable.getColumnDefinition(), true).sql(" in ").enter(SqlBuilder.ScopeType.LIST);
        for (Object sourceId : sourceIds) {
            builder.separator().variable(sourceId);
        }
        builder.leave().leave();
        Tuple3<String, List<Object>, List<Integer>> sqlResult = builder.build();
        List<Tuple2<Object, Object>> tuples = Selectors.select(this.sqlClient, this.con, sqlResult.get_1(), sqlResult.get_2(), sqlResult.get_3(), Arrays.asList(this.sourceIdExpression, this.targetIdExpression), ExecutionPurpose.MUTATE);
        return new TupleReader(tuples);
    }

    int addTargetIds(Object sourceId, Collection<Object> targetIds) {
        if (targetIds.isEmpty()) {
            return 0;
        }
        Set<Object> set = targetIds instanceof Set ? (Set<Object>)targetIds : new LinkedHashSet<Object>(targetIds);
        return this.add(new OneToManyReader(sourceId, (Collection<Object>)set));
    }

    int add(IdPairReader reader) {
        if (!reader.isReadable()) {
            return 0;
        }
        this.tryPrepareEvent(true, reader);
        SqlBuilder builder = new SqlBuilder(new AstContext(this.sqlClient));
        builder.sql("insert into ").sql(this.middleTable.getTableName()).enter(SqlBuilder.ScopeType.TUPLE).definition(this.middleTable.getColumnDefinition()).separator().definition(this.middleTable.getTargetColumnDefinition()).leave();
        if (this.sqlClient.getDialect().isMultiInsertionSupported()) {
            builder.enter(SqlBuilder.ScopeType.VALUES);
            while (reader.read()) {
                builder.separator().enter(SqlBuilder.ScopeType.TUPLE).variable(reader.sourceId()).separator().variable(reader.targetId()).leave();
            }
            builder.leave();
        } else {
            builder.sql(" ");
            String fromConstant = this.sqlClient.getDialect().getConstantTableName();
            if (fromConstant != null) {
                fromConstant = " from " + fromConstant;
            }
            builder.enter("?union all?");
            while (reader.read()) {
                builder.separator().enter(SqlBuilder.ScopeType.SELECT).variable(reader.sourceId()).separator().variable(reader.targetId()).leave();
                if (fromConstant == null) continue;
                builder.sql(fromConstant);
            }
            builder.leave();
        }
        Tuple3<String, List<Object>, List<Integer>> sqlResult = builder.build();
        return this.sqlClient.getExecutor().execute(new Executor.Args<Integer>(this.sqlClient, this.con, sqlResult.get_1(), sqlResult.get_2(), sqlResult.get_3(), ExecutionPurpose.MUTATE, null, PreparedStatement::executeUpdate));
    }

    int remove(Object sourceId, Collection<Object> targetIds) {
        if (targetIds.isEmpty()) {
            return 0;
        }
        Set<Object> set = targetIds instanceof Set ? (Set<Object>)targetIds : new LinkedHashSet<Object>(targetIds);
        return this.remove(new OneToManyReader(sourceId, (Collection<Object>)set));
    }

    int remove(IdPairReader reader) {
        return this.remove(reader, false);
    }

    int remove(IdPairReader reader, boolean checkExistence) {
        if (!reader.isReadable()) {
            return 0;
        }
        if (checkExistence && !(reader = this.filterReader(reader)).isReadable()) {
            return 0;
        }
        this.tryPrepareEvent(false, reader);
        SqlBuilder builder = new SqlBuilder(new AstContext(this.sqlClient));
        builder.sql("delete from ").sql(this.middleTable.getTableName()).enter(SqlBuilder.ScopeType.WHERE).enter(SqlBuilder.ScopeType.TUPLE).definition(this.middleTable.getColumnDefinition()).separator().definition(this.middleTable.getTargetColumnDefinition()).leave().sql(" in ").enter(SqlBuilder.ScopeType.LIST);
        while (reader.read()) {
            builder.separator().enter(SqlBuilder.ScopeType.TUPLE).variable(reader.sourceId()).separator().variable(reader.targetId()).leave();
        }
        builder.leave().leave();
        Tuple3<String, List<Object>, List<Integer>> sqlResult = builder.build();
        return this.sqlClient.getExecutor().execute(new Executor.Args<Integer>(this.sqlClient, this.con, sqlResult.get_1(), sqlResult.get_2(), sqlResult.get_3(), ExecutionPurpose.MUTATE, null, PreparedStatement::executeUpdate));
    }

    int setTargetIds(Object sourceId, Collection<Object> targetIds) {
        LinkedHashSet<Object> oldTargetIds = new LinkedHashSet<Object>(this.getTargetIds(sourceId));
        LinkedHashSet<Object> addingTargetIds = new LinkedHashSet<Object>(targetIds);
        addingTargetIds.removeAll(oldTargetIds);
        LinkedHashSet<Object> removingTargetIds = new LinkedHashSet<Object>(oldTargetIds);
        removingTargetIds.removeAll(targetIds);
        return this.remove(sourceId, removingTargetIds) + this.addTargetIds(sourceId, addingTargetIds);
    }

    public int removeBySourceIds(Collection<Object> sourceIds) {
        if (this.trigger != null) {
            IdPairReader reader = this.getIdPairReader(sourceIds);
            return this.remove(reader);
        }
        SqlBuilder builder = new SqlBuilder(new AstContext(this.sqlClient));
        builder.sql("delete from ").sql(this.middleTable.getTableName()).enter(SqlBuilder.ScopeType.WHERE).definition(null, this.middleTable.getColumnDefinition(), true).sql(" in ").enter(SqlBuilder.ScopeType.LIST);
        for (Object id : sourceIds) {
            builder.separator().variable(id);
        }
        builder.leave().leave();
        Tuple3<String, List<Object>, List<Integer>> sqlResult = builder.build();
        return this.sqlClient.getExecutor().execute(new Executor.Args<Integer>(this.sqlClient, this.con, sqlResult.get_1(), sqlResult.get_2(), sqlResult.get_3(), ExecutionPurpose.DELETE, null, PreparedStatement::executeUpdate));
    }

    private void tryPrepareEvent(boolean insert, IdPairReader reader) {
        MutationTrigger trigger = this.trigger;
        if (trigger == null) {
            return;
        }
        while (reader.read()) {
            Object sourceId = reader.sourceId();
            Object targetId = reader.targetId();
            if (this.isBackProp) {
                if (insert) {
                    trigger.insertMiddleTable(this.prop, targetId, sourceId);
                    continue;
                }
                trigger.deleteMiddleTable(this.prop, targetId, sourceId);
                continue;
            }
            if (insert) {
                trigger.insertMiddleTable(this.prop, sourceId, targetId);
                continue;
            }
            trigger.deleteMiddleTable(this.prop, sourceId, targetId);
        }
        reader.reset();
    }

    static interface IdPairReader {
        public void reset();

        public boolean read();

        public boolean isReadable();

        public Object sourceId();

        public Object targetId();
    }

    public static class TupleReader
    implements IdPairReader {
        private final Collection<Tuple2<Object, Object>> idTuples;
        private Iterator<Tuple2<Object, Object>> idTupleItr;
        private Tuple2<Object, Object> currentIdPair;

        public TupleReader(Collection<Tuple2<Object, Object>> idTuples) {
            this.idTuples = idTuples;
            this.idTupleItr = idTuples.iterator();
        }

        @Override
        public void reset() {
            this.idTupleItr = this.idTuples.iterator();
        }

        @Override
        public boolean read() {
            if (this.idTupleItr.hasNext()) {
                this.currentIdPair = this.idTupleItr.next();
                return true;
            }
            return false;
        }

        @Override
        public boolean isReadable() {
            return this.idTupleItr.hasNext();
        }

        @Override
        public Object sourceId() {
            return this.currentIdPair.get_1();
        }

        @Override
        public Object targetId() {
            return this.currentIdPair.get_2();
        }
    }

    private static class OneToManyReader
    implements IdPairReader {
        private final Object sourceId;
        private final Collection<Object> targetIds;
        private Iterator<Object> targetIdItr;
        private Object currentTargetId;

        OneToManyReader(Object sourceId, Collection<Object> targetIds) {
            this.sourceId = sourceId;
            this.targetIds = targetIds;
            this.targetIdItr = targetIds.iterator();
        }

        @Override
        public void reset() {
            this.targetIdItr = this.targetIds.iterator();
        }

        @Override
        public boolean read() {
            if (this.targetIdItr.hasNext()) {
                this.currentTargetId = this.targetIdItr.next();
                return true;
            }
            return false;
        }

        @Override
        public boolean isReadable() {
            return this.targetIdItr.hasNext();
        }

        @Override
        public Object sourceId() {
            return this.sourceId;
        }

        @Override
        public Object targetId() {
            return this.currentTargetId;
        }
    }
}

