/*
 * Decompiled with CFR 0.152.
 */
package org.babyfish.jimmer.sql;

import com.fasterxml.jackson.databind.ObjectMapper;
import java.lang.reflect.Type;
import java.sql.SQLException;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collection;
import java.util.Collections;
import java.util.HashMap;
import java.util.HashSet;
import java.util.LinkedHashSet;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.Set;
import java.util.TreeSet;
import java.util.function.Consumer;
import org.babyfish.jimmer.meta.ImmutableProp;
import org.babyfish.jimmer.meta.ImmutableType;
import org.babyfish.jimmer.meta.ModelException;
import org.babyfish.jimmer.meta.TargetLevel;
import org.babyfish.jimmer.meta.TypedProp;
import org.babyfish.jimmer.sql.Associations;
import org.babyfish.jimmer.sql.DraftInterceptor;
import org.babyfish.jimmer.sql.DraftInterceptorManager;
import org.babyfish.jimmer.sql.Entities;
import org.babyfish.jimmer.sql.EnumType;
import org.babyfish.jimmer.sql.JSqlClient;
import org.babyfish.jimmer.sql.ScalarProviderManager;
import org.babyfish.jimmer.sql.TransientResolver;
import org.babyfish.jimmer.sql.TransientResolverManager;
import org.babyfish.jimmer.sql.association.meta.AssociationType;
import org.babyfish.jimmer.sql.ast.impl.EntitiesImpl;
import org.babyfish.jimmer.sql.ast.impl.mutation.AssociationsImpl;
import org.babyfish.jimmer.sql.ast.impl.mutation.MutableDeleteImpl;
import org.babyfish.jimmer.sql.ast.impl.mutation.MutableUpdateImpl;
import org.babyfish.jimmer.sql.ast.impl.query.MutableRootQueryImpl;
import org.babyfish.jimmer.sql.ast.impl.query.MutableSubQueryImpl;
import org.babyfish.jimmer.sql.ast.mutation.MutableDelete;
import org.babyfish.jimmer.sql.ast.mutation.MutableUpdate;
import org.babyfish.jimmer.sql.ast.query.MutableRootQuery;
import org.babyfish.jimmer.sql.ast.query.MutableSubQuery;
import org.babyfish.jimmer.sql.ast.table.AssociationTable;
import org.babyfish.jimmer.sql.ast.table.Props;
import org.babyfish.jimmer.sql.ast.table.Table;
import org.babyfish.jimmer.sql.ast.table.TableEx;
import org.babyfish.jimmer.sql.ast.table.spi.TableProxy;
import org.babyfish.jimmer.sql.cache.CacheConfig;
import org.babyfish.jimmer.sql.cache.CacheDisableConfig;
import org.babyfish.jimmer.sql.cache.Caches;
import org.babyfish.jimmer.sql.cache.CachesImpl;
import org.babyfish.jimmer.sql.dialect.DefaultDialect;
import org.babyfish.jimmer.sql.dialect.Dialect;
import org.babyfish.jimmer.sql.event.TriggerType;
import org.babyfish.jimmer.sql.event.Triggers;
import org.babyfish.jimmer.sql.event.TriggersImpl;
import org.babyfish.jimmer.sql.event.binlog.BinLog;
import org.babyfish.jimmer.sql.event.binlog.BinLogParser;
import org.babyfish.jimmer.sql.filter.Filter;
import org.babyfish.jimmer.sql.filter.FilterConfig;
import org.babyfish.jimmer.sql.filter.Filters;
import org.babyfish.jimmer.sql.filter.impl.BuiltinFiltersImpl;
import org.babyfish.jimmer.sql.filter.impl.FilterManager;
import org.babyfish.jimmer.sql.loader.graphql.Loaders;
import org.babyfish.jimmer.sql.loader.graphql.impl.LoadersImpl;
import org.babyfish.jimmer.sql.meta.DatabaseNamingStrategy;
import org.babyfish.jimmer.sql.meta.ForeignKeyStrategy;
import org.babyfish.jimmer.sql.meta.IdGenerator;
import org.babyfish.jimmer.sql.meta.MetadataStrategy;
import org.babyfish.jimmer.sql.runtime.ConnectionManager;
import org.babyfish.jimmer.sql.runtime.Customizer;
import org.babyfish.jimmer.sql.runtime.DatabaseValidationException;
import org.babyfish.jimmer.sql.runtime.DatabaseValidationMode;
import org.babyfish.jimmer.sql.runtime.DatabaseValidators;
import org.babyfish.jimmer.sql.runtime.DefaultDatabaseNamingStrategy;
import org.babyfish.jimmer.sql.runtime.DefaultExecutor;
import org.babyfish.jimmer.sql.runtime.DefaultTransientResolverProvider;
import org.babyfish.jimmer.sql.runtime.EntityManager;
import org.babyfish.jimmer.sql.runtime.ExecutionException;
import org.babyfish.jimmer.sql.runtime.ExecutionPurpose;
import org.babyfish.jimmer.sql.runtime.Executor;
import org.babyfish.jimmer.sql.runtime.Initializer;
import org.babyfish.jimmer.sql.runtime.JSqlClientImplementor;
import org.babyfish.jimmer.sql.runtime.MicroServiceExchange;
import org.babyfish.jimmer.sql.runtime.Reader;
import org.babyfish.jimmer.sql.runtime.ReaderManager;
import org.babyfish.jimmer.sql.runtime.ScalarProvider;
import org.babyfish.jimmer.sql.runtime.SqlFormatter;
import org.babyfish.jimmer.sql.runtime.TransientResolverProvider;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

class JSqlClientImpl
implements JSqlClientImplementor {
    private final ConnectionManager connectionManager;
    private final ConnectionManager slaveConnectionManager;
    private final Dialect dialect;
    private final Executor executor;
    private final List<String> executorContextPrefixes;
    private final SqlFormatter sqlFormatter;
    private final Map<Class<?>, IdGenerator> idGeneratorMap;
    private final ScalarProviderManager scalarProviderManager;
    private final int defaultBatchSize;
    private final int defaultListBatchSize;
    private final int offsetOptimizingThreshold;
    private final EntitiesImpl entities;
    private final EntityManager entityManager;
    private final Caches caches;
    private final Triggers triggers;
    private final Triggers transactionTriggers;
    private final MetadataStrategy metadataStrategy;
    private final BinLog binLog;
    private final TransientResolverManager transientResolverManager;
    private final FilterManager filterManager;
    private final DraftInterceptorManager draftInterceptorManager;
    private final String microServiceName;
    private final MicroServiceExchange microServiceExchange;
    private final Loaders loaders = new LoadersImpl(this);
    private final ReaderManager readerManager = new ReaderManager(this);

    private JSqlClientImpl(ConnectionManager connectionManager, ConnectionManager slaveConnectionManager, Dialect dialect, Executor executor, List<String> executorContextPrefixes, SqlFormatter sqlFormatter, Map<Class<?>, IdGenerator> idGeneratorMap, ScalarProviderManager scalarProviderManager, int defaultBatchSize, int defaultListBatchSize, int offsetOptimizingThreshold, EntitiesImpl entities, EntityManager entityManager, Caches caches, Triggers triggers, Triggers transactionTriggers, MetadataStrategy metadataStrategy, BinLog binLog, FilterManager filterManager, TransientResolverManager transientResolverManager, DraftInterceptorManager draftInterceptorManager, String microServiceName, MicroServiceExchange microServiceExchange) {
        this.connectionManager = connectionManager != null ? connectionManager : ConnectionManager.ILLEGAL;
        this.slaveConnectionManager = slaveConnectionManager;
        this.dialect = dialect;
        this.executor = executor != null ? executor : DefaultExecutor.INSTANCE;
        this.executorContextPrefixes = executorContextPrefixes != null ? Collections.unmodifiableList(executorContextPrefixes) : null;
        this.sqlFormatter = sqlFormatter;
        this.idGeneratorMap = idGeneratorMap;
        this.scalarProviderManager = scalarProviderManager;
        this.defaultBatchSize = defaultBatchSize;
        this.defaultListBatchSize = defaultListBatchSize;
        this.offsetOptimizingThreshold = offsetOptimizingThreshold;
        this.entities = entities != null ? entities.forSqlClient(this) : new EntitiesImpl(this);
        this.entityManager = entityManager;
        this.caches = caches != null ? caches : CachesImpl.of(triggers, entityManager, microServiceName, null);
        this.triggers = triggers;
        this.transactionTriggers = transactionTriggers;
        this.metadataStrategy = metadataStrategy;
        this.binLog = binLog;
        this.filterManager = filterManager;
        this.transientResolverManager = transientResolverManager;
        this.draftInterceptorManager = draftInterceptorManager;
        this.microServiceName = microServiceName;
        this.microServiceExchange = microServiceExchange;
    }

    @Override
    public ConnectionManager getConnectionManager() {
        return this.connectionManager;
    }

    @Override
    public ConnectionManager getSlaveConnectionManager(boolean forUpdate) {
        ConnectionManager slave = this.slaveConnectionManager;
        if (slave != null && !forUpdate) {
            return slave;
        }
        return this.connectionManager;
    }

    @Override
    public Dialect getDialect() {
        return this.dialect;
    }

    @Override
    public Executor getExecutor() {
        return this.executor;
    }

    @Override
    public List<String> getExecutorContextPrefixes() {
        return this.executorContextPrefixes;
    }

    @Override
    public SqlFormatter getSqlFormatter() {
        return this.sqlFormatter;
    }

    @Override
    public <T, S> ScalarProvider<T, S> getScalarProvider(Class<T> scalarType) {
        return this.scalarProviderManager.getProvider(scalarType);
    }

    @Override
    public <T, S> ScalarProvider<T, S> getScalarProvider(TypedProp<T, ?> prop) {
        return this.scalarProviderManager.getProvider(prop.unwrap());
    }

    @Override
    public <T, S> ScalarProvider<T, S> getScalarProvider(ImmutableProp prop) {
        return this.scalarProviderManager.getProvider(prop);
    }

    @Override
    public IdGenerator getIdGenerator(Class<?> entityType) {
        IdGenerator userIdGenerator = this.idGeneratorMap.get(entityType);
        if (userIdGenerator == null && (userIdGenerator = this.idGeneratorMap.get(null)) == null) {
            userIdGenerator = ImmutableType.get(entityType).getIdGenerator(this.metadataStrategy);
        }
        return userIdGenerator;
    }

    @Override
    public int getDefaultBatchSize() {
        return this.defaultBatchSize;
    }

    @Override
    public int getDefaultListBatchSize() {
        return this.defaultListBatchSize;
    }

    @Override
    public int getOffsetOptimizingThreshold() {
        return this.offsetOptimizingThreshold;
    }

    @Override
    public <T extends TableProxy<?>> MutableRootQuery<T> createQuery(T table) {
        if (table instanceof TableEx) {
            throw new IllegalArgumentException("Top-level query does not support TableEx");
        }
        return new MutableRootQueryImpl((JSqlClientImplementor)this, table, ExecutionPurpose.QUERY, false);
    }

    @Override
    public MutableUpdate createUpdate(TableProxy<?> table) {
        return new MutableUpdateImpl((JSqlClientImplementor)this, table);
    }

    @Override
    public MutableDelete createDelete(TableProxy<?> table) {
        return new MutableDeleteImpl((JSqlClientImplementor)this, table);
    }

    @Override
    public <SE, ST extends Table<SE>, TE, TT extends Table<TE>> MutableRootQuery<AssociationTable<SE, ST, TE, TT>> createAssociationQuery(AssociationTable<SE, ST, TE, TT> table) {
        if (!(table instanceof TableProxy)) {
            throw new IllegalArgumentException("The argument \"table\" must be proxy");
        }
        return new MutableRootQueryImpl<AssociationTable<SE, ST, TE, TT>>((JSqlClientImplementor)this, (TableProxy)((Object)table), ExecutionPurpose.QUERY, false);
    }

    @Override
    public MutableSubQuery createSubQuery(TableProxy<?> table) {
        return new MutableSubQueryImpl((JSqlClientImplementor)this, table);
    }

    @Override
    public <SE, ST extends TableEx<SE>, TE, TT extends TableEx<TE>> MutableSubQuery createAssociationSubQuery(AssociationTable<SE, ST, TE, TT> table) {
        if (!(table instanceof TableProxy)) {
            throw new IllegalArgumentException("The argument \"table\" must be proxy");
        }
        return new MutableSubQueryImpl((JSqlClientImplementor)this, (TableProxy)((Object)table));
    }

    @Override
    public Entities getEntities() {
        return this.entities;
    }

    @Override
    public TriggerType getTriggerType() {
        if (this.transactionTriggers == null) {
            return TriggerType.BINLOG_ONLY;
        }
        if (this.transactionTriggers == this.triggers) {
            return TriggerType.TRANSACTION_ONLY;
        }
        return TriggerType.BOTH;
    }

    @Override
    public Triggers getTriggers() {
        return this.triggers;
    }

    @Override
    public Triggers getTriggers(boolean transaction) {
        if (transaction) {
            Triggers tt = this.transactionTriggers;
            if (tt == null) {
                throw new IllegalStateException("Transaction triggers is not supported by current sql client");
            }
            return tt;
        }
        return this.triggers;
    }

    @Override
    public MetadataStrategy getMetadataStrategy() {
        return this.metadataStrategy;
    }

    @Override
    public BinLog getBinLog() {
        BinLog bl = this.binLog;
        if (bl == null) {
            throw new IllegalStateException("binLog is not supported because the entityManager of sql client is not specified");
        }
        return bl;
    }

    @Override
    public Associations getAssociations(TypedProp.Association<?, ?> prop) {
        return this.getAssociations(prop.unwrap());
    }

    @Override
    public Associations getAssociations(ImmutableProp immutableProp) {
        return this.getAssociations(AssociationType.of(immutableProp));
    }

    @Override
    public Associations getAssociations(AssociationType associationType) {
        return new AssociationsImpl(this, null, associationType);
    }

    @Override
    public Loaders getLoaders() {
        return this.loaders;
    }

    @Override
    public EntityManager getEntityManager() {
        return this.entityManager;
    }

    @Override
    public Caches getCaches() {
        return this.caches;
    }

    @Override
    public JSqlClientImplementor caches(Consumer<CacheDisableConfig> block) {
        if (block == null) {
            throw new IllegalArgumentException("block cannot be null");
        }
        CacheDisableConfig cfg = new CacheDisableConfig();
        block.accept(cfg);
        return new JSqlClientImpl(this.connectionManager, this.slaveConnectionManager, this.dialect, this.executor, this.executorContextPrefixes, this.sqlFormatter, this.idGeneratorMap, this.scalarProviderManager, this.defaultBatchSize, this.defaultListBatchSize, this.offsetOptimizingThreshold, this.entities, this.entityManager, new CachesImpl((CachesImpl)this.caches, cfg), this.triggers, this.transactionTriggers, this.metadataStrategy, this.binLog, this.filterManager, this.transientResolverManager, this.draftInterceptorManager, this.microServiceName, this.microServiceExchange);
    }

    @Override
    public JSqlClientImplementor filters(Consumer<FilterConfig> block) {
        if (block == null) {
            throw new IllegalArgumentException("block cannot be null");
        }
        FilterConfig cfg = new FilterConfig(this.filterManager);
        block.accept(cfg);
        if (cfg.getFilterManager() == this.filterManager) {
            return this;
        }
        return new JSqlClientImpl(this.connectionManager, this.slaveConnectionManager, this.dialect, this.executor, this.executorContextPrefixes, this.sqlFormatter, this.idGeneratorMap, this.scalarProviderManager, this.defaultBatchSize, this.defaultListBatchSize, this.offsetOptimizingThreshold, this.entities, this.entityManager, this.caches, this.triggers, this.transactionTriggers, this.metadataStrategy, this.binLog, cfg.getFilterManager(), this.transientResolverManager, this.draftInterceptorManager, this.microServiceName, this.microServiceExchange);
    }

    @Override
    public JSqlClientImplementor disableSlaveConnectionManager() {
        if (this.slaveConnectionManager == null) {
            return this;
        }
        return new JSqlClientImpl(this.connectionManager, null, this.dialect, this.executor, this.executorContextPrefixes, this.sqlFormatter, this.idGeneratorMap, this.scalarProviderManager, this.defaultBatchSize, this.defaultListBatchSize, this.offsetOptimizingThreshold, this.entities, this.entityManager, this.caches, this.triggers, this.transactionTriggers, this.metadataStrategy, this.binLog, this.filterManager, this.transientResolverManager, this.draftInterceptorManager, this.microServiceName, this.microServiceExchange);
    }

    @Override
    public TransientResolver<?, ?> getResolver(ImmutableProp prop) {
        return this.transientResolverManager.get(prop);
    }

    @Override
    public Class<? extends TransientResolverProvider> getResolverProviderClass() {
        return this.transientResolverManager.getProviderClass();
    }

    @Override
    public Filters getFilters() {
        return this.filterManager;
    }

    @Override
    public DraftInterceptor<?> getDraftInterceptor(ImmutableType type) {
        return this.draftInterceptorManager.get(type);
    }

    @Override
    public Reader<?> getReader(Class<?> type) {
        return this.readerManager.reader(type);
    }

    @Override
    public Reader<?> getReader(ImmutableType type) {
        return this.readerManager.reader(type);
    }

    @Override
    public Reader<?> getReader(ImmutableProp prop) {
        return this.readerManager.reader(prop);
    }

    @Override
    public String getMicroServiceName() {
        return this.microServiceName;
    }

    @Override
    public MicroServiceExchange getMicroServiceExchange() {
        return this.microServiceExchange;
    }

    public static class BuilderImpl
    implements JSqlClient.Builder {
        private static final Logger LOGGER = LoggerFactory.getLogger(BuilderImpl.class);
        private ConnectionManager connectionManager;
        private ConnectionManager slaveConnectionManager;
        private Dialect dialect = DefaultDialect.INSTANCE;
        private Executor executor;
        private List<String> executorContextPrefixes;
        private SqlFormatter sqlFormatter = SqlFormatter.SIMPLE;
        private TransientResolverProvider transientResolverProvider;
        private final Map<Class<?>, ScalarProvider<?, ?>> typeScalarProviderMap = new HashMap();
        private final Map<ImmutableProp, ScalarProvider<?, ?>> propScalarProviderMap = new HashMap();
        private final Map<Class<?>, IdGenerator> idGeneratorMap = new HashMap();
        private EnumType.Strategy defaultEnumStrategy = EnumType.Strategy.NAME;
        private DatabaseNamingStrategy databaseNamingStrategy = DefaultDatabaseNamingStrategy.UPPER_CASE;
        private int defaultBatchSize = 128;
        private int defaultListBatchSize = 16;
        private int offsetOptimizingThreshold = Integer.MAX_VALUE;
        private EntityManager userEntityManager;
        private EntityManager defaultEntityManager;
        private Consumer<CacheConfig> cacheConfigLambda;
        private TriggerType triggerType = TriggerType.BINLOG_ONLY;
        private Triggers triggers;
        private Triggers transactionTriggers;
        private final List<Filter<?>> filters = new ArrayList();
        private final Set<Filter<?>> disabledFilters = new HashSet();
        private boolean ignoreBuiltInFilters = false;
        private final List<DraftInterceptor<?>> interceptors = new ArrayList();
        private ObjectMapper binLogObjectMapper;
        private boolean isForeignKeyEnabledByDefault = true;
        private final Set<Customizer> customizers = new LinkedHashSet<Customizer>();
        private final Set<Initializer> initializers = new LinkedHashSet<Initializer>();
        private DatabaseValidationMode databaseValidationMode = DatabaseValidationMode.NONE;
        private String databaseValidationCatalog;
        private String microServiceName = "";
        private MicroServiceExchange microServiceExchange;

        @Override
        public JSqlClient.Builder setConnectionManager(ConnectionManager connectionManager) {
            this.connectionManager = connectionManager;
            return this;
        }

        @Override
        public JSqlClient.Builder setSlaveConnectionManager(ConnectionManager connectionManager) {
            this.slaveConnectionManager = connectionManager;
            return this;
        }

        @Override
        public JSqlClient.Builder setDialect(Dialect dialect) {
            this.dialect = dialect != null ? dialect : DefaultDialect.INSTANCE;
            return this;
        }

        @Override
        public JSqlClient.Builder setExecutor(Executor executor) {
            this.executor = executor;
            return this;
        }

        @Override
        public JSqlClient.Builder setExecutorContextPrefixes(Collection<String> prefixes) {
            if (prefixes == null || prefixes.isEmpty()) {
                this.executorContextPrefixes = null;
            } else {
                TreeSet<String> set = new TreeSet<String>();
                for (String prefix : prefixes) {
                    if (prefix == null || prefix.isEmpty()) continue;
                    set.add(prefix);
                }
                this.executorContextPrefixes = set.isEmpty() ? null : new ArrayList<String>(set);
            }
            return this;
        }

        @Override
        public JSqlClient.Builder setSqlFormatter(SqlFormatter sqlFormatter) {
            this.sqlFormatter = sqlFormatter != null ? sqlFormatter : SqlFormatter.SIMPLE;
            return this;
        }

        @Override
        public JSqlClient.Builder setTransientResolverProvider(TransientResolverProvider transientResolverProvider) {
            this.transientResolverProvider = transientResolverProvider;
            return this;
        }

        @Override
        public JSqlClient.Builder setIdGenerator(IdGenerator idGenerator) {
            return this.setIdGenerator(null, idGenerator);
        }

        @Override
        public JSqlClient.Builder setIdGenerator(Class<?> entityType, IdGenerator idGenerator) {
            this.idGeneratorMap.put(entityType, idGenerator);
            return this;
        }

        @Override
        public JSqlClient.Builder addScalarProvider(ScalarProvider<?, ?> scalarProvider) {
            Collection<ImmutableProp> props = scalarProvider.getHandledProps();
            if (props == null || props.isEmpty()) {
                this.addScalarProviderImpl(null, scalarProvider);
            } else {
                for (ImmutableProp prop : props) {
                    if (prop == null) {
                        throw new IllegalStateException("Each property of returned list of \"" + scalarProvider.getClass().getName() + ".getHandledProps\" cannot be null");
                    }
                    if (!prop.isScalar(TargetLevel.ENTITY) && !prop.isScalarList()) {
                        throw new IllegalStateException("Each property of returned list of \"" + scalarProvider.getClass().getName() + ".getHandledProps\" must be scalar, but \"" + prop + "\" is not");
                    }
                    this.addScalarProviderImpl(prop, scalarProvider);
                }
            }
            return this;
        }

        @Override
        public JSqlClient.Builder addScalarProvider(TypedProp<?, ?> prop, ScalarProvider<?, ?> scalarProvider) {
            if (prop == null) {
                throw new IllegalArgumentException("prop cannot be null");
            }
            this.addScalarProviderImpl(prop.unwrap(), scalarProvider);
            return this;
        }

        @Override
        public JSqlClient.Builder addScalarProvider(ImmutableProp prop, ScalarProvider<?, ?> scalarProvider) {
            if (prop == null) {
                throw new IllegalArgumentException("prop cannot be null");
            }
            this.addScalarProviderImpl(prop, scalarProvider);
            return this;
        }

        private void addScalarProviderImpl(ImmutableProp prop, ScalarProvider<?, ?> scalarProvider) {
            Type scalarType = scalarProvider.getScalarType();
            if (prop == null) {
                if (!(scalarType instanceof Class)) {
                    throw new IllegalStateException("Illegal scalar provider type \"" + scalarProvider.getClass().getName() + "\" its scalar type argument cannot be \"" + scalarType + "\" because it is global scalar provider, please use property-specific scalar provider");
                }
                if (this.typeScalarProviderMap.containsKey(scalarType)) {
                    throw new IllegalStateException("Cannot set scalar provider for scalar type \"" + scalarType + "\" twice");
                }
                if (((Class)scalarType).isArray() || Iterable.class.isAssignableFrom((Class)scalarType) || Map.class.isAssignableFrom((Class)scalarType)) {
                    throw new IllegalStateException("Illegal scalar provider type \"" + scalarProvider.getClass().getName() + "\" its scalar type argument cannot be array, collection or map, because it is global scalar provider, please use property-specific scalar provider");
                }
                this.typeScalarProviderMap.put((Class)scalarType, scalarProvider);
            } else {
                if (!prop.isScalar(TargetLevel.ENTITY) && !prop.isScalarList()) {
                    throw new IllegalStateException("Cannot set scalar provider for property type \"" + prop + "\" because the property is not scalar property");
                }
                if (this.propScalarProviderMap.containsKey(prop)) {
                    throw new IllegalStateException("Cannot set scalar provider for property type \"" + prop + "\" twice");
                }
                ImmutableProp originalProp = prop.toOriginal();
                if (originalProp != prop) {
                    throw new IllegalArgumentException("\"" + prop + "\" hides \"" + originalProp + "\", please add scalar provider for that hidden property");
                }
                this.propScalarProviderMap.put(prop, scalarProvider);
            }
        }

        @Override
        public JSqlClient.Builder setDefaultEnumStrategy(EnumType.Strategy strategy) {
            this.defaultEnumStrategy = strategy != null ? strategy : EnumType.Strategy.NAME;
            return this;
        }

        @Override
        public JSqlClient.Builder setDatabaseNamingStrategy(DatabaseNamingStrategy strategy) {
            this.databaseNamingStrategy = strategy != null ? strategy : DefaultDatabaseNamingStrategy.UPPER_CASE;
            return this;
        }

        @Override
        public JSqlClient.Builder setDefaultBatchSize(int size) {
            if (size < 1) {
                throw new IllegalStateException("size cannot be less than 1");
            }
            this.defaultBatchSize = size;
            return this;
        }

        @Override
        public JSqlClient.Builder setDefaultListBatchSize(int size) {
            if (size < 1) {
                throw new IllegalStateException("size cannot be less than 1");
            }
            this.defaultListBatchSize = size;
            return this;
        }

        @Override
        public JSqlClient.Builder setOffsetOptimizingThreshold(int threshold) {
            if (threshold < 0) {
                throw new IllegalArgumentException("`threshold` cannot be negative number");
            }
            this.offsetOptimizingThreshold = threshold;
            return this;
        }

        @Override
        public JSqlClient.Builder setEntityManager(EntityManager entityManager) {
            if (this.userEntityManager != null && this.userEntityManager != entityManager) {
                throw new IllegalStateException("The EntityManager of SqlBuilder.Builder can only be set once");
            }
            this.userEntityManager = entityManager;
            return this;
        }

        @Override
        public JSqlClient.Builder setCaches(Consumer<CacheConfig> block) {
            this.cacheConfigLambda = block;
            return this;
        }

        @Override
        public JSqlClient.Builder setTriggerType(TriggerType triggerType) {
            this.triggerType = triggerType != null ? triggerType : TriggerType.BINLOG_ONLY;
            return this;
        }

        @Override
        public JSqlClient.Builder addFilters(Filter<?> ... filters) {
            return this.addFilters(Arrays.asList(filters));
        }

        @Override
        public JSqlClient.Builder addFilters(Collection<Filter<?>> filters) {
            for (Filter<?> filter : filters) {
                if (filter == null) continue;
                this.filters.add(filter);
            }
            return this;
        }

        @Override
        public JSqlClient.Builder addDisabledFilters(Filter<?> ... filters) {
            return this.addDisabledFilters(Arrays.asList(filters));
        }

        @Override
        public JSqlClient.Builder addDisabledFilters(Collection<Filter<?>> filters) {
            for (Filter<?> filter : filters) {
                if (filter == null) continue;
                this.filters.add(filter);
                this.disabledFilters.add(filter);
            }
            return this;
        }

        @Override
        public JSqlClient.Builder ignoreBuiltInFilters() {
            this.ignoreBuiltInFilters = true;
            return this;
        }

        @Override
        public JSqlClient.Builder addDraftInterceptor(DraftInterceptor<?> interceptor) {
            return this.addDraftInterceptors(Collections.singletonList(interceptor));
        }

        @Override
        public JSqlClient.Builder addDraftInterceptors(DraftInterceptor<?> ... interceptors) {
            return this.addDraftInterceptors(Arrays.asList(interceptors));
        }

        @Override
        public JSqlClient.Builder addDraftInterceptors(Collection<DraftInterceptor<?>> interceptors) {
            for (DraftInterceptor<?> interceptor : interceptors) {
                if (interceptor == null) continue;
                this.interceptors.add(interceptor);
            }
            return this;
        }

        @Override
        public JSqlClient.Builder setBinLogObjectMapper(ObjectMapper mapper) {
            this.binLogObjectMapper = mapper;
            return this;
        }

        @Override
        public JSqlClient.Builder setForeignKeyEnabledByDefault(boolean enabled) {
            this.isForeignKeyEnabledByDefault = enabled;
            return this;
        }

        @Override
        public JSqlClient.Builder addCustomizers(Customizer ... customizers) {
            for (Customizer customizer : customizers) {
                if (customizer == null) continue;
                this.customizers.add(customizer);
            }
            return this;
        }

        @Override
        public JSqlClient.Builder addCustomizers(Collection<Customizer> customizers) {
            for (Customizer customizer : customizers) {
                if (customizer == null) continue;
                this.customizers.add(customizer);
            }
            return this;
        }

        @Override
        public JSqlClient.Builder addInitializers(Initializer ... initializers) {
            for (Initializer initializer : initializers) {
                if (initializer == null) continue;
                this.initializers.add(initializer);
            }
            return this;
        }

        @Override
        public JSqlClient.Builder addInitializers(Collection<Initializer> initializers) {
            for (Initializer initializer : initializers) {
                if (initializer == null) continue;
                this.initializers.add(initializer);
            }
            return this;
        }

        @Override
        public JSqlClient.Builder setDatabaseValidationMode(DatabaseValidationMode databaseValidationMode) {
            this.databaseValidationMode = Objects.requireNonNull(databaseValidationMode, "argument cannot be null");
            return this;
        }

        @Override
        public JSqlClient.Builder setDatabaseValidationCatalog(String catalog) {
            this.databaseValidationCatalog = catalog != null && !catalog.isEmpty() ? catalog : null;
            return this;
        }

        @Override
        public JSqlClient.Builder setMicroServiceName(String microServiceName) {
            this.microServiceName = microServiceName != null ? microServiceName : "";
            return this;
        }

        @Override
        public JSqlClient.Builder setMicroServiceExchange(MicroServiceExchange exchange) {
            this.microServiceExchange = exchange;
            return this;
        }

        @Override
        public JSqlClient build() {
            for (Customizer customizer : this.customizers) {
                try {
                    customizer.customize(this);
                }
                catch (Exception ex) {
                    throw new ExecutionException("Failed to execute customizer before create sql client", ex);
                }
            }
            if (!this.microServiceName.isEmpty() && this.microServiceExchange == null) {
                throw new IllegalStateException("The `microServiceExchange` must be configured when `microServiceName` is configured");
            }
            FilterManager filterManager = this.createFilterManager();
            this.validateAssociations(filterManager);
            this.createTriggers();
            Caches caches = null;
            if (this.cacheConfigLambda != null) {
                caches = CachesImpl.of(this.triggers, this.entityManager(), this.microServiceName, this.cacheConfigLambda);
            }
            ForeignKeyStrategy foreignKeyStrategy = !this.dialect.isForeignKeySupported() ? ForeignKeyStrategy.FORCED_FAKE : (this.isForeignKeyEnabledByDefault ? ForeignKeyStrategy.REAL : ForeignKeyStrategy.FAKE);
            MetadataStrategy metadataStrategy = new MetadataStrategy(this.databaseNamingStrategy, foreignKeyStrategy);
            this.entityManager().validate(metadataStrategy);
            BinLogParser binLogParser = new BinLogParser();
            BinLog binLog = new BinLog(this.entityManager(), this.microServiceName, metadataStrategy, binLogParser, this.triggers);
            TransientResolverManager transientResolverManager = new TransientResolverManager(this.transientResolverProvider != null ? this.transientResolverProvider : DefaultTransientResolverProvider.INSTANCE);
            JSqlClientImpl sqlClient = new JSqlClientImpl(this.connectionManager, this.slaveConnectionManager, this.dialect, this.executor, this.executorContextPrefixes, this.sqlFormatter, this.idGeneratorMap, new ScalarProviderManager(this.typeScalarProviderMap, this.propScalarProviderMap, this.defaultEnumStrategy, this.dialect), this.defaultBatchSize, this.defaultListBatchSize, this.offsetOptimizingThreshold, null, this.entityManager(), caches, this.triggers, this.transactionTriggers, metadataStrategy, binLog, filterManager, transientResolverManager, new DraftInterceptorManager(this.interceptors), this.microServiceName, this.microServiceExchange);
            filterManager.initialize(sqlClient);
            binLogParser.initialize(sqlClient, this.binLogObjectMapper);
            transientResolverManager.initialize(sqlClient);
            for (Initializer initializer : this.initializers) {
                try {
                    initializer.initialize(sqlClient);
                }
                catch (Exception ex) {
                    throw new ExecutionException("Failed to execute initializer after create sql client", ex);
                }
            }
            this.validateDatabase(metadataStrategy);
            return sqlClient;
        }

        private void createTriggers() {
            if (this.triggers == null) {
                switch (this.triggerType) {
                    case TRANSACTION_ONLY: {
                        this.transactionTriggers = this.triggers = new TriggersImpl();
                        break;
                    }
                    case BOTH: {
                        this.triggers = new TriggersImpl();
                        this.transactionTriggers = new TriggersImpl();
                        break;
                    }
                    default: {
                        this.triggers = new TriggersImpl();
                    }
                }
            }
        }

        private FilterManager createFilterManager() {
            BuiltinFiltersImpl builtInFilters = new BuiltinFiltersImpl();
            if (this.ignoreBuiltInFilters) {
                return new FilterManager(builtInFilters, this.filters, this.disabledFilters);
            }
            ArrayList mergedFilters = new ArrayList(this.filters);
            ArrayList mergedDisabledFilters = new ArrayList(this.disabledFilters);
            for (ImmutableType type : this.entityManager().getAllTypes(this.microServiceName)) {
                Filter<Props> notDeletedFilter = builtInFilters.getDeclaredNotDeletedFilter(type);
                Filter<Props> alreadyDeletedFilter = builtInFilters.getDeclaredAlreadyDeletedFilter(type);
                if (notDeletedFilter != null) {
                    mergedFilters.add(notDeletedFilter);
                }
                if (alreadyDeletedFilter == null) continue;
                mergedFilters.add(alreadyDeletedFilter);
                mergedDisabledFilters.add(alreadyDeletedFilter);
            }
            return new FilterManager(builtInFilters, mergedFilters, mergedDisabledFilters);
        }

        private void validateAssociations(FilterManager filterManager) {
            for (ImmutableType type : this.entityManager().getAllTypes(this.microServiceName)) {
                if (!type.isEntity()) continue;
                for (ImmutableProp prop : type.getProps().values()) {
                    if (prop.isNullable() || !prop.isReference(TargetLevel.ENTITY) || prop.isTransient()) continue;
                    if (prop.isRemote()) {
                        throw new ModelException("Illegal reference association property \"" + prop + "\", it must be nullable because it is remote association");
                    }
                    if (!filterManager.contains(prop.getTargetType())) continue;
                    throw new ModelException("Illegal reference association property \"" + prop + "\", it must be nullable because the target type \"" + prop.getTargetType() + "\" may be handled by some global filters");
                }
            }
        }

        private void validateDatabase(MetadataStrategy metadataStrategy) {
            if (this.databaseValidationMode != DatabaseValidationMode.NONE) {
                ConnectionManager cm = this.connectionManager;
                if (cm == null) {
                    throw new IllegalStateException("The `connectionManager` of must be configured when `validate` is configured");
                }
                DatabaseValidationException validationException = cm.execute(con -> {
                    try {
                        return DatabaseValidators.validate(this.entityManager(), this.microServiceName, metadataStrategy, this.databaseValidationCatalog, con);
                    }
                    catch (SQLException ex) {
                        throw new ExecutionException("Cannot validate the database because of SQL exception", ex);
                    }
                });
                if (validationException != null) {
                    if (this.databaseValidationMode == DatabaseValidationMode.ERROR) {
                        throw validationException;
                    }
                    LOGGER.warn(validationException.getMessage(), (Throwable)validationException);
                }
            }
        }

        private EntityManager entityManager() {
            EntityManager em = this.userEntityManager;
            if (em == null && (em = this.defaultEntityManager) == null) {
                this.defaultEntityManager = em = EntityManager.fromResources(null, null);
            }
            return em;
        }
    }
}

