/*
 * Decompiled with CFR 0.152.
 */
package org.babyfish.jimmer.sql.ast.impl.mutation;

import java.sql.Connection;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.HashMap;
import java.util.HashSet;
import java.util.IdentityHashMap;
import java.util.List;
import java.util.Map;
import java.util.Set;
import org.babyfish.jimmer.meta.ImmutableProp;
import org.babyfish.jimmer.meta.ImmutableType;
import org.babyfish.jimmer.runtime.DraftSpi;
import org.babyfish.jimmer.runtime.ImmutableSpi;
import org.babyfish.jimmer.runtime.Internal;
import org.babyfish.jimmer.sql.JSqlClient;
import org.babyfish.jimmer.sql.ast.Predicate;
import org.babyfish.jimmer.sql.ast.impl.mutation.TypedId;
import org.babyfish.jimmer.sql.ast.impl.mutation.TypedKey;
import org.babyfish.jimmer.sql.ast.impl.query.Queries;
import org.babyfish.jimmer.sql.cache.CacheDisableConfig;
import org.babyfish.jimmer.sql.runtime.ExecutionPurpose;

class MutationCache {
    private final JSqlClient sqlClientWithoutCache;
    private final boolean pessimisticLockRequired;
    private final Map<TypedId, ImmutableSpi> idObjMap = new HashMap<TypedId, ImmutableSpi>();
    private final Map<TypedKey, ImmutableSpi> keyObjMap = new HashMap<TypedKey, ImmutableSpi>();
    private final IdentityHashMap<Object, Object> savedMap = new IdentityHashMap();

    public MutationCache(JSqlClient sqlClient, boolean pessimisticLockRequired) {
        this.sqlClientWithoutCache = sqlClient.caches(CacheDisableConfig::disableAll);
        this.pessimisticLockRequired = pessimisticLockRequired;
    }

    public ImmutableSpi find(ImmutableSpi example) {
        Object id;
        ImmutableType type = example.__type();
        ImmutableProp idProp = type.getIdProp();
        int idPropId = idProp.getId();
        if (example.__isLoaded(idPropId) && (id = example.__get(idPropId)) != null) {
            return this.idObjMap.get(new TypedId(type, id));
        }
        TypedKey key = TypedKey.of(example, this.keyProps(type), true);
        return this.keyObjMap.get(key);
    }

    public List<ImmutableSpi> loadByIds(ImmutableType type, Collection<Object> ids, Connection con) {
        if (!(ids instanceof Set)) {
            ids = new HashSet<Object>(ids);
        }
        ArrayList<ImmutableSpi> list = new ArrayList<ImmutableSpi>(ids.size());
        ArrayList<Object> missedIds = new ArrayList<Object>();
        for (Object id : ids) {
            ImmutableSpi spi = this.idObjMap.get(new TypedId(type, id));
            if (spi != null) {
                list.add(spi);
                continue;
            }
            missedIds.add(id);
        }
        if (!missedIds.isEmpty()) {
            String idPropName = type.getIdProp().getName();
            List rows = (List)Internal.requiresNewDraftContext(ctx -> {
                List spiList = (List)Queries.createQuery(this.sqlClientWithoutCache, type, ExecutionPurpose.MUTATE, true, (q, t) -> {
                    q.where(new Predicate[]{t.get(idPropName).in(missedIds)});
                    return q.select(t);
                }).forUpdate(this.pessimisticLockRequired).execute(con);
                return ctx.resolveList(spiList);
            });
            for (ImmutableSpi row : rows) {
                this.save(row, false);
                list.add(row);
            }
        }
        return list;
    }

    public ImmutableSpi save(ImmutableSpi spi, boolean forUserSave) {
        TypedKey key;
        ImmutableType type = spi.__type();
        ImmutableProp idProp = type.getIdProp();
        Set<ImmutableProp> keyProps = this.keyProps(type);
        ImmutableSpi oldSpi = this.find(spi);
        if (oldSpi != null) {
            TypedKey oldKey;
            TypedId oldTypedId = new TypedId(type, oldSpi.__get(idProp.getId()));
            this.idObjMap.remove(oldTypedId);
            if (keyProps != null && !keyProps.isEmpty() && (oldKey = TypedKey.of(oldSpi, keyProps, false)) != null) {
                this.keyObjMap.remove(oldKey);
            }
            ImmutableSpi newSpi = spi;
            spi = (ImmutableSpi)Internal.produce((ImmutableType)spi.__type(), (Object)oldSpi, draft -> {
                for (ImmutableProp prop : type.getProps().values()) {
                    int propId;
                    if (!prop.isMutable() || !newSpi.__isLoaded(propId = prop.getId())) continue;
                    ((DraftSpi)draft).__set(propId, newSpi.__get(prop.getId()));
                }
            });
        }
        TypedId typedId = new TypedId(type, spi.__get(idProp.getId()));
        this.idObjMap.put(typedId, spi);
        if (keyProps != null && !keyProps.isEmpty() && (key = TypedKey.of(spi, keyProps, false)) != null) {
            this.keyObjMap.put(key, spi);
        }
        if (forUserSave) {
            this.savedMap.put(spi, null);
        }
        return spi;
    }

    public boolean isSaved(ImmutableSpi spi) {
        return this.savedMap.containsKey(spi);
    }

    protected Set<ImmutableProp> keyProps(ImmutableType type) {
        return Collections.emptySet();
    }

    public boolean isPessimisticLockRequired() {
        return this.pessimisticLockRequired;
    }
}

