/*
 * Decompiled with CFR 0.152.
 */
package org.babyfish.jimmer.sql.runtime;

import java.util.Collection;
import java.util.List;
import java.util.Objects;
import org.babyfish.jimmer.meta.ImmutableProp;
import org.babyfish.jimmer.runtime.ImmutableSpi;
import org.babyfish.jimmer.sql.Entities;
import org.babyfish.jimmer.sql.JSqlClient;
import org.babyfish.jimmer.sql.ast.Predicate;
import org.babyfish.jimmer.sql.ast.PropExpression;
import org.babyfish.jimmer.sql.ast.impl.EntitiesImpl;
import org.babyfish.jimmer.sql.ast.impl.query.MutableRootQueryImpl;
import org.babyfish.jimmer.sql.ast.tuple.Tuple2;
import org.babyfish.jimmer.sql.fetcher.Fetcher;
import org.babyfish.jimmer.sql.runtime.ExecutionPurpose;
import org.babyfish.jimmer.sql.runtime.JSqlClientImplementor;

public class MicroServiceExporter {
    private final JSqlClientImplementor sqlClient;

    public MicroServiceExporter(JSqlClient sqlClient) {
        this.sqlClient = (JSqlClientImplementor)Objects.requireNonNull(sqlClient, "sqlClient cannot be null");
    }

    public List<ImmutableSpi> findByIds(Collection<?> ids, Fetcher<?> fetcher) {
        JSqlClientImplementor client = this.sqlClient.getFilters().getFilter(fetcher.getImmutableType()) == null ? this.sqlClient : this.sqlClient.caches(cfg -> cfg.disable(fetcher.getImmutableType()));
        Entities entities = ((EntitiesImpl)client.getEntities()).forExporter();
        return entities.findByIds(fetcher, ids);
    }

    public List<Tuple2<Object, ImmutableSpi>> findByAssociatedIds(ImmutableProp prop, Collection<?> targetIds, Fetcher<?> fetcher) {
        if (prop.getDeclaringType() != fetcher.getImmutableType()) {
            throw new IllegalArgumentException("The root entity type of fetcher is \"" + fetcher.getImmutableType() + "\" is not declaring type of \"" + prop + "\"");
        }
        MutableRootQueryImpl query = new MutableRootQueryImpl(this.sqlClient, prop.getDeclaringType(), ExecutionPurpose.EXPORT, false);
        PropExpression targetIdExpr = (PropExpression)query.getTable().join(prop.getName()).get(prop.getTargetType().getIdProp().getName());
        return (List)((MutableRootQueryImpl)query.where(new Predicate[]{targetIdExpr.in(targetIds)})).select(targetIdExpr, query.getTable().fetch(fetcher)).execute();
    }
}

