/*
 * Decompiled with CFR 0.152.
 */
package org.babyfish.jimmer.sql.ast.impl;

import org.babyfish.jimmer.sql.ast.impl.AbstractMutableStatementImpl;
import org.babyfish.jimmer.sql.ast.impl.table.RootTableResolver;
import org.babyfish.jimmer.sql.ast.impl.table.TableImplementor;
import org.babyfish.jimmer.sql.ast.impl.table.TableProxies;
import org.babyfish.jimmer.sql.ast.impl.util.AbstractIdentityDataManager;
import org.babyfish.jimmer.sql.ast.table.Table;
import org.babyfish.jimmer.sql.ast.table.spi.AbstractTypedTable;
import org.babyfish.jimmer.sql.ast.table.spi.TableProxy;
import org.babyfish.jimmer.sql.runtime.JSqlClientImplementor;
import org.babyfish.jimmer.sql.runtime.TableUsedState;

public class AstContext
extends AbstractIdentityDataManager<TableImplementor<?>, TableUsedState>
implements RootTableResolver {
    private final JSqlClientImplementor sqlClient;
    private StackFrame frame;

    public AstContext(JSqlClientImplementor sqlClient) {
        this.sqlClient = sqlClient;
    }

    public JSqlClientImplementor getSqlClient() {
        return this.sqlClient;
    }

    @Override
    protected TableUsedState createValue(TableImplementor<?> key) {
        return TableUsedState.ID_ONLY;
    }

    public void useTableId(TableImplementor<?> tableImplementor) {
        this.getOrCreateValue(tableImplementor);
    }

    public void useTable(TableImplementor<?> tableImplementor) {
        this.putValue(tableImplementor, TableUsedState.USED);
    }

    public TableUsedState getTableUsedState(TableImplementor<?> tableImplementor) {
        TableUsedState state = (TableUsedState)((Object)this.getValue(tableImplementor));
        return state != null ? state : TableUsedState.NONE;
    }

    public void pushStatement(AbstractMutableStatementImpl statement) {
        StackFrame frame = this.frame;
        if (frame != null && frame.statement.isSubQueryDisabled()) {
            throw new IllegalStateException("Cannot use sub query here because the sub query of parent statement is disabled");
        }
        this.frame = new StackFrame(statement, frame);
    }

    public void popStatement() {
        this.frame = this.frame.parent;
    }

    @Override
    public <E> TableImplementor<E> resolveRootTable(Table<E> table) {
        if (table instanceof TableImplementor) {
            return (TableImplementor)table;
        }
        TableImplementor tableImplementor = ((TableProxy)table).__unwrap();
        if (tableImplementor != null) {
            return tableImplementor;
        }
        StackFrame frame = this.frame;
        while (frame != null) {
            AbstractMutableStatementImpl statement = frame.statement;
            Object stmtTable = statement.getTable();
            if (AbstractTypedTable.__refEquals(stmtTable, table)) {
                return statement.getTableImplementor();
            }
            frame = frame.parent;
        }
        if (((TableProxy)table).__parent() != null) {
            throw new IllegalArgumentException("\"" + AstContext.class.getName() + ".resolveRootTable\" only does not accept non-root table, you can use \"" + TableProxies.class.getName() + ".resolve\"");
        }
        throw new IllegalArgumentException("Cannot resolve the root table " + table);
    }

    public AbstractMutableStatementImpl getStatement() {
        return this.frame.statement;
    }

    private static class StackFrame {
        final AbstractMutableStatementImpl statement;
        final StackFrame parent;

        private StackFrame(AbstractMutableStatementImpl statement, StackFrame parent) {
            this.statement = statement;
            this.parent = parent;
        }
    }
}

