/*
 * Decompiled with CFR 0.152.
 */
package org.babyfish.jimmer.sql.runtime;

import java.io.BufferedReader;
import java.io.IOException;
import java.io.InputStreamReader;
import java.net.URL;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collection;
import java.util.Collections;
import java.util.Comparator;
import java.util.Enumeration;
import java.util.HashMap;
import java.util.LinkedHashMap;
import java.util.LinkedHashSet;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.Set;
import java.util.concurrent.ConcurrentHashMap;
import java.util.concurrent.ConcurrentMap;
import java.util.concurrent.locks.Lock;
import java.util.concurrent.locks.ReadWriteLock;
import java.util.concurrent.locks.ReentrantReadWriteLock;
import java.util.function.Predicate;
import java.util.stream.Collectors;
import org.babyfish.jimmer.meta.ImmutableProp;
import org.babyfish.jimmer.meta.ImmutableType;
import org.babyfish.jimmer.sql.JoinTable;
import org.babyfish.jimmer.sql.ManyToOne;
import org.babyfish.jimmer.sql.association.meta.AssociationType;
import org.babyfish.jimmer.sql.meta.MetadataStrategy;
import org.babyfish.jimmer.sql.meta.impl.DatabaseIdentifiers;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class EntityManager {
    private static final Logger LOGGER = LoggerFactory.getLogger(EntityManager.class);
    private final ReadWriteLock reloadingLock = new ReentrantReadWriteLock();
    private volatile Data data;

    public EntityManager(Class<?> ... classes) {
        this(Arrays.asList(classes));
    }

    public EntityManager(Collection<Class<?>> classes) {
        if (!(classes instanceof Set)) {
            classes = new LinkedHashSet(classes);
        }
        Map<ImmutableType, ImmutableTypeInfo> map = new LinkedHashMap<ImmutableType, ImmutableTypeInfo>();
        for (Class<?> clazz : classes) {
            if (clazz == null) continue;
            ImmutableType immutableType = ImmutableType.get(clazz);
            if (!immutableType.isEntity()) {
                throw new IllegalArgumentException("\"" + immutableType + "\" is not entity");
            }
            map.put(immutableType, new ImmutableTypeInfo());
            for (immutableType = immutableType.getSuperType(); immutableType != null && (immutableType.isEntity() || immutableType.isMappedSuperclass()); immutableType = immutableType.getSuperType()) {
                map.put(immutableType, new ImmutableTypeInfo());
            }
        }
        for (Map.Entry entry : map.entrySet()) {
            ImmutableType type = (ImmutableType)entry.getKey();
            ImmutableTypeInfo info = (ImmutableTypeInfo)entry.getValue();
            if (type.isMappedSuperclass()) {
                for (ImmutableType otherType : map.keySet()) {
                    if (!this.isImplementationType(type, otherType)) continue;
                    info.implementationTypes.add(otherType);
                }
                continue;
            }
            for (ImmutableType otherType : map.keySet()) {
                if (type == otherType || !type.isAssignableFrom(otherType)) continue;
                info.allDerivedTypes.add(otherType);
                if (type != otherType.getSuperType()) continue;
                info.directDerivedTypes.add(otherType);
            }
            for (ImmutableProp prop : type.getProps().values()) {
                ImmutableType targetType = prop.getTargetType();
                if (targetType == null || !targetType.isEntity() || prop.isRemote()) continue;
                ImmutableTypeInfo targetInfo = map.get(targetType);
                if (targetInfo == null) {
                    throw new IllegalArgumentException("The target type \"" + targetType + "\" of the non-remote property \"" + prop + "\" is not manged by the current entity manager");
                }
                targetInfo.backProps.add(prop);
            }
        }
        for (ImmutableTypeInfo immutableTypeInfo : map.values()) {
            immutableTypeInfo.implementationTypes = Collections.unmodifiableList(immutableTypeInfo.implementationTypes);
            immutableTypeInfo.directDerivedTypes = Collections.unmodifiableList(immutableTypeInfo.directDerivedTypes);
            immutableTypeInfo.allDerivedTypes = Collections.unmodifiableList(immutableTypeInfo.allDerivedTypes);
            immutableTypeInfo.backProps = Collections.unmodifiableList(immutableTypeInfo.backProps.stream().sorted(Comparator.comparing(ImmutableProp::toString)).collect(Collectors.toList()));
        }
        map = Collections.unmodifiableMap(map);
        HashMap<String, ImmutableType> springDevToolMap = new HashMap<String, ImmutableType>((map.size() * 4 + 2) / 3);
        for (ImmutableType type : map.keySet()) {
            springDevToolMap.put(type.getJavaClass().getName(), type);
        }
        this.data = new Data(map, springDevToolMap);
    }

    public static EntityManager combine(EntityManager ... entityManagers) {
        if (entityManagers.length == 0) {
            throw new IllegalArgumentException("No entity managers");
        }
        if (entityManagers.length == 1) {
            return entityManagers[0];
        }
        LinkedHashSet classes = new LinkedHashSet();
        for (EntityManager entityManager : entityManagers) {
            for (ImmutableType type : entityManager.getAllTypes(null)) {
                if (!type.isEntity()) continue;
                classes.add(type.getJavaClass());
            }
        }
        return new EntityManager(classes);
    }

    public static EntityManager fromResources(@Nullable ClassLoader classLoader, @Nullable Predicate<Class<?>> predicate) {
        if (classLoader == null) {
            classLoader = EntityManager.class.getClassLoader();
        }
        LinkedHashSet classes = new LinkedHashSet();
        try {
            Enumeration<URL> urls = classLoader.getResources("META-INF/jimmer/entities");
            while (urls.hasMoreElements()) {
                URL url = urls.nextElement();
                try (BufferedReader reader = new BufferedReader(new InputStreamReader(url.openStream()));){
                    String className;
                    while ((className = reader.readLine()) != null) {
                        Class<?> clazz;
                        if ((className = className.trim()).isEmpty()) continue;
                        try {
                            clazz = Class.forName(className, true, classLoader);
                        }
                        catch (ClassNotFoundException ex) {
                            throw new IllegalStateException("Cannot parse class name \"" + className + "\" in \"META-INF/jimmer/entities\"", ex);
                        }
                        if (predicate != null && !predicate.test(clazz)) continue;
                        classes.add(clazz);
                    }
                }
            }
        }
        catch (IOException ex) {
            throw new IllegalStateException("Failed to load resources \"META-INF/jimmer/entities\"", ex);
        }
        return new EntityManager(classes);
    }

    public Set<ImmutableType> getAllTypes(String microServiceName) {
        if (microServiceName == null) {
            return this.data.map.keySet();
        }
        LinkedHashSet<ImmutableType> set = microServiceName.isEmpty() ? new LinkedHashSet<ImmutableType>((this.data.map.size() * 4 + 2) / 3) : new LinkedHashSet();
        for (ImmutableType type : this.data.map.keySet()) {
            if (!type.getMicroServiceName().equals(microServiceName)) continue;
            set.add(type);
        }
        return set;
    }

    public List<ImmutableType> getImplementationTypes(ImmutableType type) {
        return this.info((ImmutableType)type).implementationTypes;
    }

    public List<ImmutableType> getDirectDerivedTypes(ImmutableType type) {
        return this.info((ImmutableType)type).directDerivedTypes;
    }

    public List<ImmutableType> getAllDerivedTypes(ImmutableType type) {
        return this.info((ImmutableType)type).allDerivedTypes;
    }

    public List<ImmutableProp> getAllBackProps(ImmutableType type) {
        return this.info((ImmutableType)type).backProps;
    }

    private ImmutableTypeInfo info(ImmutableType type) {
        ImmutableTypeInfo info = this.data.map.get(type);
        if (info == null) {
            ImmutableType oldType = this.data.typeMapForSpringDevTools.get(type.getJavaClass().getName());
            if (oldType != null) {
                LOGGER.info("You seem to be using spring-dev-tools (or other multi-ClassLoader technology), so that some entity metadata changes but the ORM's entire metadata graph is not updated, now try to reload the EntityManager.");
                try {
                    this.reload(type);
                }
                catch (Error | RuntimeException ex) {
                    throw new IllegalStateException("You seem to be using spring-dev-tools (or other multi-ClassLoader technology), so that some entity metadata changes but the ORM's entire metadata graph is not updated, jimmer try to reload the EntityManager but meet some problem.", ex);
                }
                info = this.data.map.get(type);
            }
            if (info == null) {
                throw new IllegalArgumentException("\"" + type + "\" is not managed by current EntityManager");
            }
        }
        return info;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void reload(ImmutableType immutableType) {
        Lock lock = this.reloadingLock.readLock();
        lock.lock();
        try {
            if (this.data.map.containsKey(immutableType)) {
                return;
            }
        }
        finally {
            lock.unlock();
        }
        lock = this.reloadingLock.writeLock();
        lock.lock();
        try {
            if (this.data.map.containsKey(immutableType)) {
                return;
            }
            EntityManager newEntityManager = EntityManager.fromResources(immutableType.getJavaClass().getClassLoader(), null);
            this.data = newEntityManager.data;
        }
        finally {
            lock.unlock();
        }
    }

    private boolean isImplementationType(ImmutableType mappedSuperClass, ImmutableType type) {
        if (!mappedSuperClass.isMappedSuperclass()) {
            throw new AssertionError((Object)"Internal bug");
        }
        if (!type.isEntity()) {
            return false;
        }
        if (!mappedSuperClass.isAssignableFrom(type)) {
            return false;
        }
        return type.getSuperType().isMappedSuperclass();
    }

    public ImmutableType getTypeByServiceAndTable(String microServiceName, String tableName, MetadataStrategy strategy) {
        Map<Key, ImmutableType> typeMap = this.data.getTypeMap(strategy);
        return typeMap.get(new Key(Objects.requireNonNull(microServiceName, "`microServiceName` cannot be null"), DatabaseIdentifiers.comparableIdentifier((String)Objects.requireNonNull(tableName, "`tableName` cannot be null"))));
    }

    @NotNull
    public ImmutableType getNonNullTypeByServiceAndTable(String microServiceName, String tableName, MetadataStrategy strategy) {
        ImmutableType type = this.getTypeByServiceAndTable(microServiceName, tableName, strategy);
        if (type == null) {
            throw new IllegalArgumentException("The table \"" + tableName + "\" of micro service \"" + microServiceName + "\" is not managed by current EntityManager");
        }
        return type;
    }

    private static void tableSharedBy(Key key, ImmutableType type1, ImmutableType type2) {
        if (type1 instanceof AssociationType && type2 instanceof AssociationType) {
            AssociationType associationType1 = (AssociationType)type1;
            AssociationType associationType2 = (AssociationType)type2;
            if (associationType1.getSourceType() == associationType2.getTargetType() && associationType1.getTargetType() == associationType2.getSourceType()) {
                throw new IllegalArgumentException("Illegal entity manager, in the micro-service \"" + key.microServiceName + "\", the table \"" + key.tableName + "\" is shared by both \"" + type1 + "\" and \"" + type2 + "\". These two associations seem to form a bidirectional association, if so, please make one of them real (using @" + JoinTable.class + ") and the other image (specify `mappedBy` of @" + ManyToOne.class + ")");
            }
        }
        throw new IllegalArgumentException("Illegal entity manager, in the microservice \"" + key.microServiceName + "\", the table \"" + key.tableName + "\" is shared by both \"" + type1 + "\" and \"" + type2 + "\"");
    }

    private static class Key {
        final String microServiceName;
        final String tableName;

        private Key(String microServiceName, String tableName) {
            this.microServiceName = microServiceName;
            this.tableName = tableName;
        }

        public boolean equals(Object o) {
            if (this == o) {
                return true;
            }
            if (!(o instanceof Key)) {
                return false;
            }
            Key key = (Key)o;
            return this.microServiceName.equals(key.microServiceName) && this.tableName.equals(key.tableName);
        }

        public int hashCode() {
            return Objects.hash(this.microServiceName, this.tableName);
        }

        public String toString() {
            return "Key{microServiceName='" + this.microServiceName + '\'' + ", tableName='" + this.tableName + '\'' + '}';
        }
    }

    private static class ImmutableTypeInfo {
        List<ImmutableType> implementationTypes = new ArrayList<ImmutableType>();
        List<ImmutableType> directDerivedTypes = new ArrayList<ImmutableType>();
        List<ImmutableType> allDerivedTypes = new ArrayList<ImmutableType>();
        List<ImmutableProp> backProps = new ArrayList<ImmutableProp>();

        private ImmutableTypeInfo() {
        }
    }

    private static class Data {
        final Map<ImmutableType, ImmutableTypeInfo> map;
        final Map<String, ImmutableType> typeMapForSpringDevTools;
        final ConcurrentMap<MetadataStrategy, Map<Key, ImmutableType>> typesMap = new ConcurrentHashMap<MetadataStrategy, Map<Key, ImmutableType>>();

        Data(Map<ImmutableType, ImmutableTypeInfo> map, Map<String, ImmutableType> typeMapForSpringDevTools) {
            this.map = map;
            this.typeMapForSpringDevTools = typeMapForSpringDevTools;
        }

        public Map<Key, ImmutableType> getTypeMap(MetadataStrategy strategy) {
            return this.typesMap.computeIfAbsent(strategy, this::createTypeMap);
        }

        private Map<Key, ImmutableType> createTypeMap(MetadataStrategy strategy) {
            HashMap<Key, ImmutableType> typeMap = new HashMap<Key, ImmutableType>();
            for (ImmutableType type : this.map.keySet()) {
                if (!type.isEntity()) continue;
                String tableName = DatabaseIdentifiers.comparableIdentifier((String)type.getTableName(strategy));
                String microServiceName = type.getMicroServiceName();
                Key key = new Key(microServiceName, tableName);
                ImmutableType conflictType = typeMap.put(key, type);
                if (conflictType != null) {
                    EntityManager.tableSharedBy(key, conflictType, type);
                }
                for (ImmutableProp prop : type.getProps().values()) {
                    AssociationType associationType;
                    String associationTableName;
                    if (!prop.isMiddleTableDefinition() || (conflictType = typeMap.put(key = new Key(microServiceName, associationTableName = DatabaseIdentifiers.comparableIdentifier((String)(associationType = AssociationType.of(prop)).getTableName(strategy))), (ImmutableType)associationType)) == null) continue;
                    EntityManager.tableSharedBy(key, conflictType, (ImmutableType)associationType);
                }
            }
            return typeMap;
        }
    }
}

