/*
 * Decompiled with CFR 0.152.
 */
package org.babyfish.jimmer.sql.ast.impl.mutation;

import java.sql.Connection;
import java.util.function.Consumer;
import org.babyfish.jimmer.runtime.ImmutableSpi;
import org.babyfish.jimmer.sql.ast.impl.mutation.AbstractEntitySaveCommandImpl;
import org.babyfish.jimmer.sql.ast.impl.mutation.Saver;
import org.babyfish.jimmer.sql.ast.mutation.AbstractEntitySaveCommand;
import org.babyfish.jimmer.sql.ast.mutation.SimpleEntitySaveCommand;
import org.babyfish.jimmer.sql.ast.mutation.SimpleSaveResult;
import org.babyfish.jimmer.sql.runtime.JSqlClientImplementor;

public class SimpleEntitySaveCommandImpl<E>
extends AbstractEntitySaveCommandImpl
implements SimpleEntitySaveCommand<E> {
    private final E entity;

    public SimpleEntitySaveCommandImpl(JSqlClientImplementor sqlClient, Connection con, E entity) {
        super(sqlClient, con, null);
        if (!(entity instanceof ImmutableSpi)) {
            throw new IllegalArgumentException("entity must be an immutable object");
        }
        this.entity = entity;
    }

    private SimpleEntitySaveCommandImpl(SimpleEntitySaveCommandImpl<E> base, AbstractEntitySaveCommandImpl.Data data) {
        super(base.sqlClient, base.con, data);
        this.entity = base.entity;
    }

    @Override
    public SimpleSaveResult<E> execute() {
        if (this.con != null) {
            return this.executeImpl(this.con);
        }
        return this.sqlClient.getConnectionManager().execute(this::executeImpl);
    }

    @Override
    public SimpleSaveResult<E> execute(Connection con) {
        if (con != null) {
            return this.executeImpl(con);
        }
        if (this.con != null) {
            return this.executeImpl(this.con);
        }
        return this.sqlClient.getConnectionManager().execute(this::executeImpl);
    }

    private SimpleSaveResult<E> executeImpl(Connection con) {
        Saver saver = new Saver(this.data, con, ((ImmutableSpi)this.entity).__type());
        return saver.save(this.entity);
    }

    @Override
    public SimpleEntitySaveCommand<E> configure(Consumer<AbstractEntitySaveCommand.Cfg> block) {
        return (SimpleEntitySaveCommand)super.configure(block);
    }

    @Override
    SimpleEntitySaveCommand<E> create(AbstractEntitySaveCommandImpl.Data data) {
        return new SimpleEntitySaveCommandImpl<E>(this, data);
    }
}

