/*
 * Decompiled with CFR 0.152.
 */
package org.babyfish.jimmer.sql.ast.impl.mutation;

import java.sql.Connection;
import java.sql.PreparedStatement;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import org.babyfish.jimmer.meta.ImmutableType;
import org.babyfish.jimmer.runtime.ImmutableSpi;
import org.babyfish.jimmer.sql.ast.Predicate;
import org.babyfish.jimmer.sql.ast.impl.AbstractMutableStatementImpl;
import org.babyfish.jimmer.sql.ast.impl.Ast;
import org.babyfish.jimmer.sql.ast.impl.AstContext;
import org.babyfish.jimmer.sql.ast.impl.mutation.DeleteCommandImpl;
import org.babyfish.jimmer.sql.ast.impl.mutation.Deleter;
import org.babyfish.jimmer.sql.ast.impl.mutation.MutationCache;
import org.babyfish.jimmer.sql.ast.impl.mutation.MutationTrigger;
import org.babyfish.jimmer.sql.ast.impl.query.MutableRootQueryImpl;
import org.babyfish.jimmer.sql.ast.impl.query.UseTableVisitor;
import org.babyfish.jimmer.sql.ast.impl.table.StatementContext;
import org.babyfish.jimmer.sql.ast.impl.table.TableImplementor;
import org.babyfish.jimmer.sql.ast.mutation.AffectedTable;
import org.babyfish.jimmer.sql.ast.mutation.DeleteMode;
import org.babyfish.jimmer.sql.ast.mutation.MutableDelete;
import org.babyfish.jimmer.sql.ast.table.Table;
import org.babyfish.jimmer.sql.ast.table.TableEx;
import org.babyfish.jimmer.sql.ast.table.spi.TableProxy;
import org.babyfish.jimmer.sql.ast.tuple.Tuple2;
import org.babyfish.jimmer.sql.event.TriggerType;
import org.babyfish.jimmer.sql.runtime.ExecutionPurpose;
import org.babyfish.jimmer.sql.runtime.ExecutorContext;
import org.babyfish.jimmer.sql.runtime.JSqlClientImplementor;
import org.babyfish.jimmer.sql.runtime.SqlBuilder;

public class MutableDeleteImpl
extends AbstractMutableStatementImpl
implements MutableDelete {
    private MutableRootQueryImpl<TableEx<?>> deleteQuery;

    public MutableDeleteImpl(JSqlClientImplementor sqlClient, ImmutableType immutableType) {
        super(sqlClient, immutableType);
        this.deleteQuery = new MutableRootQueryImpl(new StatementContext(ExecutionPurpose.QUERY, false), sqlClient, immutableType);
    }

    public MutableDeleteImpl(JSqlClientImplementor sqlClient, TableProxy<?> table) {
        super(sqlClient, table);
        this.deleteQuery = new MutableRootQueryImpl(new StatementContext(ExecutionPurpose.QUERY, false), sqlClient, table);
    }

    @Override
    public <T extends Table<?>> T getTable() {
        return this.deleteQuery.getTable();
    }

    @Override
    public TableImplementor<?> getTableImplementor() {
        return this.deleteQuery.getTableImplementor();
    }

    @Override
    public AbstractMutableStatementImpl getParent() {
        return null;
    }

    @Override
    public StatementContext getContext() {
        return this.deleteQuery.getContext();
    }

    @Override
    public MutableDelete where(Predicate ... predicates) {
        this.deleteQuery.where(predicates);
        return this;
    }

    @Override
    public Integer execute() {
        return this.getSqlClient().getConnectionManager().execute(this::executeImpl);
    }

    @Override
    public Integer execute(Connection con) {
        if (con != null) {
            return this.executeImpl(con);
        }
        return this.getSqlClient().getConnectionManager().execute(this::executeImpl);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private Integer executeImpl(Connection con) {
        MutationCache cache;
        ArrayList<Object> ids;
        boolean binLogOnly;
        this.freeze();
        JSqlClientImplementor sqlClient = this.getSqlClient();
        TableImplementor<?> table = this.getTableImplementor();
        AstContext astContext = new AstContext(sqlClient);
        astContext.pushStatement(this.deleteQuery);
        try {
            Predicate predicate = this.deleteQuery.getPredicate();
            if (predicate != null) {
                ((Ast)((Object)predicate)).accept(new UseTableVisitor(astContext));
            }
        }
        finally {
            astContext.popStatement();
        }
        boolean bl = binLogOnly = sqlClient.getTriggerType() == TriggerType.BINLOG_ONLY;
        if (table.isEmpty() && binLogOnly) {
            SqlBuilder builder = new SqlBuilder(astContext);
            astContext.pushStatement(this);
            try {
                this.renderDirectly(builder);
                Tuple2<String, List<Object>> sqlResult = builder.build();
                Integer n = sqlClient.getExecutor().execute(con, sqlResult.get_1(), sqlResult.get_2(), this.getPurpose(), ExecutorContext.create(sqlClient), null, PreparedStatement::executeUpdate);
                return n;
            }
            finally {
                astContext.popStatement();
            }
        }
        if (binLogOnly) {
            ids = (ArrayList<Object>)this.deleteQuery.select(table.get(table.getImmutableType().getIdProp().getName())).distinct().execute(con);
            cache = null;
        } else {
            List rows = (List)this.deleteQuery.select(table).execute(con);
            int idPropId = table.getImmutableType().getIdProp().getId();
            ids = new ArrayList<Object>(rows.size());
            cache = new MutationCache(sqlClient, false);
            for (ImmutableSpi row : rows) {
                cache.save(row, false);
                ids.add(row.__get(idPropId));
            }
        }
        if (ids.isEmpty()) {
            return 0;
        }
        Deleter deleter = new Deleter(new DeleteCommandImpl.Data(sqlClient, DeleteMode.PHYSICAL), con, cache, binLogOnly ? null : new MutationTrigger(), new HashMap<AffectedTable, Integer>());
        deleter.addPreHandleInput(table.getImmutableType(), ids);
        return deleter.execute(true).getTotalAffectedRowCount();
    }

    private void renderDirectly(SqlBuilder builder) {
        TableImplementor<?> table = this.getTableImplementor();
        builder.sql("delete");
        if (this.getSqlClient().getDialect().isDeletedAliasRequired()) {
            builder.sql(" ");
            builder.sql(table.getAlias());
        }
        builder.sql(" from ");
        builder.sql(table.getImmutableType().getTableName(this.getSqlClient().getMetadataStrategy()));
        builder.sql(" ");
        builder.sql(table.getAlias());
        Predicate predicate = this.deleteQuery.getPredicate();
        if (predicate != null) {
            builder.sql(" where ");
            ((Ast)((Object)predicate)).renderTo(builder);
        }
    }
}

