/*
 * Decompiled with CFR 0.152.
 */
package org.babyfish.jimmer.sql.ast.impl.mutation;

import java.sql.Connection;
import java.sql.PreparedStatement;
import java.sql.ResultSet;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Iterator;
import java.util.LinkedHashMap;
import java.util.LinkedHashSet;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.Set;
import org.babyfish.jimmer.meta.ImmutableProp;
import org.babyfish.jimmer.meta.ImmutableType;
import org.babyfish.jimmer.meta.LogicalDeletedInfo;
import org.babyfish.jimmer.meta.TargetLevel;
import org.babyfish.jimmer.runtime.DraftSpi;
import org.babyfish.jimmer.runtime.ImmutableSpi;
import org.babyfish.jimmer.runtime.Internal;
import org.babyfish.jimmer.sql.DissociateAction;
import org.babyfish.jimmer.sql.LogicalDeleted;
import org.babyfish.jimmer.sql.ast.impl.AstContext;
import org.babyfish.jimmer.sql.ast.impl.mutation.ChildTableOperator;
import org.babyfish.jimmer.sql.ast.impl.mutation.DeleteCommandImpl;
import org.babyfish.jimmer.sql.ast.impl.mutation.MiddleTableOperator;
import org.babyfish.jimmer.sql.ast.impl.mutation.MutationCache;
import org.babyfish.jimmer.sql.ast.impl.mutation.MutationTrigger;
import org.babyfish.jimmer.sql.ast.mutation.AffectedTable;
import org.babyfish.jimmer.sql.ast.mutation.DeleteMode;
import org.babyfish.jimmer.sql.ast.mutation.DeleteResult;
import org.babyfish.jimmer.sql.ast.tuple.Tuple2;
import org.babyfish.jimmer.sql.meta.ColumnDefinition;
import org.babyfish.jimmer.sql.meta.MetadataStrategy;
import org.babyfish.jimmer.sql.meta.SingleColumn;
import org.babyfish.jimmer.sql.runtime.ExecutionException;
import org.babyfish.jimmer.sql.runtime.ExecutionPurpose;
import org.babyfish.jimmer.sql.runtime.ExecutorContext;
import org.babyfish.jimmer.sql.runtime.Reader;
import org.babyfish.jimmer.sql.runtime.SqlBuilder;

public class Deleter {
    private final DeleteCommandImpl.Data data;
    private final DeleteCommandImpl.Data cascadeData;
    private final Connection con;
    private final MutationCache cache;
    private final MutationTrigger trigger;
    private final Map<AffectedTable, Integer> affectedRowCountMap;
    private Map<ImmutableType, Set<Object>> preHandleIdInputMap = new LinkedHashMap<ImmutableType, Set<Object>>();
    private Map<ImmutableType, Set<Object>> postHandleIdInputMap = new LinkedHashMap<ImmutableType, Set<Object>>();
    private final Map<String, Deleter> childDeleterMap = new LinkedHashMap<String, Deleter>();

    Deleter(DeleteCommandImpl.Data data, Connection con, MutationCache cache, MutationTrigger trigger, Map<AffectedTable, Integer> affectedRowCountMap) {
        this.data = data;
        this.cascadeData = new DeleteCommandImpl.Data(data);
        this.cascadeData.setMode(DeleteMode.PHYSICAL);
        this.con = con;
        if (trigger != null) {
            this.cache = cache;
            this.trigger = trigger;
        } else {
            this.cache = cache;
            this.trigger = null;
        }
        this.affectedRowCountMap = affectedRowCountMap;
    }

    public void addPreHandleInput(ImmutableType type, Collection<?> ids) {
        Set idSet = this.preHandleIdInputMap.computeIfAbsent(type, t -> new LinkedHashSet());
        for (Object id : ids) {
            if (id == null) continue;
            idSet.add(id);
        }
    }

    private void addPostHandleInput(ImmutableType type, Collection<?> ids) {
        Set idSet = this.postHandleIdInputMap.computeIfAbsent(type, t -> new LinkedHashSet());
        for (Object id : ids) {
            if (id == null) continue;
            idSet.add(id);
        }
    }

    private void addOutput(AffectedTable affectTable, int affectedRowCount) {
        this.affectedRowCountMap.merge(affectTable, affectedRowCount, Integer::sum);
    }

    public DeleteResult execute() {
        return this.execute(true);
    }

    public DeleteResult execute(boolean submit) {
        while (!this.preHandleIdInputMap.isEmpty() || !this.postHandleIdInputMap.isEmpty()) {
            while (!this.preHandleIdInputMap.isEmpty()) {
                this.preHandle();
            }
            this.postHandle();
        }
        MutationTrigger trigger = this.trigger;
        if (!submit || trigger == null) {
            return new DeleteResult(this.affectedRowCountMap);
        }
        trigger.submit(this.data.getSqlClient(), this.con);
        return new DeleteResult(this.affectedRowCountMap);
    }

    private void preHandle() {
        Map<ImmutableType, Set<Object>> idMultiMap = this.preHandleIdInputMap;
        this.preHandleIdInputMap = new LinkedHashMap<ImmutableType, Set<Object>>();
        for (Map.Entry<ImmutableType, Set<Object>> e : idMultiMap.entrySet()) {
            this.preHandle(e.getKey(), (Collection<Object>)e.getValue());
        }
    }

    private void preHandle(ImmutableType immutableType, Collection<Object> ids) {
        if (ids.isEmpty()) {
            return;
        }
        if (this.logical(immutableType)) {
            this.addPostHandleInput(immutableType, ids);
            return;
        }
        for (ImmutableProp prop : immutableType.getProps().values()) {
            MiddleTableOperator middleTableOperator = MiddleTableOperator.tryGet(this.data.getSqlClient(), this.con, prop, this.trigger);
            if (middleTableOperator != null) {
                int affectedRowCount = middleTableOperator.removeBySourceIds(ids);
                this.addOutput(AffectedTable.of(prop), affectedRowCount);
                continue;
            }
            ImmutableProp mappedByProp = prop.getMappedBy();
            if (mappedByProp == null || !mappedByProp.isReference(TargetLevel.PERSISTENT) || !mappedByProp.isColumnDefinition()) continue;
            DissociateAction dissociateAction = this.data.getDissociateAction(mappedByProp);
            if (dissociateAction == DissociateAction.SET_NULL) {
                ChildTableOperator childTableOperator = new ChildTableOperator(this.data.getSqlClient(), this.con, mappedByProp, false, this.cache, this.trigger);
                int affectedRowCount = childTableOperator.unsetParents(ids);
                this.addOutput(AffectedTable.of(prop.getTargetType()), affectedRowCount);
                continue;
            }
            this.tryDeleteFromChildTable(prop, ids);
        }
        this.addPostHandleInput(immutableType, ids);
    }

    private void tryDeleteFromChildTable(ImmutableProp prop, Collection<?> ids) {
        ImmutableProp manyToOneProp = prop.getMappedBy();
        ImmutableType childType = manyToOneProp.getDeclaringType();
        MetadataStrategy strategy = this.data.getSqlClient().getMetadataStrategy();
        ColumnDefinition definition = (ColumnDefinition)manyToOneProp.getStorage(strategy);
        SqlBuilder builder = new SqlBuilder(new AstContext(this.data.getSqlClient()));
        Reader<?> reader = this.data.getSqlClient().getReader(childType.getIdProp());
        builder.sql("select ").sql((ColumnDefinition)childType.getIdProp().getStorage(strategy)).sql(" from ").sql(childType.getTableName(strategy)).sql(" where ").sql(null, definition, true).sql(" in (");
        String separator = "";
        for (Object id : ids) {
            builder.sql(separator);
            separator = ", ";
            builder.variable(id);
        }
        builder.sql(")");
        Tuple2<String, List<Object>> sqlResult = builder.build();
        List childIds = this.data.getSqlClient().getExecutor().execute(this.con, sqlResult.get_1(), sqlResult.get_2(), ExecutionPurpose.DELETE, ExecutorContext.create(this.data.getSqlClient()), null, stmt -> {
            ArrayList values = new ArrayList();
            try (ResultSet rs = stmt.executeQuery();){
                while (rs.next()) {
                    values.add(reader.read(rs, new Reader.Col()));
                }
            }
            return values;
        });
        if (!childIds.isEmpty()) {
            if (this.data.getDissociateAction(manyToOneProp) != DissociateAction.DELETE) {
                throw new ExecutionException("Cannot delete entities whose type are \"" + manyToOneProp.getTargetType().getJavaClass().getName() + "\" because there are some child entities whose type are \"" + manyToOneProp.getDeclaringType().getJavaClass().getName() + "\", these child entities use the association property \"" + manyToOneProp + "\" to reference current entities.");
            }
            Deleter childDeleter = this.childDeleterMap.computeIfAbsent(prop.getName(), it -> new Deleter(this.cascadeData, this.con, this.cache, this.trigger, this.affectedRowCountMap));
            childDeleter.addPreHandleInput(childType, childIds);
            childDeleter.preHandle();
        }
    }

    private void postHandle() {
        this.childDeleterMap.values().forEach(Deleter::postHandle);
        Map<ImmutableType, Set<Object>> idMultiMap = this.postHandleIdInputMap;
        this.postHandleIdInputMap = new LinkedHashMap<ImmutableType, Set<Object>>();
        for (Map.Entry<ImmutableType, Set<Object>> e : idMultiMap.entrySet()) {
            if (this.logical(e.getKey())) {
                this.logicallyDeleteImpl(e.getKey(), (Collection<Object>)e.getValue());
                continue;
            }
            this.deleteImpl(e.getKey(), (Collection<Object>)e.getValue());
        }
    }

    private void logicallyDeleteImpl(ImmutableType type, Collection<Object> ids) {
        if (ids.isEmpty()) {
            return;
        }
        LogicalDeletedInfo info = type.getLogicalDeletedInfo();
        assert (info != null);
        ImmutableProp prop = info.getProp();
        Object deletedValue = info.getValue();
        if ((ids = this.prepareLogicEvents(type, ids, prop.getId(), deletedValue)).isEmpty()) {
            return;
        }
        MetadataStrategy strategy = this.data.getSqlClient().getMetadataStrategy();
        ColumnDefinition definition = (ColumnDefinition)type.getIdProp().getStorage(strategy);
        SqlBuilder builder = new SqlBuilder(new AstContext(this.data.getSqlClient()));
        builder.sql("update ");
        builder.sql(type.getTableName(strategy));
        builder.sql(" set ");
        builder.sql(((SingleColumn)info.getProp().getStorage(strategy)).getName());
        builder.sql(" = ");
        if (deletedValue != null) {
            builder.variable(deletedValue);
        } else {
            builder.nullVariable(prop.getElementClass());
        }
        builder.sql(" where ");
        builder.sql(null, definition, true);
        builder.sql(" in (");
        String separator = "";
        for (Object id : ids) {
            builder.sql(separator);
            separator = ", ";
            builder.variable(id);
        }
        builder.sql(")");
        Tuple2<String, List<Object>> sqlResult = builder.build();
        int affectedRowCount = this.data.getSqlClient().getExecutor().execute(this.con, sqlResult.get_1(), sqlResult.get_2(), ExecutionPurpose.DELETE, ExecutorContext.create(this.data.getSqlClient()), null, PreparedStatement::executeUpdate);
        this.addOutput(AffectedTable.of(type), affectedRowCount);
    }

    private void deleteImpl(ImmutableType type, Collection<Object> ids) {
        if (ids.isEmpty()) {
            return;
        }
        if ((ids = this.prepareEvents(type, ids)).isEmpty()) {
            return;
        }
        MetadataStrategy strategy = this.data.getSqlClient().getMetadataStrategy();
        ColumnDefinition definition = (ColumnDefinition)type.getIdProp().getStorage(strategy);
        SqlBuilder builder = new SqlBuilder(new AstContext(this.data.getSqlClient()));
        builder.sql("delete from ");
        builder.sql(type.getTableName(strategy));
        builder.sql(" where ");
        builder.sql(null, definition, true);
        builder.sql(" in (");
        String separator = "";
        for (Object id : ids) {
            builder.sql(separator);
            separator = ", ";
            builder.variable(id);
        }
        builder.sql(")");
        Tuple2<String, List<Object>> sqlResult = builder.build();
        int affectedRowCount = this.data.getSqlClient().getExecutor().execute(this.con, sqlResult.get_1(), sqlResult.get_2(), ExecutionPurpose.DELETE, ExecutorContext.create(this.data.getSqlClient()), null, PreparedStatement::executeUpdate);
        this.addOutput(AffectedTable.of(type), affectedRowCount);
    }

    private Collection<Object> prepareLogicEvents(ImmutableType type, Collection<Object> ids, int propId, Object deletedValue) {
        if (ids.isEmpty()) {
            return ids;
        }
        MutationTrigger trigger = this.trigger;
        if (trigger == null) {
            return ids;
        }
        int idPropId = type.getIdProp().getId();
        List<ImmutableSpi> rows = this.cache.loadByIds(type, ids, this.con);
        Iterator<ImmutableSpi> itr = rows.iterator();
        ArrayList<Object> changedIds = new ArrayList<Object>();
        while (itr.hasNext()) {
            ImmutableSpi row = itr.next();
            if (Objects.equals(row.__get(propId), deletedValue)) {
                itr.remove();
                continue;
            }
            trigger.modifyEntityTable(row, Internal.produce((ImmutableType)type, (Object)row, draft -> ((DraftSpi)draft).__set(propId, deletedValue)));
            changedIds.add(row.__get(idPropId));
        }
        return changedIds;
    }

    private Collection<Object> prepareEvents(ImmutableType type, Collection<Object> ids) {
        MutationTrigger trigger = this.trigger;
        if (trigger == null) {
            return ids;
        }
        List<ImmutableSpi> rows = this.cache.loadByIds(type, ids, this.con);
        for (ImmutableSpi row : rows) {
            trigger.modifyEntityTable(row, null);
        }
        if (rows.size() == ids.size()) {
            return ids;
        }
        int idPropId = type.getIdProp().getId();
        ArrayList<Object> rowIds = new ArrayList<Object>(ids.size());
        for (ImmutableSpi row : rows) {
            rowIds.add(row.__get(idPropId));
        }
        return rowIds;
    }

    private boolean logical(ImmutableType type) {
        boolean hasLogicalInfo;
        DeleteMode mode = this.data.getMode();
        if (mode == DeleteMode.PHYSICAL) {
            return false;
        }
        boolean bl = hasLogicalInfo = type.getLogicalDeletedInfo() != null;
        if (hasLogicalInfo && mode == DeleteMode.LOGICAL) {
            throw new ExecutionException("The data of \"" + type + "\" cannot be logically deleted, because there is no property decorated by `@" + LogicalDeleted.class.getName() + "` in that type");
        }
        return hasLogicalInfo;
    }
}

