/*
 * Decompiled with CFR 0.152.
 */
package org.babyfish.jimmer.sql.ast.impl.mutation;

import java.sql.Connection;
import java.util.Collections;
import java.util.HashSet;
import java.util.LinkedHashMap;
import java.util.LinkedHashSet;
import java.util.Map;
import java.util.Objects;
import java.util.Set;
import java.util.function.Consumer;
import org.babyfish.jimmer.meta.ImmutableProp;
import org.babyfish.jimmer.meta.ImmutableType;
import org.babyfish.jimmer.meta.TargetLevel;
import org.babyfish.jimmer.sql.DissociateAction;
import org.babyfish.jimmer.sql.ast.mutation.AbstractEntitySaveCommand;
import org.babyfish.jimmer.sql.ast.mutation.DeleteMode;
import org.babyfish.jimmer.sql.ast.mutation.SaveMode;
import org.babyfish.jimmer.sql.event.TriggerType;
import org.babyfish.jimmer.sql.event.Triggers;
import org.babyfish.jimmer.sql.runtime.JSqlClientImplementor;

abstract class AbstractEntitySaveCommandImpl
implements AbstractEntitySaveCommand {
    final JSqlClientImplementor sqlClient;
    final Connection con;
    final Data data;

    AbstractEntitySaveCommandImpl(JSqlClientImplementor sqlClient, Connection con, Data data) {
        this.sqlClient = sqlClient;
        this.con = con;
        this.data = data != null ? data.freeze() : new Data(sqlClient).freeze();
    }

    @Override
    public AbstractEntitySaveCommand configure(Consumer<AbstractEntitySaveCommand.Cfg> block) {
        Data newData = new Data(this.data);
        block.accept(newData);
        if (this.data.equals(newData)) {
            return this;
        }
        return this.create(newData);
    }

    abstract AbstractEntitySaveCommand create(Data var1);

    static class Data
    implements AbstractEntitySaveCommand.Cfg {
        private final JSqlClientImplementor sqlClient;
        private final Triggers triggers;
        private boolean frozen;
        private SaveMode mode;
        private DeleteMode deleteMode;
        private Map<ImmutableType, Set<ImmutableProp>> keyPropMultiMap;
        private boolean autoAttachingAll;
        private Set<ImmutableProp> autoAttachingSet;
        private boolean autoCheckingAll;
        private Set<ImmutableProp> autoCheckingSet;
        private boolean appendOnlyAll;
        private Set<ImmutableProp> appendOnlySet;
        private Map<ImmutableProp, DissociateAction> dissociateActionMap;
        private boolean pessimisticLock;

        Data(JSqlClientImplementor sqlClient) {
            this.sqlClient = sqlClient;
            this.triggers = sqlClient.getTriggerType() == TriggerType.BINLOG_ONLY ? null : sqlClient.getTriggers(true);
            this.mode = SaveMode.UPSERT;
            this.deleteMode = DeleteMode.AUTO;
            this.keyPropMultiMap = new LinkedHashMap<ImmutableType, Set<ImmutableProp>>();
            this.autoAttachingSet = new HashSet<ImmutableProp>();
            this.autoCheckingSet = new HashSet<ImmutableProp>();
            this.appendOnlySet = new HashSet<ImmutableProp>();
            this.dissociateActionMap = new LinkedHashMap<ImmutableProp, DissociateAction>();
            this.pessimisticLock = false;
        }

        Data(Data base) {
            this.sqlClient = base.sqlClient;
            this.triggers = base.triggers;
            this.mode = SaveMode.UPSERT;
            this.deleteMode = base.deleteMode;
            this.keyPropMultiMap = new LinkedHashMap<ImmutableType, Set<ImmutableProp>>(base.keyPropMultiMap);
            this.autoAttachingAll = base.autoAttachingAll;
            this.autoAttachingSet = new HashSet<ImmutableProp>(base.autoAttachingSet);
            this.autoCheckingAll = base.autoCheckingAll;
            this.autoCheckingSet = new HashSet<ImmutableProp>(base.autoCheckingSet);
            this.appendOnlyAll = base.appendOnlyAll;
            this.appendOnlySet = base.appendOnlySet;
            this.dissociateActionMap = new LinkedHashMap<ImmutableProp, DissociateAction>(base.dissociateActionMap);
            this.pessimisticLock = base.pessimisticLock;
        }

        public JSqlClientImplementor getSqlClient() {
            return this.sqlClient;
        }

        public Triggers getTriggers() {
            return this.triggers;
        }

        public SaveMode getMode() {
            return this.mode;
        }

        public DeleteMode getDeleteMode() {
            return this.deleteMode;
        }

        public Set<ImmutableProp> getKeyProps(ImmutableType type) {
            Set<ImmutableProp> keyProps = this.keyPropMultiMap.get(type);
            if (keyProps != null) {
                return keyProps;
            }
            return type.getKeyProps();
        }

        public boolean isAutoAttachingProp(ImmutableProp prop) {
            return this.autoAttachingAll || this.autoAttachingSet.contains(prop);
        }

        public boolean isAutoCheckingProp(ImmutableProp prop) {
            return this.autoCheckingAll || this.autoCheckingSet.contains(prop);
        }

        public boolean isAppendOnly(ImmutableProp prop) {
            return this.appendOnlyAll || this.appendOnlySet.contains(prop);
        }

        public DissociateAction getDissociateAction(ImmutableProp prop) {
            DissociateAction action = this.dissociateActionMap.get(prop);
            return action != null ? action : prop.getDissociateAction();
        }

        Map<ImmutableProp, DissociateAction> dissociateActionMap() {
            return this.dissociateActionMap;
        }

        boolean isPessimisticLockRequired() {
            return this.pessimisticLock;
        }

        @Override
        public AbstractEntitySaveCommand.Cfg setMode(SaveMode mode) {
            this.validate();
            this.mode = Objects.requireNonNull(mode, "mode cannot be null");
            return this;
        }

        @Override
        public AbstractEntitySaveCommand.Cfg setKeyProps(ImmutableProp ... props) {
            this.validate();
            ImmutableType type = null;
            LinkedHashSet<ImmutableProp> set = new LinkedHashSet<ImmutableProp>();
            for (ImmutableProp prop : props) {
                if (prop == null) continue;
                if (prop.isId()) {
                    throw new IllegalArgumentException("'" + prop + "' cannot be key property because it is id property");
                }
                if (prop.isVersion()) {
                    throw new IllegalArgumentException("'" + prop + "' cannot be key property because it is version property");
                }
                if (prop.isAssociation(TargetLevel.PERSISTENT) || !prop.isColumnDefinition()) {
                    throw new IllegalArgumentException("'" + prop + "' cannot be key property because it is not a scalar property with storage");
                }
                if (prop.isNullable()) {
                    throw new IllegalArgumentException("'" + prop + "' cannot be key property because it is nullable");
                }
                if (type == null) {
                    type = prop.getDeclaringType();
                } else if (type != prop.getDeclaringType()) {
                    throw new IllegalArgumentException("all key properties must belong to one type");
                }
                set.add(prop);
            }
            if (type != null) {
                this.keyPropMultiMap.put(type, set);
            }
            return this;
        }

        @Override
        public AbstractEntitySaveCommand.Cfg setAutoAttachingAll() {
            this.autoAttachingAll = true;
            return this;
        }

        @Override
        public AbstractEntitySaveCommand.Cfg setAutoAttaching(ImmutableProp prop) {
            this.validate();
            this.autoAttachingSet.add(prop);
            return this;
        }

        @Override
        public AbstractEntitySaveCommand.Cfg setAutoIdOnlyTargetCheckingAll() {
            this.autoCheckingAll = true;
            return this;
        }

        @Override
        public AbstractEntitySaveCommand.Cfg setAutoIdOnlyTargetChecking(ImmutableProp prop) {
            this.autoCheckingSet.add(prop);
            return this;
        }

        @Override
        public AbstractEntitySaveCommand.Cfg setAppendOnly(ImmutableProp prop) {
            this.appendOnlySet.add(prop);
            return this;
        }

        @Override
        public AbstractEntitySaveCommand.Cfg setAppendOnlyAll() {
            this.appendOnlyAll = true;
            return this;
        }

        @Override
        public AbstractEntitySaveCommand.Cfg setDissociateAction(ImmutableProp prop, DissociateAction dissociateAction) {
            this.validate();
            if (!prop.isReference(TargetLevel.PERSISTENT) || !prop.isColumnDefinition()) {
                throw new IllegalArgumentException("'" + prop + "' must be an reference property bases on foreign key");
            }
            if (dissociateAction == DissociateAction.SET_NULL && !prop.isNullable()) {
                throw new IllegalArgumentException("'" + prop + "' is not nullable so that it does not support 'on delete set null'");
            }
            if (dissociateAction == DissociateAction.SET_NULL && prop.isInputNotNull()) {
                throw new IllegalArgumentException("'" + prop + "' is `inputNotNull` so that it does not support 'on delete set null'");
            }
            this.dissociateActionMap.put(prop, dissociateAction);
            return this;
        }

        @Override
        public AbstractEntitySaveCommand.Cfg setPessimisticLock(boolean pessimisticLock) {
            this.pessimisticLock = pessimisticLock;
            return this;
        }

        @Override
        public AbstractEntitySaveCommand.Cfg setDeleteMode(DeleteMode mode) {
            this.deleteMode = Objects.requireNonNull(mode, "mode cannot be null");
            return this;
        }

        public Data freeze() {
            if (!this.frozen) {
                this.keyPropMultiMap = Collections.unmodifiableMap(this.keyPropMultiMap);
                this.autoAttachingSet = Collections.unmodifiableSet(this.autoAttachingSet);
                this.autoCheckingSet = Collections.unmodifiableSet(this.autoCheckingSet);
                this.dissociateActionMap = Collections.unmodifiableMap(this.dissociateActionMap);
                this.frozen = true;
            }
            return this;
        }

        public int hashCode() {
            return Objects.hash(new Object[]{this.sqlClient, this.triggers, this.frozen, this.mode, this.deleteMode, this.keyPropMultiMap, this.autoAttachingAll, this.autoAttachingSet, this.autoCheckingAll, this.autoCheckingSet, this.dissociateActionMap, this.pessimisticLock});
        }

        public boolean equals(Object o) {
            if (this == o) {
                return true;
            }
            if (o == null || this.getClass() != o.getClass()) {
                return false;
            }
            Data data = (Data)o;
            return this.frozen == data.frozen && this.autoAttachingAll == data.autoAttachingAll && this.autoCheckingAll == data.autoCheckingAll && this.pessimisticLock == data.pessimisticLock && this.sqlClient.equals(data.sqlClient) && Objects.equals(this.triggers, data.triggers) && this.mode == data.mode && this.deleteMode == data.deleteMode && this.keyPropMultiMap.equals(data.keyPropMultiMap) && this.autoAttachingSet.equals(data.autoAttachingSet) && this.autoCheckingSet.equals(data.autoCheckingSet) && this.dissociateActionMap.equals(data.dissociateActionMap);
        }

        public String toString() {
            return "Data{sqlClient=" + this.sqlClient + ", triggers=" + this.triggers + ", frozen=" + this.frozen + ", mode=" + (Object)((Object)this.mode) + ", deleteMode=" + (Object)((Object)this.deleteMode) + ", keyPropMultiMap=" + this.keyPropMultiMap + ", autoAttachingAll=" + this.autoAttachingAll + ", autoAttachingSet=" + this.autoAttachingSet + ", autoCheckingAll=" + this.autoCheckingAll + ", autoCheckingSet=" + this.autoCheckingSet + ", dissociateActionMap=" + this.dissociateActionMap + ", pessimisticLock=" + this.pessimisticLock + '}';
        }

        private void validate() {
            if (this.frozen) {
                throw new IllegalStateException("The current configuration is frozen");
            }
        }
    }
}

