/*
 * Decompiled with CFR 0.152.
 */
package org.babyfish.jimmer.sql;

import com.fasterxml.jackson.databind.ObjectMapper;
import java.util.Collection;
import java.util.Map;
import java.util.function.Consumer;
import org.babyfish.jimmer.meta.ImmutableProp;
import org.babyfish.jimmer.meta.TypedProp;
import org.babyfish.jimmer.sql.Associations;
import org.babyfish.jimmer.sql.DraftInterceptor;
import org.babyfish.jimmer.sql.Entities;
import org.babyfish.jimmer.sql.EnumType;
import org.babyfish.jimmer.sql.JSqlClientImpl;
import org.babyfish.jimmer.sql.association.meta.AssociationType;
import org.babyfish.jimmer.sql.ast.mutation.DeleteMode;
import org.babyfish.jimmer.sql.ast.mutation.DeleteResult;
import org.babyfish.jimmer.sql.ast.mutation.MutableDelete;
import org.babyfish.jimmer.sql.ast.mutation.MutableUpdate;
import org.babyfish.jimmer.sql.ast.mutation.SaveMode;
import org.babyfish.jimmer.sql.ast.mutation.SimpleSaveResult;
import org.babyfish.jimmer.sql.ast.query.MutableRootQuery;
import org.babyfish.jimmer.sql.ast.query.SubQueryProvider;
import org.babyfish.jimmer.sql.ast.table.AssociationTable;
import org.babyfish.jimmer.sql.ast.table.Table;
import org.babyfish.jimmer.sql.ast.table.spi.TableProxy;
import org.babyfish.jimmer.sql.cache.CacheConfig;
import org.babyfish.jimmer.sql.cache.CacheDisableConfig;
import org.babyfish.jimmer.sql.cache.Caches;
import org.babyfish.jimmer.sql.dialect.Dialect;
import org.babyfish.jimmer.sql.event.TriggerType;
import org.babyfish.jimmer.sql.event.Triggers;
import org.babyfish.jimmer.sql.event.binlog.BinLog;
import org.babyfish.jimmer.sql.fetcher.Fetcher;
import org.babyfish.jimmer.sql.filter.Filter;
import org.babyfish.jimmer.sql.filter.FilterConfig;
import org.babyfish.jimmer.sql.filter.Filters;
import org.babyfish.jimmer.sql.loader.graphql.Loaders;
import org.babyfish.jimmer.sql.meta.DatabaseNamingStrategy;
import org.babyfish.jimmer.sql.meta.IdGenerator;
import org.babyfish.jimmer.sql.runtime.ConnectionManager;
import org.babyfish.jimmer.sql.runtime.Customizer;
import org.babyfish.jimmer.sql.runtime.DatabaseValidationMode;
import org.babyfish.jimmer.sql.runtime.EntityManager;
import org.babyfish.jimmer.sql.runtime.Executor;
import org.babyfish.jimmer.sql.runtime.Initializer;
import org.babyfish.jimmer.sql.runtime.MicroServiceExchange;
import org.babyfish.jimmer.sql.runtime.ScalarProvider;
import org.babyfish.jimmer.sql.runtime.TransientResolverProvider;
import org.jetbrains.annotations.Nullable;

public interface JSqlClient
extends SubQueryProvider {
    public static Builder newBuilder() {
        return new JSqlClientImpl.BuilderImpl();
    }

    public <T extends TableProxy<?>> MutableRootQuery<T> createQuery(T var1);

    public MutableUpdate createUpdate(TableProxy<?> var1);

    public MutableDelete createDelete(TableProxy<?> var1);

    public <SE, ST extends Table<SE>, TE, TT extends Table<TE>> MutableRootQuery<AssociationTable<SE, ST, TE, TT>> createAssociationQuery(AssociationTable<SE, ST, TE, TT> var1);

    public Entities getEntities();

    public Triggers getTriggers();

    public Triggers getTriggers(boolean var1);

    public Associations getAssociations(TypedProp.Association<?, ?> var1);

    public Associations getAssociations(ImmutableProp var1);

    public Associations getAssociations(AssociationType var1);

    public Loaders getLoaders();

    public Caches getCaches();

    public Filters getFilters();

    public BinLog getBinLog();

    public JSqlClient caches(Consumer<CacheDisableConfig> var1);

    public JSqlClient filters(Consumer<FilterConfig> var1);

    public JSqlClient disableSlaveConnectionManager();

    @Nullable
    default public <E> E findById(Class<E> entityType, Object id) {
        return this.getEntities().findById(entityType, id);
    }

    @Nullable
    default public <E> E findById(Fetcher<E> fetcher, Object id) {
        return this.getEntities().findById(fetcher, id);
    }

    @Nullable
    default public <K, V> Map<K, V> findByIds(Class<V> entityType, Collection<K> ids) {
        return this.getEntities().findMapByIds(entityType, ids);
    }

    @Nullable
    default public <K, V> Map<K, V> findByIds(Fetcher<V> entityType, Collection<K> ids) {
        return this.getEntities().findMapByIds(entityType, ids);
    }

    default public <E> SimpleSaveResult<E> save(E entity, SaveMode mode) {
        return (SimpleSaveResult)this.getEntities().saveCommand(entity).setMode(mode).setAutoAttachingAll().execute();
    }

    default public <E> SimpleSaveResult<E> save(E entity) {
        return this.save(entity, SaveMode.UPSERT);
    }

    default public <E> SimpleSaveResult<E> insert(E entity) {
        return this.save(entity, SaveMode.INSERT_ONLY);
    }

    default public <E> SimpleSaveResult<E> update(E entity) {
        return this.save(entity, SaveMode.UPDATE_ONLY);
    }

    default public DeleteResult deleteById(Class<?> entityType, Object id, DeleteMode mode) {
        return this.getEntities().delete(entityType, id, mode);
    }

    default public DeleteResult deleteById(Class<?> entityType, Object id) {
        return this.getEntities().delete(entityType, id, DeleteMode.AUTO);
    }

    default public DeleteResult deleteByIds(Class<?> entityType, Collection<?> ids, DeleteMode mode) {
        return this.getEntities().batchDelete(entityType, ids, mode);
    }

    default public DeleteResult deleteByIds(Class<?> entityType, Collection<?> ids) {
        return this.getEntities().batchDelete(entityType, ids, DeleteMode.AUTO);
    }

    public static interface Builder {
        public static final int DEFAULT_BATCH_SIZE = 128;
        public static final int DEFAULT_LIST_BATCH_SIZE = 16;

        public Builder setConnectionManager(ConnectionManager var1);

        public Builder setSlaveConnectionManager(ConnectionManager var1);

        public Builder setDialect(Dialect var1);

        public Builder setExecutor(Executor var1);

        public Builder setExecutorContextPrefixes(Collection<String> var1);

        public Builder setTransientResolverProvider(TransientResolverProvider var1);

        public Builder setIdGenerator(IdGenerator var1);

        public Builder setIdGenerator(Class<?> var1, IdGenerator var2);

        public Builder addScalarProvider(ScalarProvider<?, ?> var1);

        public Builder addScalarProvider(TypedProp<?, ?> var1, ScalarProvider<?, ?> var2);

        public Builder addScalarProvider(ImmutableProp var1, ScalarProvider<?, ?> var2);

        public Builder setDefaultEnumStrategy(EnumType.Strategy var1);

        public Builder setDatabaseNamingStrategy(DatabaseNamingStrategy var1);

        public Builder setDefaultBatchSize(int var1);

        public Builder setDefaultListBatchSize(int var1);

        public Builder setOffsetOptimizingThreshold(int var1);

        public Builder setEntityManager(EntityManager var1);

        public Builder setCaches(Consumer<CacheConfig> var1);

        public Builder setTriggerType(TriggerType var1);

        public Builder addFilters(Filter<?> ... var1);

        public Builder addFilters(Collection<Filter<?>> var1);

        public Builder addDisabledFilters(Filter<?> ... var1);

        public Builder ignoreBuiltInFilters();

        public Builder addDisabledFilters(Collection<Filter<?>> var1);

        public Builder addDraftInterceptor(DraftInterceptor<?> var1);

        public Builder addDraftInterceptors(DraftInterceptor<?> ... var1);

        public Builder addDraftInterceptors(Collection<DraftInterceptor<?>> var1);

        public Builder setBinLogObjectMapper(ObjectMapper var1);

        public Builder setForeignKeyEnabledByDefault(boolean var1);

        public Builder addCustomizers(Customizer ... var1);

        public Builder addCustomizers(Collection<Customizer> var1);

        public Builder addInitializers(Initializer ... var1);

        public Builder addInitializers(Collection<Initializer> var1);

        public Builder setDatabaseValidationMode(DatabaseValidationMode var1);

        public Builder setDatabaseValidationCatalog(String var1);

        public Builder setMicroServiceName(String var1);

        public Builder setMicroServiceExchange(MicroServiceExchange var1);

        public JSqlClient build();
    }
}

