/*
 * Decompiled with CFR 0.152.
 */
package org.babyfish.jimmer.sql.runtime;

import java.util.ArrayList;
import java.util.Collection;
import java.util.List;
import java.util.Objects;
import java.util.function.Function;
import org.babyfish.jimmer.meta.EmbeddedLevel;
import org.babyfish.jimmer.meta.ImmutableProp;
import org.babyfish.jimmer.meta.ImmutableType;
import org.babyfish.jimmer.runtime.ImmutableSpi;
import org.babyfish.jimmer.sql.ast.impl.AstContext;
import org.babyfish.jimmer.sql.ast.impl.TupleImplementor;
import org.babyfish.jimmer.sql.ast.impl.util.EmbeddableObjects;
import org.babyfish.jimmer.sql.ast.tuple.Tuple2;
import org.babyfish.jimmer.sql.ast.tuple.Tuple3;
import org.babyfish.jimmer.sql.ast.tuple.Tuple4;
import org.babyfish.jimmer.sql.ast.tuple.Tuple5;
import org.babyfish.jimmer.sql.ast.tuple.Tuple6;
import org.babyfish.jimmer.sql.ast.tuple.Tuple7;
import org.babyfish.jimmer.sql.ast.tuple.Tuple8;
import org.babyfish.jimmer.sql.ast.tuple.Tuple9;
import org.babyfish.jimmer.sql.meta.ColumnDefinition;
import org.babyfish.jimmer.sql.meta.SingleColumn;
import org.babyfish.jimmer.sql.runtime.DbNull;
import org.babyfish.jimmer.sql.runtime.ExecutionException;
import org.babyfish.jimmer.sql.runtime.ScalarProvider;

public class SqlBuilder {
    private final AstContext ctx;
    private final SqlBuilder parent;
    private final StringBuilder builder = new StringBuilder();
    private final List<Object> variables = new ArrayList<Object>();
    private int childBuilderCount;
    private int tupleDepth = 0;
    private boolean terminated;

    public SqlBuilder(AstContext ctx) {
        this.ctx = ctx;
        this.parent = null;
    }

    private SqlBuilder(SqlBuilder parent) {
        this.ctx = parent.ctx;
        this.parent = parent;
        ++parent.childBuilderCount;
    }

    public AstContext getAstContext() {
        return this.ctx;
    }

    public SqlBuilder sql(String tableAlias, ColumnDefinition definition) {
        return this.sql(tableAlias, definition, null);
    }

    public SqlBuilder sql(String tableAlias, ColumnDefinition definition, Function<Integer, String> asBlock) {
        if (tableAlias == null || tableAlias.isEmpty()) {
            return this.sql(definition);
        }
        if (definition instanceof SingleColumn) {
            this.builder.append(tableAlias).append('.').append(((SingleColumn)definition).getName());
            if (asBlock != null) {
                this.builder.append(" ").append(asBlock.apply(0));
            }
        } else {
            int size = definition.size();
            for (int i = 0; i < size; ++i) {
                if (i != 0) {
                    this.builder.append(", ");
                }
                this.builder.append(tableAlias).append('.').append(definition.name(i));
                if (asBlock == null) continue;
                this.builder.append(" ").append(asBlock.apply(i));
            }
        }
        return this;
    }

    public SqlBuilder sql(String tableAlias, ColumnDefinition definition, boolean applyEmbeddedScope) {
        if (applyEmbeddedScope && definition.isEmbedded()) {
            this.enterTuple();
            this.sql(tableAlias, definition);
            this.leaveTuple();
        } else {
            this.sql(tableAlias, definition);
        }
        return this;
    }

    public SqlBuilder sql(ColumnDefinition definition) {
        if (definition instanceof SingleColumn) {
            this.builder.append(((SingleColumn)definition).getName());
        } else {
            boolean addComma = false;
            for (String columnName : definition) {
                if (addComma) {
                    this.builder.append(", ");
                } else {
                    addComma = true;
                }
                this.builder.append(columnName);
            }
        }
        return this;
    }

    public SqlBuilder assignment(ImmutableProp prop, Object value) {
        ColumnDefinition definition = (ColumnDefinition)this.ctx.getSqlClient().getDatabaseMetadata().getStorage(prop);
        if (definition instanceof SingleColumn) {
            this.builder.append(((SingleColumn)definition).getName()).append(" = ");
            if (value != null) {
                ScalarProvider scalarProvider = this.ctx.getSqlClient().getScalarProvider(prop);
                if (scalarProvider != null) {
                    try {
                        value = scalarProvider.toSql(value);
                    }
                    catch (Exception ex) {
                        throw new ExecutionException("Cannot convert the value of \"" + prop + "\" by \"" + scalarProvider.getClass().getName() + "\"", ex);
                    }
                }
                this.variable(value);
            } else {
                this.nullVariable(prop.getElementClass());
            }
        } else {
            ImmutableType type = prop.isEmbedded(EmbeddedLevel.SCALAR) ? prop.getTargetType() : prop.getTargetType().getIdProp().getTargetType();
            List<Class<?>> subTypes = EmbeddableObjects.expandTypes(type);
            Object[] subValues = EmbeddableObjects.expand(type, value);
            int size = definition.size();
            for (int i = 0; i < size; ++i) {
                if (i != 0) {
                    this.builder.append(", ");
                }
                this.builder.append(definition.name(i)).append(" = ");
                Object subValue = subValues[i];
                if (subValue != null) {
                    this.variable(subValue);
                    continue;
                }
                this.nullSingeVariable(subTypes.get(i));
            }
        }
        return this;
    }

    public SqlBuilder sql(String sql) {
        this.builder.append(sql);
        return this;
    }

    public <T> SqlBuilder variable(Class<T> type, T value) {
        if (value != null) {
            return this.variable(value);
        }
        return this.nullVariable(type);
    }

    public SqlBuilder variable(Object value) {
        return this.variable(value, null);
    }

    public SqlBuilder variable(Object value, ScalarProvider<?, ?> scalarProvider) {
        this.validate();
        if (value instanceof TupleImplementor) {
            if (value instanceof Tuple2) {
                Tuple2 tuple = (Tuple2)value;
                this.enterTuple().nonTupleVariable(Objects.requireNonNull(tuple.get_1(), "tuple.get_1 cannot be null")).sql(", ").nonTupleVariable(Objects.requireNonNull(tuple.get_2(), "tuple.get_2 cannot be null")).leaveTuple();
            } else if (value instanceof Tuple3) {
                Tuple3 tuple = (Tuple3)value;
                this.enterTuple().nonTupleVariable(Objects.requireNonNull(tuple.get_1(), "tuple.get_1 cannot be null")).sql(", ").nonTupleVariable(Objects.requireNonNull(tuple.get_2(), "tuple.get_2 cannot be null")).sql(", ").nonTupleVariable(Objects.requireNonNull(tuple.get_3(), "tuple.get_3 cannot be null")).leaveTuple();
            } else if (value instanceof Tuple4) {
                Tuple4 tuple = (Tuple4)value;
                this.enterTuple().nonTupleVariable(Objects.requireNonNull(tuple.get_1(), "tuple.get_1 cannot be null")).sql(", ").nonTupleVariable(Objects.requireNonNull(tuple.get_2(), "tuple.get_2 cannot be null")).sql(", ").nonTupleVariable(Objects.requireNonNull(tuple.get_3(), "tuple.get_3 cannot be null")).sql(", ").nonTupleVariable(Objects.requireNonNull(tuple.get_4(), "tuple.get_4 cannot be null")).leaveTuple();
            } else if (value instanceof Tuple5) {
                Tuple5 tuple = (Tuple5)value;
                this.enterTuple().nonTupleVariable(Objects.requireNonNull(tuple.get_1(), "tuple.get_1 cannot be null")).sql(", ").nonTupleVariable(Objects.requireNonNull(tuple.get_2(), "tuple.get_2 cannot be null")).sql(", ").nonTupleVariable(Objects.requireNonNull(tuple.get_3(), "tuple.get_3 cannot be null")).sql(", ").nonTupleVariable(Objects.requireNonNull(tuple.get_4(), "tuple.get_4 cannot be null")).sql(", ").nonTupleVariable(Objects.requireNonNull(tuple.get_5(), "tuple.get_5 cannot be null")).leaveTuple();
            } else if (value instanceof Tuple6) {
                Tuple6 tuple = (Tuple6)value;
                this.enterTuple().nonTupleVariable(Objects.requireNonNull(tuple.get_1(), "tuple.get_1 cannot be null")).sql(", ").nonTupleVariable(Objects.requireNonNull(tuple.get_2(), "tuple.get_2 cannot be null")).sql(", ").nonTupleVariable(Objects.requireNonNull(tuple.get_3(), "tuple.get_3 cannot be null")).sql(", ").nonTupleVariable(Objects.requireNonNull(tuple.get_4(), "tuple.get_4 cannot be null")).sql(", ").nonTupleVariable(Objects.requireNonNull(tuple.get_5(), "tuple.get_5 cannot be null")).sql(", ").nonTupleVariable(Objects.requireNonNull(tuple.get_6(), "tuple.get_6 cannot be null")).leaveTuple();
            } else if (value instanceof Tuple7) {
                Tuple7 tuple = (Tuple7)value;
                this.enterTuple().nonTupleVariable(Objects.requireNonNull(tuple.get_1(), "tuple.get_1 cannot be null")).sql(", ").nonTupleVariable(Objects.requireNonNull(tuple.get_2(), "tuple.get_2 cannot be null")).sql(", ").nonTupleVariable(Objects.requireNonNull(tuple.get_3(), "tuple.get_3 cannot be null")).sql(", ").nonTupleVariable(Objects.requireNonNull(tuple.get_4(), "tuple.get_4 cannot be null")).sql(", ").nonTupleVariable(Objects.requireNonNull(tuple.get_5(), "tuple.get_5 cannot be null")).sql(", ").nonTupleVariable(Objects.requireNonNull(tuple.get_6(), "tuple.get_6 cannot be null")).sql(", ").nonTupleVariable(Objects.requireNonNull(tuple.get_7(), "tuple.get_7 cannot be null")).leaveTuple();
            } else if (value instanceof Tuple8) {
                Tuple8 tuple = (Tuple8)value;
                this.enterTuple().nonTupleVariable(Objects.requireNonNull(tuple.get_1(), "tuple.get_1 cannot be null")).sql(", ").nonTupleVariable(Objects.requireNonNull(tuple.get_2(), "tuple.get_2 cannot be null")).sql(", ").nonTupleVariable(Objects.requireNonNull(tuple.get_3(), "tuple.get_3 cannot be null")).sql(", ").nonTupleVariable(Objects.requireNonNull(tuple.get_4(), "tuple.get_4 cannot be null")).sql(", ").nonTupleVariable(Objects.requireNonNull(tuple.get_5(), "tuple.get_5 cannot be null")).sql(", ").nonTupleVariable(Objects.requireNonNull(tuple.get_6(), "tuple.get_6 cannot be null")).sql(", ").nonTupleVariable(Objects.requireNonNull(tuple.get_7(), "tuple.get_7 cannot be null")).sql(", ").nonTupleVariable(Objects.requireNonNull(tuple.get_8(), "tuple.get_8 cannot be null")).leaveTuple();
            } else if (value instanceof Tuple9) {
                Tuple9 tuple = (Tuple9)value;
                this.enterTuple().nonTupleVariable(Objects.requireNonNull(tuple.get_1(), "tuple.get_1 cannot be null")).sql(", ").nonTupleVariable(Objects.requireNonNull(tuple.get_2(), "tuple.get_2 cannot be null")).sql(", ").nonTupleVariable(Objects.requireNonNull(tuple.get_3(), "tuple.get_3 cannot be null")).sql(", ").nonTupleVariable(Objects.requireNonNull(tuple.get_4(), "tuple.get_4 cannot be null")).sql(", ").nonTupleVariable(Objects.requireNonNull(tuple.get_5(), "tuple.get_5 cannot be null")).sql(", ").nonTupleVariable(Objects.requireNonNull(tuple.get_6(), "tuple.get_6 cannot be null")).sql(", ").nonTupleVariable(Objects.requireNonNull(tuple.get_7(), "tuple.get_7 cannot be null")).sql(", ").nonTupleVariable(Objects.requireNonNull(tuple.get_8(), "tuple.get_8 cannot be null")).sql(", ").nonTupleVariable(Objects.requireNonNull(tuple.get_9(), "tuple.get_9 cannot be null")).leaveTuple();
            }
        } else {
            this.nonTupleVariable(value);
        }
        return this;
    }

    /*
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    private SqlBuilder nonTupleVariable(Object value) {
        if (value instanceof ImmutableSpi) {
            ImmutableSpi spi = (ImmutableSpi)value;
            ImmutableType type = spi.__type();
            if (type.isEntity()) {
                this.nonTupleVariable(spi.__get(type.getIdProp().getId()));
                return this;
            } else {
                if (!type.isEmbeddable()) throw new IllegalArgumentException("Immutable variable must be entity or embeddable");
                this.embeddedVariable(spi, null);
            }
            return this;
        } else {
            Object finalValue;
            if (value instanceof DbNull) {
                throw new ExecutionException("Cannot add variable whose type is " + DbNull.class.getName());
            }
            ScalarProvider scalarProvider = this.ctx.getSqlClient().getScalarProvider(value.getClass());
            if (scalarProvider != null) {
                try {
                    finalValue = scalarProvider.toSql(value);
                }
                catch (Exception ex) {
                    throw new ExecutionException("Cannot convert the jvm type \"" + value + "\" to the sql type \"" + scalarProvider.getSqlType() + "\"", ex);
                }
            } else {
                finalValue = value;
            }
            this.builder.append('?');
            this.variables.add(finalValue);
        }
        return this;
    }

    private void embeddedVariable(ImmutableSpi spi, EmbeddedPath parentPath) {
        this.enterTuple();
        boolean addComma = false;
        for (ImmutableProp prop : spi.__type().getProps().values()) {
            if (addComma) {
                this.builder.append(", ");
            } else {
                addComma = true;
            }
            EmbeddedPath path = new EmbeddedPath(parentPath, prop);
            if (!spi.__isLoaded(prop.getId())) {
                throw new IllegalArgumentException("Embedded object must loaded, the property path \"" + path + "\" is unloaded");
            }
            Object value = spi.__get(prop.getId());
            if (value == null) {
                this.nullVariable(prop);
                continue;
            }
            if (value instanceof ImmutableSpi) {
                this.embeddedVariable((ImmutableSpi)value, path);
                continue;
            }
            this.nonTupleVariable(value);
        }
        this.leaveTuple();
    }

    public SqlBuilder nullVariable(ImmutableProp prop) {
        this.validate();
        ImmutableType targetType = prop.getTargetType();
        if (targetType == null) {
            return this.nullVariable(prop.getElementClass());
        }
        return this.nullVariable(targetType.getIdProp().getElementClass());
    }

    public SqlBuilder nullVariable(Class<?> type) {
        this.validate();
        ImmutableType immutableType = ImmutableType.tryGet(type);
        if (immutableType != null) {
            this.nullImmutableVariable(immutableType);
        } else {
            this.nullSingeVariable(type);
        }
        return this;
    }

    private void nullImmutableVariable(ImmutableType type) {
        if (type.isEntity()) {
            ImmutableProp idProp = type.getIdProp();
            if (idProp.isEmbedded(EmbeddedLevel.SCALAR)) {
                this.nullEmbeddedVariable(idProp.getTargetType());
            } else {
                this.nullSingeVariable(idProp.getElementClass());
            }
        } else if (type.isEmbeddable()) {
            this.nullEmbeddedVariable(type);
        } else {
            throw new IllegalArgumentException("Immutable variable must be entity or embeddable");
        }
    }

    private void nullEmbeddedVariable(ImmutableType type) {
        this.enterTuple();
        for (ImmutableProp prop : type.getProps().values()) {
            ImmutableType targetType = prop.getTargetType();
            if (targetType != null) {
                this.nullEmbeddedVariable(targetType);
                continue;
            }
            this.nullSingeVariable(prop.getElementClass());
        }
        this.leaveTuple();
    }

    private void nullSingeVariable(Class<?> type) {
        ScalarProvider scalarProvider = this.ctx.getSqlClient().getScalarProvider(type);
        DbNull finalValue = scalarProvider != null ? new DbNull(scalarProvider.getSqlType()) : new DbNull(type);
        this.builder.append('?');
        this.variables.add(finalValue);
    }

    public SqlBuilder enterTuple() {
        if (this.tupleDepth++ == 0) {
            this.builder.append('(');
        }
        return this;
    }

    public SqlBuilder leaveTuple() {
        if (--this.tupleDepth == 0) {
            this.builder.append(')');
        }
        return this;
    }

    public SqlBuilder createChildBuilder() {
        return new SqlBuilder(this);
    }

    public Tuple2<String, List<Object>> build() {
        return this.build(null);
    }

    public Tuple2<String, List<Object>> build(Function<Tuple2<String, List<Object>>, Tuple2<String, List<Object>>> transformer) {
        SqlBuilder p;
        this.validate();
        Tuple2<String, List<Object>> result = new Tuple2<String, List<Object>>(this.builder.toString(), this.variables);
        if (transformer != null) {
            result = transformer.apply(result);
        }
        if ((p = this.parent) != null) {
            p.builder.append(result.get_1());
            p.variables.addAll((Collection<Object>)result.get_2());
            while (p != null) {
                --p.childBuilderCount;
                p = p.parent;
            }
        }
        this.terminated = true;
        return result;
    }

    private void validate() {
        if (this.childBuilderCount != 0) {
            throw new IllegalStateException("Internal bug: Cannot change sqlbuilder because there are some child builders");
        }
        if (this.terminated) {
            throw new IllegalStateException("Internal bug: Current build has been terminated");
        }
    }

    private static class EmbeddedPath {
        final EmbeddedPath parent;
        final ImmutableProp prop;

        EmbeddedPath(EmbeddedPath parent, ImmutableProp prop) {
            this.parent = parent;
            this.prop = prop;
        }

        public String toString() {
            if (this.parent == null) {
                return this.prop.getName();
            }
            return this.parent.toString() + '.' + this.prop.getName();
        }
    }
}

