/*
 * Decompiled with CFR 0.152.
 */
package org.babyfish.jimmer.sql.runtime;

import java.io.BufferedReader;
import java.io.IOException;
import java.io.InputStreamReader;
import java.net.URL;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collection;
import java.util.Collections;
import java.util.Enumeration;
import java.util.LinkedHashMap;
import java.util.LinkedHashSet;
import java.util.List;
import java.util.Map;
import java.util.Set;
import java.util.function.Predicate;
import org.babyfish.jimmer.meta.ImmutableProp;
import org.babyfish.jimmer.meta.ImmutableType;
import org.jetbrains.annotations.Nullable;

public class EntityManager {
    private final Map<ImmutableType, ImmutableTypeInfo> map;

    public EntityManager(Class<?> ... classes) {
        this(Arrays.asList(classes));
    }

    public EntityManager(Collection<Class<?>> classes) {
        if (!(classes instanceof Set)) {
            classes = new LinkedHashSet(classes);
        }
        LinkedHashMap<ImmutableType, ImmutableTypeInfo> map = new LinkedHashMap<ImmutableType, ImmutableTypeInfo>();
        for (Class<?> clazz : classes) {
            if (clazz == null) continue;
            ImmutableType immutableType = ImmutableType.get(clazz);
            if (!immutableType.isEntity()) {
                throw new IllegalArgumentException("\"" + immutableType + "\" is not entity");
            }
            map.put(immutableType, new ImmutableTypeInfo());
            for (immutableType = immutableType.getSuperType(); immutableType != null && (immutableType.isEntity() || immutableType.isMappedSuperclass()); immutableType = immutableType.getSuperType()) {
                map.put(immutableType, new ImmutableTypeInfo());
            }
        }
        for (Map.Entry entry : map.entrySet()) {
            ImmutableType type = (ImmutableType)entry.getKey();
            ImmutableTypeInfo info = (ImmutableTypeInfo)entry.getValue();
            if (type.isMappedSuperclass()) {
                for (ImmutableType otherType : map.keySet()) {
                    if (!this.isImplementationType(type, otherType)) continue;
                    info.implementationTypes.add(otherType);
                }
                continue;
            }
            for (ImmutableType otherType : map.keySet()) {
                if (type == otherType || !type.isAssignableFrom(otherType)) continue;
                info.allDerivedTypes.add(otherType);
                if (type != otherType.getSuperType()) continue;
                info.directDerivedTypes.add(otherType);
            }
            for (ImmutableProp prop : type.getProps().values()) {
                ImmutableType targetType = prop.getTargetType();
                if (targetType == null || !targetType.isEntity() || prop.isRemote()) continue;
                ImmutableTypeInfo targetInfo = (ImmutableTypeInfo)map.get(targetType);
                if (targetInfo == null) {
                    throw new IllegalArgumentException("The target type \"" + targetType + "\" of the non-remote property \"" + prop + "\" is not manged by the current entity manager");
                }
                targetInfo.backProps.add(prop);
            }
        }
        for (ImmutableTypeInfo immutableTypeInfo : map.values()) {
            immutableTypeInfo.implementationTypes = Collections.unmodifiableList(immutableTypeInfo.implementationTypes);
            immutableTypeInfo.directDerivedTypes = Collections.unmodifiableList(immutableTypeInfo.directDerivedTypes);
            immutableTypeInfo.allDerivedTypes = Collections.unmodifiableList(immutableTypeInfo.allDerivedTypes);
            immutableTypeInfo.backProps = Collections.unmodifiableList(immutableTypeInfo.backProps);
        }
        this.map = Collections.unmodifiableMap(map);
    }

    public static EntityManager combine(EntityManager ... entityManagers) {
        if (entityManagers.length == 0) {
            throw new IllegalArgumentException("No entity managers");
        }
        if (entityManagers.length == 1) {
            return entityManagers[0];
        }
        LinkedHashSet classes = new LinkedHashSet();
        for (EntityManager entityManager : entityManagers) {
            for (ImmutableType type : entityManager.getAllTypes(null)) {
                if (!type.isEntity()) continue;
                classes.add(type.getJavaClass());
            }
        }
        return new EntityManager(classes);
    }

    public static EntityManager fromResources(@Nullable ClassLoader classLoader, @Nullable Predicate<Class<?>> predicate) {
        if (classLoader == null) {
            classLoader = EntityManager.class.getClassLoader();
        }
        LinkedHashSet classes = new LinkedHashSet();
        try {
            Enumeration<URL> urls = classLoader.getResources("META-INF/jimmer/entities");
            while (urls.hasMoreElements()) {
                URL url = urls.nextElement();
                try (BufferedReader reader = new BufferedReader(new InputStreamReader(url.openStream()));){
                    String className;
                    while ((className = reader.readLine()) != null) {
                        Class<?> clazz;
                        if ((className = className.trim()).isEmpty()) continue;
                        try {
                            clazz = Class.forName(className, true, classLoader);
                        }
                        catch (ClassNotFoundException ex) {
                            throw new IllegalStateException("Cannot parse class name \"" + className + "\" in \"META-INF/jimmer/entities\"", ex);
                        }
                        if (predicate != null && !predicate.test(clazz)) continue;
                        classes.add(clazz);
                    }
                }
            }
        }
        catch (IOException ex) {
            throw new IllegalStateException("Failed to load resources \"META-INF/jimmer/entities\"", ex);
        }
        return new EntityManager(classes);
    }

    public Set<ImmutableType> getAllTypes(String microServiceName) {
        if (microServiceName == null) {
            return this.map.keySet();
        }
        LinkedHashSet<ImmutableType> set = microServiceName.isEmpty() ? new LinkedHashSet<ImmutableType>((this.map.size() * 4 + 2) / 3) : new LinkedHashSet();
        for (ImmutableType type : this.map.keySet()) {
            if (!type.getMicroServiceName().equals(microServiceName)) continue;
            set.add(type);
        }
        return set;
    }

    public List<ImmutableType> getImplementationTypes(ImmutableType type) {
        return this.info((ImmutableType)type).implementationTypes;
    }

    public List<ImmutableType> getDirectDerivedTypes(ImmutableType type) {
        return this.info((ImmutableType)type).directDerivedTypes;
    }

    public List<ImmutableType> getAllDerivedTypes(ImmutableType type) {
        return this.info((ImmutableType)type).allDerivedTypes;
    }

    public List<ImmutableProp> getAllBackProps(ImmutableType type) {
        return this.info((ImmutableType)type).backProps;
    }

    private ImmutableTypeInfo info(ImmutableType type) {
        ImmutableTypeInfo info = this.map.get(type);
        if (info == null) {
            throw new IllegalArgumentException("\"" + type + "\" is not managed by current EntityManager");
        }
        return info;
    }

    private boolean isImplementationType(ImmutableType mappedSuperClass, ImmutableType type) {
        if (!mappedSuperClass.isMappedSuperclass()) {
            throw new AssertionError((Object)"Internal bug");
        }
        if (!type.isEntity()) {
            return false;
        }
        if (!mappedSuperClass.isAssignableFrom(type)) {
            return false;
        }
        return type.getSuperType().isMappedSuperclass();
    }

    private static class ImmutableTypeInfo {
        List<ImmutableType> implementationTypes = new ArrayList<ImmutableType>();
        List<ImmutableType> directDerivedTypes = new ArrayList<ImmutableType>();
        List<ImmutableType> allDerivedTypes = new ArrayList<ImmutableType>();
        List<ImmutableProp> backProps = new ArrayList<ImmutableProp>();

        private ImmutableTypeInfo() {
        }
    }
}

