/*
 * Decompiled with CFR 0.152.
 */
package org.babyfish.jimmer.sql.meta;

import java.util.Collections;
import java.util.Iterator;
import java.util.NoSuchElementException;
import java.util.Set;
import org.babyfish.jimmer.sql.meta.ColumnDefinition;
import org.babyfish.jimmer.sql.meta.DatabaseMetadata;
import org.jetbrains.annotations.NotNull;

public class SingleColumn
implements ColumnDefinition {
    private final String name;
    private final boolean isForeignKey;

    public SingleColumn(String name, boolean isForeignKey) {
        this.name = name;
        this.isForeignKey = isForeignKey;
    }

    public String getName() {
        return this.name;
    }

    @Override
    public boolean isEmbedded() {
        return false;
    }

    @Override
    public boolean isForeignKey() {
        return this.isForeignKey;
    }

    @Override
    public int size() {
        return 1;
    }

    @Override
    public String name(int index) {
        if (index != 0) {
            throw new ArrayIndexOutOfBoundsException();
        }
        return this.name;
    }

    @Override
    public int index(String name) {
        return this.name.equals(name) ? 0 : -1;
    }

    @Override
    public Set<String> toColumnNames() {
        return Collections.singleton(DatabaseMetadata.comparableIdentifier(this.name));
    }

    @Override
    @NotNull
    public Iterator<String> iterator() {
        return new Itr(this.name);
    }

    public String toString() {
        return "SingleColumn{name='" + this.name + '\'' + '}';
    }

    private static class Itr
    implements Iterator<String> {
        private final String name;
        private boolean terminated;

        private Itr(String name) {
            this.name = name;
        }

        @Override
        public boolean hasNext() {
            return !this.terminated;
        }

        @Override
        public String next() {
            if (this.terminated) {
                throw new NoSuchElementException();
            }
            this.terminated = true;
            return this.name;
        }
    }
}

