/*
 * Decompiled with CFR 0.152.
 */
package org.babyfish.jimmer.sql.meta;

import java.lang.annotation.Annotation;
import java.lang.invoke.LambdaMetafactory;
import java.lang.reflect.InvocationTargetException;
import java.lang.reflect.Type;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collections;
import java.util.HashMap;
import java.util.LinkedHashMap;
import java.util.LinkedList;
import java.util.List;
import java.util.Map;
import java.util.Set;
import java.util.function.Function;
import java.util.regex.Pattern;
import java.util.stream.Collectors;
import org.apache.commons.lang3.reflect.TypeUtils;
import org.babyfish.jimmer.impl.util.Classes;
import org.babyfish.jimmer.meta.EmbeddedLevel;
import org.babyfish.jimmer.meta.ImmutableProp;
import org.babyfish.jimmer.meta.ImmutableType;
import org.babyfish.jimmer.meta.ModelException;
import org.babyfish.jimmer.meta.TargetLevel;
import org.babyfish.jimmer.sql.Column;
import org.babyfish.jimmer.sql.GeneratedValue;
import org.babyfish.jimmer.sql.GenerationType;
import org.babyfish.jimmer.sql.JoinColumn;
import org.babyfish.jimmer.sql.JoinColumns;
import org.babyfish.jimmer.sql.JoinTable;
import org.babyfish.jimmer.sql.ManyToMany;
import org.babyfish.jimmer.sql.ManyToOne;
import org.babyfish.jimmer.sql.PropOverride;
import org.babyfish.jimmer.sql.PropOverrides;
import org.babyfish.jimmer.sql.Table;
import org.babyfish.jimmer.sql.association.meta.AssociationType;
import org.babyfish.jimmer.sql.meta.ColumnDefinition;
import org.babyfish.jimmer.sql.meta.DatabaseNamingStrategy;
import org.babyfish.jimmer.sql.meta.EmbeddedColumns;
import org.babyfish.jimmer.sql.meta.IdGenerator;
import org.babyfish.jimmer.sql.meta.IdentityIdGenerator;
import org.babyfish.jimmer.sql.meta.MiddleTable;
import org.babyfish.jimmer.sql.meta.MultipleJoinColumns;
import org.babyfish.jimmer.sql.meta.SequenceIdGenerator;
import org.babyfish.jimmer.sql.meta.SingleColumn;
import org.babyfish.jimmer.sql.meta.Storage;
import org.babyfish.jimmer.sql.meta.UserIdGenerator;
import org.babyfish.jimmer.sql.runtime.EntityManager;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public class DatabaseMetadata {
    private static final Pattern DOT_PATTERN = Pattern.compile("\\.");
    private final DatabaseNamingStrategy databaseNamingStrategy;
    private final EntityManager entityManager;
    private final String microServiceName;
    private final Map<ImmutableType, String> tableNameMap = new HashMap<ImmutableType, String>();
    private final Map<String, ImmutableType> typeMap = new HashMap<String, ImmutableType>();
    private final Map<ImmutableType, IdGenerator> idGeneratorMap = new HashMap<ImmutableType, IdGenerator>();
    private final Map<ImmutableProp, Storage> storageMap = new HashMap<ImmutableProp, Storage>();
    private final Map<ImmutableType, Map<String, List<ImmutableProp>>> propChainsMap = new HashMap<ImmutableType, Map<String, List<ImmutableProp>>>();

    public DatabaseMetadata(DatabaseNamingStrategy databaseNamingStrategy, EntityManager entityManager, String microServiceName) {
        this.databaseNamingStrategy = databaseNamingStrategy;
        this.entityManager = entityManager;
        this.microServiceName = microServiceName;
        for (ImmutableType type : entityManager.getAllTypes(microServiceName)) {
            if (!type.isEntity()) continue;
            this.initializeTableName(type);
            this.initializeIdGenerator(type);
            for (ImmutableProp prop : type.getProps().values()) {
                AssociationType associationType;
                MiddleTable middleTable;
                Storage storage;
                ImmutableProp mappedBy = prop.getMappedBy();
                if (mappedBy != null) {
                    storage = this.lazyGetStorage(mappedBy);
                    if (!(storage instanceof MiddleTable)) continue;
                    middleTable = (MiddleTable)storage;
                    associationType = AssociationType.of(prop);
                    this.tableNameMap.put(associationType, middleTable.getTableName());
                    this.storageMap.put(associationType.getSourceProp(), middleTable.getTargetColumnDefinition());
                    this.storageMap.put(associationType.getTargetProp(), middleTable.getColumnDefinition());
                    continue;
                }
                storage = this.lazyGetStorage(prop);
                if (!(storage instanceof MiddleTable)) continue;
                middleTable = (MiddleTable)storage;
                associationType = AssociationType.of(prop);
                this.tableNameMap.put(associationType, middleTable.getTableName());
                this.storageMap.put(associationType.getSourceProp(), middleTable.getColumnDefinition());
                this.storageMap.put(associationType.getTargetProp(), middleTable.getTargetColumnDefinition());
            }
            this.initializePropChainMap(type);
        }
        this.initializeTypeMap();
    }

    public EntityManager getEntityManager() {
        return this.entityManager;
    }

    public String getMicroServiceName() {
        return this.microServiceName;
    }

    public Set<ImmutableType> getEntityTypes() {
        return Collections.unmodifiableSet(this.tableNameMap.keySet());
    }

    public String getTableName(ImmutableType type) {
        return this.tableNameMap.get(type);
    }

    public IdGenerator getIdGenerator(ImmutableType type) {
        return this.idGeneratorMap.get(type);
    }

    public <S extends Storage> S getStorage(ImmutableProp prop) {
        return (S)this.storageMap.get(prop);
    }

    public List<ImmutableProp> getPropChainByColumnName(ImmutableType type, String columnName) {
        List<ImmutableProp> chain = null;
        Map<String, List<ImmutableProp>> chainMap = this.propChainsMap.get(type);
        if (chainMap != null) {
            String cmpName = DatabaseMetadata.comparableIdentifier(columnName);
            chain = chainMap.get(cmpName);
        }
        if (chain == null) {
            throw new IllegalArgumentException("There is no property chain whose column name is \"" + columnName + "\" in type \"" + type + "\"");
        }
        return chain;
    }

    public MiddleTable getMiddleTable(AssociationType type) {
        ImmutableProp prop = type.getBaseProp();
        ImmutableProp mappedBy = prop.getMappedBy();
        if (mappedBy != null) {
            return ((MiddleTable)this.storageMap.get(mappedBy)).getInverse();
        }
        return (MiddleTable)this.storageMap.get(prop);
    }

    public MiddleTable getMiddleTable(ImmutableProp prop) {
        return (MiddleTable)this.storageMap.get(prop);
    }

    @Nullable
    public ImmutableType getTypeByTableName(String tableName) {
        String standardTableName = DatabaseMetadata.comparableIdentifier(tableName);
        return this.typeMap.get(standardTableName);
    }

    @NotNull
    public ImmutableType getNonNullTypeByTableName(String tableName) {
        ImmutableType type = this.getTypeByTableName(tableName);
        if (type == null) {
            throw new IllegalArgumentException("The table \"" + tableName + "\" of micro service \"" + this.microServiceName + "\" is not managed by current EntityManager");
        }
        return type;
    }

    private Storage lazyGetStorage(ImmutableProp prop) {
        Storage storage = this.storageMap.get(prop);
        if (storage == null && !this.storageMap.containsKey(prop)) {
            storage = this.createStorage(prop);
            this.storageMap.put(prop, storage);
        }
        return storage;
    }

    private void initializeTableName(ImmutableType type) {
        String tableName;
        Class javaClass = type.getJavaClass();
        Table table = javaClass.getAnnotation(Table.class);
        String string = tableName = table != null ? table.name() : "";
        if (tableName.isEmpty()) {
            tableName = this.databaseNamingStrategy.tableName(type);
        }
        this.tableNameMap.put(type, tableName);
    }

    private void initializeIdGenerator(ImmutableType type) {
        Class returnType;
        ImmutableProp idProp = type.getIdProp();
        GeneratedValue generatedValue = (GeneratedValue)idProp.getAnnotation(GeneratedValue.class);
        if (generatedValue == null) {
            return;
        }
        Class generatorType = generatedValue.generatorType();
        GenerationType strategy = generatedValue.strategy();
        GenerationType strategyFromGeneratorType = GenerationType.AUTO;
        GenerationType strategyFromSequenceName = GenerationType.AUTO;
        if (UserIdGenerator.class.isAssignableFrom(generatorType)) {
            strategyFromGeneratorType = GenerationType.USER;
        } else if (IdentityIdGenerator.class.isAssignableFrom(generatorType)) {
            strategyFromGeneratorType = GenerationType.IDENTITY;
        } else if (SequenceIdGenerator.class.isAssignableFrom(generatorType)) {
            strategyFromGeneratorType = GenerationType.SEQUENCE;
        }
        if (!generatedValue.sequenceName().isEmpty()) {
            strategyFromSequenceName = GenerationType.SEQUENCE;
        }
        if (strategy == GenerationType.USER && strategyFromGeneratorType != GenerationType.USER) {
            throw new ModelException("Illegal property \"" + idProp + "\", its generator strategy is explicitly specified to \"USER\",but its generator type does not implement " + UserIdGenerator.class.getName());
        }
        if (strategy != GenerationType.AUTO && strategyFromGeneratorType != GenerationType.AUTO && strategy != strategyFromGeneratorType) {
            throw new ModelException("Illegal property \"" + idProp + "\", it's decorated by the annotation @" + GeneratedValue.class.getName() + " but that annotation has conflict attributes 'strategy' and 'generatorType'");
        }
        if (strategy != GenerationType.AUTO && strategyFromSequenceName != GenerationType.AUTO && strategy != strategyFromSequenceName) {
            throw new ModelException("Illegal property \"" + idProp + "\", it's decorated by the annotation @" + GeneratedValue.class.getName() + " but that annotation has conflict attributes 'strategy' and 'sequenceName'");
        }
        if (strategyFromGeneratorType != GenerationType.AUTO && strategyFromSequenceName != GenerationType.AUTO && strategyFromGeneratorType != strategyFromSequenceName) {
            throw new ModelException("Illegal property \"" + idProp + "\", it's decorated by the annotation @" + GeneratedValue.class.getName() + " but that annotation has conflict attributes 'generatorType' and 'sequenceName'");
        }
        if (strategy == GenerationType.AUTO) {
            strategy = strategyFromGeneratorType;
        }
        if (strategy == GenerationType.AUTO) {
            strategy = strategyFromSequenceName;
        }
        if (strategy == GenerationType.AUTO) {
            throw new ModelException("Illegal property \"" + idProp + "\", it's decorated by the annotation @" + GeneratedValue.class.getName() + " but that annotation does not have any attributes");
        }
        if (strategy == GenerationType.IDENTITY || strategy == GenerationType.SEQUENCE) {
            returnType = idProp.getElementClass();
            if (!returnType.isPrimitive() && !Number.class.isAssignableFrom(returnType)) {
                throw new ModelException("Illegal property \"" + idProp + "\", it's id generation strategy is \"" + strategy + "\", but that the type of id is not numeric");
            }
        } else if (strategy == GenerationType.USER) {
            Type typeArgument;
            returnType = idProp.getElementClass();
            Map typeArguments = TypeUtils.getTypeArguments((Type)generatorType, UserIdGenerator.class);
            Class parsedType = null;
            if (!typeArguments.isEmpty() && (typeArgument = (Type)typeArguments.values().iterator().next()) instanceof Class) {
                parsedType = (Class)typeArgument;
            }
            if (parsedType == null) {
                throw new ModelException("Illegal property \"" + idProp + "\", the generator type is \"" + generatorType.getName() + "\" does support type argument for \"" + UserIdGenerator.class + "\"");
            }
            if (!Classes.matches(parsedType, (Class)returnType)) {
                throw new ModelException("Illegal property \"" + idProp + "\", the generator type is \"" + generatorType.getName() + "\" generates id whose type is \"" + parsedType.getName() + "\" but the property returns \"" + returnType.getName() + "\"");
            }
        }
        Object idGenerator = null;
        if (strategy == GenerationType.USER) {
            String error = null;
            Throwable errorCause = null;
            if (generatorType == IdGenerator.None.class) {
                error = "'generatorType' must be specified when 'strategy' is 'GenerationType.USER'";
            }
            try {
                idGenerator = (IdGenerator)generatorType.getDeclaredConstructor(new Class[0]).newInstance(new Object[0]);
            }
            catch (IllegalAccessException | InstantiationException | NoSuchMethodException ex) {
                error = "cannot create the instance of \"" + generatorType.getName() + "\"";
                errorCause = ex;
            }
            catch (InvocationTargetException ex) {
                error = "cannot create the instance of \"" + generatorType.getName() + "\"";
                errorCause = ex.getTargetException();
            }
            if (error != null) {
                throw new ModelException("Illegal property \"" + idProp + "\" with the annotation @GeneratedValue, " + error, errorCause);
            }
        } else if (strategy == GenerationType.IDENTITY) {
            idGenerator = IdentityIdGenerator.INSTANCE;
        } else if (strategy == GenerationType.SEQUENCE) {
            String sequenceName = generatedValue.sequenceName();
            if (sequenceName.isEmpty()) {
                sequenceName = this.databaseNamingStrategy.sequenceName(idProp.getDeclaringType());
            }
            idGenerator = new SequenceIdGenerator(sequenceName);
        }
        if (idGenerator != null) {
            this.idGeneratorMap.put(type, (IdGenerator)idGenerator);
        }
    }

    private Storage createStorage(ImmutableProp prop) {
        if (!prop.hasStorage()) {
            return null;
        }
        Annotation annotation = prop.getAssociationAnnotation();
        if (annotation == null) {
            String columnName;
            if (prop.isEmbedded(EmbeddedLevel.SCALAR)) {
                return new EmbeddedTree(prop).toEmbeddedColumns(this.databaseNamingStrategy);
            }
            Column column = (Column)prop.getAnnotation(Column.class);
            String string = columnName = column != null ? column.name() : "";
            if (columnName.isEmpty()) {
                columnName = this.databaseNamingStrategy.columnName(prop);
            }
            return new SingleColumn(columnName, false);
        }
        Storage storage = this.middleTable(prop, this.databaseNamingStrategy, false);
        if (storage == null) {
            storage = this.joinColumn(prop, this.databaseNamingStrategy, false);
        }
        if (storage == null) {
            storage = prop.getAssociationAnnotation() instanceof ManyToMany ? this.middleTable(prop, this.databaseNamingStrategy, true) : this.joinColumn(prop, this.databaseNamingStrategy, true);
        }
        return storage;
    }

    private ColumnDefinition joinColumn(ImmutableProp prop, DatabaseNamingStrategy databaseNamingStrategy, boolean force) {
        ColumnDefinition definition;
        JoinColumn joinColumn = (JoinColumn)prop.getAnnotation(JoinColumn.class);
        JoinColumns joinColumns = (JoinColumns)prop.getAnnotation(JoinColumns.class);
        if (joinColumn == null && joinColumns == null && !force) {
            return null;
        }
        JoinColumnObj[] columns = joinColumns != null ? JoinColumnObj.array(joinColumns.value()) : JoinColumnObj.array(joinColumn);
        try {
            definition = this.joinDefinition(columns, prop.getTargetType(), prop.isEmbedded(EmbeddedLevel.REFERENCE));
        }
        catch (IllegalJoinColumnCount ex) {
            throw new ModelException("Illegal property \"" + prop + "\", it has " + ex.actual + " join column(s), but the referenced property \"" + prop.getTargetType().getIdProp() + "\" has " + ex.expect + " join column(s)");
        }
        catch (NoReference ex) {
            throw new ModelException("Illegal property \"" + prop + "\", the `referencedColumnName` of join columns must be set when multiple join columns are used");
        }
        catch (ReferenceNothing ex) {
            throw new ModelException("Illegal property \"" + prop + "\", the `referencedColumnName` \"" + ex.ref + "\" is illegal");
        }
        catch (SourceConflict ex) {
            throw new ModelException("Illegal property \"" + prop + "\", conflict column name \"" + ex.name + "\" in several join columns");
        }
        catch (TargetConflict ex) {
            throw new ModelException("Illegal property \"" + prop + "\", conflict referenced column name \"" + ex.ref + "\" in several join columns");
        }
        catch (ForeignKeyConflict ex) {
            throw new ModelException("Illegal property \"" + prop + "\", conflict columns \"" + ex.columnName1 + "\" and \"" + ex.columnName2 + "\", their attribute `foreignKey` is different");
        }
        if (definition != null) {
            return definition;
        }
        return new SingleColumn(databaseNamingStrategy.foreignKeyColumnName(prop), true);
    }

    private MiddleTable middleTable(ImmutableProp prop, DatabaseNamingStrategy databaseNamingStrategy, boolean force) {
        String tableName;
        ColumnDefinition targetDefinition;
        ColumnDefinition definition;
        JoinColumnObj[] referencedColumns;
        JoinColumnObj[] joinColumns;
        JoinTable joinTable = (JoinTable)prop.getAnnotation(JoinTable.class);
        if (joinTable == null && !force) {
            return null;
        }
        if (joinTable != null) {
            if (!joinTable.joinColumnName().isEmpty() && joinTable.joinColumns().length != 0) {
                throw new ModelException("Illegal property \"" + prop + "\", `joinColumnName` and `joinColumns` of `@" + JoinTable.class.getName() + "` cannot be specified at the same time");
            }
            if (!joinTable.inverseJoinColumnName().isEmpty() && joinTable.inverseColumns().length != 0) {
                throw new ModelException("Illegal property \"" + prop + "\", `inverseJoinColumnName` and `inverseColumns` of `@" + JoinTable.class.getName() + "` cannot be specified at the same time");
            }
            joinColumns = JoinColumnObj.array(joinTable.joinColumnName());
            if (joinColumns == null) {
                joinColumns = JoinColumnObj.array(joinTable.joinColumns());
            }
            if ((referencedColumns = JoinColumnObj.array(joinTable.inverseJoinColumnName())) == null) {
                referencedColumns = JoinColumnObj.array(joinTable.inverseColumns());
            }
        } else {
            joinColumns = null;
            referencedColumns = null;
        }
        boolean leftParsed = false;
        try {
            definition = this.joinDefinition(joinColumns, prop.getDeclaringType(), prop.getDeclaringType().getIdProp().isEmbedded(EmbeddedLevel.SCALAR));
            leftParsed = true;
            targetDefinition = this.joinDefinition(referencedColumns, prop.getTargetType(), prop.getTargetType().getIdProp().isEmbedded(EmbeddedLevel.SCALAR));
        }
        catch (IllegalJoinColumnCount ex) {
            throw new ModelException("Illegal property \"" + prop + "\", there are " + ex.actual + " `" + (leftParsed ? "inverseColumn(s)" : "joinColumn(s)") + "`, but the id property \"" + (leftParsed ? prop.getTargetType() : prop.getDeclaringType()).getIdProp() + "\" has " + ex.expect + " column(s)");
        }
        catch (NoReference ex) {
            throw new ModelException("Illegal property \"" + prop + "\", the `referencedColumns` of `" + (leftParsed ? "inverseColumns" : "joinColumns") + "` must be specified when multiple `" + (leftParsed ? "inverseColumns" : "joinColumns") + "` are used");
        }
        catch (ReferenceNothing ex) {
            throw new ModelException("Illegal property \"" + prop + "\", the `referencedColumnName` \"" + ex.ref + "\" of `" + (leftParsed ? "inverseColumns" : "joinColumns") + "` is illegal");
        }
        catch (SourceConflict ex) {
            throw new ModelException("Illegal property \"" + prop + "\", conflict column name \"" + ex.name + "\" in several " + (leftParsed ? "inverseColumns" : "joinColumns"));
        }
        catch (TargetConflict ex) {
            throw new ModelException("Illegal property \"" + prop + "\", conflict referenced column name \"" + ex.ref + "\" in several " + (leftParsed ? "inverseColumns" : "joinColumns"));
        }
        catch (ForeignKeyConflict ex) {
            throw new ModelException("Illegal property \"" + prop + "\", conflict columns \"" + ex.columnName1 + "\" and \"" + ex.columnName2 + "\" in " + (leftParsed ? "inverseColumns" : "joinColumns") + ", their attribute `foreignKey` is different");
        }
        String string = tableName = joinTable != null ? joinTable.name() : "";
        if (tableName.isEmpty()) {
            tableName = databaseNamingStrategy.middleTableName(prop);
        }
        if (definition == null) {
            definition = new SingleColumn(databaseNamingStrategy.middleTableBackRefColumnName(prop), true);
        }
        if (targetDefinition == null) {
            targetDefinition = new SingleColumn(databaseNamingStrategy.middleTableTargetRefColumnName(prop), true);
        }
        return new MiddleTable(tableName, definition, targetDefinition);
    }

    private ColumnDefinition joinDefinition(JoinColumnObj[] joinColumns, ImmutableType targetType, boolean isEmbedded) throws IllegalJoinColumnCount, NoReference, ReferenceNothing, TargetConflict, SourceConflict, ForeignKeyConflict {
        if (joinColumns == null || joinColumns.length == 0) {
            ColumnDefinition definition = (ColumnDefinition)this.lazyGetStorage(targetType.getIdProp());
            if (definition.size() == 1) {
                return null;
            }
            throw new IllegalJoinColumnCount(definition.size(), 0);
        }
        JoinColumnObj firstJoinColumn = null;
        for (JoinColumnObj joinColumn : joinColumns) {
            if (firstJoinColumn == null) {
                firstJoinColumn = joinColumn;
                continue;
            }
            if (firstJoinColumn.foreignKey == joinColumn.foreignKey) continue;
            throw new ForeignKeyConflict(firstJoinColumn.name, joinColumn.name);
        }
        ColumnDefinition targetIdDefinition = (ColumnDefinition)this.lazyGetStorage(targetType.getIdProp());
        if (joinColumns.length != targetIdDefinition.size()) {
            throw new IllegalJoinColumnCount(targetIdDefinition.size(), joinColumns.length);
        }
        if (joinColumns.length == 1) {
            if (joinColumns[0].name.isEmpty()) {
                return null;
            }
            String ref = joinColumns[0].referencedColumnName;
            if (!ref.isEmpty() && !ref.equals(targetIdDefinition.name(0))) {
                throw new ReferenceNothing(ref);
            }
            return new SingleColumn(joinColumns[0].name, joinColumns[0].foreignKey);
        }
        HashMap<String, String> columnMap = new HashMap<String, String>();
        for (JoinColumnObj joinColumn : joinColumns) {
            String ref = joinColumn.referencedColumnName;
            if (ref.isEmpty()) {
                throw new NoReference();
            }
            if (targetIdDefinition.index(ref) == -1) {
                throw new ReferenceNothing(ref);
            }
            if (columnMap.put(ref, joinColumn.name) == null) continue;
            throw new TargetConflict(ref);
        }
        LinkedHashMap<String, String> referencedColumnMap = new LinkedHashMap<String, String>();
        for (String targetColumnName : targetIdDefinition) {
            String name = (String)columnMap.get(targetColumnName);
            if (referencedColumnMap.put(name, targetColumnName) == null) continue;
            throw new SourceConflict(name);
        }
        return new MultipleJoinColumns(referencedColumnMap, isEmbedded, joinColumns[0].foreignKey);
    }

    private void initializePropChainMap(ImmutableType type) {
        LinkedHashMap<String, List<ImmutableProp>> map = new LinkedHashMap<String, List<ImmutableProp>>();
        PropChains propChains = new PropChains();
        for (ImmutableProp prop : type.getProps().values()) {
            ImmutableProp mappedBy;
            propChains.addInto(prop, map);
            if (prop.isMiddleTableDefinition()) {
                AssociationType associationType = AssociationType.of(prop);
                this.initializePropChainMap(associationType);
            }
            if ((mappedBy = prop.getMappedBy()) == null || !mappedBy.isMiddleTableDefinition()) continue;
            AssociationType associationType = AssociationType.of(prop);
            this.initializePropChainMap(associationType);
        }
        this.propChainsMap.put(type, map);
    }

    private void initializeTypeMap() {
        for (Map.Entry<ImmutableType, String> e : this.tableNameMap.entrySet()) {
            ImmutableType type = e.getKey();
            if (type instanceof AssociationType && ((AssociationType)type).getBaseProp().getMappedBy() != null) continue;
            String tableName = DatabaseMetadata.comparableIdentifier(e.getValue());
            ImmutableType oldType = this.typeMap.put(tableName, type);
            if (oldType != null && !oldType.equals((Object)type)) {
                DatabaseMetadata.tableSharedBy(tableName, oldType, type);
            }
            for (ImmutableProp prop : type.getProps().values()) {
                if (!prop.isMiddleTableDefinition()) continue;
                AssociationType associationType = AssociationType.of(prop);
                String associationTableName = DatabaseMetadata.comparableIdentifier(((MiddleTable)this.lazyGetStorage(prop)).getTableName());
                oldType = this.typeMap.put(associationTableName, associationType);
                if (oldType == null || oldType.equals((Object)associationType)) continue;
                DatabaseMetadata.tableSharedBy(tableName, oldType, associationType);
            }
        }
    }

    private static void tableSharedBy(String tableName, ImmutableType type1, ImmutableType type2) {
        if (type1 instanceof AssociationType && type2 instanceof AssociationType) {
            AssociationType associationType1 = (AssociationType)type1;
            AssociationType associationType2 = (AssociationType)type2;
            if (associationType1.getSourceType() == associationType2.getTargetType() && associationType1.getTargetType() == associationType2.getSourceType()) {
                throw new IllegalArgumentException("Illegal entity manager, the table \"" + tableName + "\" is shared by both \"" + type1 + "\" and \"" + type2 + "\". These two associations seem to form a bidirectional association, if so, please make one of them real (using @" + JoinTable.class + ") and the other image (specify `mappedBy` of @" + ManyToOne.class + ")");
            }
        }
        throw new IllegalArgumentException("Illegal entity manager, the table \"" + tableName + "\" is shared by both \"" + type1 + "\" and \"" + type2 + "\"");
    }

    public static String comparableIdentifier(String identifier) {
        if (identifier == null) {
            return null;
        }
        boolean cut = false;
        if (identifier.startsWith("`") && identifier.endsWith("`") && identifier.length() > 2) {
            cut = true;
        } else if (identifier.startsWith("\"") && identifier.endsWith("\"") && identifier.length() > 2) {
            cut = true;
        } else if (identifier.startsWith("[") && identifier.endsWith("]")) {
            cut = true;
        }
        return (cut ? identifier.substring(1, identifier.length() - 1) : identifier).toUpperCase();
    }

    private static class EmbeddedTree {
        private final EmbeddedTree parent;
        private final ImmutableProp prop;
        private final String path;
        private final int depth;
        private final Map<String, EmbeddedTree> childMap;
        private OverrideContext usedCtx;

        public EmbeddedTree(ImmutableProp prop) {
            this(null, prop);
            this.applyOverride();
        }

        private EmbeddedTree(EmbeddedTree parent, ImmutableProp prop) {
            EmbeddedTree p = parent;
            while (p != null) {
                if (p.prop.getDeclaringType() == prop.getTargetType()) {
                    LinkedList<String> names = new LinkedList<String>();
                    EmbeddedTree p2 = parent;
                    while (p2 != null) {
                        names.add(0, p2.prop.getName());
                        if (p2 == p) break;
                        p2 = p2.parent;
                    }
                    throw new ModelException("Reference cycle is found in \"" + p.prop.getDeclaringType() + '.' + names.stream().collect(Collectors.joining(".")) + '.' + prop.getName() + "\"");
                }
                p = p.parent;
            }
            this.parent = parent;
            this.prop = prop;
            if (parent == null) {
                this.path = "";
                this.depth = 0;
            } else {
                String parentPath = parent.path;
                this.path = parentPath.isEmpty() ? prop.getName() : parentPath + '.' + prop.getName();
                this.depth = parent.depth + 1;
            }
            if (prop.isEmbedded(EmbeddedLevel.SCALAR)) {
                LinkedHashMap<String, EmbeddedTree> map = new LinkedHashMap<String, EmbeddedTree>();
                for (ImmutableProp childProp : prop.getTargetType().getProps().values()) {
                    map.put(childProp.getName(), new EmbeddedTree(this, childProp));
                }
                this.childMap = map;
            } else {
                this.childMap = Collections.emptyMap();
            }
        }

        private void applyOverride() {
            PropOverride propOverride;
            PropOverrides propOverrides = (PropOverrides)this.prop.getAnnotation(PropOverrides.class);
            if (propOverrides != null) {
                for (PropOverride propOverride2 : propOverrides.value()) {
                    this.applyOverride(propOverride2.prop(), new OverrideContext(this.prop, this.depth, propOverride2));
                }
            }
            if ((propOverride = (PropOverride)this.prop.getAnnotation(PropOverride.class)) != null) {
                this.applyOverride(propOverride.prop(), new OverrideContext(this.prop, this.depth, propOverride));
            }
            for (EmbeddedTree childTree : this.childMap.values()) {
                childTree.applyOverride();
            }
        }

        private void applyOverride(String path, OverrideContext ctx) {
            boolean tooLong;
            String rest;
            String propName;
            int index = path.indexOf(46);
            if (index == -1) {
                propName = path;
                rest = null;
            } else {
                propName = path.substring(0, index);
                rest = path.substring(index + 1);
            }
            EmbeddedTree childTree = this.childMap.get(propName);
            if (childTree == null) {
                throw new ModelException("Illegal property \"" + ctx.prop + "\", the path \"" + ctx.annotation.prop() + "\" of `@PropOverride` is illegal, there is no property \"" + propName + "\" declared in \"" + this.prop.getDeclaringType() + "\"");
            }
            boolean tooShort = rest == null && childTree.prop.isEmbedded(EmbeddedLevel.SCALAR);
            boolean bl = tooLong = rest != null && !childTree.prop.isEmbedded(EmbeddedLevel.SCALAR);
            if (tooLong || tooShort) {
                throw new ModelException("Illegal property \"" + ctx.prop + "\", the property path \"" + ctx.annotation.prop() + "\" of `@PropOverride` is too " + (tooLong ? "long" : "short"));
            }
            if (rest == null) {
                childTree.useOverride(ctx);
            } else {
                childTree.applyOverride(rest, ctx);
            }
        }

        private void useOverride(OverrideContext ctx) {
            if (this.usedCtx == null || ctx.depth < this.usedCtx.depth) {
                this.usedCtx = ctx;
            } else if (this.usedCtx.depth == ctx.depth) {
                throw new ModelException("Illegal property \"" + ctx.prop + "\", the property path \"" + ctx.annotation.prop() + "\" and \"" + this.usedCtx.annotation.prop() + "\" of `@PropOverride`s are conflict");
            }
        }

        public EmbeddedColumns toEmbeddedColumns(DatabaseNamingStrategy databaseNamingStrategy) {
            CollectContext ctx = new CollectContext(this.prop, databaseNamingStrategy);
            this.collect(ctx);
            return ctx.toEmbeddedColumns();
        }

        private void collect(CollectContext ctx) {
            ctx.accept(this);
            for (EmbeddedTree childTree : this.childMap.values()) {
                childTree.collect(ctx);
            }
        }

        private static class OverrideContext {
            final ImmutableProp prop;
            final int depth;
            final PropOverride annotation;

            private OverrideContext(ImmutableProp prop, int depth, PropOverride annotation) {
                this.prop = prop;
                this.depth = depth;
                this.annotation = annotation;
            }
        }

        private static class CollectContext {
            private final ImmutableProp prop;
            private final DatabaseNamingStrategy databaseNamingStrategy;
            private final Map<String, String> identifierPathMap = new LinkedHashMap<String, String>();
            private final Map<String, EmbeddedColumns.PathData> pathMap = new LinkedHashMap<String, EmbeddedColumns.PathData>();

            private CollectContext(ImmutableProp prop, DatabaseNamingStrategy strategy) {
                this.prop = prop;
                this.databaseNamingStrategy = strategy;
            }

            public void accept(EmbeddedTree tree) {
                if (tree.childMap.isEmpty()) {
                    String columnName = tree.usedCtx != null ? ((EmbeddedTree)tree).usedCtx.annotation.columnName() : this.databaseNamingStrategy.columnName(tree.prop);
                    String comparableIdentifier = DatabaseMetadata.comparableIdentifier(columnName);
                    String conflictPath = this.identifierPathMap.put(comparableIdentifier, tree.path);
                    if (conflictPath != null) {
                        throw new ModelException("The property \"" + this.prop + "\" is illegal, its an embedded property but both the path `" + conflictPath + "` and `" + tree.path + "` has been mapped to an same column \"" + columnName + "\"");
                    }
                    EmbeddedTree t = tree;
                    while (t != null) {
                        boolean isTerminal = tree == t;
                        this.pathMap.computeIfAbsent((String)((EmbeddedTree)t).path, (Function<String, EmbeddedColumns.PathData>)LambdaMetafactory.metafactory(null, null, null, (Ljava/lang/Object;)Ljava/lang/Object;, lambda$accept$0(boolean java.lang.String ), (Ljava/lang/String;)Lorg/babyfish/jimmer/sql/meta/EmbeddedColumns$PathData;)((boolean)isTerminal)).columnNames.add(columnName);
                        t = t.parent;
                    }
                }
            }

            public EmbeddedColumns toEmbeddedColumns() {
                return new EmbeddedColumns(this.pathMap);
            }

            private static /* synthetic */ EmbeddedColumns.PathData lambda$accept$0(boolean isTerminal, String it) {
                return new EmbeddedColumns.PathData(isTerminal);
            }
        }
    }

    private static class JoinColumnObj {
        final String name;
        final String referencedColumnName;
        final boolean foreignKey;

        JoinColumnObj(String name, String referencedColumnName, boolean foreignKey) {
            this.name = name;
            this.referencedColumnName = referencedColumnName;
            this.foreignKey = foreignKey;
        }

        JoinColumnObj(JoinColumn joinColumn) {
            this.name = joinColumn.name();
            this.referencedColumnName = joinColumn.referencedColumnName();
            this.foreignKey = joinColumn.foreignKey();
        }

        static JoinColumnObj[] array(String name) {
            if (name.isEmpty()) {
                return null;
            }
            return new JoinColumnObj[]{new JoinColumnObj(name, "", true)};
        }

        static JoinColumnObj[] array(JoinColumn joinColumn) {
            if (joinColumn == null) {
                return null;
            }
            return new JoinColumnObj[]{new JoinColumnObj(joinColumn.name(), joinColumn.referencedColumnName(), joinColumn.foreignKey())};
        }

        static JoinColumnObj[] array(JoinColumn[] arr) {
            if (arr.length == 0) {
                return null;
            }
            return (JoinColumnObj[])Arrays.stream(arr).map(JoinColumnObj::new).toArray(JoinColumnObj[]::new);
        }
    }

    private static class IllegalJoinColumnCount
    extends Exception {
        final int expect;
        final int actual;

        private IllegalJoinColumnCount(int expect, int actual) {
            this.expect = expect;
            this.actual = actual;
        }
    }

    private static class NoReference
    extends Exception {
        private NoReference() {
        }
    }

    private static class ReferenceNothing
    extends Exception {
        final String ref;

        ReferenceNothing(String ref) {
            this.ref = ref;
        }
    }

    private static class SourceConflict
    extends Exception {
        final String name;

        SourceConflict(String name) {
            this.name = name;
        }
    }

    private static class TargetConflict
    extends Exception {
        final String ref;

        TargetConflict(String ref) {
            this.ref = ref;
        }
    }

    private static class ForeignKeyConflict
    extends Exception {
        final String columnName1;
        final String columnName2;

        private ForeignKeyConflict(String columnName1, String columnName2) {
            this.columnName1 = columnName1;
            this.columnName2 = columnName2;
        }
    }

    private class PropChains {
        private PropChains() {
        }

        public void addInto(ImmutableProp prop, Map<String, List<ImmutableProp>> map) {
            Storage storage = DatabaseMetadata.this.lazyGetStorage(prop);
            if (prop.isEmbedded(EmbeddedLevel.BOTH)) {
                List baseChain;
                MultipleJoinColumns multipleJoinColumns = null;
                if (prop.isReference(TargetLevel.PERSISTENT)) {
                    if (storage instanceof MultipleJoinColumns) {
                        multipleJoinColumns = (MultipleJoinColumns)storage;
                    }
                    baseChain = new ArrayList();
                    baseChain.add(prop);
                    prop = prop.getTargetType().getIdProp();
                } else {
                    baseChain = Collections.emptyList();
                }
                for (Map.Entry<String, EmbeddedColumns.Partial> e : ((EmbeddedColumns)DatabaseMetadata.this.lazyGetStorage(prop)).getPartialMap().entrySet()) {
                    EmbeddedColumns.Partial partial = e.getValue();
                    if (partial.isEmbedded()) continue;
                    ImmutableProp partProp = prop;
                    String cmpName = DatabaseMetadata.comparableIdentifier(partial.name(0));
                    String path = e.getKey();
                    ArrayList chain = new ArrayList(baseChain);
                    chain.add(partProp);
                    ImmutableType targetType = partProp.getTargetType();
                    if (path != null) {
                        for (String part : DOT_PATTERN.split(path)) {
                            partProp = targetType.getProp(part);
                            targetType = partProp.getTargetType();
                            chain.add(partProp);
                        }
                    }
                    if (multipleJoinColumns != null) {
                        int index;
                        for (index = multipleJoinColumns.size() - 1; index >= 0; --index) {
                            String referencedName = multipleJoinColumns.referencedName(index);
                            if (!DatabaseMetadata.comparableIdentifier(referencedName).equals(cmpName)) continue;
                            map.put(multipleJoinColumns.name(index), Collections.unmodifiableList(chain));
                            break;
                        }
                        if (index == -1) {
                            throw new AssertionError((Object)"Internal bug: Cannot find column name by reference columnName");
                        }
                        continue;
                    }
                    map.put(cmpName, Collections.unmodifiableList(chain));
                }
            } else if (storage instanceof SingleColumn) {
                String cmpName = DatabaseMetadata.comparableIdentifier(((SingleColumn)storage).getName());
                map.put(cmpName, Collections.singletonList(prop));
            }
        }
    }
}

