/*
 * Decompiled with CFR 0.152.
 */
package org.babyfish.jimmer.sql.event.binlog;

import com.fasterxml.jackson.core.JsonParser;
import com.fasterxml.jackson.databind.DeserializationContext;
import com.fasterxml.jackson.databind.JsonNode;
import com.fasterxml.jackson.databind.deser.std.StdDeserializer;
import java.io.IOException;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import org.babyfish.jimmer.meta.EmbeddedLevel;
import org.babyfish.jimmer.meta.ImmutableProp;
import org.babyfish.jimmer.meta.ImmutableType;
import org.babyfish.jimmer.runtime.DraftSpi;
import org.babyfish.jimmer.runtime.Internal;
import org.babyfish.jimmer.sql.JSqlClient;
import org.babyfish.jimmer.sql.ast.impl.util.EmbeddableObjects;
import org.babyfish.jimmer.sql.event.binlog.ValueParser;
import org.babyfish.jimmer.sql.meta.DatabaseMetadata;

class BinLogDeserializer
extends StdDeserializer<Object> {
    private final JSqlClient sqlClient;
    private final ImmutableType immutableType;

    public BinLogDeserializer(JSqlClient sqlClient, ImmutableType immutableType) {
        super(immutableType.getJavaClass());
        this.sqlClient = sqlClient;
        this.immutableType = immutableType;
    }

    public Object deserialize(JsonParser jp, DeserializationContext ctx) throws IOException {
        DatabaseMetadata metadata = this.sqlClient.getDatabaseMetadata();
        JsonNode node = (JsonNode)jp.getCodec().readTree(jp);
        return Internal.produce((ImmutableType)this.immutableType, null, draft -> {
            Iterator itr = node.fields();
            while (itr.hasNext()) {
                Map.Entry fieldEntry = (Map.Entry)itr.next();
                String columnName = (String)fieldEntry.getKey();
                JsonNode childNode = (JsonNode)fieldEntry.getValue();
                List<ImmutableProp> chain = metadata.getPropChainByColumnName(this.immutableType, columnName);
                ValueParser.addEntityProp((DraftSpi)draft, chain, childNode, this.sqlClient);
            }
            for (ImmutableProp prop : this.immutableType.getProps().values()) {
                if (!prop.isMutable() || !prop.isEmbedded(EmbeddedLevel.BOTH) || EmbeddableObjects.isCompleted(((DraftSpi)draft).__get(prop.getId()))) continue;
                if (!prop.isNullable()) {
                    throw new IllegalArgumentException("Illegal binlog data, the property \"" + prop + "\" is not nullable");
                }
                ((DraftSpi)draft).__set(prop.getId(), null);
            }
        });
    }
}

