/*
 * Decompiled with CFR 0.152.
 */
package org.babyfish.jimmer.sql.event.binlog;

import com.fasterxml.jackson.databind.JsonNode;
import org.babyfish.jimmer.meta.ImmutableType;
import org.babyfish.jimmer.sql.association.meta.AssociationType;
import org.babyfish.jimmer.sql.ast.tuple.Tuple2;
import org.babyfish.jimmer.sql.event.Triggers;
import org.babyfish.jimmer.sql.event.binlog.BinLogParser;
import org.babyfish.jimmer.sql.meta.DatabaseMetadata;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class BinLog {
    private static final Logger LOGGER = LoggerFactory.getLogger(BinLog.class);
    private final DatabaseMetadata databaseMetadata;
    private final BinLogParser binLogParser;
    private final Triggers triggers;

    public BinLog(DatabaseMetadata databaseMetadata, BinLogParser binLogParser, Triggers triggers) {
        this.databaseMetadata = databaseMetadata;
        this.binLogParser = binLogParser;
        this.triggers = triggers;
    }

    public void accept(String tableName, JsonNode oldData, JsonNode newData) {
        this.accept(tableName, oldData, newData, null);
    }

    public void accept(String tableName, JsonNode oldData, JsonNode newData, String reason) {
        boolean isNewNull;
        boolean isOldNull = oldData == null || oldData.isNull();
        boolean bl = isNewNull = newData == null || newData.isNull();
        if (isOldNull && isNewNull) {
            return;
        }
        ImmutableType type = this.databaseMetadata.getTypeByTableName(tableName);
        if (type == null) {
            LOGGER.warn("Illegal table name \"{}\" of micro service \"{}\", it is not managed by current entity manager", (Object)tableName, (Object)this.databaseMetadata.getMicroServiceName());
            return;
        }
        if (type instanceof AssociationType) {
            if (isOldNull) {
                AssociationType associationType = (AssociationType)type;
                Tuple2 idPair = this.binLogParser.parseIdPair(associationType, newData);
                this.triggers.fireMiddleTableInsert(associationType.getBaseProp(), idPair.get_1(), idPair.get_2(), null, reason);
            } else {
                AssociationType associationType = (AssociationType)type;
                Tuple2 idPair = this.binLogParser.parseIdPair(associationType, oldData);
                this.triggers.fireMiddleTableDelete(associationType.getBaseProp(), idPair.get_1(), idPair.get_2(), null, reason);
            }
        } else {
            this.triggers.fireEntityTableChange(this.binLogParser.parseEntity(type, oldData), this.binLogParser.parseEntity(type, newData), null, reason);
        }
    }
}

