/*
 * Decompiled with CFR 0.152.
 */
package org.babyfish.jimmer.sql.ast.impl.table;

import java.util.function.Function;
import org.babyfish.jimmer.Input;
import org.babyfish.jimmer.meta.ImmutableProp;
import org.babyfish.jimmer.meta.ImmutableType;
import org.babyfish.jimmer.meta.TargetLevel;
import org.babyfish.jimmer.meta.TypedProp;
import org.babyfish.jimmer.sql.ImmutableProps;
import org.babyfish.jimmer.sql.JoinType;
import org.babyfish.jimmer.sql.association.meta.AssociationProp;
import org.babyfish.jimmer.sql.association.meta.AssociationType;
import org.babyfish.jimmer.sql.ast.Expression;
import org.babyfish.jimmer.sql.ast.NumericExpression;
import org.babyfish.jimmer.sql.ast.Predicate;
import org.babyfish.jimmer.sql.ast.Selection;
import org.babyfish.jimmer.sql.ast.impl.AbstractMutableStatementImpl;
import org.babyfish.jimmer.sql.ast.impl.Ast;
import org.babyfish.jimmer.sql.ast.impl.AstVisitor;
import org.babyfish.jimmer.sql.ast.impl.ExampleImpl;
import org.babyfish.jimmer.sql.ast.impl.PropExpressionImpl;
import org.babyfish.jimmer.sql.ast.impl.table.FetcherSelectionImpl;
import org.babyfish.jimmer.sql.ast.impl.table.TableImplementor;
import org.babyfish.jimmer.sql.ast.impl.table.TableProxies;
import org.babyfish.jimmer.sql.ast.impl.table.TableRowCountDestructive;
import org.babyfish.jimmer.sql.ast.impl.table.WeakJoinHandle;
import org.babyfish.jimmer.sql.ast.impl.util.AbstractDataManager;
import org.babyfish.jimmer.sql.ast.query.Example;
import org.babyfish.jimmer.sql.ast.table.Table;
import org.babyfish.jimmer.sql.ast.table.TableEx;
import org.babyfish.jimmer.sql.ast.table.WeakJoin;
import org.babyfish.jimmer.sql.fetcher.Fetcher;
import org.babyfish.jimmer.sql.meta.ColumnDefinition;
import org.babyfish.jimmer.sql.meta.DatabaseMetadata;
import org.babyfish.jimmer.sql.meta.FormulaTemplate;
import org.babyfish.jimmer.sql.meta.JoinTemplate;
import org.babyfish.jimmer.sql.meta.MiddleTable;
import org.babyfish.jimmer.sql.meta.SqlTemplate;
import org.babyfish.jimmer.sql.runtime.ExecutionException;
import org.babyfish.jimmer.sql.runtime.SqlBuilder;
import org.babyfish.jimmer.sql.runtime.TableUsedState;
import org.jetbrains.annotations.NotNull;

class TableImpl<E>
extends AbstractDataManager<String, TableImplementor<?>>
implements TableImplementor<E> {
    private final AbstractMutableStatementImpl statement;
    private final ImmutableType immutableType;
    private final TableImpl<?> parent;
    private final boolean isInverse;
    private final ImmutableProp joinProp;
    private final WeakJoinHandle weakJoinHandle;
    private JoinType joinType;
    private final String alias;
    private String middleTableAlias;

    public TableImpl(AbstractMutableStatementImpl statement, ImmutableType immutableType, TableImpl<?> parent, boolean isInverse, ImmutableProp joinProp, WeakJoinHandle weakJoinHandle, JoinType joinType) {
        if (parent != null && immutableType instanceof AssociationType) {
            throw new AssertionError((Object)"Internal bug: Bad constructor arguments for TableImpl");
        }
        if (parent == null != (joinProp == null && weakJoinHandle == null)) {
            throw new AssertionError((Object)"Internal bug: Bad constructor arguments for TableImpl");
        }
        if (parent != null && joinProp == null == (weakJoinHandle == null)) {
            throw new AssertionError((Object)"Internal bug: Bad constructor arguments for TableImpl");
        }
        if (weakJoinHandle != null && isInverse) {
            throw new AssertionError((Object)"Internal bug: Bad constructor arguments for TableImpl");
        }
        this.statement = statement;
        this.immutableType = immutableType;
        this.parent = parent;
        this.isInverse = isInverse;
        this.joinProp = joinProp;
        this.weakJoinHandle = weakJoinHandle;
        this.joinType = joinType;
        if (joinProp != null) {
            if (joinProp.isMiddleTableDefinition()) {
                this.middleTableAlias = statement.getContext().allocateTableAlias();
            } else if (joinProp.getSqlTemplate() == null && !joinProp.hasStorage()) {
                throw new AssertionError((Object)"Internal bug: Join property has not storage");
            }
        }
        this.alias = statement.getContext().allocateTableAlias();
    }

    @Override
    public ImmutableType getImmutableType() {
        return this.immutableType;
    }

    public AbstractMutableStatementImpl getStatement() {
        return this.statement;
    }

    @Override
    public TableImplementor<?> getParent() {
        return this.parent;
    }

    @Override
    public boolean isInverse() {
        return this.isInverse;
    }

    @Override
    public boolean isRemote() {
        return this.joinProp != null && this.joinProp.isRemote();
    }

    @Override
    public ImmutableProp getJoinProp() {
        return this.joinProp;
    }

    @Override
    public JoinType getJoinType() {
        return this.joinType;
    }

    @Override
    public String getAlias() {
        return this.alias;
    }

    @Override
    public Predicate eq(Table<E> other) {
        if (other.getImmutableType() != this.immutableType) {
            throw new IllegalArgumentException("Cannot compare tables of different types");
        }
        String idPropName = this.immutableType.getIdProp().getName();
        return this.get(idPropName).eq(other.get(idPropName));
    }

    @Override
    public Predicate eq(Example<E> example) {
        return ((ExampleImpl)example).toPredicate(this);
    }

    @Override
    public Predicate eq(E example) {
        return this.eq((E)Example.of(example));
    }

    @Override
    public Predicate eq(Input<E> input) {
        return this.eq((E)Example.of(input));
    }

    @Override
    public Predicate isNull() {
        String idPropName = this.immutableType.getIdProp().getName();
        return this.get(idPropName).isNull();
    }

    @Override
    public Predicate isNotNull() {
        String idPropName = this.immutableType.getIdProp().getName();
        return this.get(idPropName).isNotNull();
    }

    @Override
    public NumericExpression<Long> count() {
        return this.count(false);
    }

    @Override
    public NumericExpression<Long> count(boolean distinct) {
        if (this.immutableType instanceof AssociationType) {
            return this.get(((AssociationType)this.immutableType).getSourceProp().getName()).count();
        }
        return this.get(this.immutableType.getIdProp().getName()).count(distinct);
    }

    @Override
    public <XE extends Expression<?>> XE get(String prop) {
        if (this.isRemote() && !this.immutableType.getIdProp().getName().equals(prop)) {
            throw new IllegalArgumentException("The current table is remote so that only the id property \"" + this.immutableType.getIdProp() + "\" can be accessed");
        }
        ImmutableProp immutableProp = this.immutableType.getProp(prop);
        return (XE)PropExpressionImpl.of(this, immutableProp);
    }

    @Override
    public <XT extends Table<?>> XT join(String prop) {
        return (XT)TableProxies.wrap(this.joinImplementor(prop));
    }

    @Override
    public <XT extends Table<?>> XT join(String prop, JoinType joinType) {
        return (XT)TableProxies.wrap(this.joinImplementor(prop, joinType));
    }

    @Override
    public <XT extends Table<?>> XT join(String prop, JoinType joinType, ImmutableType treatedAs) {
        return (XT)TableProxies.wrap(this.joinImplementor(prop, joinType, treatedAs));
    }

    @Override
    public <XT extends Table<?>> XT inverseJoin(ImmutableProp prop) {
        return (XT)TableProxies.wrap(this.inverseJoinImplementor(prop));
    }

    @Override
    public <XT extends Table<?>> XT inverseJoin(ImmutableProp prop, JoinType joinType) {
        return (XT)TableProxies.wrap(this.inverseJoinImplementor(prop, joinType));
    }

    @Override
    public <XT extends Table<?>> XT inverseJoin(TypedProp.Association<?, ?> prop) {
        return (XT)TableProxies.wrap(this.inverseJoinImplementor(prop));
    }

    @Override
    public <XT extends Table<?>> XT inverseJoin(TypedProp.Association<?, ?> prop, JoinType joinType) {
        return (XT)TableProxies.wrap(this.inverseJoinImplementor(prop, joinType));
    }

    @Override
    public <XT extends Table<?>> XT inverseJoin(Class<XT> targetTableType, Function<XT, ? extends Table<?>> backPropBlock) {
        return this.inverseJoin(ImmutableProps.join(targetTableType, backPropBlock));
    }

    @Override
    public <XT extends Table<?>> XT inverseJoin(Class<XT> targetTableType, Function<XT, ? extends Table<?>> backPropBlock, JoinType joinType) {
        return this.inverseJoin(ImmutableProps.join(targetTableType, backPropBlock), joinType);
    }

    @Override
    public <X> TableImplementor<X> joinImplementor(String prop) {
        return this.joinImplementor(prop, JoinType.INNER);
    }

    @Override
    public <X> TableImplementor<X> joinImplementor(String prop, JoinType joinType) {
        return this.joinImplementor(prop, joinType, null);
    }

    @Override
    public <X> TableImplementor<X> joinImplementor(String prop, JoinType joinType, ImmutableType treatedAs) {
        ImmutableProp immutableProp = this.immutableType.getProp(prop);
        ImmutableProp manyToManyViewProp = immutableProp.getManyToManyViewBaseProp();
        if (manyToManyViewProp != null) {
            return ((TableImpl)this.join0(false, manyToManyViewProp, joinType)).join0(false, immutableProp.getManyToManyViewBaseDeeperProp(), joinType);
        }
        if (!immutableProp.isAssociation(TargetLevel.ENTITY)) {
            if (this.isRemote()) {
                throw new IllegalStateException("The current table is remote so that join is not supported");
            }
            if (immutableProp.isTransient()) {
                throw new IllegalArgumentException("\"" + prop + "\" cannot be transient");
            }
            if (immutableProp.isRemote() && immutableProp.getMappedBy() != null) {
                throw new IllegalArgumentException("\"" + prop + "\" cannot be remote and reversed(with `mappedBy`)");
            }
            throw new IllegalArgumentException("\"" + prop + "\" is not association property of \"" + this.immutableType + "\"");
        }
        return this.join0(false, immutableProp, joinType);
    }

    @Override
    public <X> TableImplementor<X> inverseJoinImplementor(ImmutableProp prop) {
        return this.inverseJoinImplementor(prop, JoinType.INNER);
    }

    @Override
    public <X> TableImplementor<X> inverseJoinImplementor(TypedProp.Association<?, ?> prop) {
        return this.inverseJoinImplementor(prop.unwrap(), JoinType.INNER);
    }

    @Override
    public <X> TableImplementor<X> inverseJoinImplementor(TypedProp.Association<?, ?> prop, JoinType joinType) {
        return this.inverseJoinImplementor(prop.unwrap(), joinType);
    }

    @Override
    public <X> TableImplementor<X> inverseJoinImplementor(ImmutableProp backProp, JoinType joinType) {
        if (backProp.getTargetType() != this.immutableType) {
            throw new IllegalArgumentException("'" + backProp + "' is not back association property");
        }
        if (!backProp.getDeclaringType().isEntity()) {
            throw new IllegalArgumentException("'" + backProp + "' is not declared in entity");
        }
        return this.join0(true, backProp, joinType);
    }

    private TableImplementor<?> join0(boolean isInverse, ImmutableProp prop, JoinType joinType) {
        if (prop.isTransient()) {
            throw new ExecutionException("Cannot join to '" + prop.getName() + "' because it's transient association");
        }
        if (isInverse && prop instanceof AssociationProp) {
            throw new ExecutionException("Cannot join to '" + prop + "' by inverse mode because it's property of association entity");
        }
        String joinName = !isInverse ? prop.getName() : (prop.getOpposite() != null ? prop.getOpposite().getName() : "inverse(" + prop + ")");
        if (prop.getMappedBy() != null) {
            return this.join1(joinName, !isInverse, prop.getMappedBy(), joinType);
        }
        return this.join1(joinName, isInverse, prop, joinType);
    }

    private TableImplementor<?> join1(String joinName, boolean isInverse, ImmutableProp prop, JoinType joinType) {
        TableImpl existing = (TableImpl)this.getValue(joinName);
        if (existing != null) {
            if (existing.joinType != joinType) {
                existing.joinType = JoinType.INNER;
            }
            return existing;
        }
        TableImpl<E> newTable = new TableImpl<E>(this.statement, isInverse ? prop.getDeclaringType() : prop.getTargetType(), this, isInverse, prop, null, joinType);
        this.putValue(joinName, newTable);
        return newTable;
    }

    @Override
    public <X> TableImplementor<X> weakJoinImplementor(Class<? extends WeakJoin<?, ?>> weakJoinType, JoinType joinType) {
        return this.weakJoinImplementor(WeakJoinHandle.of(weakJoinType), joinType);
    }

    @Override
    public <X> TableImplementor<X> weakJoinImplementor(WeakJoinHandle handle, JoinType joinType) {
        String joinName = "weak(" + handle.getWeakJoinType().getName() + ")";
        TableImpl existing = (TableImpl)this.getValue(joinName);
        if (existing != null) {
            if (existing.joinType != joinType) {
                existing.joinType = JoinType.INNER;
            }
            return existing;
        }
        TableImpl<E> newTable = new TableImpl<E>(this.statement, handle.getTargetType(), this, this.isInverse, null, handle, joinType);
        this.putValue(joinName, newTable);
        return newTable;
    }

    @Override
    public Selection<E> fetch(Fetcher<E> fetcher) {
        if (fetcher == null) {
            return this;
        }
        if (this.immutableType != fetcher.getImmutableType()) {
            throw new IllegalArgumentException("Illegal fetcher type, the entity type of current table is \"" + this + "\" but the fetcher type is \"" + fetcher.getImmutableType() + "\"");
        }
        return new FetcherSelectionImpl<E>(this, fetcher);
    }

    @Override
    public TableEx<E> asTableEx() {
        return TableProxies.wrap(this);
    }

    @Override
    public void accept(@NotNull AstVisitor visitor) {
        visitor.visitTableReference(this, null);
    }

    @Override
    public void renderJoinAsFrom(SqlBuilder builder, TableImplementor.RenderMode mode) {
        if (this.parent == null) {
            throw new IllegalStateException("Internal bug: renderJoinAsFrom can only be called base on joined tables");
        }
        if (mode == TableImplementor.RenderMode.NORMAL) {
            throw new IllegalStateException("Internal bug: renderJoinAsFrom does not accept render mode ALL");
        }
        TableUsedState usedState = builder.getAstContext().getTableUsedState(this);
        if (usedState != TableUsedState.NONE) {
            this.renderSelf(builder, mode);
            if (mode == TableImplementor.RenderMode.DEEPER_JOIN_ONLY) {
                for (TableImplementor childTable : this) {
                    childTable.renderTo(builder);
                }
            }
        }
    }

    @Override
    public void renderTo(@NotNull SqlBuilder builder) {
        TableUsedState usedState = builder.getAstContext().getTableUsedState(this);
        if (this.parent == null || usedState != TableUsedState.NONE) {
            this.renderSelf(builder, TableImplementor.RenderMode.NORMAL);
            for (TableImplementor childTable : this) {
                childTable.renderTo(builder);
            }
        }
    }

    private void renderSelf(SqlBuilder sqlBuilder, TableImplementor.RenderMode mode) {
        if (this.isInverse) {
            this.renderInverseJoin(sqlBuilder, mode);
        } else if (this.joinProp != null || this.weakJoinHandle != null) {
            this.renderJoin(sqlBuilder, mode);
        } else {
            sqlBuilder.sql(" from ").sql(sqlBuilder.getAstContext().getSqlClient().getDatabaseMetadata().getTableName(this.immutableType)).sql(" ").sql(this.alias);
        }
    }

    private void renderJoin(SqlBuilder builder, TableImplementor.RenderMode mode) {
        DatabaseMetadata metadata = builder.getAstContext().getSqlClient().getDatabaseMetadata();
        if (this.weakJoinHandle != null) {
            if (builder.getAstContext().getTableUsedState(this) != TableUsedState.NONE) {
                Predicate predicate = this.weakJoinHandle.createPredicate(this.parent, this);
                builder.sql(" ").sql(this.joinType.name().toLowerCase()).sql(" join ").sql(metadata.getTableName(this.immutableType)).sql(" ").sql(this.alias).sql(" on ");
                if (predicate == null) {
                    builder.sql("1 = 1");
                } else {
                    ((Ast)((Object)predicate)).renderTo(builder);
                }
            }
            return;
        }
        if (this.joinProp.getSqlTemplate() instanceof JoinTemplate) {
            this.renderJoinBySql(builder, (JoinTemplate)this.joinProp.getSqlTemplate(), mode);
            return;
        }
        if (this.joinProp instanceof AssociationProp) {
            if (builder.getAstContext().getTableUsedState(this) == TableUsedState.USED) {
                this.renderJoinImpl(builder, this.joinType, this.parent.alias, (ColumnDefinition)metadata.getStorage(this.joinProp), metadata.getTableName(this.immutableType), this.alias, (ColumnDefinition)metadata.getStorage(this.immutableType.getIdProp()), mode);
            }
            return;
        }
        TableImpl<?> parent = this.parent;
        JoinType joinType = this.joinType;
        MiddleTable middleTable = null;
        if (this.joinProp.isMiddleTableDefinition()) {
            middleTable = metadata.getMiddleTable(this.joinProp);
        }
        if (middleTable != null) {
            this.renderJoinImpl(builder, joinType, parent.alias, (ColumnDefinition)metadata.getStorage(parent.immutableType.getIdProp()), middleTable.getTableName(), this.middleTableAlias, middleTable.getColumnDefinition(), mode);
            if (builder.getAstContext().getTableUsedState(this) == TableUsedState.USED && (mode == TableImplementor.RenderMode.NORMAL || mode == TableImplementor.RenderMode.DEEPER_JOIN_ONLY)) {
                this.renderJoinImpl(builder, joinType, this.middleTableAlias, middleTable.getTargetColumnDefinition(), metadata.getTableName(this.immutableType), this.alias, (ColumnDefinition)metadata.getStorage(this.immutableType.getIdProp()), TableImplementor.RenderMode.NORMAL);
            }
        } else if (builder.getAstContext().getTableUsedState(this) == TableUsedState.USED) {
            this.renderJoinImpl(builder, joinType, parent.alias, (ColumnDefinition)metadata.getStorage(this.joinProp), metadata.getTableName(this.immutableType), this.alias, (ColumnDefinition)metadata.getStorage(this.immutableType.getIdProp()), mode);
        }
    }

    private void renderInverseJoin(SqlBuilder sqlBuilder, TableImplementor.RenderMode mode) {
        DatabaseMetadata metadata = sqlBuilder.getAstContext().getSqlClient().getDatabaseMetadata();
        TableImpl<?> parent = this.parent;
        JoinType joinType = this.joinType;
        if (this.joinProp.getSqlTemplate() instanceof JoinTemplate) {
            this.renderJoinBySql(sqlBuilder, (JoinTemplate)this.joinProp.getSqlTemplate(), mode);
            return;
        }
        MiddleTable middleTable = null;
        if (this.joinProp.isMiddleTableDefinition()) {
            middleTable = metadata.getMiddleTable(this.joinProp);
        }
        if (middleTable != null) {
            this.renderJoinImpl(sqlBuilder, joinType, parent.alias, (ColumnDefinition)metadata.getStorage(parent.immutableType.getIdProp()), middleTable.getTableName(), this.middleTableAlias, middleTable.getTargetColumnDefinition(), mode);
            if (sqlBuilder.getAstContext().getTableUsedState(this) == TableUsedState.USED && (mode == TableImplementor.RenderMode.NORMAL || mode == TableImplementor.RenderMode.DEEPER_JOIN_ONLY)) {
                this.renderJoinImpl(sqlBuilder, joinType, this.middleTableAlias, middleTable.getColumnDefinition(), metadata.getTableName(this.immutableType), this.alias, (ColumnDefinition)metadata.getStorage(this.immutableType.getIdProp()), TableImplementor.RenderMode.NORMAL);
            }
        } else {
            this.renderJoinImpl(sqlBuilder, joinType, parent.alias, (ColumnDefinition)metadata.getStorage(parent.immutableType.getIdProp()), metadata.getTableName(this.immutableType), this.alias, (ColumnDefinition)metadata.getStorage(this.joinProp), mode);
        }
    }

    private void renderJoinBySql(SqlBuilder builder, JoinTemplate joinTemplate, TableImplementor.RenderMode mode) {
        if (builder.getAstContext().getTableUsedState(this) != TableUsedState.NONE) {
            DatabaseMetadata metadata = builder.getAstContext().getSqlClient().getDatabaseMetadata();
            switch (mode) {
                case NORMAL: {
                    builder.sql(" ").sql(this.joinType.name().toLowerCase()).sql(" join ").sql(metadata.getTableName(this.immutableType)).sql(" ").sql(this.alias).sql(" on ");
                    break;
                }
                case FROM_ONLY: {
                    builder.sql(metadata.getTableName(this.immutableType)).sql(" ").sql(this.alias);
                }
            }
            if (mode == TableImplementor.RenderMode.NORMAL || mode == TableImplementor.RenderMode.WHERE_ONLY) {
                if (this.isInverse) {
                    builder.sql(joinTemplate.toSql(this.alias, this.parent.alias));
                } else {
                    builder.sql(joinTemplate.toSql(this.parent.alias, this.alias));
                }
            }
        }
    }

    private void renderJoinImpl(SqlBuilder sqlBuilder, JoinType joinType, String previousAlias, ColumnDefinition previousDefinition, String newTableName, String newAlias, ColumnDefinition newDefinition, TableImplementor.RenderMode mode) {
        if (mode != TableImplementor.RenderMode.NORMAL && joinType != JoinType.INNER) {
            throw new AssertionError((Object)"Internal bug: outer join cannot be accepted by abnormal render mode");
        }
        switch (mode) {
            case NORMAL: {
                sqlBuilder.sql(" ").sql(joinType.name().toLowerCase()).sql(" join ").sql(newTableName).sql(" ").sql(newAlias).sql(" on ");
                break;
            }
            case FROM_ONLY: {
                sqlBuilder.sql(newTableName).sql(" ").sql(newAlias);
            }
        }
        if (mode == TableImplementor.RenderMode.NORMAL || mode == TableImplementor.RenderMode.WHERE_ONLY) {
            int size = previousDefinition.size();
            boolean addSeparator = false;
            for (int i = 0; i < size; ++i) {
                if (addSeparator) {
                    sqlBuilder.sql(" and ");
                } else {
                    addSeparator = true;
                }
                sqlBuilder.sql(previousAlias).sql(".").sql(previousDefinition.name(i)).sql(" = ").sql(newAlias).sql(".").sql(newDefinition.name(i));
            }
        }
    }

    @Override
    public void renderSelection(ImmutableProp prop, SqlBuilder builder, ColumnDefinition optionalDefinition, boolean withPrefix, Function<Integer, String> asBlock) {
        SqlTemplate template;
        DatabaseMetadata metadata = builder.getAstContext().getSqlClient().getDatabaseMetadata();
        if (prop.isId() && this.joinProp != null && !(this.joinProp.getSqlTemplate() instanceof JoinTemplate)) {
            MiddleTable middleTable = this.joinProp.isMiddleTableDefinition() ? metadata.getMiddleTable(this.joinProp) : null;
            boolean isInverse = this.isInverse;
            if (middleTable != null) {
                if (optionalDefinition == null) {
                    if (isInverse) {
                        builder.sql(withPrefix ? this.middleTableAlias : null, middleTable.getColumnDefinition(), asBlock);
                    } else {
                        builder.sql(withPrefix ? this.middleTableAlias : null, middleTable.getTargetColumnDefinition(), asBlock);
                    }
                } else {
                    ColumnDefinition fullDefinition = (ColumnDefinition)metadata.getStorage(prop);
                    ColumnDefinition parentDefinition = isInverse ? middleTable.getColumnDefinition() : middleTable.getTargetColumnDefinition();
                    int size = optionalDefinition.size();
                    for (int i = 0; i < size; ++i) {
                        if (i != 0) {
                            builder.sql(", ");
                        }
                        int index = fullDefinition.index(optionalDefinition.name(i));
                        String parentColumnName = parentDefinition.name(index);
                        if (withPrefix) {
                            builder.sql(this.middleTableAlias).sql(".");
                        }
                        builder.sql(parentColumnName);
                        if (asBlock == null) continue;
                        builder.sql(" ").sql(asBlock.apply(i));
                    }
                }
                return;
            }
            if (!isInverse) {
                if (optionalDefinition == null) {
                    if (metadata.getStorage(this.joinProp) == null) {
                        System.out.println(this.joinProp);
                    }
                    builder.sql(withPrefix ? this.parent.alias : null, (ColumnDefinition)metadata.getStorage(this.joinProp), asBlock);
                } else {
                    ColumnDefinition fullDefinition = (ColumnDefinition)metadata.getStorage(prop);
                    ColumnDefinition parentDefinition = (ColumnDefinition)metadata.getStorage(this.joinProp);
                    int size = optionalDefinition.size();
                    for (int i = 0; i < size; ++i) {
                        if (i != 0) {
                            builder.sql(", ");
                        }
                        int index = fullDefinition.index(optionalDefinition.name(i));
                        String parentColumnName = parentDefinition.name(index);
                        if (withPrefix) {
                            builder.sql(this.parent.alias).sql(".");
                        }
                        builder.sql(parentColumnName);
                        if (asBlock == null) continue;
                        builder.sql(" ").sql(asBlock.apply(i));
                    }
                }
                return;
            }
        }
        if ((template = prop.getSqlTemplate()) instanceof FormulaTemplate) {
            builder.sql(((FormulaTemplate)template).toSql(this.alias));
            if (asBlock != null) {
                builder.sql(" ").sql(asBlock.apply(0));
            }
        } else {
            ColumnDefinition definition = optionalDefinition != null ? optionalDefinition : (ColumnDefinition)metadata.getStorage(prop);
            builder.sql(withPrefix ? this.alias : null, definition, asBlock);
        }
    }

    public String toString() {
        String text;
        if (this.joinProp == null) {
            text = this.immutableType.getJavaClass().getSimpleName();
        } else if (this.isInverse) {
            ImmutableProp opposite = this.joinProp.getOpposite();
            text = opposite != null ? this.parent.toString() + '.' + opposite.getName() : this.parent + "[\u2190 " + this.joinProp + ']';
        } else {
            return this.parent.toString() + '.' + this.joinProp.getName();
        }
        if (this.joinType == JoinType.INNER) {
            return text;
        }
        return text + '(' + this.joinType.name().toLowerCase() + ')';
    }

    @Override
    public TableRowCountDestructive getDestructive() {
        ImmutableProp prop;
        if (this.joinProp == null) {
            return TableRowCountDestructive.NONE;
        }
        if (this.isInverse) {
            prop = this.joinProp.getOpposite();
            if (prop == null) {
                return TableRowCountDestructive.BREAK_REPEATABILITY;
            }
        } else {
            prop = this.joinProp;
        }
        if (prop.isReferenceList(TargetLevel.PERSISTENT)) {
            return TableRowCountDestructive.BREAK_REPEATABILITY;
        }
        if (prop.isNullable() && this.joinType != JoinType.LEFT) {
            return TableRowCountDestructive.BREAK_ROW_COUNT;
        }
        return TableRowCountDestructive.NONE;
    }
}

