/*
 * Decompiled with CFR 0.152.
 */
package org.babyfish.jimmer.sql.ast.impl.mutation;

import java.sql.Connection;
import java.sql.PreparedStatement;
import java.sql.ResultSet;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.List;
import java.util.Objects;
import org.babyfish.jimmer.meta.ImmutableProp;
import org.babyfish.jimmer.meta.ImmutableType;
import org.babyfish.jimmer.runtime.DraftSpi;
import org.babyfish.jimmer.runtime.ImmutableSpi;
import org.babyfish.jimmer.runtime.Internal;
import org.babyfish.jimmer.sql.JSqlClient;
import org.babyfish.jimmer.sql.ast.Predicate;
import org.babyfish.jimmer.sql.ast.PropExpression;
import org.babyfish.jimmer.sql.ast.impl.AstContext;
import org.babyfish.jimmer.sql.ast.impl.mutation.MutationCache;
import org.babyfish.jimmer.sql.ast.impl.mutation.MutationTrigger;
import org.babyfish.jimmer.sql.ast.impl.query.PaginationContextImpl;
import org.babyfish.jimmer.sql.ast.impl.query.Queries;
import org.babyfish.jimmer.sql.ast.impl.util.EmbeddableObjects;
import org.babyfish.jimmer.sql.ast.tuple.Tuple2;
import org.babyfish.jimmer.sql.meta.ColumnDefinition;
import org.babyfish.jimmer.sql.meta.DatabaseMetadata;
import org.babyfish.jimmer.sql.meta.SingleColumn;
import org.babyfish.jimmer.sql.runtime.ExecutionException;
import org.babyfish.jimmer.sql.runtime.ExecutionPurpose;
import org.babyfish.jimmer.sql.runtime.ExecutorContext;
import org.babyfish.jimmer.sql.runtime.Reader;
import org.babyfish.jimmer.sql.runtime.SqlBuilder;

class ChildTableOperator {
    private final JSqlClient sqlClient;
    private final Connection con;
    private final ImmutableProp parentProp;
    private final ColumnDefinition fkDefinition;
    private final ColumnDefinition pkDefinition;
    private final Reader<Object> pkReader;
    private final boolean pessimisticLockRequired;
    private final MutationCache cache;
    private final MutationTrigger trigger;

    public ChildTableOperator(JSqlClient sqlClient, Connection con, ImmutableProp parentProp, boolean pessimisticLockRequired, MutationCache cache, MutationTrigger trigger) {
        this.sqlClient = sqlClient;
        this.con = con;
        this.parentProp = parentProp;
        this.fkDefinition = (ColumnDefinition)sqlClient.getDatabaseMetadata().getStorage(parentProp);
        this.pkDefinition = (ColumnDefinition)sqlClient.getDatabaseMetadata().getStorage(parentProp.getDeclaringType().getIdProp());
        this.pkReader = sqlClient.getReader(parentProp.getDeclaringType().getIdProp());
        this.pessimisticLockRequired = pessimisticLockRequired;
        if (trigger != null) {
            this.cache = cache;
            this.trigger = trigger;
        } else {
            this.cache = null;
            this.trigger = null;
        }
    }

    public boolean exists(Object parentId, Collection<Object> retainedChildIds) {
        SqlBuilder builder = new SqlBuilder(new AstContext(this.sqlClient));
        SqlBuilder subBuilder = builder.createChildBuilder();
        DatabaseMetadata metadata = this.sqlClient.getDatabaseMetadata();
        subBuilder.sql("select 1 from ").sql(metadata.getTableName(this.parentProp.getDeclaringType())).sql(" where ").sql((ColumnDefinition)metadata.getStorage(this.parentProp)).sql(" = ").variable(parentId);
        if (!retainedChildIds.isEmpty()) {
            subBuilder.sql(" and ").sql((ColumnDefinition)metadata.getStorage(this.parentProp.getDeclaringType().getIdProp())).sql(" not in(");
            String separator = "";
            for (Object retainedChildId : retainedChildIds) {
                subBuilder.sql(separator);
                subBuilder.variable(retainedChildId);
                separator = ", ";
            }
            subBuilder.sql(")");
        }
        Tuple2<String, List<Object>> sqlResult = subBuilder.build(result -> {
            PaginationContextImpl ctx = new PaginationContextImpl(1, 0, (String)result.get_1(), (List)result.get_2(), false);
            this.sqlClient.getDialect().paginate(ctx);
            return ctx.build();
        });
        return this.sqlClient.getExecutor().execute(this.con, sqlResult.get_1(), sqlResult.get_2(), ExecutionPurpose.MUTATE, ExecutorContext.create(this.sqlClient), null, stmt -> stmt.executeQuery().next());
    }

    public int setParent(Object parentId, Collection<Object> childIds) {
        if (childIds.isEmpty()) {
            return 0;
        }
        if (this.trigger != null) {
            return this.setParentAndPrepareEvents(parentId, childIds);
        }
        return this.setParentImpl(parentId, childIds);
    }

    private int setParentAndPrepareEvents(Object parentId, Collection<Object> childIds) {
        assert (this.cache != null && this.trigger != null);
        ImmutableType childType = this.parentProp.getDeclaringType();
        List<ImmutableSpi> childRows = this.cache.loadByIds(childType, childIds, this.con);
        ImmutableSpi currentIdOnly = ChildTableOperator.makeIdOnly(this.parentProp.getTargetType(), parentId);
        int parentPropId = this.parentProp.getId();
        ArrayList<Object> newChildIds = null;
        for (ImmutableSpi childRow : childRows) {
            Object childId = ChildTableOperator.idOf(childRow);
            Object oldParentId = ChildTableOperator.idOf((ImmutableSpi)childRow.__get(parentPropId));
            Object changedRow = Internal.produce((ImmutableType)childType, (Object)childRow, draft -> ((DraftSpi)draft).__set(parentPropId, currentIdOnly));
            if (Objects.equals(parentId, oldParentId)) {
                if (newChildIds == null) {
                    newChildIds = new ArrayList<Object>(childIds);
                }
                newChildIds.remove(childId);
                continue;
            }
            this.trigger.modifyEntityTable(childRow, changedRow);
        }
        if (newChildIds != null) {
            childIds = newChildIds;
        }
        if (childIds.isEmpty()) {
            return 0;
        }
        return this.setParentImpl(parentId, childIds);
    }

    private int setParentImpl(Object parentId, Collection<Object> childIds) {
        SqlBuilder builder = new SqlBuilder(new AstContext(this.sqlClient));
        DatabaseMetadata metadata = this.sqlClient.getDatabaseMetadata();
        builder.sql("update ").sql(metadata.getTableName(this.parentProp.getDeclaringType())).sql(" set ");
        ColumnDefinition definition = (ColumnDefinition)metadata.getStorage(this.parentProp);
        if (definition instanceof SingleColumn) {
            builder.sql(((SingleColumn)definition).getName()).sql(" = ");
            if (parentId == null) {
                builder.sql("null");
            } else {
                builder.variable(parentId);
            }
        } else {
            boolean addComma = false;
            Object[] values = EmbeddableObjects.expand(this.parentProp.getTargetType().getIdProp().getTargetType(), parentId);
            int n = definition.size();
            for (int i = 0; i < n; ++i) {
                if (addComma) {
                    builder.sql(", ");
                } else {
                    addComma = true;
                }
                builder.sql(definition.name(i)).sql(" = ");
                Object value = values[i];
                if (value == null) {
                    builder.sql("null");
                    continue;
                }
                builder.variable(value);
            }
        }
        builder.sql(" where ").sql(null, this.pkDefinition, true).sql(" in (");
        String separator = "";
        for (Object e : childIds) {
            builder.sql(separator);
            separator = ", ";
            builder.variable(e);
        }
        builder.sql(")");
        Tuple2<String, List<Object>> sqlResult = builder.build();
        return this.sqlClient.getExecutor().execute(this.con, sqlResult.get_1(), sqlResult.get_2(), ExecutionPurpose.MUTATE, ExecutorContext.create(this.sqlClient), null, PreparedStatement::executeUpdate);
    }

    public int unsetParent(Object parentId, Collection<Object> retainedChildIds) {
        if (this.trigger != null) {
            return this.unsetParentAndPrepareEvents(Collections.singleton(parentId), retainedChildIds);
        }
        return this.unsetParentImpl(Collections.singleton(parentId), retainedChildIds);
    }

    public int unsetParents(Collection<Object> parentIds) {
        if (this.trigger != null) {
            return this.unsetParentAndPrepareEvents(parentIds, Collections.emptyList());
        }
        return this.unsetParentImpl(parentIds, Collections.emptyList());
    }

    private int unsetParentAndPrepareEvents(Collection<Object> parentIds, Collection<Object> retainedChildIds) {
        assert (this.trigger != null);
        int parentPropId = this.parentProp.getId();
        ImmutableType childType = this.parentProp.getDeclaringType();
        String parentIdPropName = this.parentProp.getTargetType().getIdProp().getName();
        String childIdPropName = childType.getIdProp().getName();
        int childIdPropId = childType.getIdProp().getId();
        List childRows = (List)Internal.requiresNewDraftContext(ctx -> {
            List list = (List)Queries.createQuery(this.sqlClient, this.parentProp.getDeclaringType(), ExecutionPurpose.MUTATE, true, (q, child) -> {
                PropExpression parentIdExpr = (PropExpression)child.join(this.parentProp.getName()).get(parentIdPropName);
                if (parentIds.size() > 1) {
                    q.where(new Predicate[]{parentIdExpr.in(parentIds)});
                } else {
                    q.where(new Predicate[]{parentIdExpr.eq(parentIds.iterator().next())});
                }
                if (!retainedChildIds.isEmpty()) {
                    q.where(new Predicate[]{((PropExpression)child.get(childIdPropName)).notIn(retainedChildIds)});
                }
                return q.select(child);
            }).execute(this.con);
            return ctx.resolveList(list);
        });
        if (childRows.isEmpty()) {
            return 0;
        }
        ArrayList<Object> affectedChildIds = new ArrayList<Object>(childRows.size());
        for (ImmutableSpi childRow : childRows) {
            Object childId = childRow.__get(childIdPropId);
            affectedChildIds.add(childId);
            ImmutableSpi changedRow = (ImmutableSpi)Internal.produce((ImmutableType)childType, (Object)childRow, draft -> ((DraftSpi)draft).__set(parentPropId, null));
            this.trigger.modifyEntityTable(childRow, changedRow);
        }
        return this.setParentImpl(null, affectedChildIds);
    }

    private int unsetParentImpl(Collection<Object> parentId, Collection<Object> retainedChildIds) {
        SqlBuilder builder = new SqlBuilder(new AstContext(this.sqlClient));
        DatabaseMetadata metadata = this.sqlClient.getDatabaseMetadata();
        builder.sql("update ").sql(metadata.getTableName(this.parentProp.getDeclaringType())).sql(" set ");
        ColumnDefinition definition = (ColumnDefinition)metadata.getStorage(this.parentProp);
        if (definition instanceof SingleColumn) {
            builder.sql(((SingleColumn)definition).getName()).sql(" = null");
        } else {
            boolean addComma = false;
            for (String columName : definition) {
                if (addComma) {
                    builder.sql(", ");
                } else {
                    addComma = true;
                }
                builder.sql(columName).sql(" = null");
            }
        }
        this.addDetachConditions(builder, parentId, retainedChildIds);
        Tuple2<String, List<Object>> sqlResult = builder.build();
        return this.sqlClient.getExecutor().execute(this.con, sqlResult.get_1(), sqlResult.get_2(), ExecutionPurpose.MUTATE, ExecutorContext.create(this.sqlClient), null, PreparedStatement::executeUpdate);
    }

    public List<Object> getDetachedChildIds(Object parentId, Collection<Object> retainedChildIds) {
        SqlBuilder builder = new SqlBuilder(new AstContext(this.sqlClient));
        DatabaseMetadata metadata = this.sqlClient.getDatabaseMetadata();
        ImmutableProp idProp = this.parentProp.getDeclaringType().getIdProp();
        builder.sql("select ").sql((ColumnDefinition)metadata.getStorage(idProp)).sql(" from ").sql(metadata.getTableName(this.parentProp.getDeclaringType()));
        this.addDetachConditions(builder, Collections.singleton(parentId), retainedChildIds);
        if (this.pessimisticLockRequired) {
            builder.sql(" for update");
        }
        Tuple2<String, List<Object>> sqlResult = builder.build();
        return this.sqlClient.getExecutor().execute(this.con, sqlResult.get_1(), sqlResult.get_2(), ExecutionPurpose.MUTATE, ExecutorContext.create(this.sqlClient), null, stmt -> {
            ArrayList<Object> list = new ArrayList<Object>();
            try (ResultSet rs = stmt.executeQuery();){
                while (rs.next()) {
                    Object id = this.pkReader.read(rs, new Reader.Col());
                    if (id == null) {
                        throw new ExecutionException("Cannot convert " + id + " to the type of " + idProp);
                    }
                    list.add(id);
                }
            }
            return list;
        });
    }

    private void addDetachConditions(SqlBuilder builder, Collection<Object> parentIds, Collection<Object> retainedChildIds) {
        boolean addComma;
        builder.sql(" where ").sql(null, this.fkDefinition, true);
        if (parentIds.size() == 1) {
            builder.sql(" = ").variable(parentIds.iterator().next());
        } else {
            builder.sql(" in (");
            addComma = false;
            for (Object parentId : parentIds) {
                if (addComma) {
                    builder.sql(", ");
                } else {
                    addComma = true;
                }
                builder.variable(parentId);
            }
            builder.sql(")");
        }
        if (!retainedChildIds.isEmpty()) {
            builder.sql(" and ").sql(null, this.pkDefinition, true).sql(" not in (");
            addComma = false;
            for (Object retainedChildId : retainedChildIds) {
                if (addComma) {
                    builder.sql(", ");
                } else {
                    addComma = true;
                }
                builder.variable(retainedChildId);
            }
            builder.sql(")");
        }
    }

    private static ImmutableSpi makeIdOnly(ImmutableType type, Object id) {
        return (ImmutableSpi)Internal.produce((ImmutableType)type, null, draft -> ((DraftSpi)draft).__set(type.getIdProp().getId(), id));
    }

    private static Object idOf(ImmutableSpi spi) {
        if (spi == null) {
            return null;
        }
        return spi.__get(spi.__type().getIdProp().getId());
    }
}

