/*
 * Decompiled with CFR 0.152.
 */
package org.babyfish.jimmer.sql.runtime;

import java.util.LinkedHashMap;
import java.util.List;
import org.babyfish.jimmer.meta.EmbeddedLevel;
import org.babyfish.jimmer.meta.ImmutableProp;
import org.babyfish.jimmer.meta.ImmutableType;
import org.babyfish.jimmer.meta.TargetLevel;
import org.babyfish.jimmer.sql.JSqlClient;
import org.babyfish.jimmer.sql.ast.PropExpression;
import org.babyfish.jimmer.sql.ast.Selection;
import org.babyfish.jimmer.sql.ast.embedded.AbstractTypedEmbeddedPropExpression;
import org.babyfish.jimmer.sql.ast.impl.ExpressionImplementor;
import org.babyfish.jimmer.sql.ast.impl.table.TableSelection;
import org.babyfish.jimmer.sql.ast.table.Table;
import org.babyfish.jimmer.sql.ast.table.spi.PropExpressionImplementor;
import org.babyfish.jimmer.sql.fetcher.Fetcher;
import org.babyfish.jimmer.sql.fetcher.Field;
import org.babyfish.jimmer.sql.fetcher.impl.FetcherSelection;
import org.babyfish.jimmer.sql.runtime.ObjectReader;
import org.babyfish.jimmer.sql.runtime.Reader;

class Readers {
    private Readers() {
    }

    public static Reader<?> createReader(JSqlClient sqlClient, List<Selection<?>> selections) {
        switch (selections.size()) {
            case 1: {
                return Readers.createSingleReader(sqlClient, selections.get(0));
            }
            case 2: {
                return Reader.tuple(Readers.createSingleReader(sqlClient, selections.get(0)), Readers.createSingleReader(sqlClient, selections.get(1)));
            }
            case 3: {
                return Reader.tuple(Readers.createSingleReader(sqlClient, selections.get(0)), Readers.createSingleReader(sqlClient, selections.get(1)), Readers.createSingleReader(sqlClient, selections.get(2)));
            }
            case 4: {
                return Reader.tuple(Readers.createSingleReader(sqlClient, selections.get(0)), Readers.createSingleReader(sqlClient, selections.get(1)), Readers.createSingleReader(sqlClient, selections.get(2)), Readers.createSingleReader(sqlClient, selections.get(3)));
            }
            case 5: {
                return Reader.tuple(Readers.createSingleReader(sqlClient, selections.get(0)), Readers.createSingleReader(sqlClient, selections.get(1)), Readers.createSingleReader(sqlClient, selections.get(2)), Readers.createSingleReader(sqlClient, selections.get(3)), Readers.createSingleReader(sqlClient, selections.get(4)));
            }
            case 6: {
                return Reader.tuple(Readers.createSingleReader(sqlClient, selections.get(0)), Readers.createSingleReader(sqlClient, selections.get(1)), Readers.createSingleReader(sqlClient, selections.get(2)), Readers.createSingleReader(sqlClient, selections.get(3)), Readers.createSingleReader(sqlClient, selections.get(4)), Readers.createSingleReader(sqlClient, selections.get(5)));
            }
            case 7: {
                return Reader.tuple(Readers.createSingleReader(sqlClient, selections.get(0)), Readers.createSingleReader(sqlClient, selections.get(1)), Readers.createSingleReader(sqlClient, selections.get(2)), Readers.createSingleReader(sqlClient, selections.get(3)), Readers.createSingleReader(sqlClient, selections.get(4)), Readers.createSingleReader(sqlClient, selections.get(5)), Readers.createSingleReader(sqlClient, selections.get(6)));
            }
            case 8: {
                return Reader.tuple(Readers.createSingleReader(sqlClient, selections.get(0)), Readers.createSingleReader(sqlClient, selections.get(1)), Readers.createSingleReader(sqlClient, selections.get(2)), Readers.createSingleReader(sqlClient, selections.get(3)), Readers.createSingleReader(sqlClient, selections.get(4)), Readers.createSingleReader(sqlClient, selections.get(5)), Readers.createSingleReader(sqlClient, selections.get(6)), Readers.createSingleReader(sqlClient, selections.get(7)));
            }
            case 9: {
                return Reader.tuple(Readers.createSingleReader(sqlClient, selections.get(0)), Readers.createSingleReader(sqlClient, selections.get(1)), Readers.createSingleReader(sqlClient, selections.get(2)), Readers.createSingleReader(sqlClient, selections.get(3)), Readers.createSingleReader(sqlClient, selections.get(4)), Readers.createSingleReader(sqlClient, selections.get(5)), Readers.createSingleReader(sqlClient, selections.get(6)), Readers.createSingleReader(sqlClient, selections.get(7)), Readers.createSingleReader(sqlClient, selections.get(8)));
            }
        }
        throw new IllegalArgumentException("The selection count must between 1 and 9");
    }

    private static Reader<?> createSingleReader(JSqlClient sqlClient, Selection<?> selection) {
        ImmutableProp prop;
        if (selection instanceof TableSelection) {
            ImmutableType immutableType = ((TableSelection)((Object)selection)).getImmutableType();
            return sqlClient.getReader(immutableType);
        }
        if (selection instanceof Table) {
            ImmutableType immutableType = ((Table)selection).getImmutableType();
            return sqlClient.getReader(immutableType);
        }
        if (selection instanceof FetcherSelection) {
            Fetcher<?> fetcher = ((FetcherSelection)selection).getFetcher();
            ImmutableType type = fetcher.getImmutableType();
            Reader<?> idReader = sqlClient.getReader(type.getIdProp());
            LinkedHashMap nonIdReaderMap = new LinkedHashMap();
            for (Field field : fetcher.getFieldMap().values()) {
                Reader<?> subReader;
                ImmutableProp prop2 = field.getProp();
                if (prop2.isId() || (subReader = sqlClient.getReader(prop2)) == null) continue;
                nonIdReaderMap.put(prop2, subReader);
            }
            return new ObjectReader(type, idReader, nonIdReaderMap);
        }
        ExpressionImplementor unwrapped = (ExpressionImplementor)AbstractTypedEmbeddedPropExpression.unwrap(selection);
        if (unwrapped instanceof PropExpression && (prop = ((PropExpressionImplementor)((Object)unwrapped)).getProp()).isScalar(TargetLevel.ENTITY) && !prop.isEmbedded(EmbeddedLevel.SCALAR)) {
            return sqlClient.getReader(prop);
        }
        return sqlClient.getReader(unwrapped.getType());
    }
}

