/*
 * Decompiled with CFR 0.152.
 */
package org.babyfish.jimmer.sql.fetcher.impl;

import java.util.Arrays;
import java.util.Collection;
import java.util.Collections;
import java.util.List;
import java.util.Objects;
import java.util.function.Supplier;
import org.babyfish.jimmer.sql.ast.Expression;
import org.babyfish.jimmer.sql.ast.Predicate;
import org.babyfish.jimmer.sql.ast.impl.query.AbstractMutableQueryImpl;
import org.babyfish.jimmer.sql.ast.query.MutableSubQuery;
import org.babyfish.jimmer.sql.ast.query.Order;
import org.babyfish.jimmer.sql.ast.query.Sortable;
import org.babyfish.jimmer.sql.ast.table.AssociationTable;
import org.babyfish.jimmer.sql.ast.table.Table;
import org.babyfish.jimmer.sql.ast.table.TableEx;
import org.babyfish.jimmer.sql.ast.table.spi.TableProxy;
import org.babyfish.jimmer.sql.fetcher.spi.FieldFilterArgsImplementor;

public class FieldFilterArgsImpl<T extends Table<?>>
implements FieldFilterArgsImplementor<T> {
    private final AbstractMutableQueryImpl query;
    private final T table;
    private final Collection<Object> keys;
    private boolean sorted;

    public static <T extends Table<?>> FieldFilterArgsImpl<T> of(AbstractMutableQueryImpl query, T table, Collection<Object> keys) {
        return new FieldFilterArgsImpl<T>(query, table, Objects.requireNonNull(keys, "keys cannot be null"));
    }

    private FieldFilterArgsImpl(AbstractMutableQueryImpl query, T table, Collection<Object> keys) {
        this.query = query;
        this.table = table;
        this.keys = keys != null ? Collections.unmodifiableCollection(keys) : null;
    }

    public boolean isSorted() {
        return this.sorted;
    }

    @Override
    public T getTable() {
        return this.table;
    }

    @Override
    public <K> K getKey() {
        if (this.keys.size() > 1) {
            throw new IllegalStateException("Too much keys");
        }
        return (K)this.keys.iterator().next();
    }

    @Override
    public <K> Collection<K> getKeys() {
        return this.keys;
    }

    @Override
    public Sortable where(Predicate ... predicates) {
        return this.query.where(predicates);
    }

    @Override
    public Sortable whereIf(boolean condition, Predicate predicates) {
        return this.query.whereIf(condition, predicates);
    }

    @Override
    public Sortable whereIf(boolean condition, Supplier<Predicate> block) {
        return this.query.whereIf(condition, (Supplier)block);
    }

    @Override
    public Sortable orderBy(Expression<?> ... expressions) {
        if (!this.sorted) {
            this.sorted = Arrays.stream(expressions).anyMatch(Objects::nonNull);
        }
        return this.query.orderBy((Expression[])expressions);
    }

    @Override
    public Sortable orderBy(Order ... orders) {
        if (!this.sorted) {
            this.sorted = Arrays.stream(orders).anyMatch(Objects::nonNull);
        }
        return this.query.orderBy(orders);
    }

    @Override
    public Sortable orderBy(List<Order> orders) {
        if (!this.sorted) {
            this.sorted = orders.stream().anyMatch(Objects::nonNull);
        }
        return this.query.orderBy((List)orders);
    }

    @Override
    public MutableSubQuery createSubQuery(TableProxy<?> table) {
        return this.query.createSubQuery(table);
    }

    @Override
    public <SE, ST extends TableEx<SE>, TE, TT extends TableEx<TE>> MutableSubQuery createAssociationSubQuery(AssociationTable<SE, ST, TE, TT> table) {
        return this.query.createAssociationSubQuery(table);
    }

    @Override
    public AbstractMutableQueryImpl query() {
        return this.query;
    }
}

