/*
 * Decompiled with CFR 0.152.
 */
package org.babyfish.jimmer.sql;

import com.fasterxml.jackson.databind.JavaType;
import com.fasterxml.jackson.databind.type.ArrayType;
import com.fasterxml.jackson.databind.type.CollectionType;
import com.fasterxml.jackson.databind.type.MapType;
import com.fasterxml.jackson.databind.type.SimpleType;
import java.lang.reflect.Field;
import java.lang.reflect.GenericArrayType;
import java.lang.reflect.ParameterizedType;
import java.lang.reflect.Type;
import java.lang.reflect.TypeVariable;
import java.lang.reflect.WildcardType;
import java.util.Collection;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import java.util.NavigableMap;
import java.util.NavigableSet;
import java.util.Set;
import java.util.SortedMap;
import java.util.SortedSet;
import org.babyfish.jimmer.impl.util.StaticCache;
import org.babyfish.jimmer.meta.ImmutableProp;
import org.babyfish.jimmer.meta.ModelException;
import org.babyfish.jimmer.sql.EnumItem;
import org.babyfish.jimmer.sql.EnumType;
import org.babyfish.jimmer.sql.Serialized;
import org.babyfish.jimmer.sql.dialect.DefaultDialect;
import org.babyfish.jimmer.sql.dialect.Dialect;
import org.babyfish.jimmer.sql.runtime.ScalarProvider;
import org.jetbrains.annotations.NotNull;

class ScalarProviderManager {
    private static final Set<Class<?>> GENERIC_TYPES;
    private final StaticCache<Class<?>, ScalarProvider<?, ?>> typeScalarProviderCache = new StaticCache(this::createProvider, true);
    private final StaticCache<ImmutableProp, ScalarProvider<?, ?>> propScalarProviderCache = new StaticCache(this::createProvider, true);
    private final Map<Class<?>, ScalarProvider<?, ?>> customizedTypeScalarProviderMap;
    private final Map<ImmutableProp, ScalarProvider<?, ?>> customizedPropScalarProviderMap;
    private final EnumType.Strategy defaultEnumStrategy;
    private final Dialect dialect;

    ScalarProviderManager(Map<Class<?>, ScalarProvider<?, ?>> customizedTypeScalarProviderMap, Map<ImmutableProp, ScalarProvider<?, ?>> customizedPropScalarProviderMap, EnumType.Strategy defaultEnumStrategy, Dialect dialect) {
        this.customizedTypeScalarProviderMap = customizedTypeScalarProviderMap;
        this.customizedPropScalarProviderMap = customizedPropScalarProviderMap;
        this.defaultEnumStrategy = defaultEnumStrategy;
        this.dialect = dialect != null ? dialect : new DefaultDialect();
    }

    public ScalarProvider<?, ?> getProvider(ImmutableProp prop) {
        return (ScalarProvider)this.propScalarProviderCache.get((Object)prop);
    }

    public ScalarProvider<?, ?> getProvider(Class<?> type) {
        return (ScalarProvider)this.typeScalarProviderCache.get(type);
    }

    private ScalarProvider<?, ?> createProvider(ImmutableProp prop) {
        ScalarProvider<?, ?> provider = this.customizedPropScalarProviderMap.get(prop);
        if (provider != null) {
            return provider;
        }
        Serialized serialized = (Serialized)prop.getAnnotation(Serialized.class);
        if (serialized == null) {
            return (ScalarProvider)this.typeScalarProviderCache.get((Object)prop.getReturnClass());
        }
        return this.createJsonProvider(prop.getReturnClass(), ScalarProviderManager.jacksonType(prop.getGenericType()));
    }

    private ScalarProvider<?, ?> createProvider(Class<?> type) {
        ScalarProvider<?, ?> provider = this.customizedTypeScalarProviderMap.get(type);
        if (provider != null) {
            return provider;
        }
        EnumType enumType = type.getAnnotation(EnumType.class);
        Serialized serialized = type.getAnnotation(Serialized.class);
        if (enumType != null && serialized != null) {
            throw new ModelException("Illegal type \"" + type + "\", it cannot be decorated by both @" + EnumType.class.getName() + " and @" + Serialized.class.getName());
        }
        if (enumType != null && !type.isEnum()) {
            throw new ModelException("Illegal type \"" + type + "\", it cannot be decorated by @EnumType because it is not enum");
        }
        if (enumType != null && enumType.value() == EnumType.Strategy.ORDINAL) {
            return this.newEnumByIntProvider(type);
        }
        if (enumType != null && enumType.value() == EnumType.Strategy.NAME) {
            return this.newEnumByStringProvider(type);
        }
        if (type.isEnum()) {
            if (this.defaultEnumStrategy == EnumType.Strategy.ORDINAL) {
                return this.newEnumByIntProvider(type);
            }
            return this.newEnumByStringProvider(type);
        }
        if (serialized != null) {
            return this.createJsonProvider(type, (JavaType)SimpleType.constructUnsafe(type));
        }
        return null;
    }

    private <E extends Enum<E>> ScalarProvider<E, ?> newEnumByStringProvider(Class<E> enumType) {
        return ScalarProvider.enumProviderByString(enumType, it -> {
            for (Enum enumValue : (Enum[])enumType.getEnumConstants()) {
                Field enumField;
                try {
                    enumField = enumType.getField(enumValue.name());
                }
                catch (NoSuchFieldException ex) {
                    throw new AssertionError("Internal bug", ex);
                }
                EnumItem enumItem = enumField.getAnnotation(EnumItem.class);
                if (enumItem == null) break;
                if (enumItem.ordinal() != -1) {
                    throw new ModelException("Illegal enum type \"" + enumType.getName() + "\", it is mapped by name, not ordinal, but ordinal of the @EnumItem of \"" + enumField.getName() + "\" is configured");
                }
                if (enumItem.name().equals("")) continue;
                it.map(enumValue, enumItem.name());
            }
        });
    }

    private <E extends Enum<E>> ScalarProvider<?, ?> newEnumByIntProvider(Class<E> enumType) {
        return ScalarProvider.enumProviderByInt(enumType, it -> {
            for (Enum enumValue : (Enum[])enumType.getEnumConstants()) {
                Field enumField;
                try {
                    enumField = enumType.getField(enumValue.name());
                }
                catch (NoSuchFieldException ex) {
                    throw new AssertionError("Internal bug", ex);
                }
                EnumItem enumItem = enumField.getAnnotation(EnumItem.class);
                if (enumItem == null) break;
                if (!enumItem.name().equals("")) {
                    throw new ModelException("Illegal enum type \"" + enumType.getName() + "\", it is mapped by ordinal, not name, but name of the @EnumItem of \"" + enumField.getName() + "\" is configured");
                }
                if (enumItem.ordinal() == -1) continue;
                it.map(enumValue, enumItem.ordinal());
            }
        });
    }

    private ScalarProvider<?, ?> createJsonProvider(Class<?> type, final JavaType javaType) {
        return new ScalarProvider<Object, Object>(type, this.dialect.getJsonBaseType()){

            @Override
            @NotNull
            public Object toScalar(@NotNull Object sqlValue) throws Exception {
                if (!ScalarProviderManager.this.dialect.getJsonBaseType().isAssignableFrom(sqlValue.getClass())) {
                    throw new IllegalArgumentException("The type of the sql value is not the json base type \"" + ScalarProviderManager.this.dialect.getJsonBaseType().getName() + "\" of the dialect \"" + ScalarProviderManager.this.dialect.getClass().getName() + "\"");
                }
                return ScalarProviderManager.this.dialect.baseValueToJson(sqlValue, javaType);
            }

            @Override
            @NotNull
            public Object toSql(@NotNull Object scalarValue) throws Exception {
                return ScalarProviderManager.this.dialect.jsonToBaseValue(scalarValue);
            }
        };
    }

    private static JavaType jacksonType(Type type) {
        if (type instanceof ParameterizedType) {
            ParameterizedType parameterizedType = (ParameterizedType)type;
            Type rawType = parameterizedType.getRawType();
            if (!(rawType instanceof Class) || !GENERIC_TYPES.contains(rawType)) {
                throw new IllegalArgumentException("Generic type must be one of " + GENERIC_TYPES);
            }
            Class rawClass = (Class)rawType;
            if (Map.class.isAssignableFrom(rawClass)) {
                return MapType.construct((Class)rawClass, null, null, null, (JavaType)ScalarProviderManager.jacksonType(parameterizedType.getActualTypeArguments()[0]), (JavaType)ScalarProviderManager.jacksonType(parameterizedType.getActualTypeArguments()[1]));
            }
            return CollectionType.construct((Class)rawClass, null, null, null, (JavaType)ScalarProviderManager.jacksonType(parameterizedType.getActualTypeArguments()[0]));
        }
        if (type instanceof Class) {
            if (GENERIC_TYPES.contains(type)) {
                throw new IllegalArgumentException("\"" + type + "\" does not have generic arguments");
            }
            Class clazz = (Class)type;
            if (clazz.isArray()) {
                return ArrayType.construct(null, null, null, (Object)ScalarProviderManager.jacksonType(clazz.getComponentType()));
            }
            return SimpleType.constructUnsafe((Class)clazz);
        }
        if (type instanceof WildcardType) {
            WildcardType wildcardType = (WildcardType)type;
            return ScalarProviderManager.jacksonType(wildcardType.getLowerBounds()[0]);
        }
        if (type instanceof TypeVariable) {
            throw new IllegalArgumentException("type variable is not allowed");
        }
        if (type instanceof GenericArrayType) {
            throw new IllegalArgumentException("generic array is not allowed");
        }
        throw new IllegalArgumentException("Unexpected type: " + type.getClass().getName());
    }

    static {
        HashSet genericTypes = new HashSet();
        genericTypes.add(Iterable.class);
        genericTypes.add(Collection.class);
        genericTypes.add(List.class);
        genericTypes.add(Set.class);
        genericTypes.add(SortedSet.class);
        genericTypes.add(NavigableSet.class);
        genericTypes.add(Map.class);
        genericTypes.add(SortedMap.class);
        genericTypes.add(NavigableMap.class);
        GENERIC_TYPES = genericTypes;
    }
}

