/*
 * Decompiled with CFR 0.152.
 */
package org.babyfish.jimmer.sql.dialect;

import org.babyfish.jimmer.sql.dialect.Dialect;
import org.babyfish.jimmer.sql.dialect.PaginationContext;
import org.jetbrains.annotations.Nullable;

public class OracleDialect
implements Dialect {
    @Override
    public void paginate(PaginationContext ctx) {
        int offset = ctx.getOffset();
        if (offset == 0) {
            this.limit(ctx);
        } else {
            ctx.sql("select * from (");
            this.limit(ctx);
            ctx.sql(") limited__ where rn__ > ");
            ctx.variable(offset);
        }
    }

    private void limit(PaginationContext ctx) {
        int offset = ctx.getOffset();
        int limit = ctx.getLimit();
        String rnProjection = offset > 0 ? ", rownum rn__" : "";
        ctx.sql("select core__.*" + rnProjection + " from (").origin().sql(") core__ where rownum <= ").variable(offset + limit);
    }

    @Override
    public String getSelectIdFromSequenceSql(String sequenceName) {
        return "select " + sequenceName + ".nextval from dual";
    }

    @Override
    public boolean isMultiInsertionSupported() {
        return false;
    }

    @Override
    @Nullable
    public String getConstantTableName() {
        return "dual";
    }

    public String toString() {
        return this.getClass().getName();
    }
}

