/*
 * Decompiled with CFR 0.152.
 */
package org.babyfish.jimmer.sql.ast.impl.query;

import java.util.Collections;
import java.util.List;
import java.util.Map;
import org.babyfish.jimmer.meta.ImmutableProp;
import org.babyfish.jimmer.sql.ast.Selection;
import org.babyfish.jimmer.sql.ast.impl.Ast;
import org.babyfish.jimmer.sql.ast.impl.AstContext;
import org.babyfish.jimmer.sql.ast.impl.AstVisitor;
import org.babyfish.jimmer.sql.ast.impl.query.AbstractMutableQueryImpl;
import org.babyfish.jimmer.sql.ast.impl.query.PaginationContextImpl;
import org.babyfish.jimmer.sql.ast.impl.query.TypedQueryData;
import org.babyfish.jimmer.sql.ast.impl.query.TypedQueryImplementor;
import org.babyfish.jimmer.sql.ast.impl.table.TableImplementor;
import org.babyfish.jimmer.sql.ast.impl.table.TableProxies;
import org.babyfish.jimmer.sql.ast.impl.table.TableSelection;
import org.babyfish.jimmer.sql.ast.table.Table;
import org.babyfish.jimmer.sql.ast.table.spi.PropExpressionImplementor;
import org.babyfish.jimmer.sql.fetcher.Field;
import org.babyfish.jimmer.sql.fetcher.impl.FetcherSelection;
import org.babyfish.jimmer.sql.meta.ColumnDefinition;
import org.babyfish.jimmer.sql.meta.FormulaTemplate;
import org.babyfish.jimmer.sql.meta.SqlTemplate;
import org.babyfish.jimmer.sql.meta.Storage;
import org.babyfish.jimmer.sql.runtime.SqlBuilder;
import org.jetbrains.annotations.NotNull;

class AbstractConfigurableTypedQueryImpl
implements TypedQueryImplementor {
    private TypedQueryData data;
    private AbstractMutableQueryImpl baseQuery;

    public AbstractConfigurableTypedQueryImpl(TypedQueryData data, AbstractMutableQueryImpl baseQuery) {
        this.data = data;
        this.baseQuery = baseQuery;
    }

    public AbstractMutableQueryImpl getBaseQuery() {
        return this.baseQuery;
    }

    public TypedQueryData getData() {
        return this.data;
    }

    @Override
    public List<Selection<?>> getSelections() {
        return this.data.getSelections();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void accept(@NotNull AstVisitor visitor) {
        AstContext astContext = visitor.getAstContext();
        astContext.pushStatement(this.getBaseQuery());
        try {
            PropExpressionImplementor<?> idOnlySelection = this.idOnlyPropExprByOffset();
            if (idOnlySelection != null) {
                this.baseQuery.accept(visitor, Collections.singletonList(idOnlySelection), false);
            } else {
                for (Selection<?> selection : this.data.getSelections()) {
                    Ast.from(selection, visitor.getAstContext()).accept(visitor);
                }
                this.baseQuery.accept(visitor, this.data.getOldSelections(), this.data.isWithoutSortingAndPaging());
            }
        }
        finally {
            astContext.popStatement();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void renderTo(@NotNull SqlBuilder builder) {
        AstContext astContext = builder.getAstContext();
        astContext.pushStatement(this.getBaseQuery());
        try {
            if (this.data.isWithoutSortingAndPaging() || this.data.getLimit() == Integer.MAX_VALUE) {
                this.renderWithoutPaging(builder, null);
            } else {
                PropExpressionImplementor<?> idPropExpr = this.idOnlyPropExprByOffset();
                if (idPropExpr != null) {
                    this.renderIdOnlyQuery(idPropExpr, builder);
                } else {
                    SqlBuilder subBuilder = builder.createChildBuilder();
                    this.renderWithoutPaging(subBuilder, null);
                    subBuilder.build(result -> {
                        PaginationContextImpl ctx = new PaginationContextImpl(this.data.getLimit(), this.data.getOffset(), (String)result.get_1(), (List)result.get_2());
                        this.baseQuery.getSqlClient().getDialect().paginate(ctx);
                        return ctx.build();
                    });
                }
            }
            if (this.data.isForUpdate()) {
                builder.sql(" for update");
            }
        }
        finally {
            astContext.popStatement();
        }
    }

    private void renderWithoutPaging(SqlBuilder builder, PropExpressionImplementor<?> idPropExpr) {
        builder.sql("select ");
        if (this.data.isDistinct()) {
            builder.sql("distinct ");
        }
        if (idPropExpr != null) {
            TableImplementor<?> tableImplementor = TableProxies.resolve(idPropExpr.getTable(), builder.getAstContext());
            tableImplementor.renderSelection(tableImplementor.getImmutableType().getIdProp(), builder, null, true, IdOnlyQueryWrapperWriter::idAlias);
        } else {
            String separator = "";
            for (Selection<?> selection : this.data.getSelections()) {
                TableImplementor tableSelection;
                builder.sql(separator);
                if (selection instanceof TableSelection) {
                    tableSelection = (TableImplementor)selection;
                    AbstractConfigurableTypedQueryImpl.renderAllProps(tableSelection, builder);
                } else if (selection instanceof Table) {
                    tableSelection = TableProxies.resolve((Table)selection, builder.getAstContext());
                    AbstractConfigurableTypedQueryImpl.renderAllProps(tableSelection, builder);
                } else {
                    Ast ast = Ast.from(selection, builder.getAstContext());
                    if (ast instanceof PropExpressionImplementor) {
                        ((PropExpressionImplementor)((Object)ast)).renderTo(builder, true);
                    } else {
                        ast.renderTo(builder);
                    }
                }
                separator = ", ";
            }
        }
        this.baseQuery.renderTo(builder, this.data.isWithoutSortingAndPaging());
    }

    private PropExpressionImplementor<?> idOnlyPropExprByOffset() {
        if (this.data.getOffset() >= this.baseQuery.getSqlClient().getOffsetOptimizingThreshold()) {
            return this.data.getIdOnlyExpression();
        }
        return null;
    }

    private static void renderAllProps(TableSelection table, SqlBuilder builder) {
        String separator = "";
        Map selectableProps = table.getImmutableType().getSelectableProps();
        for (ImmutableProp prop : selectableProps.values()) {
            builder.sql(separator);
            table.renderSelection(prop, builder, null);
            separator = ", ";
        }
    }

    private void renderIdOnlyQuery(PropExpressionImplementor<?> idPropExpr, SqlBuilder builder) {
        IdOnlyQueryWrapperWriter writer = new IdOnlyQueryWrapperWriter(builder);
        TableImplementor<?> tableImplementor = TableProxies.resolve(idPropExpr.getTable(), builder.getAstContext());
        builder.sql("select ");
        if (this.data.getSelections().get(0) instanceof FetcherSelection) {
            for (Field field : ((FetcherSelection)this.data.getSelections().get(0)).getFetcher().getFieldMap().values()) {
                writer.prop(field.getProp(), "optimize_", false);
            }
        } else {
            for (ImmutableProp prop : tableImplementor.getImmutableType().getProps().values()) {
                writer.prop(prop, "optimize_", false);
            }
        }
        builder.sql(" from (");
        SqlBuilder subBuilder = builder.createChildBuilder();
        this.renderWithoutPaging(subBuilder, idPropExpr);
        subBuilder.build(result -> {
            PaginationContextImpl ctx = new PaginationContextImpl(this.data.getLimit(), this.data.getOffset(), (String)result.get_1(), (List)result.get_2());
            this.baseQuery.getSqlClient().getDialect().paginate(ctx);
            return ctx.build();
        });
        writer.resetComma();
        builder.sql(") ").sql("optimize_core_").sql(" inner join ").sql(tableImplementor.getImmutableType().getTableName()).sql(" as ").sql("optimize_").sql(" on ");
        writer.prop(tableImplementor.getImmutableType().getIdProp(), "optimize_", true);
        builder.sql(" = ");
        int size = ((ColumnDefinition)tableImplementor.getImmutableType().getIdProp().getStorage()).size();
        if (size == 1) {
            builder.sql("optimize_core_").sql(".");
            builder.sql(IdOnlyQueryWrapperWriter.idAlias(0));
        } else {
            builder.sql("(");
            for (int i = 0; i < size; ++i) {
                if (i != 0) {
                    builder.sql(", ");
                }
                builder.sql("optimize_core_").sql(".");
                builder.sql(IdOnlyQueryWrapperWriter.idAlias(i));
            }
            builder.sql(")");
        }
    }

    private static class IdOnlyQueryWrapperWriter {
        private static final String ALIAS = "optimize_";
        private static final String CORE_ALIAS = "optimize_core_";
        private static final String CORE_ID_ALIAS = "optimize_core_id_";
        private final SqlBuilder builder;
        private boolean addComma;

        IdOnlyQueryWrapperWriter(SqlBuilder builder) {
            this.builder = builder;
        }

        public void prop(ImmutableProp prop, String alias, boolean multiColumnsAsTuple) {
            SqlTemplate template = prop.getSqlTemplate();
            if (template instanceof FormulaTemplate) {
                this.appendComma();
                this.builder.sql(((FormulaTemplate)template).toSql(alias));
                return;
            }
            Storage storage = prop.getStorage();
            if (storage instanceof ColumnDefinition) {
                ColumnDefinition definition = (ColumnDefinition)storage;
                int size = definition.size();
                if (size == 1) {
                    this.appendComma();
                    this.builder.sql(alias).sql(".").sql(definition.name(0));
                } else if (multiColumnsAsTuple) {
                    this.builder.enterTuple();
                    for (int i = 0; i < size; ++i) {
                        this.appendComma();
                        this.builder.sql(alias).sql(".").sql(definition.name(i));
                    }
                    this.builder.leaveTuple();
                } else {
                    for (int i = 0; i < size; ++i) {
                        this.appendComma();
                        this.builder.sql(alias).sql(".").sql(definition.name(i));
                    }
                }
            }
        }

        private void appendComma() {
            if (this.addComma) {
                this.builder.sql(", ");
            } else {
                this.addComma = true;
            }
        }

        public static String idAlias(int index) {
            return index == 0 ? CORE_ID_ALIAS : CORE_ID_ALIAS + index + '_';
        }

        public void resetComma() {
            this.addComma = false;
        }
    }
}

