/*
 * Decompiled with CFR 0.152.
 */
package org.babyfish.jimmer.sql.runtime;

import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collections;
import java.util.List;
import org.babyfish.jimmer.sql.JSqlClient;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public class ExecutorContext {
    private final StackTraceElement primaryElement;
    private final List<StackTraceElement> matchedElements;
    private final List<StackTraceElement> elements;

    private ExecutorContext(StackTraceElement primaryElement, List<StackTraceElement> matchedElements, List<StackTraceElement> elements) {
        this.primaryElement = primaryElement;
        this.matchedElements = matchedElements;
        this.elements = elements;
    }

    @NotNull
    public StackTraceElement getPrimaryElement() {
        return this.primaryElement;
    }

    @NotNull
    public List<StackTraceElement> getElements() {
        return this.elements;
    }

    @NotNull
    public List<StackTraceElement> getMatchedElements() {
        return this.matchedElements;
    }

    @Nullable
    public static ExecutorContext create(JSqlClient sqlClient) {
        List<String> prefixes = sqlClient.getExecutorContextPrefixes();
        if (prefixes == null) {
            return null;
        }
        StackTraceElement[] elements = Thread.currentThread().getStackTrace();
        ArrayList<StackTraceElement> matchedElements = new ArrayList<StackTraceElement>();
        block0: for (StackTraceElement element : elements) {
            if (element.getLineNumber() < 0) continue;
            for (String prefix : prefixes) {
                if (!element.getClassName().startsWith(prefix)) continue;
                matchedElements.add(element);
                continue block0;
            }
        }
        if (matchedElements.isEmpty()) {
            return null;
        }
        return new ExecutorContext((StackTraceElement)matchedElements.get(0), Collections.unmodifiableList(matchedElements), Collections.unmodifiableList(Arrays.asList(elements)));
    }
}

