/*
 * Decompiled with CFR 0.152.
 */
package org.babyfish.jimmer.sql.loader.graphql.impl;

import java.sql.Connection;
import java.util.Collection;
import java.util.Map;
import org.babyfish.jimmer.meta.ImmutableProp;
import org.babyfish.jimmer.runtime.ImmutableSpi;
import org.babyfish.jimmer.sql.JSqlClient;
import org.babyfish.jimmer.sql.ast.Executable;
import org.babyfish.jimmer.sql.loader.graphql.ValueLoader;
import org.babyfish.jimmer.sql.loader.graphql.impl.BatchCommand;
import org.babyfish.jimmer.sql.loader.graphql.impl.SingleCommand;

class ValueLoaderImpl<S, V>
implements ValueLoader<S, V> {
    private final JSqlClient sqlClient;
    private final Connection con;
    private final ImmutableProp prop;

    public ValueLoaderImpl(JSqlClient sqlClient, ImmutableProp prop) {
        this(sqlClient, null, prop);
    }

    public ValueLoaderImpl(JSqlClient sqlClient, Connection con, ImmutableProp prop) {
        this.sqlClient = sqlClient;
        this.con = con;
        this.prop = prop;
    }

    @Override
    public ValueLoader<S, V> forConnection(Connection con) {
        if (this.con == con) {
            return this;
        }
        return new ValueLoaderImpl<S, V>(this.sqlClient, con, this.prop);
    }

    @Override
    public Executable<V> loadCommand(S source) {
        if (source instanceof Collection) {
            throw new IllegalArgumentException("source cannot be collection, do you want to call 'batchLoadCommand'?");
        }
        return new SingleCommand<Object>(this.sqlClient, this.con, this.prop, null, Integer.MAX_VALUE, 0, (ImmutableSpi)source, null);
    }

    @Override
    public Executable<Map<S, V>> batchLoadCommand(Collection<S> sources) {
        return new BatchCommand(this.sqlClient, this.con, this.prop, null, sources, null);
    }
}

