/*
 * Decompiled with CFR 0.152.
 */
package org.babyfish.jimmer.sql.fetcher.impl;

import org.babyfish.jimmer.meta.ImmutableProp;
import org.babyfish.jimmer.meta.ImmutableType;
import org.babyfish.jimmer.sql.fetcher.Fetcher;
import org.babyfish.jimmer.sql.fetcher.Field;
import org.babyfish.jimmer.sql.fetcher.FieldFilter;
import org.babyfish.jimmer.sql.fetcher.RecursionStrategy;
import org.babyfish.jimmer.sql.fetcher.impl.FetcherImpl;
import org.babyfish.jimmer.sql.fetcher.impl.FetcherWriter;
import org.babyfish.jimmer.sql.meta.ColumnDefinition;
import org.babyfish.jimmer.sql.meta.FormulaTemplate;

class FieldImpl
implements Field {
    private final ImmutableType entityType;
    private final ImmutableProp prop;
    private final FieldFilter<?> filter;
    private final int batchSize;
    private final int limit;
    private final int offset;
    private final RecursionStrategy<?> recursionStrategy;
    private final FetcherImpl<?> childFetcher;
    private final boolean isSimpleField;
    private final boolean implicit;

    FieldImpl(ImmutableType entityType, ImmutableProp prop, FieldFilter<?> filter, int batchSize, int limit, int offset, RecursionStrategy<?> recursionStrategy, FetcherImpl<?> childFetcher, boolean implicit) {
        this.entityType = entityType;
        this.prop = prop;
        this.filter = filter;
        this.batchSize = batchSize;
        this.limit = limit;
        this.offset = offset;
        this.recursionStrategy = recursionStrategy;
        this.childFetcher = childFetcher;
        this.isSimpleField = this.determineIsSimpleField();
        this.implicit = implicit;
    }

    FieldImpl(FieldImpl base, FetcherImpl<?> childFetcher) {
        this.entityType = base.entityType;
        this.prop = base.prop;
        this.filter = base.filter;
        this.batchSize = base.batchSize;
        this.limit = base.limit;
        this.offset = base.offset;
        this.recursionStrategy = base.recursionStrategy;
        this.implicit = base.implicit;
        this.childFetcher = childFetcher;
        this.isSimpleField = this.determineIsSimpleField();
    }

    @Override
    public ImmutableType getEntityType() {
        return this.entityType;
    }

    @Override
    public ImmutableProp getProp() {
        return this.prop;
    }

    @Override
    public FieldFilter<?> getFilter() {
        return this.filter;
    }

    @Override
    public int getBatchSize() {
        return this.batchSize;
    }

    @Override
    public int getLimit() {
        return this.limit;
    }

    @Override
    public int getOffset() {
        return this.offset;
    }

    @Override
    public RecursionStrategy<?> getRecursionStrategy() {
        return this.recursionStrategy;
    }

    @Override
    public Fetcher<?> getChildFetcher() {
        return this.childFetcher;
    }

    @Override
    public boolean isSimpleField() {
        return this.isSimpleField;
    }

    @Override
    public boolean isImplicit() {
        return this.implicit;
    }

    public String toString() {
        FetcherWriter writer = new FetcherWriter();
        writer.write(this);
        return writer.toString();
    }

    private boolean determineIsSimpleField() {
        if (this.prop.getStorage() instanceof ColumnDefinition) {
            return this.childFetcher == null || this.childFetcher.getFieldMap().size() == 1;
        }
        return this.prop.getSqlTemplate() instanceof FormulaTemplate;
    }
}

