/*
 * Decompiled with CFR 0.152.
 */
package org.babyfish.jimmer.sql.ast.impl.mutation;

import java.sql.Connection;
import java.sql.PreparedStatement;
import java.util.Collection;
import java.util.Collections;
import java.util.HashMap;
import java.util.LinkedHashMap;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import org.babyfish.jimmer.meta.ImmutableProp;
import org.babyfish.jimmer.meta.ImmutableType;
import org.babyfish.jimmer.runtime.ImmutableSpi;
import org.babyfish.jimmer.sql.JSqlClient;
import org.babyfish.jimmer.sql.JoinType;
import org.babyfish.jimmer.sql.ast.Expression;
import org.babyfish.jimmer.sql.ast.Predicate;
import org.babyfish.jimmer.sql.ast.PropExpression;
import org.babyfish.jimmer.sql.ast.impl.AbstractMutableStatementImpl;
import org.babyfish.jimmer.sql.ast.impl.Ast;
import org.babyfish.jimmer.sql.ast.impl.AstContext;
import org.babyfish.jimmer.sql.ast.impl.AstVisitor;
import org.babyfish.jimmer.sql.ast.impl.ExpressionImplementor;
import org.babyfish.jimmer.sql.ast.impl.Literals;
import org.babyfish.jimmer.sql.ast.impl.mutation.MutationTrigger;
import org.babyfish.jimmer.sql.ast.impl.query.UseTableVisitor;
import org.babyfish.jimmer.sql.ast.impl.table.StatementContext;
import org.babyfish.jimmer.sql.ast.impl.table.TableImplementor;
import org.babyfish.jimmer.sql.ast.impl.table.TableProxies;
import org.babyfish.jimmer.sql.ast.mutation.MutableUpdate;
import org.babyfish.jimmer.sql.ast.table.Table;
import org.babyfish.jimmer.sql.ast.table.spi.PropExpressionImplementor;
import org.babyfish.jimmer.sql.ast.table.spi.TableProxy;
import org.babyfish.jimmer.sql.ast.tuple.Tuple2;
import org.babyfish.jimmer.sql.dialect.Dialect;
import org.babyfish.jimmer.sql.dialect.UpdateJoin;
import org.babyfish.jimmer.sql.event.TriggerType;
import org.babyfish.jimmer.sql.meta.ColumnDefinition;
import org.babyfish.jimmer.sql.meta.EmbeddedColumns;
import org.babyfish.jimmer.sql.runtime.ExecutionException;
import org.babyfish.jimmer.sql.runtime.ExecutionPurpose;
import org.babyfish.jimmer.sql.runtime.ExecutorContext;
import org.babyfish.jimmer.sql.runtime.Selectors;
import org.babyfish.jimmer.sql.runtime.SqlBuilder;
import org.babyfish.jimmer.sql.runtime.TableUsedState;
import org.jetbrains.annotations.NotNull;

public class MutableUpdateImpl
extends AbstractMutableStatementImpl
implements MutableUpdate,
Ast {
    private final StatementContext ctx;
    private Map<Target, Expression<?>> assignmentMap = new LinkedHashMap();

    public MutableUpdateImpl(JSqlClient sqlClient, ImmutableType immutableType) {
        super(sqlClient, immutableType);
        this.ctx = new StatementContext(ExecutionPurpose.UPDATE, false);
    }

    public MutableUpdateImpl(JSqlClient sqlClient, TableProxy<?> table) {
        super(sqlClient, table);
        this.ctx = new StatementContext(ExecutionPurpose.UPDATE, false);
    }

    @Override
    public StatementContext getContext() {
        return this.ctx;
    }

    @Override
    public AbstractMutableStatementImpl getParent() {
        return null;
    }

    @Override
    public <X> MutableUpdate set(PropExpression<X> path, X value) {
        if (value != null) {
            return this.set(path, Expression.any().value(value));
        }
        return this.set(path, Expression.any().nullValue(((ExpressionImplementor)((Object)path)).getType()));
    }

    @Override
    public <X> MutableUpdate set(PropExpression<X> path, Expression<X> value) {
        boolean joinedTableUpdatable;
        this.validateMutable();
        Target target = Target.of(path);
        if (target.table != this.getTable() && this.getSqlClient().getTriggerType() != TriggerType.BINLOG_ONLY) {
            throw new IllegalArgumentException("Only the primary table can be deleted when transaction trigger is supported");
        }
        if (!(target.prop.getStorage() instanceof ColumnDefinition)) {
            throw new IllegalArgumentException("The assigned prop expression must be mapped by database columns");
        }
        UpdateJoin updateJoin = this.getSqlClient().getDialect().getUpdateJoin();
        boolean bl = joinedTableUpdatable = updateJoin != null && updateJoin.isJoinedTableUpdatable();
        if (!joinedTableUpdatable && target.table != this.getTable() && target.table != this.getTableImplementor()) {
            throw new IllegalArgumentException("The current dialect '" + this.getSqlClient().getDialect().getClass().getName() + "' indicates that only the columns of current table can be updated");
        }
        if (this.assignmentMap.put(target, value) != null) {
            throw new IllegalStateException("Cannot update same column twice");
        }
        Literals.bind(value, path);
        return this;
    }

    @Override
    public MutableUpdate where(Predicate ... predicates) {
        return (MutableUpdate)super.where(predicates);
    }

    @Override
    public Integer execute() {
        return this.getSqlClient().getConnectionManager().execute(this::executeImpl);
    }

    @Override
    public Integer execute(Connection con) {
        if (con != null) {
            return this.executeImpl(con);
        }
        return this.getSqlClient().getConnectionManager().execute(this::executeImpl);
    }

    private int executeImpl(Connection con) {
        this.freeze();
        if (this.assignmentMap.isEmpty()) {
            return 0;
        }
        if (this.getSqlClient().getTriggerType() != TriggerType.BINLOG_ONLY) {
            return this.executeWithTrigger(con);
        }
        SqlBuilder builder = new SqlBuilder(new AstContext(this.getSqlClient()));
        this.renderTo(builder);
        Tuple2<String, List<Object>> sqlResult = builder.build();
        return this.getSqlClient().getExecutor().execute(con, sqlResult.get_1(), sqlResult.get_2(), this.getPurpose(), ExecutorContext.create(this.getSqlClient()), null, PreparedStatement::executeUpdate);
    }

    private int executeWithTrigger(Connection con) {
        SqlBuilder builder = new SqlBuilder(new AstContext(this.getSqlClient()));
        this.renderAsSelect(builder, null);
        Tuple2<String, List<Object>> sqlResult = builder.build();
        List<ImmutableSpi> rows = Selectors.select(this.getSqlClient(), con, sqlResult.get_1(), sqlResult.get_2(), Collections.singletonList(this.getTable()), ExecutionPurpose.UPDATE);
        if (rows.isEmpty()) {
            return 0;
        }
        int idPropId = this.getTable().getImmutableType().getIdProp().getId();
        HashMap<Object, ImmutableSpi> rowMap = new HashMap<Object, ImmutableSpi>((rows.size() * 4 + 2) / 3);
        for (ImmutableSpi row : rows) {
            rowMap.put(row.__get(idPropId), row);
        }
        builder = new SqlBuilder(new AstContext(this.getSqlClient()));
        this.renderTo(builder, rowMap.keySet());
        sqlResult = builder.build();
        int affectRowCount = this.getSqlClient().getExecutor().execute(con, sqlResult.get_1(), sqlResult.get_2(), this.getPurpose(), ExecutorContext.create(this.getSqlClient()), null, PreparedStatement::executeUpdate);
        if (affectRowCount == 0) {
            return 0;
        }
        builder = new SqlBuilder(new AstContext(this.getSqlClient()));
        this.renderAsSelect(builder, rowMap.keySet());
        sqlResult = builder.build();
        List<ImmutableSpi> changedRows = Selectors.select(this.getSqlClient(), con, sqlResult.get_1(), sqlResult.get_2(), Collections.singletonList(this.getTable()), ExecutionPurpose.UPDATE);
        MutationTrigger trigger = new MutationTrigger();
        for (ImmutableSpi changedRow : changedRows) {
            ImmutableSpi row = (ImmutableSpi)rowMap.get(changedRow.__get(idPropId));
            if (row.__equals((Object)changedRow, true)) continue;
            trigger.modifyEntityTable(row, changedRow);
        }
        trigger.submit(this.getSqlClient(), con);
        return affectRowCount;
    }

    @Override
    public void accept(@NotNull AstVisitor visitor) {
        this.accept(visitor, true);
    }

    @Override
    public void renderTo(@NotNull SqlBuilder builder) {
        this.renderTo(builder, null);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void accept(@NotNull AstVisitor visitor, boolean visitAssignments) {
        AstContext astContext = visitor.getAstContext();
        astContext.pushStatement(this);
        try {
            Predicate predicate;
            if (visitAssignments) {
                for (Map.Entry<Target, Expression<?>> e : this.assignmentMap.entrySet()) {
                    ((Ast)((Object)e.getKey().expr)).accept(visitor);
                    ((Ast)((Object)e.getValue())).accept(visitor);
                }
            }
            if ((predicate = this.getPredicate()) != null) {
                ((Ast)((Object)predicate)).accept(visitor);
            }
        }
        finally {
            astContext.popStatement();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void renderTo(@NotNull SqlBuilder builder, Collection<Object> ids) {
        AstContext astContext = builder.getAstContext();
        astContext.pushStatement(this);
        try {
            TableImplementor<?> table = this.getTableImplementor();
            Dialect dialect = this.getSqlClient().getDialect();
            this.accept(new VisitorImpl(builder.getAstContext(), dialect));
            builder.sql("update ").sql(table.getImmutableType().getTableName()).sql(" ").sql(table.getAlias());
            UpdateJoin updateJoin = dialect.getUpdateJoin();
            if (updateJoin != null && updateJoin.getFrom() == UpdateJoin.From.UNNECESSARY) {
                for (TableImplementor tableImplementor : table) {
                    tableImplementor.renderTo(builder);
                }
            }
            builder.sql(" set ");
            this.renderAssignments(builder);
            this.renderTables(builder);
            this.renderDeeperJoins(builder);
            this.renderPredicates(builder, true, ids);
        }
        finally {
            astContext.popStatement();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void renderAsSelect(SqlBuilder builder, Collection<Object> ids) {
        AstContext astContext = builder.getAstContext();
        astContext.pushStatement(this);
        try {
            this.accept(new VisitorImpl(builder.getAstContext(), null), false);
            TableImplementor<?> table = this.getTableImplementor();
            builder.sql("select ");
            boolean addComma = false;
            for (ImmutableProp prop : table.getImmutableType().getSelectableProps().values()) {
                if (addComma) {
                    builder.sql(", ");
                } else {
                    addComma = true;
                }
                builder.sql(table.getAlias(), (ColumnDefinition)prop.getStorage());
            }
            if (ids != null) {
                builder.sql(" from ").sql(table.getImmutableType().getTableName()).sql(" as ").sql(table.getAlias()).sql(" where ").sql(table.getAlias(), (ColumnDefinition)table.getImmutableType().getIdProp().getStorage(), true).sql(" in (");
                addComma = false;
                for (Object id : ids) {
                    if (addComma) {
                        builder.sql(", ");
                    } else {
                        addComma = true;
                    }
                    builder.variable(id);
                }
                builder.sql(")");
            } else {
                table.renderTo(builder);
                this.renderPredicates(builder, false, null);
            }
        }
        finally {
            astContext.popStatement();
        }
    }

    private void renderAssignments(SqlBuilder builder) {
        TableImplementor<?> table = this.getTableImplementor();
        UpdateJoin updateJoin = this.getSqlClient().getDialect().getUpdateJoin();
        boolean withTargetPrefix = updateJoin != null && updateJoin.isJoinedTableUpdatable() && MutableUpdateImpl.hasUsedChild(table, builder.getAstContext());
        String separator = "";
        for (Map.Entry<Target, Expression<?>> e : this.assignmentMap.entrySet()) {
            builder.sql(separator);
            this.renderTarget(builder, e.getKey(), withTargetPrefix);
            builder.sql(" = ");
            ((Ast)((Object)e.getValue())).renderTo(builder);
            separator = ", ";
        }
    }

    private void renderTarget(SqlBuilder builder, Target target, boolean withPrefix) {
        TableImplementor<?> impl = TableProxies.resolve(target.table, builder.getAstContext());
        impl.renderSelection(target.prop, builder, (ColumnDefinition)target.expr.getPartial(), withPrefix);
    }

    private void renderTables(SqlBuilder builder) {
        TableImplementor<?> table = this.getTableImplementor();
        if (MutableUpdateImpl.hasUsedChild(table, builder.getAstContext())) {
            switch (this.getSqlClient().getDialect().getUpdateJoin().getFrom()) {
                case AS_ROOT: {
                    table.renderTo(builder);
                    break;
                }
                case AS_JOIN: {
                    builder.sql(" from ");
                    String separator = "";
                    for (TableImplementor tableImplementor : table) {
                        builder.sql(separator);
                        tableImplementor.renderJoinAsFrom(builder, TableImplementor.RenderMode.FROM_ONLY);
                        separator = ",";
                    }
                    break;
                }
            }
        }
    }

    private void renderDeeperJoins(SqlBuilder builder) {
        TableImplementor<?> table = this.getTableImplementor();
        UpdateJoin updateJoin = this.getSqlClient().getDialect().getUpdateJoin();
        if (updateJoin != null && updateJoin.getFrom() == UpdateJoin.From.AS_JOIN && MutableUpdateImpl.hasUsedChild(table, builder.getAstContext())) {
            for (TableImplementor tableImplementor : table) {
                tableImplementor.renderJoinAsFrom(builder, TableImplementor.RenderMode.DEEPER_JOIN_ONLY);
            }
        }
    }

    private void renderPredicates(SqlBuilder builder, boolean forUpdate, Collection<Object> ids) {
        Predicate predicate;
        TableImplementor<?> table = this.getTableImplementor();
        UpdateJoin updateJoin = this.getSqlClient().getDialect().getUpdateJoin();
        String separator = " where ";
        if (ids != null) {
            ImmutableProp idProp = table.getImmutableType().getIdProp();
            builder.sql(separator).sql(table.getAlias(), (ColumnDefinition)idProp.getStorage(), true).sql(" in (");
            boolean bl = false;
            for (Object id : ids) {
                boolean bl2;
                if (bl2) {
                    builder.sql(", ");
                } else {
                    bl2 = true;
                }
                builder.variable(id);
            }
            builder.sql(")");
            separator = " and ";
        }
        if (forUpdate && updateJoin != null && updateJoin.getFrom() == UpdateJoin.From.AS_JOIN && MutableUpdateImpl.hasUsedChild(table, builder.getAstContext())) {
            for (TableImplementor tableImplementor : table) {
                builder.sql(separator);
                separator = " and ";
                tableImplementor.renderJoinAsFrom(builder, TableImplementor.RenderMode.WHERE_ONLY);
            }
        }
        if (ids == null && (predicate = this.getPredicate()) != null) {
            builder.sql(separator);
            ((Ast)((Object)predicate)).renderTo(builder);
        }
    }

    private static boolean hasUsedChild(TableImplementor<?> tableImplementor, AstContext astContext) {
        for (TableImplementor tableImplementor2 : tableImplementor) {
            if (astContext.getTableUsedState(tableImplementor2) != TableUsedState.USED) continue;
            return true;
        }
        return false;
    }

    private static class Target {
        Table<?> table;
        ImmutableProp prop;
        PropExpressionImplementor<?> expr;

        private Target(Table<?> table, ImmutableProp prop, PropExpression<?> expr) {
            this.table = table;
            this.prop = prop;
            this.expr = (PropExpressionImplementor)expr;
        }

        static Target of(PropExpression<?> expr) {
            ImmutableProp prop;
            Table<?> parent;
            PropExpressionImplementor implementor = (PropExpressionImplementor)expr;
            EmbeddedColumns.Partial partial = implementor.getPartial();
            if (partial != null && partial.isEmbedded()) {
                throw new IllegalArgumentException("The property \"" + implementor + "\" is embedded, it cannot be used as the assignment target of update statement");
            }
            Table<?> targetTable = implementor.getTable();
            if (targetTable instanceof TableImplementor) {
                parent = ((TableImplementor)targetTable).getParent();
                prop = ((TableImplementor)targetTable).getJoinProp();
            } else {
                parent = ((TableProxy)targetTable).__parent();
                prop = ((TableProxy)targetTable).__prop();
            }
            if (parent != null && prop != null && implementor.getProp().isId()) {
                return new Target(parent, prop, expr);
            }
            return new Target(targetTable, implementor.getProp(), expr);
        }

        public boolean equals(Object o) {
            if (this == o) {
                return true;
            }
            if (o == null || this.getClass() != o.getClass()) {
                return false;
            }
            Target target = (Target)o;
            return this.table.equals(target.table) && this.prop.equals((Object)target.prop);
        }

        public int hashCode() {
            return Objects.hash(this.table, this.prop);
        }
    }

    private static class VisitorImpl
    extends UseTableVisitor {
        private final Dialect dialect;

        public VisitorImpl(AstContext astContext, Dialect dialect) {
            super(astContext);
            this.dialect = dialect;
        }

        @Override
        public void visitTableReference(TableImplementor<?> table, ImmutableProp prop) {
            super.visitTableReference(table, prop);
            if (this.dialect != null) {
                this.validateTable(table);
            }
        }

        private void validateTable(TableImplementor<?> tableImpl) {
            if (this.getAstContext().getTableUsedState(tableImpl) == TableUsedState.USED) {
                if (tableImpl.getParent() != null && this.dialect.getUpdateJoin() == null) {
                    throw new ExecutionException("Table joins for update statement is forbidden by the current dialect, but there is a join '" + tableImpl + "'.");
                }
                if (tableImpl.getParent() != null && tableImpl.getParent().getParent() == null && tableImpl.getJoinType() != JoinType.INNER && this.dialect.getUpdateJoin() != null && this.dialect.getUpdateJoin().getFrom() == UpdateJoin.From.AS_JOIN) {
                    throw new ExecutionException("The first level table joins cannot be outer join because current dialect '" + this.dialect.getClass().getName() + "' indicates that the first level table joins in update statement must be rendered as 'from' clause, but there is a first level table join whose join type is outer: '" + tableImpl + "'.");
                }
            }
            if (tableImpl.getParent() != null) {
                this.validateTable(tableImpl.getParent());
            }
        }
    }
}

