/*
 * Decompiled with CFR 0.152.
 */
package org.babyfish.jimmer.sql.ast.impl.mutation;

import java.sql.Connection;
import java.sql.PreparedStatement;
import java.sql.ResultSet;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.HashSet;
import java.util.LinkedHashMap;
import java.util.LinkedHashSet;
import java.util.List;
import java.util.Map;
import java.util.Set;
import org.babyfish.jimmer.meta.ImmutableProp;
import org.babyfish.jimmer.meta.ImmutableType;
import org.babyfish.jimmer.meta.LogicalDeletedInfo;
import org.babyfish.jimmer.meta.TargetLevel;
import org.babyfish.jimmer.meta.impl.DatabaseIdentifiers;
import org.babyfish.jimmer.runtime.DraftSpi;
import org.babyfish.jimmer.runtime.ImmutableSpi;
import org.babyfish.jimmer.runtime.Internal;
import org.babyfish.jimmer.sql.DissociateAction;
import org.babyfish.jimmer.sql.DraftInterceptor;
import org.babyfish.jimmer.sql.Key;
import org.babyfish.jimmer.sql.ManyToOne;
import org.babyfish.jimmer.sql.OnDissociate;
import org.babyfish.jimmer.sql.OneToOne;
import org.babyfish.jimmer.sql.ast.Predicate;
import org.babyfish.jimmer.sql.ast.PropExpression;
import org.babyfish.jimmer.sql.ast.impl.AstContext;
import org.babyfish.jimmer.sql.ast.impl.mutation.AbstractEntitySaveCommandImpl;
import org.babyfish.jimmer.sql.ast.impl.mutation.ChildTableOperator;
import org.babyfish.jimmer.sql.ast.impl.mutation.DeleteCommandImpl;
import org.babyfish.jimmer.sql.ast.impl.mutation.Deleter;
import org.babyfish.jimmer.sql.ast.impl.mutation.IdAndKeyFetchers;
import org.babyfish.jimmer.sql.ast.impl.mutation.MiddleTableOperator;
import org.babyfish.jimmer.sql.ast.impl.mutation.MutationTrigger;
import org.babyfish.jimmer.sql.ast.impl.mutation.SaverCache;
import org.babyfish.jimmer.sql.ast.impl.query.Queries;
import org.babyfish.jimmer.sql.ast.mutation.AffectedTable;
import org.babyfish.jimmer.sql.ast.mutation.SaveMode;
import org.babyfish.jimmer.sql.ast.mutation.SimpleSaveResult;
import org.babyfish.jimmer.sql.ast.tuple.Tuple2;
import org.babyfish.jimmer.sql.fetcher.impl.FetcherImpl;
import org.babyfish.jimmer.sql.meta.ColumnDefinition;
import org.babyfish.jimmer.sql.meta.IdGenerator;
import org.babyfish.jimmer.sql.meta.IdentityIdGenerator;
import org.babyfish.jimmer.sql.meta.SequenceIdGenerator;
import org.babyfish.jimmer.sql.meta.SingleColumn;
import org.babyfish.jimmer.sql.meta.UserIdGenerator;
import org.babyfish.jimmer.sql.runtime.Converters;
import org.babyfish.jimmer.sql.runtime.ExecutionException;
import org.babyfish.jimmer.sql.runtime.ExecutionPurpose;
import org.babyfish.jimmer.sql.runtime.SaveErrorCode;
import org.babyfish.jimmer.sql.runtime.SaveException;
import org.babyfish.jimmer.sql.runtime.SavePath;
import org.babyfish.jimmer.sql.runtime.ScalarProvider;
import org.babyfish.jimmer.sql.runtime.SqlBuilder;

class Saver {
    private final AbstractEntitySaveCommandImpl.Data data;
    private final Connection con;
    private final SaverCache cache;
    private final MutationTrigger trigger;
    private final boolean triggerSubmitImmediately;
    private final Map<AffectedTable, Integer> affectedRowCountMap;
    private final SavePath path;
    private boolean triggerSubmitted;

    Saver(AbstractEntitySaveCommandImpl.Data data, Connection con, ImmutableType type) {
        this(data, con, type, new SaverCache(data), true, new LinkedHashMap<AffectedTable, Integer>());
    }

    Saver(AbstractEntitySaveCommandImpl.Data data, Connection con, ImmutableType type, SaverCache cache, boolean triggerSubmitImmediately, Map<AffectedTable, Integer> affectedRowCountMap) {
        this.data = data;
        this.con = con;
        this.cache = cache;
        this.trigger = data.getTriggers() != null ? new MutationTrigger() : null;
        this.triggerSubmitImmediately = triggerSubmitImmediately && this.trigger != null;
        this.affectedRowCountMap = affectedRowCountMap;
        this.path = SavePath.root(type);
    }

    Saver(Saver base, AbstractEntitySaveCommandImpl.Data data, ImmutableProp prop) {
        this.data = data;
        this.con = base.con;
        this.cache = base.cache;
        this.trigger = base.trigger;
        this.triggerSubmitImmediately = this.trigger != null;
        this.affectedRowCountMap = base.affectedRowCountMap;
        this.path = base.path.to(prop);
    }

    public <E> SimpleSaveResult<E> save(E entity) {
        ImmutableType immutableType = ImmutableType.get(entity.getClass());
        Object newEntity = Internal.produce((ImmutableType)immutableType, entity, draft -> this.saveImpl((DraftSpi)draft), this.trigger == null ? null : this.trigger::prepareSubmit);
        if (this.triggerSubmitImmediately) {
            this.submitTrigger();
        }
        return new SimpleSaveResult<Object>(this.affectedRowCountMap, entity, newEntity);
    }

    public void submitTrigger() {
        if (this.trigger != null && !this.triggerSubmitted) {
            this.trigger.submit(this.data.getSqlClient(), this.con);
            this.triggerSubmitted = true;
        }
    }

    private void saveImpl(DraftSpi draftSpi) {
        this.saveAssociations(draftSpi, ObjectType.EXISTING, true);
        ObjectType objectType = this.saveSelf(draftSpi);
        this.saveAssociations(draftSpi, objectType, false);
    }

    private void saveAssociations(DraftSpi currentDraftSpi, ObjectType currentObjectType, boolean forParent) {
        ImmutableType currentType = currentDraftSpi.__type();
        for (ImmutableProp prop : currentType.getProps().values()) {
            MiddleTableOperator middleTableOperator;
            if (!prop.isAssociation(TargetLevel.ENTITY) || prop.getStorage() instanceof ColumnDefinition != forParent || !currentDraftSpi.__isLoaded(prop.getId())) continue;
            ImmutableType targetType = prop.getTargetType();
            if (prop.isRemote() && prop.getMappedBy() != null) {
                throw new SaveException(SaveErrorCode.REVERSED_REMOTE_ASSOCIATION, this.path, "The property \"" + prop + "\" which is reversed(with `mappedBy`) remote(across different microservices) association cannot be supported by save command");
            }
            int currentIdPropId = currentType.getIdProp().getId();
            Object currentId = currentDraftSpi.__isLoaded(currentIdPropId) ? currentDraftSpi.__get(currentIdPropId) : null;
            ImmutableProp mappedBy = prop.getMappedBy();
            ChildTableOperator childTableOperator = null;
            if (!prop.isRemote() && mappedBy != null && mappedBy.getStorage() instanceof ColumnDefinition) {
                childTableOperator = new ChildTableOperator(this.data.getSqlClient(), this.con, mappedBy, this.data.isPessimisticLockRequired(), this.cache, this.trigger);
            }
            Object associatedValue = currentDraftSpi.__get(prop.getId());
            LinkedHashSet<Object> associatedObjectIds = new LinkedHashSet<Object>();
            if (associatedValue == null) {
                if (prop.isInputNotNull()) {
                    throw new SaveException(SaveErrorCode.NULL_TARGET, this.path, "The association \"" + prop + "\" cannot be null, because that association is decorated by \"@" + (prop.getAnnotation(ManyToOne.class) != null ? ManyToOne.class : OneToOne.class).getName() + "\" whose `inputNotNull` is true");
                }
            } else {
                List<DraftSpi> associatedObjects = associatedValue instanceof List ? (List<DraftSpi>)associatedValue : Collections.singletonList((DraftSpi)associatedValue);
                List<Object> idOnlyTargetIds = Collections.emptyList();
                if (this.data.isAutoCheckingProp(prop) || childTableOperator != null) {
                    int targetIdPropId = prop.getTargetType().getIdProp().getId();
                    idOnlyTargetIds = new ArrayList();
                    for (DraftSpi associatedObject : associatedObjects) {
                        if (!this.isNonIdPropLoaded((ImmutableSpi)associatedObject, false)) {
                            idOnlyTargetIds.add(associatedObject.__get(targetIdPropId));
                            continue;
                        }
                        if (!prop.isRemote()) continue;
                        throw new SaveException(SaveErrorCode.LONG_REMOTE_ASSOCIATION, this.path, "The property \"" + prop + "\" is remote(across different microservices) association, but it has associated object which is not id-only");
                    }
                }
                if (this.data.isAutoCheckingProp(prop)) {
                    this.validateIdOnlyTargetIds(prop, idOnlyTargetIds);
                }
                if (childTableOperator != null) {
                    for (DraftSpi associatedObject : associatedObjects) {
                        if (!this.isNonIdPropLoaded((ImmutableSpi)associatedObject, false)) continue;
                        associatedObject.__set(mappedBy.getId(), Internal.produce((ImmutableType)currentType, null, backRef -> ((DraftSpi)backRef).__set(currentIdPropId, currentId)));
                    }
                    if (!idOnlyTargetIds.isEmpty()) {
                        int rowCount = childTableOperator.setParent(currentId, idOnlyTargetIds);
                        this.addOutput(AffectedTable.of(targetType), rowCount);
                    }
                }
                for (DraftSpi associatedObject : associatedObjects) {
                    associatedObjectIds.add(this.saveAssociatedObjectAndGetId(prop, associatedObject));
                }
            }
            if (childTableOperator != null && currentObjectType != ObjectType.NEW && !this.data.isAppendOnly(prop)) {
                DissociateAction dissociateAction = this.data.getDissociateAction(prop.getMappedBy());
                if (dissociateAction == DissociateAction.DELETE) {
                    List<Object> detachedTargetIds = childTableOperator.getDetachedChildIds(currentId, associatedObjectIds);
                    Deleter deleter = new Deleter(new DeleteCommandImpl.Data(this.data.getSqlClient(), this.data.getDeleteMode(), this.data.dissociateActionMap()), this.con, this.cache, this.trigger, this.affectedRowCountMap);
                    deleter.addPreHandleInput(prop.getTargetType(), detachedTargetIds);
                    deleter.execute(false);
                } else if (dissociateAction == DissociateAction.SET_NULL) {
                    int rowCount = childTableOperator.unsetParent(currentId, associatedObjectIds);
                    this.addOutput(AffectedTable.of(targetType), rowCount);
                } else if (childTableOperator.exists(currentId, associatedObjectIds)) {
                    throw new SaveException(SaveErrorCode.CANNOT_DISSOCIATE_TARGETS, this.path.to(prop), "Cannot dissociate child objects because the dissociation action of the many-to-one property \"" + mappedBy + "\" is not configured as \"set null\" or \"cascade\". There are two ways to resolve this issue: Decorate the many-to-one property \"" + mappedBy + "\" by @" + OnDissociate.class.getName() + " whose argument is `DissociateAction.SET_NULL` or `DissociateAction.DELETE` , or use save command's runtime configuration to override it");
                }
            }
            if ((middleTableOperator = MiddleTableOperator.tryGet(this.data.getSqlClient(), this.con, prop, this.trigger)) == null) continue;
            int rowCount = currentObjectType == ObjectType.NEW || this.data.isAppendOnly(prop) ? middleTableOperator.addTargetIds(currentId, associatedObjectIds) : middleTableOperator.setTargetIds(currentId, associatedObjectIds);
            this.addOutput(AffectedTable.of(prop), rowCount);
        }
    }

    private void validateIdOnlyTargetIds(ImmutableProp prop, List<Object> targetIds) {
        if (targetIds.isEmpty()) {
            return;
        }
        LinkedHashSet<Object> illegalTargetIds = new LinkedHashSet<Object>(targetIds);
        if (prop.isRemote()) {
            List<ImmutableSpi> targets;
            int targetIdPropId = prop.getTargetType().getIdProp().getId();
            try {
                targets = this.data.getSqlClient().getMicroServiceExchange().findByIds(prop.getTargetType().getMicroServiceName(), targetIds, new FetcherImpl(prop.getTargetType().getJavaClass()));
            }
            catch (Exception ex) {
                throw new SaveException(SaveErrorCode.FAILED_REMOTE_VALIDATION, this.path, "Cannot validate the id-only associated objects of remote association \"" + prop + "\"");
            }
            for (ImmutableSpi target : targets) {
                illegalTargetIds.remove(target.__get(targetIdPropId));
            }
        } else {
            List existingTargetIds = (List)Queries.createQuery(this.data.getSqlClient(), prop.getTargetType(), ExecutionPurpose.MUTATE, true, (q, t) -> {
                PropExpression idExpr = (PropExpression)t.get(prop.getTargetType().getIdProp().getName());
                q.where(new Predicate[]{idExpr.in(targetIds)});
                return q.select(idExpr);
            }).execute(this.con);
            illegalTargetIds.removeAll(new HashSet(existingTargetIds));
        }
        if (!illegalTargetIds.isEmpty()) {
            throw new SaveException(SaveErrorCode.ILLEGAL_TARGET_ID, this.path.to(prop), "Illegal ids: " + illegalTargetIds);
        }
    }

    private Object saveAssociatedObjectAndGetId(ImmutableProp prop, DraftSpi associatedDraftSpi) {
        if (this.isNonIdPropLoaded((ImmutableSpi)associatedDraftSpi, true)) {
            AbstractEntitySaveCommandImpl.Data associatedData = new AbstractEntitySaveCommandImpl.Data(this.data);
            associatedData.setMode(this.data.isAutoAttachingProp(prop) ? SaveMode.UPSERT : SaveMode.UPDATE_ONLY);
            Saver associatedSaver = new Saver(this, associatedData, prop);
            associatedSaver.saveImpl(associatedDraftSpi);
        }
        return associatedDraftSpi.__get(associatedDraftSpi.__type().getIdProp().getId());
    }

    private ObjectType saveSelf(DraftSpi draftSpi) {
        if (this.cache.isSaved((ImmutableSpi)draftSpi)) {
            return ObjectType.EXISTING;
        }
        if (this.data.getMode() == SaveMode.INSERT_ONLY) {
            if (this.trigger != null) {
                this.trigger.modifyEntityTable(null, draftSpi);
            }
            this.insert(draftSpi);
            return ObjectType.NEW;
        }
        if (this.trigger == null && this.data.getMode() == SaveMode.UPDATE_ONLY && draftSpi.__isLoaded(draftSpi.__type().getIdProp().getId())) {
            this.update(draftSpi, false);
            return ObjectType.EXISTING;
        }
        ImmutableSpi existingSpi = this.find(draftSpi);
        if (existingSpi != null) {
            boolean updated;
            int idPropId = draftSpi.__type().getIdProp().getId();
            if (draftSpi.__isLoaded(idPropId)) {
                updated = this.update(draftSpi, false);
            } else {
                draftSpi.__set(idPropId, existingSpi.__get(idPropId));
                updated = this.update(draftSpi, true);
            }
            if (updated && this.trigger != null) {
                this.trigger.modifyEntityTable(existingSpi, draftSpi);
            }
            return ObjectType.EXISTING;
        }
        if (this.data.getMode() == SaveMode.UPDATE_ONLY) {
            if (this.path.getParent() == null) {
                this.addOutput(AffectedTable.of(draftSpi.__type()), 0);
                return ObjectType.UNKNOWN;
            }
            String guide = this.path.getType().isKotlinClass() ? "call `setAutoAttaching(" + this.path.getProp().getDeclaringType().getJavaClass().getSimpleName() + "::" + this.path.getProp().getName() + ")` or `setAutoAttachingAll()` of the save command" : "call `setAutoAttaching(" + this.path.getProp().getDeclaringType().getJavaClass().getSimpleName() + "Props." + DatabaseIdentifiers.databaseIdentifier((String)this.path.getProp().getName()) + ")` or `setAutoAttachingAll()` of the save command";
            throw new SaveException(SaveErrorCode.CANNOT_CREATE_TARGET, this.path, "Cannot insert object because insert operation for this path is disabled, please " + guide);
        }
        if (this.trigger != null) {
            this.trigger.modifyEntityTable(null, draftSpi);
        }
        this.insert(draftSpi);
        return ObjectType.NEW;
    }

    private void insert(DraftSpi draftSpi) {
        String overrideIdentityIdSql;
        Object id;
        this.callInterceptor(draftSpi, true);
        ImmutableType type = draftSpi.__type();
        IdGenerator idGenerator = this.data.getSqlClient().getIdGenerator(type.getJavaClass());
        Object object = id = draftSpi.__isLoaded(type.getIdProp().getId()) ? draftSpi.__get(type.getIdProp().getId()) : null;
        if (id == null) {
            if (idGenerator == null) {
                throw new SaveException(SaveErrorCode.NO_ID_GENERATOR, this.path, "Cannot save \"" + type + "\" without id because id generator is not specified");
            }
            if (idGenerator instanceof SequenceIdGenerator) {
                String sql = this.data.getSqlClient().getDialect().getSelectIdFromSequenceSql(((SequenceIdGenerator)idGenerator).getSequenceName());
                id = this.data.getSqlClient().getExecutor().execute(this.con, sql, Collections.emptyList(), ExecutionPurpose.MUTATE, null, stmt -> {
                    try (ResultSet rs = stmt.executeQuery();){
                        rs.next();
                        Object object = rs.getObject(1);
                        return object;
                    }
                });
                this.setDraftId(draftSpi, id);
            } else if (idGenerator instanceof UserIdGenerator) {
                id = ((UserIdGenerator)idGenerator).generate(type.getJavaClass());
                this.setDraftId(draftSpi, id);
            } else if (!(idGenerator instanceof IdentityIdGenerator)) {
                throw new SaveException(SaveErrorCode.ILLEGAL_ID_GENERATOR, this.path, "Illegal id generator type: \"" + idGenerator.getClass().getName() + "\", id generator must be sub type of \"" + SequenceIdGenerator.class.getName() + "\", \"" + IdentityIdGenerator.class.getName() + "\" or \"" + UserIdGenerator.class.getName() + "\"");
            }
        }
        if (type.getVersionProp() != null && !draftSpi.__isLoaded(type.getVersionProp().getId())) {
            draftSpi.__set(type.getVersionProp().getId(), (Object)0);
        }
        ArrayList<ImmutableProp> props = new ArrayList<ImmutableProp>();
        ArrayList values = new ArrayList();
        for (ImmutableProp prop : draftSpi.__type().getProps().values()) {
            if (!(prop.getStorage() instanceof ColumnDefinition) || !draftSpi.__isLoaded(prop.getId())) continue;
            props.add(prop);
            Object value = draftSpi.__get(prop.getId());
            if (value != null) {
                if (prop.isReference(TargetLevel.ENTITY)) {
                    value = ((ImmutableSpi)value).__get(prop.getTargetType().getIdProp().getId());
                } else {
                    ScalarProvider scalarProvider = this.data.getSqlClient().getScalarProvider(prop);
                    if (scalarProvider != null) {
                        try {
                            value = scalarProvider.toSql(value);
                        }
                        catch (Exception ex) {
                            throw new ExecutionException("Cannot convert the value of \"" + prop + "\" by the scalar provider \"" + scalarProvider.getClass().getName() + "\"", ex);
                        }
                    }
                }
            }
            values.add(value);
        }
        if (props.isEmpty()) {
            throw new SaveException(SaveErrorCode.NO_NON_ID_PROPS, this.path, "Cannot insert \"" + type + "\" without any properties");
        }
        SqlBuilder builder = new SqlBuilder(new AstContext(this.data.getSqlClient()));
        builder.sql("insert into ").sql(type.getTableName()).sql("(");
        String separator = "";
        for (ImmutableProp prop : props) {
            builder.sql(separator);
            separator = ", ";
            builder.sql((ColumnDefinition)prop.getStorage());
        }
        builder.sql(")");
        if (id != null && idGenerator instanceof IdentityIdGenerator && (overrideIdentityIdSql = this.data.getSqlClient().getDialect().getOverrideIdentityIdSql()) != null) {
            builder.sql(" ").sql(overrideIdentityIdSql);
        }
        builder.sql(" values").enterTuple();
        separator = "";
        int size = values.size();
        for (int i = 0; i < size; ++i) {
            builder.sql(separator);
            separator = ", ";
            Object value = values.get(i);
            if (value != null) {
                builder.variable(value);
                continue;
            }
            builder.nullVariable((ImmutableProp)props.get(i));
        }
        builder.leaveTuple();
        Tuple2<String, List<Object>> sqlResult = builder.build();
        boolean generateKeys = id == null;
        Object insertedResult = this.data.getSqlClient().getExecutor().execute(this.con, sqlResult.get_1(), sqlResult.get_2(), ExecutionPurpose.MUTATE, generateKeys ? (c, s) -> c.prepareStatement(s, 1) : null, stmt -> {
            if (generateKeys) {
                Object generatedId;
                int updateCount = stmt.executeUpdate();
                try (ResultSet rs = stmt.getGeneratedKeys();){
                    rs.next();
                    generatedId = rs.getObject(1);
                }
                return new Tuple2<Integer, Object>(updateCount, generatedId);
            }
            return stmt.executeUpdate();
        });
        int rowCount = insertedResult instanceof Tuple2 ? (Integer)((Tuple2)insertedResult).get_1() : (Integer)insertedResult;
        this.addOutput(AffectedTable.of(type), rowCount);
        if (insertedResult instanceof Tuple2) {
            id = ((Tuple2)insertedResult).get_2();
            this.setDraftId(draftSpi, id);
        }
        this.cache.save((ImmutableSpi)draftSpi, true);
    }

    private boolean update(DraftSpi draftSpi, boolean excludeKeyProps) {
        this.callInterceptor(draftSpi, false);
        ImmutableType type = draftSpi.__type();
        Set<Object> excludeProps = null;
        if (excludeKeyProps) {
            excludeProps = this.data.getKeyProps(type);
        }
        if (excludeProps == null) {
            excludeProps = Collections.emptySet();
        }
        ArrayList<ImmutableProp> updatedProps = new ArrayList<ImmutableProp>();
        ArrayList<Object> updatedValues = new ArrayList<Object>();
        Integer version = null;
        for (ImmutableProp prop : type.getProps().values()) {
            if (!(prop.getStorage() instanceof ColumnDefinition) || !draftSpi.__isLoaded(prop.getId())) continue;
            if (prop.isVersion()) {
                version = (Integer)draftSpi.__get(prop.getId());
                continue;
            }
            if (prop.isId() || excludeProps.contains(prop)) continue;
            updatedProps.add(prop);
            Object value = draftSpi.__get(prop.getId());
            if (value != null && prop.isReference(TargetLevel.ENTITY)) {
                value = ((ImmutableSpi)value).__get(prop.getTargetType().getIdProp().getId());
            }
            updatedValues.add(value);
        }
        if (type.getVersionProp() != null && version == null) {
            throw new SaveException(SaveErrorCode.NO_VERSION, this.path, "Cannot update \"" + type + "\", the version property \"" + type.getVersionProp() + "\" is unloaded");
        }
        if (updatedProps.isEmpty() && version == null) {
            return false;
        }
        SqlBuilder builder = new SqlBuilder(new AstContext(this.data.getSqlClient()));
        builder.sql("update ").sql(type.getTableName()).sql(" set ");
        String separator = "";
        int updatedCount = updatedProps.size();
        for (int i = 0; i < updatedCount; ++i) {
            builder.sql(separator);
            separator = ", ";
            builder.assignment((ImmutableProp)updatedProps.get(i), updatedValues.get(i));
        }
        if (version != null) {
            String versionColumName = ((SingleColumn)type.getVersionProp().getStorage()).getName();
            builder.sql(separator).sql(versionColumName).sql(" = ").sql(versionColumName).sql(" + 1");
        }
        builder.sql(" where ");
        builder.sql(null, (ColumnDefinition)type.getIdProp().getStorage(), true).sql(" = ").variable(draftSpi.__get(type.getIdProp().getId()));
        if (version != null) {
            builder.sql(" and ").sql(((SingleColumn)type.getVersionProp().getStorage()).getName()).sql(" = ").variable(version);
        }
        Tuple2<String, List<Object>> sqlResult = builder.build();
        int rowCount = this.data.getSqlClient().getExecutor().execute(this.con, sqlResult.get_1(), sqlResult.get_2(), ExecutionPurpose.MUTATE, null, PreparedStatement::executeUpdate);
        if (rowCount != 0) {
            this.addOutput(AffectedTable.of(type), rowCount);
            if (version != null) {
                Saver.increaseDraftVersion(draftSpi);
            }
            this.cache.save((ImmutableSpi)draftSpi, true);
        } else if (version != null) {
            throw new SaveException(SaveErrorCode.ILLEGAL_VERSION, this.path, "Cannot update the entity whose type is \"" + type + "\", id is \"" + draftSpi.__get(type.getIdProp().getId()) + "\" and version is \"" + version + "\"");
        }
        return true;
    }

    private void callInterceptor(DraftSpi draftSpi, boolean insert) {
        DraftInterceptor<?> interceptor;
        ImmutableType type = draftSpi.__type();
        LogicalDeletedInfo info = type.getLogicalDeletedInfo();
        if (info != null) {
            draftSpi.__set(info.getProp().getId(), info.getRestoredValue());
        }
        if ((interceptor = this.data.getSqlClient().getDraftInterceptor(type)) != null) {
            int idPropId = type.getIdProp().getId();
            Object id = draftSpi.__isLoaded(idPropId) ? draftSpi.__get(type.getIdProp().getId()) : null;
            interceptor.beforeSave(draftSpi, insert);
            if (id != null) {
                if (!draftSpi.__isLoaded(idPropId)) {
                    throw new IllegalStateException("Draft interceptor cannot be used to unload id");
                }
                if (!id.equals(draftSpi.__get(idPropId))) {
                    throw new IllegalStateException("Draft interceptor cannot be used to change id");
                }
            }
        }
    }

    private ImmutableSpi find(DraftSpi example) {
        ImmutableSpi spi;
        ImmutableSpi cached;
        ImmutableProp prop = this.path.getProp();
        boolean requiresKey = prop != null && !this.data.isAppendOnly(prop);
        try {
            cached = this.cache.find((ImmutableSpi)example, requiresKey);
        }
        catch (IllegalArgumentException ex) {
            throw new SaveException(SaveErrorCode.NO_KEY_PROPS, this.path, ex.getMessage());
        }
        if (cached != null) {
            return cached;
        }
        ImmutableType type = example.__type();
        Collection<ImmutableProp> actualKeyProps = this.actualKeyProps((ImmutableSpi)example, requiresKey);
        if (actualKeyProps == null || actualKeyProps.isEmpty()) {
            return null;
        }
        List rows = (List)Internal.requiresNewDraftContext(ctx -> {
            List list = (List)Queries.createQuery(this.data.getSqlClient(), type, ExecutionPurpose.MUTATE, true, (q, table) -> {
                for (ImmutableProp keyProp : actualKeyProps) {
                    if (keyProp.isReference(TargetLevel.ENTITY)) {
                        ImmutableProp targetIdProp = keyProp.getTargetType().getIdProp();
                        Object targetIdExpression = table.join(keyProp.getName()).get(targetIdProp.getName());
                        ImmutableSpi target = (ImmutableSpi)example.__get(keyProp.getId());
                        if (target != null) {
                            q.where(new Predicate[]{targetIdExpression.eq((Object)target.__get(targetIdProp.getId()))});
                            continue;
                        }
                        q.where(new Predicate[]{targetIdExpression.isNull()});
                        continue;
                    }
                    Object value = example.__get(keyProp.getId());
                    if (value != null) {
                        q.where(new Predicate[]{table.get(keyProp.getName()).eq((Object)value)});
                        continue;
                    }
                    q.where(new Predicate[]{table.get(keyProp.getName()).isNull()});
                }
                if (this.trigger != null) {
                    return q.select(table);
                }
                return q.select(table.fetch(IdAndKeyFetchers.getFetcher(type)));
            }).forUpdate(this.data.isPessimisticLockRequired()).execute(this.con);
            return ctx.resolveList(list);
        });
        if (rows.size() > 1) {
            throw new SaveException(SaveErrorCode.KEY_NOT_UNIQUE, this.path, "Key properties " + actualKeyProps + " cannot guarantee uniqueness under that path");
        }
        ImmutableSpi immutableSpi = spi = rows.isEmpty() ? null : (ImmutableSpi)rows.get(0);
        if (spi != null) {
            this.cache.save(spi, false);
        }
        return spi;
    }

    private Collection<ImmutableProp> actualKeyProps(ImmutableSpi spi, boolean requiresKey) {
        Object id;
        ImmutableType type = spi.__type();
        ImmutableProp idProp = type.getIdProp();
        Object object = id = spi.__isLoaded(idProp.getId()) ? spi.__get(idProp.getId()) : null;
        if (id != null) {
            return Collections.singleton(idProp);
        }
        Set<ImmutableProp> keyProps = this.data.getKeyProps(type);
        if (keyProps == null && requiresKey) {
            throw new SaveException(SaveErrorCode.NO_KEY_PROPS, this.path, "Cannot save \"" + type + "\" that have no properties decorated by \"@" + Key.class.getName() + "\"");
        }
        return keyProps;
    }

    private void addOutput(AffectedTable affectTable, int affectedRowCount) {
        if (affectedRowCount != 0) {
            this.affectedRowCountMap.merge(affectTable, affectedRowCount, Integer::sum);
        }
    }

    private boolean isNonIdPropLoaded(ImmutableSpi spi, boolean validate) {
        boolean idPropLoaded = false;
        boolean nonIdPropLoaded = false;
        for (ImmutableProp prop : spi.__type().getProps().values()) {
            if (!spi.__isLoaded(prop.getId())) continue;
            if (prop.isId()) {
                idPropLoaded = true;
                continue;
            }
            nonIdPropLoaded = true;
        }
        if (nonIdPropLoaded && !idPropLoaded) {
            Set<ImmutableProp> keyProps = this.data.getKeyProps(spi.__type());
            for (ImmutableProp keyProp : keyProps) {
                if (!validate || spi.__isLoaded(keyProp.getId())) continue;
                throw new SaveException(SaveErrorCode.NEITHER_ID_NOR_KEY, this.path, "Cannot save illegal entity object " + spi + " whose type is \"" + spi.__type() + "\", key property \"" + keyProp + "\" must be loaded when id is unloaded");
            }
        } else if (validate && !idPropLoaded) {
            throw new SaveException(SaveErrorCode.NEITHER_ID_NOR_KEY, this.path, "Cannot save illegal entity object " + spi + " whose type is \"" + spi.__type() + "\", neither id nor key is specified");
        }
        return nonIdPropLoaded;
    }

    private void setDraftId(DraftSpi spi, Object id) {
        ImmutableType type = spi.__type();
        ImmutableProp idProp = type.getIdProp();
        Object convertedId = Converters.tryConvert(id, idProp.getElementClass());
        if (convertedId == null) {
            throw new SaveException(SaveErrorCode.ILLEGAL_GENERATED_ID, this.path, "The type of generated id does not match the property \"" + idProp + "\"");
        }
        spi.__set(idProp.getId(), convertedId);
    }

    private static void increaseDraftVersion(DraftSpi spi) {
        ImmutableType type = spi.__type();
        ImmutableProp versionProp = type.getVersionProp();
        spi.__set(versionProp.getId(), (Object)((Integer)spi.__get(versionProp.getId()) + 1));
    }

    private static enum ObjectType {
        UNKNOWN,
        NEW,
        EXISTING;

    }
}

