/*
 * Decompiled with CFR 0.152.
 */
package org.babyfish.jimmer.sql.loader.graphql.impl;

import java.sql.Connection;
import java.util.Collections;
import org.babyfish.jimmer.meta.ImmutableProp;
import org.babyfish.jimmer.runtime.ImmutableSpi;
import org.babyfish.jimmer.sql.JSqlClient;
import org.babyfish.jimmer.sql.ast.Executable;
import org.babyfish.jimmer.sql.ast.table.Table;
import org.babyfish.jimmer.sql.fetcher.FieldFilter;
import org.babyfish.jimmer.sql.loader.graphql.impl.DataLoader;

class SingleCommand<T>
implements Executable<T> {
    private final JSqlClient sqlClient;
    private final Connection con;
    private final ImmutableProp prop;
    private final FieldFilter<Table<ImmutableSpi>> filter;
    private final int limit;
    private final int offset;
    private final ImmutableSpi source;
    private final T defaultValue;

    public SingleCommand(JSqlClient sqlClient, Connection con, ImmutableProp prop, FieldFilter<Table<ImmutableSpi>> filter, int limit, int offset, ImmutableSpi source, T defaultValue) {
        this.sqlClient = sqlClient;
        this.con = con;
        this.prop = prop;
        this.filter = filter;
        this.limit = limit;
        this.offset = offset;
        this.source = source;
        this.defaultValue = defaultValue;
    }

    @Override
    public T execute() {
        if (this.con != null) {
            return this.executeImpl(this.con);
        }
        return (T)this.sqlClient.getConnectionManager().execute(this::executeImpl);
    }

    @Override
    public T execute(Connection con) {
        if (con != null) {
            return this.executeImpl(con);
        }
        if (this.con != null) {
            return this.executeImpl(this.con);
        }
        return (T)this.sqlClient.getConnectionManager().execute(this::executeImpl);
    }

    private T executeImpl(Connection con) {
        Object result = new DataLoader(this.sqlClient, con, this.prop, this.filter, this.limit, this.offset).load(Collections.singleton(this.source)).get(this.source);
        return (T)(result != null ? result : this.defaultValue);
    }
}

