/*
 * Decompiled with CFR 0.152.
 */
package org.babyfish.jimmer.sql.filter.impl;

import java.lang.reflect.ParameterizedType;
import java.lang.reflect.Type;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.HashMap;
import java.util.HashSet;
import java.util.LinkedHashSet;
import java.util.List;
import java.util.Map;
import java.util.Set;
import java.util.SortedMap;
import java.util.TreeMap;
import java.util.stream.Collectors;
import org.apache.commons.lang3.reflect.TypeUtils;
import org.babyfish.jimmer.impl.util.StaticCache;
import org.babyfish.jimmer.lang.Ref;
import org.babyfish.jimmer.meta.ImmutableProp;
import org.babyfish.jimmer.meta.ImmutableType;
import org.babyfish.jimmer.meta.TargetLevel;
import org.babyfish.jimmer.meta.TypedProp;
import org.babyfish.jimmer.runtime.ImmutableSpi;
import org.babyfish.jimmer.sql.JSqlClient;
import org.babyfish.jimmer.sql.ast.Predicate;
import org.babyfish.jimmer.sql.ast.impl.query.Queries;
import org.babyfish.jimmer.sql.ast.table.Props;
import org.babyfish.jimmer.sql.ast.table.PropsFor;
import org.babyfish.jimmer.sql.ast.table.Table;
import org.babyfish.jimmer.sql.ast.table.TableEx;
import org.babyfish.jimmer.sql.cache.Cache;
import org.babyfish.jimmer.sql.cache.CachesImpl;
import org.babyfish.jimmer.sql.cache.LocatedCache;
import org.babyfish.jimmer.sql.event.EntityEvent;
import org.babyfish.jimmer.sql.event.Triggers;
import org.babyfish.jimmer.sql.filter.BuiltInFilters;
import org.babyfish.jimmer.sql.filter.CacheableFilter;
import org.babyfish.jimmer.sql.filter.Filter;
import org.babyfish.jimmer.sql.filter.FilterArgs;
import org.babyfish.jimmer.sql.filter.Filters;
import org.babyfish.jimmer.sql.filter.ShardingFilter;
import org.babyfish.jimmer.sql.filter.impl.TypeAware;
import org.babyfish.jimmer.sql.meta.ColumnDefinition;
import org.babyfish.jimmer.sql.runtime.ConnectionManager;
import org.babyfish.jimmer.sql.runtime.ExecutionPurpose;

public class FilterManager
implements Filters {
    private final Set<Filter<?>> allFilters;
    private final Set<Filter<?>> disabledFilters;
    private final Map<ImmutableType, List<Filter<Props>>> filterMap;
    private final Map<ImmutableType, List<Filter<Props>>> allCacheableFilterMap;
    private final StaticCache<ImmutableType, Filter<Props>> cache = new StaticCache(this::create, true);
    private final StaticCache<ImmutableType, Filter<Props>> shardingOnlyCache = new StaticCache(this::createShardingOnly, true);
    private final StaticCache<ImmutableType, List<Filter<Props>>> allCacheableCache = new StaticCache(this::createAllCacheable, false);
    private final BuiltInFilters builtIns;
    private JSqlClient sqlClient;

    public FilterManager(BuiltInFilters builtIns, List<Filter<?>> filters, Collection<Filter<?>> disabledFilters) {
        this.builtIns = builtIns;
        this.allFilters = FilterManager.standardFilters(filters);
        this.disabledFilters = FilterManager.standardDisabledFilters(null, disabledFilters, this.allFilters);
        this.filterMap = FilterManager.filterMap(this.allFilters, this.disabledFilters);
        this.allCacheableFilterMap = FilterManager.filterMap(this.allFilters.stream().filter(it -> it instanceof CacheableFilter).collect(Collectors.toList()), Collections.emptyList());
    }

    private FilterManager(BuiltInFilters builtIns, Set<Filter<?>> filters, Set<Filter<?>> disabledFilters, Map<ImmutableType, List<Filter<Props>>> filterMap, Map<ImmutableType, List<Filter<Props>>> allCacheableFilterMap) {
        this.builtIns = builtIns;
        this.allFilters = filters;
        this.disabledFilters = disabledFilters;
        this.filterMap = filterMap;
        this.allCacheableFilterMap = allCacheableFilterMap;
    }

    @Override
    public Filter<Props> getFilter(Class<?> type, boolean shardingOnly) {
        return this.getFilter(ImmutableType.get(type), shardingOnly);
    }

    @Override
    public Filter<Props> getFilter(ImmutableType type, boolean shardingOnly) {
        if (shardingOnly) {
            return (Filter)this.shardingOnlyCache.get((Object)type);
        }
        return (Filter)this.cache.get((Object)type);
    }

    @Override
    public Filter<Props> getTargetFilter(TypedProp.Association<?, ?> prop, boolean shardingOnly) {
        return this.getTargetFilter(prop.unwrap(), shardingOnly);
    }

    @Override
    public Filter<Props> getTargetFilter(ImmutableProp prop, boolean shardingOnly) {
        ImmutableType targetType = prop.getTargetType();
        if (targetType == null) {
            throw new IllegalArgumentException("`" + prop + "` is not association property");
        }
        return this.getFilter(targetType, shardingOnly);
    }

    @Override
    public Ref<SortedMap<String, Object>> getParameterMapRef(Class<?> type) {
        return this.getParameterMapRef(ImmutableType.get(type));
    }

    @Override
    public Ref<SortedMap<String, Object>> getParameterMapRef(ImmutableType type) {
        Filter<Props> filter = this.getFilter(type);
        if (filter == null) {
            return Ref.empty();
        }
        if (filter instanceof CacheableFilter) {
            return Ref.of(((CacheableFilter)filter).getParameters());
        }
        return null;
    }

    @Override
    public Ref<SortedMap<String, Object>> getTargetParameterMapRef(ImmutableProp prop) {
        Filter<Props> filter = this.getTargetFilter(prop);
        if (filter == null) {
            return Ref.empty();
        }
        if (filter instanceof CacheableFilter) {
            return Ref.of(((CacheableFilter)filter).getParameters());
        }
        return null;
    }

    @Override
    public Ref<SortedMap<String, Object>> getTargetParameterMapRef(TypedProp.Association<?, ?> prop) {
        return this.getTargetParameterMapRef(prop.unwrap());
    }

    public FilterManager enable(Collection<Filter<?>> filters) {
        if (filters.isEmpty()) {
            return this;
        }
        HashSet disabledSet = new HashSet(this.disabledFilters);
        for (Filter<?> filter : filters) {
            disabledSet.remove(FilterManager.unwrap(filter));
        }
        if (disabledSet.size() == this.disabledFilters.size()) {
            return this;
        }
        return new FilterManager(this.builtIns, this.allFilters, disabledSet, FilterManager.filterMap(this.allFilters, disabledSet), this.allCacheableFilterMap);
    }

    public FilterManager disable(Collection<Filter<?>> filters) {
        if (filters.isEmpty()) {
            return this;
        }
        Set<Filter<?>> disabledSet = FilterManager.standardDisabledFilters(this.disabledFilters, filters, this.allFilters);
        if (disabledSet.size() == this.disabledFilters.size()) {
            return this;
        }
        return new FilterManager(this.builtIns, this.allFilters, disabledSet, FilterManager.filterMap(this.allFilters, disabledSet), this.allCacheableFilterMap);
    }

    public FilterManager enableByTypes(Collection<Class<?>> filterTypes) {
        if (filterTypes.isEmpty()) {
            return this;
        }
        ArrayList deltaSet = new ArrayList();
        for (Filter<?> filter : this.disabledFilters) {
            boolean matched = false;
            for (Class<?> expectedType : filterTypes) {
                Class<?> actualType;
                if (!expectedType.isAssignableFrom(actualType = filter instanceof TypeAware ? ((TypeAware)((Object)filter)).getFilterType() : filter.getClass())) continue;
                matched = true;
                break;
            }
            if (!matched) continue;
            deltaSet.add(filter);
        }
        return this.enable(deltaSet);
    }

    public FilterManager disableByTypes(Collection<Class<?>> filterTypes) {
        if (filterTypes.isEmpty()) {
            return this;
        }
        ArrayList deltaSet = new ArrayList();
        for (Filter<?> filter : this.allFilters) {
            boolean matched = false;
            for (Class<?> expectedType : filterTypes) {
                Class<?> actualType;
                if (!expectedType.isAssignableFrom(actualType = filter instanceof TypeAware ? ((TypeAware)((Object)filter)).getFilterType() : filter.getClass())) continue;
                matched = true;
                break;
            }
            if (!matched) continue;
            deltaSet.add(filter);
        }
        return this.disable(deltaSet);
    }

    public FilterManager disableAll() {
        return this.disable(this.allFilters);
    }

    public void initialize(JSqlClient sqlClient) {
        if (this.sqlClient != null) {
            throw new IllegalStateException("The filter manager has been initialized");
        }
        if (sqlClient.getConnectionManager() == ConnectionManager.ILLEGAL) {
            for (Filter<?> filter : this.allFilters) {
                if (!(filter instanceof CacheableFilter)) continue;
                throw new IllegalStateException("The ConnectionManager of SqlClient must be configured when \"" + CacheableFilter.class.getName() + "\" is used");
            }
        }
        this.sqlClient = sqlClient;
        this.onInitialized();
    }

    @Override
    public BuiltInFilters builtIns() {
        return this.builtIns;
    }

    public boolean contains(ImmutableType type) {
        for (ImmutableType t = type; t != null; t = t.getSuperType()) {
            if (!this.filterMap.containsKey(t)) continue;
            return true;
        }
        return false;
    }

    private Filter<Props> create(ImmutableType type) {
        return this.create(type, false);
    }

    private Filter<Props> createShardingOnly(ImmutableType type) {
        return this.create(type, true);
    }

    private Filter<Props> create(ImmutableType type, boolean shardingOnly) {
        LinkedHashSet<Filter<Props>> filters = new LinkedHashSet<Filter<Props>>();
        for (ImmutableType t = type; t != null; t = t.getSuperType()) {
            List<Filter<Props>> list = this.filterMap.get(t);
            if (list == null) continue;
            for (Filter<Props> filter : list) {
                if (shardingOnly && !(filter instanceof ShardingFilter) || this.disabledFilters.contains(filter)) continue;
                filters.add(filter);
            }
        }
        if (filters.isEmpty()) {
            return null;
        }
        for (Filter filter : filters) {
            if (filter instanceof CacheableFilter) continue;
            return new CompositeFilter(filters);
        }
        return new CompositeCacheableFilter(type, filters);
    }

    private List<Filter<Props>> createAllCacheable(ImmutableType type) {
        ArrayList<Filter<Props>> filters = new ArrayList<Filter<Props>>();
        while (type != null) {
            List<Filter<Props>> list = this.allCacheableFilterMap.get(type);
            if (list != null) {
                for (Filter<Props> filter : list) {
                    if (this.disabledFilters.contains(filter)) continue;
                    filters.add(filter);
                }
            }
            type = type.getSuperType();
        }
        return filters;
    }

    public static ImmutableType getImmutableType(Filter<?> filter) {
        Class propsClass;
        if (filter instanceof TypeAware) {
            return ((TypeAware)((Object)filter)).getImmutableType();
        }
        Class<?> filterClass = filter.getClass();
        Collection filterTypeArguments = TypeUtils.getTypeArguments(filterClass, Filter.class).values();
        if (filterTypeArguments.isEmpty()) {
            throw new IllegalStateException("`" + filterClass.getName() + "` does not specify the type argument of `" + Filter.class.getName() + "`");
        }
        Type propsType = (Type)filterTypeArguments.iterator().next();
        if (propsType instanceof Class) {
            propsClass = (Class)propsType;
        } else if (propsType instanceof ParameterizedType) {
            propsClass = (Class)((ParameterizedType)propsType).getRawType();
        } else {
            throw new IllegalStateException("`" + filterClass.getName() + "` is illegal, the type argument of `" + Filter.class.getName() + "` can only be class of parameterized type");
        }
        if (TableEx.class.isAssignableFrom(propsClass)) {
            throw new IllegalStateException("`" + filterClass.getName() + "` is illegal, the type argument of `" + Filter.class.getName() + "` can not be `TableEx`");
        }
        if (Table.class.isAssignableFrom(propsClass)) {
            Collection propsTypeArguments = TypeUtils.getTypeArguments((Type)propsType, Table.class).values();
            if (propsTypeArguments.isEmpty()) {
                throw new IllegalStateException("`" + filterClass.getName() + "` does not specify the type argument of `" + Table.class.getName() + "`");
            }
            Type entityType = (Type)propsTypeArguments.iterator().next();
            if (!(entityType instanceof Class)) {
                throw new IllegalStateException("`" + filterClass.getName() + "` is illegal, the type argument of `" + Table.class.getName() + "` can only be class or interface");
            }
            return ImmutableType.get((Class)((Class)entityType));
        }
        if (Props.class.isAssignableFrom(propsClass)) {
            PropsFor propsFor = propsClass.getAnnotation(PropsFor.class);
            if (Props.class == propsClass) {
                throw new IllegalStateException("`" + filterClass.getName() + "` is illegal, its type argument cannot be `" + propsClass.getName() + "`");
            }
            if (propsFor == null) {
                throw new IllegalStateException("`" + filterClass.getName() + "` is illegal, the type argument of `" + Props.class.getName() + "` is `" + propsClass.getName() + "` which is not decorated by `@" + PropsFor.class.getName() + "`");
            }
            return ImmutableType.get(propsFor.value());
        }
        throw new IllegalStateException("`" + filterClass.getName() + "` is illegal, its type argument must inherit `" + Props.class.getName() + "`");
    }

    private static Set<Filter<?>> standardFilters(Collection<Filter<?>> filters) {
        LinkedHashSet set = new LinkedHashSet();
        for (Filter<?> filter : filters) {
            Filter<?> unwrapped = FilterManager.unwrap(filter);
            if (unwrapped == null) continue;
            set.add(unwrapped);
        }
        return set;
    }

    private static Filter<?> unwrap(Filter<?> filter) {
        Object o = filter;
        while (o instanceof TypeAware) {
            if (!((o = ((TypeAware)o).unwrap()) instanceof Filter)) continue;
            filter = (Filter)o;
        }
        return filter;
    }

    private static Map<ImmutableType, List<Filter<Props>>> filterMap(Collection<Filter<?>> filters, Collection<Filter<?>> disabledFilters) {
        HashMap<ImmutableType, List<Filter<Props>>> map = new HashMap<ImmutableType, List<Filter<Props>>>();
        for (Filter<?> filter : filters) {
            if (filter == null || disabledFilters.contains(filter)) continue;
            ImmutableType immutableType = FilterManager.getImmutableType(filter);
            map.computeIfAbsent(immutableType, it -> new ArrayList()).add(filter);
        }
        return map;
    }

    private static Set<Filter<?>> standardDisabledFilters(Collection<Filter<?>> base, Collection<Filter<?>> more, Collection<Filter<?>> all) {
        HashSet set = base != null ? new HashSet(base) : new HashSet();
        for (Filter<?> filter : more) {
            Filter<?> unwrapped = FilterManager.unwrap(filter);
            if (unwrapped == null) continue;
            set.add(unwrapped);
        }
        set.retainAll(all);
        return set;
    }

    private void onInitialized() {
        CachesImpl caches = (CachesImpl)this.sqlClient.getCaches();
        for (Map.Entry<ImmutableProp, LocatedCache<?, ?>> entry : caches.getPropCacheMap().entrySet()) {
            List filters;
            ImmutableProp prop = entry.getKey();
            if (!prop.isAssociation(TargetLevel.PERSISTENT) || (filters = (List)this.allCacheableCache.get((Object)prop.getTargetType())).isEmpty()) continue;
            this.sqlClient.getTriggers().addEntityListener(prop.getTargetType(), e -> this.handleTargetChange(prop, filters, e));
        }
    }

    private void handleTargetChange(ImmutableProp prop, List<Filter<Props>> filters, EntityEvent<?> e) {
        ImmutableProp mappedBy;
        if (!(this.sqlClient.getCaches().getPropertyCache(prop) instanceof Cache.Parameterized)) {
            return;
        }
        if (prop.isReferenceList(TargetLevel.PERSISTENT) && (mappedBy = prop.getMappedBy()) != null && mappedBy.getStorage() instanceof ColumnDefinition && e.getUnchangedFieldRef(mappedBy) == null) {
            return;
        }
        boolean affected = false;
        for (Filter<Props> filter : filters) {
            if (!(filter instanceof CacheableFilter) || !((CacheableFilter)filter).isAffectedBy(e)) continue;
            affected = true;
            break;
        }
        if (affected) {
            this.fireAssociationEvent(prop, e);
        }
    }

    private void fireAssociationEvent(ImmutableProp prop, EntityEvent<?> e) {
        Triggers triggers = this.sqlClient.getTriggers();
        ImmutableProp mappedBy = prop.getMappedBy();
        if (mappedBy != null && mappedBy.getStorage() instanceof ColumnDefinition) {
            ImmutableSpi source2;
            Ref ref = e.getUnchangedFieldRef(mappedBy);
            if (ref != null && (source2 = (ImmutableSpi)ref.getValue()) != null) {
                ImmutableType sourceType = source2.__type();
                Object sourceId = source2.__get(sourceType.getIdProp().getId());
                triggers.fireAssociationEvict(prop, sourceId);
            }
        } else {
            ImmutableType declaringType = prop.getDeclaringType();
            List<ImmutableType> sourceTypes = declaringType.isEntity() ? Collections.singletonList(declaringType) : this.sqlClient.getEntityManager().getImplementationTypes(declaringType);
            String targetIdPropName = prop.getTargetType().getIdProp().getName();
            for (ImmutableType sourceType : sourceTypes) {
                Collection sourceIds = (Collection)Queries.createQuery(this.sqlClient, sourceType, ExecutionPurpose.EVICT, true, (q, source) -> {
                    Object sourceIdExpr = source.get(sourceType.getIdProp().getName());
                    Object targetIdExpr = source.join(prop.getName()).get(targetIdPropName);
                    q.where(new Predicate[]{targetIdExpr.eq((Object)e.getId())});
                    return q.select(sourceIdExpr);
                }).distinct().execute();
                for (Object sourceId : sourceIds) {
                    triggers.fireAssociationEvict(prop, sourceId);
                }
            }
        }
    }

    private static class CompositeFilter
    implements Filter<Props> {
        private final List<Filter<Props>> filters;

        private CompositeFilter(Collection<Filter<Props>> filters) {
            this.filters = new ArrayList<Filter<Props>>(filters);
        }

        @Override
        public void filter(FilterArgs<Props> args) {
            for (Filter<Props> filter : this.filters) {
                filter.filter(args);
            }
        }

        public String toString() {
            return "CompositeFilter{filters=" + this.filters + '}';
        }
    }

    private static class CompositeCacheableFilter
    implements CacheableFilter<Props> {
        private final ImmutableType type;
        private final List<CacheableFilter<Props>> filters;

        private CompositeCacheableFilter(ImmutableType type, Collection<CacheableFilter<Props>> filters) {
            this.type = type;
            this.filters = new ArrayList<CacheableFilter<Props>>(filters);
        }

        @Override
        public void filter(FilterArgs<Props> args) {
            for (Filter filter : this.filters) {
                filter.filter(args);
            }
        }

        @Override
        public SortedMap<String, Object> getParameters() {
            if (this.filters.size() == 1) {
                SortedMap<String, Object> map = this.filters.get(0).getParameters();
                return map != null ? map : Collections.emptySortedMap();
            }
            TreeMap<String, Object> map = new TreeMap<String, Object>();
            for (CacheableFilter<Props> filter : this.filters) {
                SortedMap<String, Object> subMap = filter.getParameters();
                if (subMap == null || subMap.isEmpty()) continue;
                for (Map.Entry<String, Object> e : subMap.entrySet()) {
                    String key = e.getKey();
                    Object value = e.getValue();
                    if (key == null || key.isEmpty()) {
                        throw new IllegalStateException("The method `getParameters` of \"" + filter.getClass().getName() + "\" cannot map with null or empty key");
                    }
                    if (value == null) {
                        throw new IllegalStateException("The method `getParameters` of \"" + filter.getClass().getName() + "\" cannot map with null value");
                    }
                    Object conflictValue = map.get(key);
                    if (conflictValue != null && !conflictValue.equals(value)) {
                        throw new IllegalStateException("Duplicated parameter key `" + key + "` in filters: " + this.filters);
                    }
                    map.put(key, value);
                }
            }
            return map;
        }

        @Override
        public boolean isAffectedBy(EntityEvent<?> e) {
            if (this.type.isAssignableFrom(e.getImmutableType())) {
                for (CacheableFilter<Props> filter : this.filters) {
                    if (!filter.isAffectedBy(e)) continue;
                    return true;
                }
            }
            return false;
        }

        public String toString() {
            return "CompositeCacheableFilter{filters=" + this.filters + '}';
        }
    }
}

