/*
 * Decompiled with CFR 0.152.
 */
package org.babyfish.jimmer.sql.ast.query;

import java.sql.Connection;
import java.util.List;
import java.util.Optional;
import java.util.function.Consumer;
import javax.validation.constraints.NotNull;
import org.babyfish.jimmer.sql.ast.Executable;
import org.babyfish.jimmer.sql.runtime.ExecutionException;
import org.jetbrains.annotations.Nullable;

public interface TypedRootQuery<R>
extends Executable<List<R>> {
    public TypedRootQuery<R> union(TypedRootQuery<R> var1);

    public TypedRootQuery<R> unionAll(TypedRootQuery<R> var1);

    public TypedRootQuery<R> minus(TypedRootQuery<R> var1);

    public TypedRootQuery<R> intersect(TypedRootQuery<R> var1);

    @NotNull
    default public R fetchOne() {
        return this.fetchOne(null);
    }

    @NotNull
    default public R fetchOne(Connection con) {
        List list = (List)this.execute(con);
        if (list.isEmpty()) {
            throw new ExecutionException("No data is returned");
        }
        if (list.size() > 1) {
            throw new ExecutionException("Too much data is returned");
        }
        return (R)list.get(0);
    }

    @Nullable
    default public R fetchOneOrNull() {
        return this.fetchOneOrNull(null);
    }

    @Nullable
    default public R fetchOneOrNull(Connection con) {
        List list = (List)this.execute(con);
        if (list.isEmpty()) {
            return null;
        }
        if (list.size() > 1) {
            throw new ExecutionException("Too much data is returned");
        }
        return (R)list.get(0);
    }

    @NotNull
    default public Optional<R> fetchOptional() {
        return Optional.ofNullable(this.fetchOneOrNull());
    }

    @NotNull
    default public Optional<R> fetchOptional(Connection con) {
        return Optional.ofNullable(this.fetchOneOrNull(con));
    }

    default public void forEach(Consumer<R> consumer) {
        this.forEach(null, -1, consumer);
    }

    default public void forEach(Connection con, Consumer<R> consumer) {
        this.forEach(con, -1, consumer);
    }

    default public void forEach(int batchSize, Consumer<R> consumer) {
        this.forEach(null, batchSize, consumer);
    }

    public void forEach(Connection var1, int var2, Consumer<R> var3);
}

