/*
 * Decompiled with CFR 0.152.
 */
package org.babyfish.jimmer.sql.cache;

import java.util.Collections;
import java.util.LinkedHashMap;
import java.util.Map;
import java.util.Set;
import java.util.function.Consumer;
import org.babyfish.jimmer.meta.ImmutableProp;
import org.babyfish.jimmer.meta.ImmutableType;
import org.babyfish.jimmer.meta.TargetLevel;
import org.babyfish.jimmer.runtime.ImmutableSpi;
import org.babyfish.jimmer.sql.cache.Cache;
import org.babyfish.jimmer.sql.cache.CacheAbandonedCallback;
import org.babyfish.jimmer.sql.cache.CacheConfig;
import org.babyfish.jimmer.sql.cache.CacheDisableConfig;
import org.babyfish.jimmer.sql.cache.CacheOperator;
import org.babyfish.jimmer.sql.cache.Caches;
import org.babyfish.jimmer.sql.cache.LocatedCache;
import org.babyfish.jimmer.sql.cache.LocatedCacheImpl;
import org.babyfish.jimmer.sql.event.Triggers;
import org.babyfish.jimmer.sql.runtime.EntityManager;

public class CachesImpl
implements Caches {
    private final Triggers triggers;
    private final Map<ImmutableType, LocatedCacheImpl<?, ?>> objectCacheMap;
    private final Map<ImmutableProp, LocatedCacheImpl<?, ?>> propCacheMap;
    private final CacheOperator operator;
    private final CacheAbandonedCallback abandonedCallback;
    private final boolean disableAll;
    private final Set<ImmutableType> disabledTypes;
    private final Set<ImmutableProp> disabledProps;

    public CachesImpl(Triggers triggers, Map<ImmutableType, Cache<?, ?>> objectCacheMap, Map<ImmutableProp, Cache<?, ?>> propCacheMap, CacheOperator operator, CacheAbandonedCallback abandonedCallback) {
        LinkedHashMap objectCacheWrapperMap = new LinkedHashMap();
        for (Map.Entry<ImmutableType, Cache<?, ?>> e : objectCacheMap.entrySet()) {
            ImmutableType type = e.getKey();
            objectCacheWrapperMap.put(type, this.wrapObjectCache(triggers, e.getValue(), type));
        }
        LinkedHashMap propCacheWrapperMap = new LinkedHashMap();
        for (Map.Entry<ImmutableProp, Cache<?, ?>> e : propCacheMap.entrySet()) {
            ImmutableProp prop = e.getKey();
            propCacheWrapperMap.put(prop, this.wrapPropCache(triggers, e.getValue(), prop));
        }
        this.triggers = triggers;
        this.objectCacheMap = objectCacheWrapperMap;
        this.propCacheMap = propCacheWrapperMap;
        this.operator = operator;
        this.abandonedCallback = abandonedCallback;
        this.disableAll = false;
        this.disabledTypes = Collections.emptySet();
        this.disabledProps = Collections.emptySet();
    }

    public CachesImpl(CachesImpl base, CacheDisableConfig cfg) {
        this.triggers = base.triggers;
        this.objectCacheMap = base.objectCacheMap;
        this.propCacheMap = base.propCacheMap;
        this.operator = base.operator;
        this.abandonedCallback = base.abandonedCallback;
        this.disableAll = cfg.isDisableAll();
        this.disabledTypes = cfg.getDisabledTypes();
        this.disabledProps = cfg.getDisabledProps();
    }

    public Map<ImmutableType, LocatedCache<?, ?>> getObjectCacheMap() {
        return Collections.unmodifiableMap(this.objectCacheMap);
    }

    public Map<ImmutableProp, LocatedCache<?, ?>> getPropCacheMap() {
        return Collections.unmodifiableMap(this.propCacheMap);
    }

    public <K, V> LocatedCache<K, V> getObjectCache(ImmutableType type) {
        if (this.disableAll || this.disabledTypes.contains(type)) {
            return null;
        }
        return LocatedCacheImpl.export(this.objectCacheMap.get(type));
    }

    public <K, V> LocatedCache<K, V> getPropertyCache(ImmutableProp prop) {
        if (!prop.getDeclaringType().isEntity()) {
            throw new IllegalArgumentException("\"" + prop + "\" is not declared in entity");
        }
        if (this.disableAll || this.disabledProps.contains(prop) || this.disabledTypes.contains(prop.getTargetType())) {
            return null;
        }
        return LocatedCacheImpl.export(this.propCacheMap.get(prop));
    }

    @Override
    public CacheAbandonedCallback getAbandonedCallback() {
        return this.abandonedCallback;
    }

    private LocatedCacheImpl<?, ?> wrapObjectCache(Triggers triggers, Cache<?, ?> cache, ImmutableType type) {
        if (cache == null) {
            return null;
        }
        LocatedCacheImpl<?, ?> wrapper = LocatedCacheImpl.wrap(cache, type);
        triggers.addEntityListener(type, e -> {
            ImmutableSpi oldEntity = (ImmutableSpi)e.getOldEntity();
            if (oldEntity != null) {
                Object id = e.getId();
                if (this.operator != null) {
                    this.operator.delete(wrapper, id, e.getReason());
                } else {
                    wrapper.delete(id, e.getReason());
                }
            }
        });
        return wrapper;
    }

    private LocatedCacheImpl<?, ?> wrapPropCache(Triggers triggers, Cache<?, ?> cache, ImmutableProp prop) {
        if (!prop.getDeclaringType().isEntity()) {
            throw new IllegalArgumentException("\"" + prop + "\" is not declared in entity");
        }
        if (cache == null) {
            return null;
        }
        LocatedCacheImpl<?, ?> wrapper = LocatedCacheImpl.wrap(cache, prop);
        if (prop.isAssociation(TargetLevel.PERSISTENT)) {
            triggers.addAssociationListener(prop, e -> {
                Object id = e.getSourceId();
                if (this.operator != null) {
                    this.operator.delete(wrapper, id, e.getReason());
                } else {
                    wrapper.delete(id, e.getReason());
                }
            });
        }
        return wrapper;
    }

    public static Caches of(Triggers triggers, EntityManager entityManager, Consumer<CacheConfig> block) {
        CacheConfig cfg = new CacheConfig(entityManager);
        if (block != null) {
            block.accept(cfg);
        }
        return cfg.build(triggers);
    }
}

