/*
 * Decompiled with CFR 0.152.
 */
package org.babyfish.jimmer.sql.runtime;

import java.sql.Connection;
import java.sql.ResultSet;
import java.sql.SQLException;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.HashMap;
import java.util.HashSet;
import java.util.LinkedHashMap;
import java.util.LinkedHashSet;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.Set;
import java.util.function.Consumer;
import java.util.stream.Collectors;
import org.babyfish.jimmer.lang.Ref;
import org.babyfish.jimmer.meta.ImmutableProp;
import org.babyfish.jimmer.meta.ImmutableType;
import org.babyfish.jimmer.meta.TargetLevel;
import org.babyfish.jimmer.sql.DatabaseValidationIgnore;
import org.babyfish.jimmer.sql.association.meta.AssociationType;
import org.babyfish.jimmer.sql.ast.tuple.Tuple2;
import org.babyfish.jimmer.sql.ast.tuple.Tuple3;
import org.babyfish.jimmer.sql.meta.ColumnDefinition;
import org.babyfish.jimmer.sql.meta.MetadataStrategy;
import org.babyfish.jimmer.sql.meta.MiddleTable;
import org.babyfish.jimmer.sql.meta.MultipleJoinColumns;
import org.babyfish.jimmer.sql.meta.SingleColumn;
import org.babyfish.jimmer.sql.meta.Storage;
import org.babyfish.jimmer.sql.meta.impl.DatabaseIdentifiers;
import org.babyfish.jimmer.sql.runtime.DatabaseValidationException;
import org.babyfish.jimmer.sql.runtime.EntityManager;
import org.jetbrains.annotations.Nullable;

public class DatabaseValidators {
    private final EntityManager entityManager;
    private final String microServiceName;
    private final MetadataStrategy strategy;
    private final String catalog;
    private final Connection con;
    private final List<DatabaseValidationException.Item> items;
    private final Map<ImmutableType, Ref<Table>> tableRefMap = new HashMap<ImmutableType, Ref<Table>>();
    private final Map<ImmutableProp, Ref<Table>> middleTableRefMap = new HashMap<ImmutableProp, Ref<Table>>();

    @Nullable
    public static DatabaseValidationException validate(EntityManager entityManager, String microServiceName, MetadataStrategy strategy, String catalog, Connection con) throws SQLException {
        return new DatabaseValidators(entityManager, microServiceName, strategy, catalog, con).validate();
    }

    private DatabaseValidators(EntityManager entityManager, String microServiceName, MetadataStrategy strategy, String catalog, Connection con) throws SQLException {
        this.entityManager = entityManager;
        this.microServiceName = microServiceName;
        this.strategy = strategy;
        this.catalog = catalog != null ? catalog : con.getCatalog();
        this.con = con;
        this.items = new ArrayList<DatabaseValidationException.Item>();
    }

    private DatabaseValidationException validate() throws SQLException {
        for (ImmutableType type : this.entityManager.getAllTypes(this.microServiceName)) {
            if (!type.isEntity() || type instanceof AssociationType || type.getJavaClass().isAnnotationPresent(DatabaseValidationIgnore.class)) continue;
            this.validateSelf(type);
        }
        for (ImmutableType type : this.entityManager.getAllTypes(this.microServiceName)) {
            if (!type.isEntity() || type instanceof AssociationType || type.getJavaClass().isAnnotationPresent(DatabaseValidationIgnore.class)) continue;
            this.validateForeignKey(type);
        }
        if (!this.items.isEmpty()) {
            return new DatabaseValidationException(this.items);
        }
        return null;
    }

    private void validateSelf(ImmutableType type) throws SQLException {
        Table table = this.tableOf(type);
        if (table == null) {
            return;
        }
        if (!(type instanceof AssociationType) && type.getIdProp().getAnnotation(DatabaseValidationIgnore.class) != null) {
            ColumnDefinition idColumnDefinition = (ColumnDefinition)type.getIdProp().getStorage(this.strategy);
            LinkedHashSet<String> idColumnNames = new LinkedHashSet<String>((idColumnDefinition.size() * 4 + 2) / 3);
            for (int i = 0; i < idColumnDefinition.size(); ++i) {
                idColumnNames.add(DatabaseIdentifiers.comparableIdentifier((String)idColumnDefinition.name(i)));
            }
            if (!idColumnNames.equals(table.primaryKeyColumns)) {
                this.items.add(new DatabaseValidationException.Item(type, null, "Expected primary key columns are " + ((ColumnDefinition)type.getIdProp().getStorage(this.strategy)).toColumnNames() + ", but actual primary key columns are " + table.primaryKeyColumns));
            }
        }
        for (ImmutableProp prop : type.getProps().values()) {
            boolean nullable;
            Column column;
            if (prop.getAnnotation(DatabaseValidationIgnore.class) != null) continue;
            Storage storage = prop.getStorage(this.strategy);
            if (storage instanceof ColumnDefinition) {
                ColumnDefinition columnDefinition = (ColumnDefinition)storage;
                for (int i = 0; i < columnDefinition.size(); ++i) {
                    Column column2 = table.columnMap.get(DatabaseIdentifiers.comparableIdentifier((String)columnDefinition.name(i)));
                    if (column2 != null) continue;
                    this.items.add(new DatabaseValidationException.Item(type, prop, "There is no column \"" + columnDefinition.name(i) + "\" in table \"" + table + "\""));
                }
            }
            if (!(storage instanceof SingleColumn) || (column = table.columnMap.get(DatabaseIdentifiers.comparableIdentifier((String)((SingleColumn)storage).getName()))) == null || (nullable = prop.isNullable() && !prop.isInputNotNull()) == column.nullable) continue;
            this.items.add(new DatabaseValidationException.Item(type, prop, "The property is " + (nullable ? "nullable" : "nonnull(include inputNotNull)") + ", but the database column \"" + ((SingleColumn)storage).getName() + "\" is " + (column.nullable ? "nullable" : "nonnull")));
        }
    }

    private void validateForeignKey(ImmutableType type) throws SQLException {
        Table table = this.tableOf(type);
        if (table == null) {
            return;
        }
        for (ImmutableProp prop : type.getProps().values()) {
            ForeignKey foreignKey;
            ColumnDefinition columnDefinition;
            if (!prop.isAssociation(TargetLevel.PERSISTENT) || prop.getAnnotation(DatabaseValidationIgnore.class) != null || prop.getTargetType().getJavaClass().isAnnotationPresent(DatabaseValidationIgnore.class)) continue;
            ForeignKeyContext ctx = new ForeignKeyContext(this, type, prop);
            Storage storage = prop.getStorage(this.strategy);
            if (storage instanceof MiddleTable) {
                ForeignKey targetForeignKey;
                ForeignKey thisForeignKey;
                Table middleTable = this.middleTableOf(prop);
                if (middleTable == null) continue;
                MiddleTable middleTableMeta = (MiddleTable)storage;
                if (middleTableMeta.getColumnDefinition().isForeignKey() && (thisForeignKey = middleTable.getForeignKey(ctx, middleTableMeta.getColumnDefinition())) != null) {
                    thisForeignKey.assertReferencedColumns(ctx, type);
                }
                if (!middleTableMeta.getTargetColumnDefinition().isForeignKey() || (targetForeignKey = middleTable.getForeignKey(ctx, middleTableMeta.getTargetColumnDefinition())) == null) continue;
                targetForeignKey.assertReferencedColumns(ctx, prop.getTargetType());
                continue;
            }
            if (storage == null || !prop.isReference(TargetLevel.PERSISTENT) || !(columnDefinition = (ColumnDefinition)prop.getStorage(this.strategy)).isForeignKey() || (foreignKey = table.getForeignKey(ctx, columnDefinition)) == null) continue;
            foreignKey.assertReferencedColumns(ctx, prop.getTargetType());
        }
    }

    private Table tableOf(ImmutableType type) throws SQLException {
        Ref tableRef = this.tableRefMap.get(type);
        if (tableRef == null) {
            Set<Table> tables = this.tablesOf(type.getTableName(this.strategy));
            if (tables.isEmpty()) {
                this.items.add(new DatabaseValidationException.Item(type, null, "There is no table \"" + type.getTableName(this.strategy) + "\""));
                tableRef = Ref.empty();
            } else if (tables.size() > 1) {
                this.items.add(new DatabaseValidationException.Item(type, null, "Too many matched tables: " + tables));
                tableRef = Ref.empty();
            } else {
                Table table = tables.iterator().next();
                table = new Table(table, this.columnsOf(table), this.primaryKeyColumns(table));
                tableRef = Ref.of((Object)table);
            }
            this.tableRefMap.put(type, (Ref<Table>)tableRef);
        }
        return (Table)tableRef.getValue();
    }

    private Table middleTableOf(ImmutableProp prop) throws SQLException {
        Ref tableRef = this.middleTableRefMap.get(prop);
        if (tableRef == null) {
            Storage storage = prop.getStorage(this.strategy);
            if (storage instanceof MiddleTable) {
                MiddleTable middleTable = (MiddleTable)storage;
                Set<Table> tables = this.tablesOf(middleTable.getTableName());
                if (tables.isEmpty()) {
                    this.items.add(new DatabaseValidationException.Item(prop.getDeclaringType(), prop, "There is no table \"" + middleTable.getTableName() + "\""));
                    tableRef = Ref.empty();
                } else if (tables.size() > 1) {
                    this.items.add(new DatabaseValidationException.Item(prop.getDeclaringType(), prop, "Too many matched tables: " + tables));
                    tableRef = Ref.empty();
                } else {
                    Table table = tables.iterator().next();
                    table = new Table(table, this.columnsOf(table), this.primaryKeyColumns(table));
                    tableRef = Ref.of((Object)table);
                }
            } else {
                tableRef = Ref.empty();
            }
            this.middleTableRefMap.put(prop, (Ref<Table>)tableRef);
        }
        return (Table)tableRef.getValue();
    }

    private Set<Table> tablesOf(String table) throws SQLException {
        String catalogName = null;
        String schemaName = null;
        String tableName = table;
        int index = tableName.lastIndexOf(46);
        if (index != -1) {
            schemaName = tableName.substring(0, index);
            tableName = tableName.substring(index + 1);
            index = schemaName.lastIndexOf(46);
            if (index != -1) {
                catalogName = schemaName.substring(0, index);
                schemaName = schemaName.substring(index + 1);
            }
        }
        return this.tablesOf(DatabaseValidators.optional(catalogName), DatabaseValidators.optional(schemaName), tableName);
    }

    private static String optional(String value) {
        if ("".equals(value) || "null".equals(value)) {
            return null;
        }
        return value;
    }

    private Set<Table> tablesOf(String catalogName, String schemaName, String tableName) throws SQLException {
        LinkedHashSet tuples = new LinkedHashSet();
        new TableNameCollector(new String[]{catalogName, schemaName, tableName}, arr -> tuples.add(new Tuple3<String, String, String>(arr[0], arr[1], arr[2]))).emit();
        for (Tuple3 tuple : tuples) {
            Set<Table> tables = this.tablesOf0((String)tuple.get_1(), (String)tuple.get_2(), (String)tuple.get_3());
            if (tables.isEmpty()) continue;
            return tables;
        }
        return Collections.emptySet();
    }

    private Set<Table> tablesOf0(String catalogName, String schemaName, String tableName) throws SQLException {
        LinkedHashSet<Table> tables = new LinkedHashSet<Table>();
        try (ResultSet rs = this.con.getMetaData().getTables(catalogName, schemaName, tableName, null);){
            while (rs.next()) {
                tables.add(new Table(rs.getString("TABLE_CAT"), rs.getString("TABLE_SCHEM"), rs.getString("TABLE_NAME")));
            }
        }
        if (this.catalog != null && !this.catalog.isEmpty()) {
            return tables.stream().filter(it -> it.catalog == null || catalogName == null || it.catalog.equalsIgnoreCase(this.catalog)).filter(it -> it.schema == null || catalogName == null || it.schema.equalsIgnoreCase(schemaName)).collect(Collectors.toSet());
        }
        return tables;
    }

    private Map<String, Column> columnsOf(Table table) throws SQLException {
        HashMap<String, Column> columnMap = new HashMap<String, Column>();
        try (ResultSet rs = this.con.getMetaData().getColumns(table.catalog, table.schema, table.name, null);){
            while (rs.next()) {
                Column column = new Column(table, rs.getString("COLUMN_NAME").toUpperCase(), rs.getInt("NULLABLE") == 1);
                columnMap.put(column.name.toUpperCase(), column);
            }
        }
        return columnMap;
    }

    private Set<String> primaryKeyColumns(Table table) throws SQLException {
        HashSet<String> columnNames = new HashSet<String>();
        try (ResultSet rs = this.con.getMetaData().getPrimaryKeys(table.catalog, table.schema, table.name);){
            while (rs.next()) {
                columnNames.add(rs.getString("COLUMN_NAME").toUpperCase());
            }
        }
        return columnNames;
    }

    private Map<Set<String>, ForeignKey> foreignKeys(Table table) throws SQLException {
        HashMap<Tuple2, Map> map = new HashMap<Tuple2, Map>();
        try (ResultSet rs = this.con.getMetaData().getImportedKeys(table.catalog, table.schema, table.name);){
            while (rs.next()) {
                String constraintName = rs.getString("FK_NAME").toUpperCase();
                Table referencedTable = this.tablesOf(DatabaseValidators.upper(rs.getString("PKTABLE_CAT")), DatabaseValidators.upper(rs.getString("PKTABLE_SCHEM")), rs.getString("PKTABLE_NAME").toUpperCase()).iterator().next();
                String columnName = DatabaseValidators.upper(rs.getString("FKCOLUMN_NAME"));
                String referencedColumnName = DatabaseValidators.upper(rs.getString("PKCOLUMN_NAME"));
                map.computeIfAbsent(new Tuple2<String, Table>(constraintName, referencedTable), it -> new LinkedHashMap()).put(columnName, referencedColumnName);
            }
        }
        if (map.isEmpty()) {
            return Collections.emptyMap();
        }
        HashMap<Set<String>, ForeignKey> foreignKeyMap = new HashMap<Set<String>, ForeignKey>();
        for (Map.Entry e : map.entrySet()) {
            String constraintName = (String)((Tuple2)e.getKey()).get_1();
            Table referencedTable = (Table)((Tuple2)e.getKey()).get_2();
            Map subMap = (Map)e.getValue();
            Set<String> columnNames = subMap.keySet();
            Collection referencedColumnNames = subMap.values();
            ForeignKey foreignKey = new ForeignKey(constraintName, columnNames, referencedTable, new LinkedHashSet<String>(referencedColumnNames));
            foreignKeyMap.put(columnNames, foreignKey);
        }
        return foreignKeyMap;
    }

    private static String upper(String text) {
        return text == null ? null : text.toUpperCase();
    }

    private static class Table {
        final String catalog;
        final String schema;
        final String name;
        final Map<String, Column> columnMap;
        final Set<String> primaryKeyColumns;
        private Map<Set<String>, ForeignKey> _foreignKeyMap;

        Table(String catalog, String schema, String name) {
            this.catalog = catalog;
            this.schema = schema;
            this.name = name;
            this.columnMap = Collections.emptyMap();
            this.primaryKeyColumns = Collections.emptySet();
        }

        public Table(Table base, Map<String, Column> columnMap, Set<String> primaryKeyColumns) {
            this.catalog = base.catalog;
            this.schema = base.schema;
            this.name = base.name;
            this.columnMap = columnMap;
            this.primaryKeyColumns = primaryKeyColumns;
        }

        public ForeignKey getForeignKey(ForeignKeyContext ctx, ColumnDefinition columnDefinition) throws SQLException {
            ForeignKey foreignKey;
            if (columnDefinition instanceof MultipleJoinColumns) {
                MultipleJoinColumns multipleJoinColumns = (MultipleJoinColumns)columnDefinition;
                LinkedHashSet<String> columnNames = new LinkedHashSet<String>();
                for (int i = 0; i < multipleJoinColumns.size(); ++i) {
                    columnNames.add(multipleJoinColumns.name(i).toUpperCase());
                }
                foreignKey = this.getForeignKeyMap(ctx).get(columnNames);
            } else {
                foreignKey = this.getForeignKeyMap(ctx).get(Collections.singleton(((SingleColumn)columnDefinition).getName().toUpperCase()));
            }
            if (foreignKey == null) {
                ctx.databaseValidators.items.add(new DatabaseValidationException.Item(ctx.type, ctx.prop, "No foreign key for columns: " + columnDefinition.toColumnNames() + ". If this column is a real foreign key, please add foreign key constraint in database; If this column is a fake foreign key, please use `@JoinColumn(foreignKey = false, ...)`"));
            }
            return foreignKey;
        }

        public int hashCode() {
            return Objects.hash(this.catalog, this.schema, this.name);
        }

        public boolean equals(Object o) {
            if (this == o) {
                return true;
            }
            if (o == null || this.getClass() != o.getClass()) {
                return false;
            }
            Table table = (Table)o;
            return this.catalog.equals(table.catalog) && this.schema.equals(table.schema) && this.name.equals(table.name);
        }

        public String toString() {
            return this.catalog + '.' + this.schema + '.' + this.name;
        }

        private Map<Set<String>, ForeignKey> getForeignKeyMap(ForeignKeyContext ctx) throws SQLException {
            Map map = this._foreignKeyMap;
            if (map == null) {
                this._foreignKeyMap = map = ctx.databaseValidators.foreignKeys(this);
            }
            return map;
        }
    }

    private static class Column {
        final Table table;
        final String name;
        final boolean nullable;

        private Column(Table table, String name, boolean nullable) {
            this.table = table;
            this.name = name.toUpperCase();
            this.nullable = nullable;
        }
    }

    private static class ForeignKeyContext {
        final DatabaseValidators databaseValidators;
        final ImmutableType type;
        final ImmutableProp prop;

        private ForeignKeyContext(DatabaseValidators databaseValidators, ImmutableType type, ImmutableProp prop) {
            this.databaseValidators = databaseValidators;
            this.type = type;
            this.prop = prop;
        }
    }

    private static class ForeignKey {
        final String constraintName;
        final Set<String> columnNames;
        final Table referencedTable;
        final Set<String> referenceColumNames;

        ForeignKey(String constraintName, Set<String> columnNames, Table referencedTable, Set<String> referenceColumNames) {
            this.constraintName = constraintName;
            this.columnNames = columnNames;
            this.referencedTable = referencedTable;
            this.referenceColumNames = referenceColumNames;
        }

        void assertReferencedColumns(ForeignKeyContext ctx, ImmutableType referencedType) {
            if (!((ColumnDefinition)referencedType.getIdProp().getStorage(ctx.databaseValidators.strategy)).toColumnNames().equals(this.referenceColumNames)) {
                ctx.databaseValidators.items.add(new DatabaseValidationException.Item(ctx.type, ctx.prop, "Illegal foreign key \"" + this.constraintName + "\", expected referenced columns are " + this.referenceColumNames + ", but actual referenced columns are " + ((ColumnDefinition)referencedType.getIdProp().getStorage(ctx.databaseValidators.strategy)).toColumnNames()));
            }
        }
    }

    private class TableNameCollector {
        private final String[] originalNames;
        private final String[] currentNames;
        private final Consumer<String[]> emitter;

        private TableNameCollector(String[] originalNames, Consumer<String[]> emitter) {
            this.originalNames = originalNames;
            this.currentNames = new String[originalNames.length];
            this.emitter = emitter;
        }

        public void emit() {
            this.emit(0);
        }

        private void emit(int depth) {
            String text;
            this.currentNames[depth] = text = this.originalNames[depth];
            if (depth + 1 < this.originalNames.length) {
                this.emit(depth + 1);
            } else {
                this.emitter.accept(this.currentNames);
            }
            if (text != null && !text.isEmpty()) {
                this.currentNames[depth] = text.toUpperCase();
                if (depth + 1 < this.originalNames.length) {
                    this.emit(depth + 1);
                } else {
                    this.emitter.accept(this.currentNames);
                }
                this.currentNames[depth] = text.toLowerCase();
                if (depth + 1 < this.originalNames.length) {
                    this.emit(depth + 1);
                } else {
                    this.emitter.accept(this.currentNames);
                }
            }
        }
    }
}

